/* -*- mode: c ; c-file-style: "canonware-c-style" -*-
 ****************************************************************************
 *
 * Copyright (C) 1996-1999 Jason Evans <jasone@canonware.com>.
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice(s), this list of conditions and the following disclaimer as
 *    the first lines of this file unmodified other than the possible
 *    addition of one or more copyright notices.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice(s), this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDER(S) ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT HOLDER(S) BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************
 *
 * Version: s19990912a
 *
 * <<< Description >>>
 *
 * Simple oh test.
 *
 ****************************************************************************/

#define _LIBSTASH_USE_OH
#include <libstash/libstash_r.h>

#define NUM_STRINGS 5000

int
main()
{
  cw_oh_t hash;
  char ** strings, * junk;
/*   oh_h1_t * h1_ptr; */
  int i;
  cw_bool_t error;
  cw_sint32_t ins_error;

  libstash_init();
  out_put(cw_g_out, "Test begin\n");
  
  oh_new(&hash);
/*   dbg_register(cw_g_dbg, "oh_slot"); */
  
  strings = (char **) _cw_malloc(sizeof(char *) * NUM_STRINGS);

  for (i = 0; i < NUM_STRINGS; i++)
  {
    strings[i] = (char *) _cw_malloc(sizeof(char) * 50);
    out_put_s(cw_g_out, strings[i], "([i]) This is string [i]", i, i);
  }

/*   h1_ptr = oh_get_h1(hash); */
/*   oh_set_h1(hash, new_h1); */

/*   out_put(cw_g_out, "<<< Begin first insertion loop >>>\n"); */
  for (i = 0; i < NUM_STRINGS; i++)
  {
/*     out_put(cw_g_out, "<<< Iteration [i] >>>\n", i); */
    ins_error = oh_item_insert(&hash, (void *) strings[i],
			       (void *) &(strings[i]));
    if (ins_error == 1)
    {
      out_put(cw_g_out, "(1) Error at i == [i]\n", i);
      oh_dump(&hash, FALSE);
      exit(1);
    }
  }

/*   out_put(cw_g_out, "<<< Begin first deletion loop >>>\n"); */
  for (i = 0; i < (NUM_STRINGS / 2); i++)
  {
    error = oh_item_delete(&hash, (void *) strings[i],
			   (void **) &junk, (void **) &junk);
    if (error == TRUE)
    {
      out_put(cw_g_out, "(2) Error at i == [i]\n", i);
      oh_dump(&hash, FALSE);
      exit(1);
    }
  }

/*   out_put(cw_g_out, "<<< Begin second insertion loop >>>\n"); */
  for (i = 0; i < NUM_STRINGS / 2; i++)
  {
    ins_error = oh_item_insert(&hash, (void *) strings[i],
			       (void *) &(strings[i]));
    if (ins_error == 1)
    {
      out_put(cw_g_out, "(3) Error at i == [i]\n", i);
      oh_dump(&hash, FALSE);
      exit(1);
    }
  }

/*   out_put(cw_g_out, "<<< Begin second deletion loop >>>\n"); */
  for (i = 0; i < NUM_STRINGS; i++)
  {
    error = oh_item_delete(&hash, (void *) strings[i],
			   (void **) &junk, (void **) &junk);
    if (error == TRUE)
    {
      out_put(cw_g_out, "(4) Error at i == [i]\n", i);
      oh_dump(&hash, FALSE);
      exit(1);
    }
  }

/*   out_put(cw_g_out, "<<< Final insertion >>>\n"); */
  ins_error = oh_item_insert(&hash, (void *) strings[0],
			     (void *) &(strings[0]));
  
  {
    out_put(cw_g_out, "Table size: [q]\n",
	    oh_get_size(&hash));
    out_put(cw_g_out, "Number of items: [q]\n",
	    oh_get_num_items(&hash));
  }

/*   oh_dump(&hash, FALSE); */
  
  for (i = 0; i < NUM_STRINGS; i++)
  {
    _cw_free(strings[i]);
  }
  _cw_free(strings);

  oh_delete(&hash);
  out_put(cw_g_out, "Test end\n");
  libstash_shutdown();
  
  return 0;
}
