/* -*- mode: c ; c-file-style: "canonware-c-style" -*-
 ****************************************************************************
 *
 * Copyright (C) 1996-1999 Jason Evans <jasone@canonware.com>.
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice(s), this list of conditions and the following disclaimer as
 *    the first lines of this file unmodified other than the possible
 *    addition of one or more copyright notices.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice(s), this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDER(S) ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT HOLDER(S) BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************
 *
 * Version: s19990912a
 *
 * <<< Description >>>
 *
 * buf test.
 *
 ****************************************************************************/

#define _LIBSTASH_USE_BUF
#include <libstash/libstash.h>

#include <time.h>

int
main()
{
/*    time_t beg_time, end_time, bef_time, aft_time, secs; */
  cw_buf_t * buf_a, * buf_b, * buf_c, * buf_d;

  libstash_init();
  out_put(cw_g_out, "Test begin\n");
  
  buf_a = buf_new_r(NULL);
  buf_b = buf_new_r(NULL);
  buf_c = buf_new_r(NULL);
  buf_d = buf_new_r(NULL);

  /* Create the data. */
  {
    cw_uint32_t i, j;
    cw_bufc_t * bufc;
    void * data;

    for (i = 1; i < 16; i++)
    {
      for (j = 1; j < 16; j++)
      {
	bufc = bufc_new((cw_bufc_t *) _cw_malloc(sizeof(cw_bufc_t)),
			mem_dealloc,
			cw_g_mem);
	data = _cw_malloc(i * j);
	bufc_set_buffer(bufc, data, i * j, FALSE, mem_dealloc, cw_g_mem);

	buf_append_bufc(buf_a, bufc, 0, i * j);
	bufc_delete(bufc);
      }
    }

    for (i = 0; i < 4; i++)
    {
      bufc = bufc_new((cw_bufc_t *) _cw_malloc(sizeof(cw_bufc_t)),
		      mem_dealloc,
		      cw_g_mem);
      data = _cw_malloc(4096);
      bufc_set_buffer(bufc, data, 4096, FALSE, mem_dealloc, cw_g_mem);
      buf_append_bufc(buf_b, bufc, 0, 4096);
      bufc_delete(bufc);
    }

    for (i = 0; i < 1024; i++)
    {
      bufc = bufc_new((cw_bufc_t *) _cw_malloc(sizeof(cw_bufc_t)),
		      mem_dealloc,
		      cw_g_mem);
      data = _cw_malloc(16);
      bufc_set_buffer(bufc, data, 16, FALSE, mem_dealloc, cw_g_mem);
      buf_append_bufc(buf_c, bufc, 0, 16);
      bufc_delete(bufc);
    }
  }

  out_put(cw_g_out, "[i] bytes of data in buf_a (various sized bufc's)\n",
	  buf_get_size(buf_a));
  out_put(cw_g_out, "[i] bytes of data in buf_b (4kB bufc's)\n",
	  buf_get_size(buf_b));
  out_put(cw_g_out, "[i] bytes of data in buf_c (16B bufc's)\n",
	  buf_get_size(buf_c));

  /* buf_get_uint8() inc loop for each buf. */
  {
    cw_uint32_t i, j, size;
    
    for (i = 0; i < 1; i++)
    {
      for (j = 0, size = buf_get_size(buf_a); j < size; j++)
      {
	buf_get_uint8(buf_a, j);
      }
    }

    for (i = 0; i < 1; i++)
    {
      for (j = 0, size = buf_get_size(buf_b); j < size; j++)
      {
	buf_get_uint8(buf_b, j);
      }
    }

    for (i = 0; i < 1; i++)
    {
      for (j = 0, size = buf_get_size(buf_c); j < size; j++)
      {
	buf_get_uint8(buf_c, j);
      }
    }
  }

  /* buf_get_uint8() dec loop for each buf. */
  {
    cw_uint32_t i, j, size;
    
    for (i = 0; i < 1; i++)
    {
      for (j = 0, size = buf_get_size(buf_a); j < size; j++)
      {
	buf_get_uint8(buf_a, size - (1 + j));
      }
    }

    for (i = 0; i < 1; i++)
    {
      for (j = 0, size = buf_get_size(buf_b); j < size; j++)
      {
	buf_get_uint8(buf_b, size - (1 + j));
      }
    }

    for (i = 0; i < 1; i++)
    {
      for (j = 0, size = buf_get_size(buf_c); j < size; j++)
      {
	buf_get_uint8(buf_c, size - (1 + j));
      }
    }
  }
  
  /* Stride-wise buf_get_uint8(). */
  {
    cw_uint32_t i, j, size;
    
    for (i = 0, size = buf_get_size(buf_a); i < 1; i++)
    {
      for (j = i; j < size; j += 13)
      {
	buf_get_uint8(buf_a, j);
      }
    }

    for (i = 0, size = buf_get_size(buf_b); i < 1; i++)
    {
      for (j = i; j < size; j += 13)
      {
	buf_get_uint8(buf_b, j);
      }
    }

    for (i = 0, size = buf_get_size(buf_c); i < 1; i++)
    {
      for (j = i; j < size; j += 13)
      {
	buf_get_uint8(buf_c, j);
      }
    }
  }

  /* Takes a long time to run. */
/*  #if (0) */
  /* Multi-stride buf_get_uint8(). */
  {
    cw_uint32_t h, i, j, k, size;
    
    for (h = 0; h < 1; h++)
    {
      for (i = 1, size = buf_get_size(buf_a); i < size; i <<= 1)
      {
	for (j = 0; j < i; j++)
	{
	  for (k = 0; k < size; k += i)
	  {
	    buf_get_uint8(buf_a, k);
	  }
	}
      }
    }

    for (h = 0; h < 1; h++)
    {
      for (i = 1, size = buf_get_size(buf_b); i < size; i <<= 1)
      {
	for (j = 0; j < i; j++)
	{
	  for (k = 0; k < size; k += i)
	  {
	    buf_get_uint8(buf_b, k);
	  }
	}
      }
    }

    for (h = 0; h < 1; h++)
    {
      for (i = 1, size = buf_get_size(buf_c); i < size; i <<= 1)
      {
	for (j = 0; j < i; j++)
	{
	  for (k = 0; k < size; k += i)
	  {
	    buf_get_uint8(buf_c, k);
	  }
	}
      }
    }
  }
/*  #endif */
  
  /* buf_get_uint32() inc loop for each buf. */
  {
    cw_uint32_t i, j, size;
    
    for (i = 0; i < 1; i++)
    {
      for (j = 0, size = buf_get_size(buf_a); j < size - 3; j++)
      {
	buf_get_uint32(buf_a, j);
      }
    }

    for (i = 0; i < 1; i++)
    {
      for (j = 0, size = buf_get_size(buf_b); j < size - 3; j++)
      {
	buf_get_uint32(buf_b, j);
      }
    }

    for (i = 0; i < 1; i++)
    {
      for (j = 0, size = buf_get_size(buf_c); j < size - 3; j++)
      {
	buf_get_uint32(buf_c, j);
      }
    }
  }
  
  /* buf_get_uint32() dec loop for each buf. */
  {
    cw_uint32_t i, j, size;
    
    for (i = 0; i < 1; i++)
    {
      for (j = 0, size = buf_get_size(buf_a); j < size - 3; j++)
      {
	buf_get_uint32(buf_a, size - (4 + j));
      }
    }

    for (i = 0; i < 1; i++)
    {
      for (j = 0, size = buf_get_size(buf_b); j < size - 3; j++)
      {
	buf_get_uint32(buf_b, size - (4 + j));
      }
    }

    for (i = 0; i < 1; i++)
    {
      for (j = 0, size = buf_get_size(buf_c); j < size - 3; j++)
      {
	buf_get_uint32(buf_c, size - (4 + j));
      }
    }
  }
  
  /* Stride-wise buf_get_uint32(). */
  {
    cw_uint32_t i, j, size;
    
    for (i = 0, size = buf_get_size(buf_a); i < 1; i++)
    {
      for (j = i; j < size - 3; j += 13)
      {
	buf_get_uint32(buf_a, j);
      }
    }

    for (i = 0, size = buf_get_size(buf_b); i < 1; i++)
    {
      for (j = i; j < size - 3; j += 13)
      {
	buf_get_uint32(buf_b, j);
      }
    }

    for (i = 0, size = buf_get_size(buf_c); i < 1; i++)
    {
      for (j = i; j < size - 3; j += 13)
      {
	buf_get_uint32(buf_c, j);
      }
    }
  }

  /* buf_get_uint64() inc loop for each buf. */
  {
    cw_uint32_t i, j, size;
    
    for (i = 0; i < 1; i++)
    {
      for (j = 0, size = buf_get_size(buf_a); j < size - 7; j++)
      {
	buf_get_uint64(buf_a, j);
      }
    }

    for (i = 0; i < 1; i++)
    {
      for (j = 0, size = buf_get_size(buf_b); j < size - 7; j++)
      {
	buf_get_uint64(buf_b, j);
      }
    }

    for (i = 0; i < 1; i++)
    {
      for (j = 0, size = buf_get_size(buf_c); j < size - 7; j++)
      {
	buf_get_uint64(buf_c, j);
      }
    }
  }
  
  /* buf_get_uint64() dec loop for each buf. */
  {
    cw_uint32_t i, j, size;
    
    for (i = 0; i < 1; i++)
    {
      for (j = 0, size = buf_get_size(buf_a); j < size - 7; j++)
      {
	buf_get_uint64(buf_a, size - (8 + j));
      }
    }

    for (i = 0; i < 1; i++)
    {
      for (j = 0, size = buf_get_size(buf_b); j < size - 7; j++)
      {
	buf_get_uint64(buf_b, size - (8 + j));
      }
    }

    for (i = 0; i < 1; i++)
    {
      for (j = 0, size = buf_get_size(buf_c); j < size - 7; j++)
      {
	buf_get_uint64(buf_c, size - (8 + j));
      }
    }
  }

  /* Stride-wise buf_get_uint64(). */
  {
    cw_uint32_t i, j, size;
    
    for (i = 0, size = buf_get_size(buf_a); i < 1; i++)
    {
      for (j = i; j < size - 7; j += 13)
      {
	buf_get_uint64(buf_a, j);
      }
    }

    for (i = 0, size = buf_get_size(buf_b); i < 1; i++)
    {
      for (j = i; j < size - 7; j += 13)
      {
	buf_get_uint64(buf_b, j);
      }
    }

    for (i = 0, size = buf_get_size(buf_c); i < 1; i++)
    {
      for (j = i; j < size - 7; j += 13)
      {
	buf_get_uint64(buf_c, j);
      }
    }
  }

  {
    cw_uint32_t i;

    for (i = 0; i < 1; i++)
    {
      buf_catenate_buf(buf_d, buf_a, FALSE);
      buf_catenate_buf(buf_a, buf_d, FALSE);
    }

    for (i = 0; i < 1; i++)
    {
      buf_catenate_buf(buf_d, buf_b, FALSE);
      buf_catenate_buf(buf_b, buf_d, FALSE);
    }

    for (i = 0; i < 1; i++)
    {
      buf_catenate_buf(buf_d, buf_c, FALSE);
      buf_catenate_buf(buf_c, buf_d, FALSE);
    }
  }

  /* buf_split() loop. */
  {
    cw_uint32_t i, j, size;
    
    for (i = 2099, size = buf_get_size(buf_a); i < size; i += 2099)
    {
      for (j = 0; (j + i) < size; j += i)
      {
	buf_split(buf_d, buf_a, i);
      }
      buf_catenate_buf(buf_d, buf_a, FALSE);
      buf_catenate_buf(buf_a, buf_d, FALSE);
    }
    
    for (i = 2099, size = buf_get_size(buf_b); i < size; i += 2099)
    {
      for (j = 0; (j + i) < size; j += i)
      {
	buf_split(buf_d, buf_b, i);
      }
      buf_catenate_buf(buf_d, buf_b, FALSE);
      buf_catenate_buf(buf_b, buf_d, FALSE);
    }
    
    for (i = 2099, size = buf_get_size(buf_c); i < size; i += 2099)
    {
      for (j = 0; (j + i) < size; j += i)
      {
	buf_split(buf_d, buf_c, i);
      }
      buf_catenate_buf(buf_d, buf_c, FALSE);
      buf_catenate_buf(buf_c, buf_d, FALSE);
    }
  }

  /* buf_release_head_data() loop. */
  {
    cw_uint32_t i, j;

    for (i = 0; i < 1; i++)
    {
      buf_catenate_buf(buf_d, buf_a, TRUE);
      for (j = 0; j < buf_get_size(buf_d); j += 13)
      {
	buf_release_head_data(buf_d, j);
      }
      buf_release_head_data(buf_d, buf_get_size(buf_d));
    }

    for (i = 0; i < 1; i++)
    {
      buf_catenate_buf(buf_d, buf_b, TRUE);
      for (j = 0; j < buf_get_size(buf_d); j += 13)
      {
	buf_release_head_data(buf_d, j);
      }
      buf_release_head_data(buf_d, buf_get_size(buf_d));
    }

    for (i = 0; i < 1; i++)
    {
      buf_catenate_buf(buf_d, buf_c, TRUE);
      for (j = 0; j < buf_get_size(buf_d); j += 13)
      {
	buf_release_head_data(buf_d, j);
      }
      buf_release_head_data(buf_d, buf_get_size(buf_d));
    }
  }

  /* buf_release_tail_data() loop. */
  {
    cw_uint32_t i, j;

    for (i = 0; i < 1; i++)
    {
      buf_catenate_buf(buf_d, buf_a, TRUE);
      for (j = 0; j < buf_get_size(buf_d); j += 13)
      {
	buf_release_tail_data(buf_d, j);
      }
      buf_release_tail_data(buf_d, buf_get_size(buf_d));
    }

    for (i = 0; i < 1; i++)
    {
      buf_catenate_buf(buf_d, buf_b, TRUE);
      for (j = 0; j < buf_get_size(buf_d); j += 13)
      {
	buf_release_tail_data(buf_d, j);
      }
      buf_release_tail_data(buf_d, buf_get_size(buf_d));
    }

    for (i = 0; i < 1; i++)
    {
      buf_catenate_buf(buf_d, buf_c, TRUE);
      for (j = 0; j < buf_get_size(buf_d); j += 13)
      {
	buf_release_tail_data(buf_d, j);
      }
      buf_release_tail_data(buf_d, buf_get_size(buf_d));
    }
  }

  /* Cumulative index rebuild. */
  {
    cw_uint32_t i, j;
    
    for (i = 0; i < 1; i++)
    {
      buf_catenate_buf(buf_d, buf_a, TRUE);
      for (j = 0; buf_get_size(buf_d) > 349; j++)
      {
	buf_release_head_data(buf_d, 349);
	buf_get_uint8(buf_d, buf_get_size(buf_d) - 1);
      }
      buf_release_head_data(buf_d, buf_get_size(buf_d));
    }

    for (i = 0; i < 1; i++)
    {
      buf_catenate_buf(buf_d, buf_b, TRUE);
      for (j = 0; buf_get_size(buf_d) > 349; j++)
      {
	buf_release_head_data(buf_d, 349);
	buf_get_uint8(buf_d, buf_get_size(buf_d) - 1);
      }
      buf_release_head_data(buf_d, buf_get_size(buf_d));
    }

    for (i = 0; i < 1; i++)
    {
      buf_catenate_buf(buf_d, buf_c, TRUE);
      for (j = 0; buf_get_size(buf_d) > 349; j++)
      {
	buf_release_head_data(buf_d, 349);
	buf_get_uint8(buf_d, buf_get_size(buf_d) - 1);
      }
      buf_release_head_data(buf_d, buf_get_size(buf_d));
    }
  }
  
  /* buf_get_iovec(). */
  {
    cw_uint32_t i, j;
    int iov_cnt;
    
    for (i = 0; i < 1; i++)
    {
      buf_catenate_buf(buf_d, buf_a, TRUE);
      for (j = 0; buf_get_size(buf_d) > 11; j++)
      {
	buf_release_head_data(buf_d, 11);
	buf_get_iovec(buf_d, 0, FALSE, &iov_cnt);
      }
      buf_release_head_data(buf_d, buf_get_size(buf_d));
    }

    for (i = 0; i < 1; i++)
    {
      buf_catenate_buf(buf_d, buf_b, TRUE);
      for (j = 0; buf_get_size(buf_d) > 11; j++)
      {
	buf_release_head_data(buf_d, 11);
	buf_get_iovec(buf_d, 0, FALSE, &iov_cnt);
      }
      buf_release_head_data(buf_d, buf_get_size(buf_d));
    }

    for (i = 0; i < 1; i++)
    {
      buf_catenate_buf(buf_d, buf_c, TRUE);
      for (j = 0; buf_get_size(buf_d) > 11; j++)
      {
	buf_release_head_data(buf_d, 11);
	buf_get_iovec(buf_d, 0, FALSE, &iov_cnt);
      }
      buf_release_head_data(buf_d, buf_get_size(buf_d));
    }
  }

  buf_delete(buf_a);
  buf_delete(buf_b);
  buf_delete(buf_c);
  buf_delete(buf_d);

  out_put(cw_g_out, "Test end\n");

  libstash_shutdown();
  return 0;
}
