/* -*- mode: c ; c-file-style: "canonware-c-style" -*-
 ****************************************************************************
 *
 * Copyright (C) 1996-1999 Jason Evans <jasone@canonware.com>.
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice(s), this list of conditions and the following disclaimer as
 *    the first lines of this file unmodified other than the possible
 *    addition of one or more copyright notices.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice(s), this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDER(S) ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT HOLDER(S) BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************
 *
 * Version: s19990912a
 *
 * <<< Description >>>
 *
 * bhp test.
 *
 ****************************************************************************/

#define _LIBSTASH_USE_BHP
#include <libstash/libstash_r.h>

/* Make sure that nums is at least as large. */
#define _LIBSTASH_TEST_NUM_NODES 100

int
main()
{
  cw_bhpi_t * bhpi;
  cw_bhp_t * h;
  cw_sint32_t i, * a, * b, nums[100] = 
  {
    -944, -522, 410, 296, -523, 828, 573, 611, 878, 936, 604, 527, -893, -696,
    716, 299, -327, -653, 614, 720, -527, 26, -786, -603, 74, -643, 912, -484,
    -960, -266, -516, -905, 210, 893, 390, 687, 722, -35, 298, 600, -99, -97,
    128, 7, 206, -155, -693, 879, 190, 921, 599, 663, -52, 813, -939, -978,
    -830, 972, -462, -790, -294, 20, -696, 916, -85, 694, 603, -363, -340, -97,
    -762, 559, 805, 365, -432, 11, -789, -125, -108, 401, -204, -509, 65, 743,
    -696, 125, 765, -526, 98, -697, -317, 804, 323, -13, 720, -762, -318, 324,
    -125, 340
  };
  
  libstash_init();
  out_put(cw_g_out, "Test begin\n");

  h = bhp_new_r(NULL, bhp_priority_compare_sint32);
  _cw_check_ptr(h);

  for (i = 0; i < _LIBSTASH_TEST_NUM_NODES; i++)
  {
    bhpi = bhpi_new(NULL, &(nums[i]), &(nums[i]), NULL, NULL);
    _cw_check_ptr(bhpi);
    bhp_insert(h, bhpi);
  }
  for (i = 0; i < _LIBSTASH_TEST_NUM_NODES; i++)
  {
    _cw_assert(FALSE == bhp_del_min(h, (void **) &a, (void **) &b));
  }

  for (i = 0; i < _LIBSTASH_TEST_NUM_NODES; i++)
  {
    bhpi = bhpi_new(NULL, &(nums[i]), &(nums[i]), NULL, NULL);
    _cw_check_ptr(bhpi);
    bhp_insert(h, bhpi);
  }
  for (i = 0; i < _LIBSTASH_TEST_NUM_NODES; i++)
  {
    _cw_assert(FALSE == bhp_del_min(h, (void **) &a, (void **) &b));
    out_put(cw_g_out, "i == [i], size == [q]: [i|s:s], [i|s:s]\n",
	    i, bhp_get_size(h), *a, *b);
  }

  bhp_delete(h);
  out_put(cw_g_out, "Test end\n");
  libstash_shutdown();
  return 0;
}
