/* -*- mode: c ; c-file-style: "canonware-c-style" -*-
 ****************************************************************************
 *
 * Copyright (C) 1996-1999 Jason Evans <jasone@canonware.com>.
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice(s), this list of conditions and the following disclaimer as
 *    the first lines of this file unmodified other than the possible
 *    addition of one or more copyright notices.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice(s), this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDER(S) ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT HOLDER(S) BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************
 *
 * Version: s19990912a
 *
 * <<< Description >>>
 *
 * Macros that bypass the mem class, to avoid circular dependencies inside
 * libstash.
 *
 ****************************************************************************/

#ifdef _cw_malloc
#  undef _cw_malloc
#endif
#define _cw_malloc(a) malloc(a)

#ifdef _cw_calloc
#  undef _cw_calloc
#endif
#define _cw_calloc(a, b) calloc(a, b)

#ifdef _cw_realloc
#  undef _cw_realloc
#endif
#define _cw_realloc(a, b) realloc(a, b)

#ifdef _cw_free
#  undef _cw_free
#endif
#define _cw_free(a) free(a)

#ifdef _cw_dealloc
#  undef _cw_dealloc
#endif
#define _cw_dealloc(a) free(a)

#define _cw_mem_check_ptr(x) \
  { \
    if ((x) == NULL) \
      { \
	fprintf(stderr, "At %s, line %d, %s(): %s is a NULL pointer\n", \
		__FILE__, __LINE__, __FUNCTION__, #x); \
        abort(); \
      } \
  }
