/******************************************************************************
 *  Sega Master System / GameGear Emulator
 *  Copyright (C) 1998-2007  Charles MacDonald
 *
 *  additionnal code by Eke-Eke (SMS Plus GX)
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *   ROM File loading support
 *
 ******************************************************************************/

#ifndef LOADROM_H_
#define LOADROM_H_

/* Function prototypes */
uint32_t load_rom(const char *filename);
uint32_t load_rom_mem (const char *data, size_t size);

#ifndef NGC
uint8_t *loadzip(char *archive, const char *filename, int32_t *filesize);
extern char game_name[PATH_MAX];
#endif

#endif /* _LOADROM_H_ */

