/**
 * @file	asiodriverlist.h
 * @brief	ASIO hCo Xg NX̐錾уC^[tFCX̒`܂
 */

#pragma once

#include <vector>

interface IASIO;

/**
 * ASIO hCo
 */
struct AsioDriverInfo
{
	CLSID clsid;					/*!< NX ID */
	TCHAR szDllPath[MAX_PATH];		/*!< DLL pX */
	TCHAR szDriverName[128];		/*!< hCo */
};

/**
 * @brief ASIO hCo Xg NX
 */
class AsioDriverList : public std::vector<AsioDriverInfo>
{
public:
	void EnumerateDrivers();
	IASIO* OpenDriver(LPCTSTR lpDriverName);

private:
	static bool FindDrvPath(LPCTSTR lpClsId, LPTSTR lpDllPath, UINT cchDllPath);
};
