/**
 * @file	externalchipmanager.h
 * @brief	O`bvǗNX̐錾уC^[tFCX̒`܂
 */

#pragma once

#include <vector>
#include "externalchip.h"
#include "c86ctl/c86ctlif.h"
#include "romeo/juliet.h"
#include "scci/scciif.h"

/**
 * @brief O`bvǗNX
 */
class CExternalChipManager
{
public:
	static CExternalChipManager* GetInstance();

	CExternalChipManager();
	void Initialize();
	void Deinitialize();
	IExternalChip* GetInterface(IExternalChip::ChipType nChipType, UINT nClock);
	void Release(IExternalChip* pChip);
	void Reset();
	void Mute(bool bMute);

private:
	static CExternalChipManager sm_instance;	/*!< B̃CX^Xł */
	std::vector<IExternalChip*> m_chips;		/*!< W[ */

	C86CtlIf m_c86ctl;							/*!< C86Ctl CX^X */
	CJuliet m_juliet;							/*!< ROMEO CX^X */
	CScciIf m_scci;								/*!< SCCI CX^X */
	IExternalChip* GetInterfaceInner(IExternalChip::ChipType nChipType, UINT nClock);
};

/**
 * CX^X𓾂
 * @return CX^X
 */
inline CExternalChipManager* CExternalChipManager::GetInstance()
{
	return &sm_instance;
}
