// ---------------------------------------------------------------------------
//	OPN/A/B interface with ADPCM support
//	Copyright (C) cisc 1998, 2003.
// ---------------------------------------------------------------------------
//	$Id: opna.h,v 1.33 2003/06/12 13:14:37 cisc Exp $

#ifndef FM_OPNA_H
#define FM_OPNA_H

#include "fmgen_fmgen.h"
#include "fmgen_fmtimer.h"
#include "fmgen_psg.h"

// ---------------------------------------------------------------------------
//	class OPN/OPNA
//	OPN/OPNA ɗǂ𐶐鉹jbg
//	
//	interface:
//	bool Init(uint clock, uint rate, bool, const char* path);
//		D̃NXgpOɂȂ炸ĂłƁD
//		OPNA ̏ꍇ͂̊֐ŃYTvǂݍ
//
//		clock:	OPN/OPNA/OPNB ̃NbNg(Hz)
//
//		rate:	 PCM ̕W{g(Hz)
//
//		path:	YTṽpX(OPNA ̂ݗL)
//				ȗ̓JgfBNgǂݍ
//				̖ɂ '\'  '/' Ȃǂ邱
//
//		Ԃl	ɐ true
//
//	bool LoadRhythmSample(const char* path)
//		(OPNA ONLY)
//		Rhythm TvǂݒD
//		path  Init  path ƓD
//		
//	bool SetRate(uint clock, uint rate, bool)
//		NbN PCM [gύX
//		 Init QƂ̂ƁD
//	
//	void Mix(FM_SAMPLETYPE* dest, int nsamples)
//		Stereo PCM f[^ nsamples C dest Ŏn܂z
//		(Z)
//		Edest ɂ sample*2 ̗̈悪Kv
//		Ei[` L, R, L, R... ƂȂD
//		E܂ŉZȂ̂ŁC炩ߔz[NAKv
//		EFM_SAMPLETYPE  short ^̏ꍇNbsOs.
//		E̊֐͉̃^C}[Ƃ͓ƗĂD
//		  Timer  Count  GetNextEvent ő삷KvD
//	
//	void Reset()
//		Zbg()
//
//	void SetReg(uint reg, uint data)
//		̃WX^ reg  data 
//	
//	uint GetReg(uint reg)
//		̃WX^ reg ̓eǂݏo
//		ǂݍނƂo郌WX^ PSG, ADPCM ̈ꕔCID(0xff) Ƃ
//	
//	uint ReadStatus()/ReadStatusEx()
//		̃Xe[^XWX^ǂݏo
//		ReadStatusEx ͊gXe[^XWX^̓ǂݏo(OPNA)
//		busy tO͏ 0
//	
//	bool Count(uint32 t)
//		̃^C}[ t [ʕb] i߂D
//		̓Ԃɕω(timer I[o[t[)
//		true Ԃ
//
//	uint32 GetNextEvent()
//		̃^C}[̂ǂ炩I[o[t[܂łɕKv
//		[ʕb]Ԃ
//		^C}[~Ăꍇ ULONG_MAX Ԃc Ǝv
//	
//	void SetVolumeFM(int db)/SetVolumePSG(int db) ...
//		ẻʂ{|ɒ߂DWl 0.
//		Pʂ͖ 1/2 dBCL͈͂̏ 20 (10dB)
//
namespace FM
{
	//	OPN Base -------------------------------------------------------
	struct OPNBaseData {
		struct TimerData timer;
		int fmvolume;
		uint	clock;
		uint	rate;
		uint	psgrate;
		uint	status;
		uint8	prescale;
		struct ChipData chip;
		struct PSGData psg;
	};

	class OPNBase : public Timer
	{
	public:
		OPNBase();
		
		bool	Init(uint c, uint r);
		virtual void Reset();
		
		void	SetVolumeFM(int db);
		void	SetVolumePSG(int db);
		void	SetLPFCutoff(uint freq) {}	// obsolete

		void    DataSave(struct OPNBaseData* data);
		void    DataLoad(struct OPNBaseData* data);
	
	protected:
		void	SetParameter(Channel4* ch, uint addr, uint data);
		void	SetPrescaler(uint p);
		void	RebuildTimeTable();
		
		int		fmvolume;
		
		uint	clock;				// OPN NbN
		uint	rate;				// FM [g
		uint	psgrate;			// FMGen  o̓[g
		uint	status;
		Channel4* csmch;
		

		static  uint32 lfotable[8];
	
	private:
		void	TimerA();
		uint8	prescale;
		
	protected:
		Chip	chip;
		PSG		psg;
	};

	//	OPN2 Base ------------------------------------------------------
	struct OPNABaseData {
		struct OPNBaseData opnbase;
		uint8	pan[6];
		uint8	fnum2[9];
		uint8	reg22;
		uint	reg29;
		uint	stmask;
		uint	statusnext;
		uint32	lfocount;
		uint32	lfodcount;
		uint	fnum[6];
		uint	fnum3[3];
		bool    is_adpcmbuf;
		uint8   adpcmbuf[0x40000];
		uint	adpcmmask;
		uint	adpcmnotice;
		uint	startaddr;
		uint	stopaddr;
		uint	memaddr;
		uint	limitaddr;
		int		adpcmlevel;
		int		adpcmvolume;
		int		adpcmvol;
		uint	deltan;
		int		adplc;
		int		adpld;
		uint	adplbase;
		int		adpcmx;
		int		adpcmd;
		int		adpcmout;
		int		apout0;
		int		apout1;
		uint	adpcmreadbuf;
		bool	adpcmplay;
		int8	granuality;		
		bool	adpcmmask_;
		uint8	control1;
		uint8	control2;
		uint8	adpcmreg[8];
		int		rhythmmask_;
		struct Channel4Data ch[6];
	};

	class OPNABase : public OPNBase
	{
	public:
		OPNABase();
		~OPNABase();
		
		uint	ReadStatus() { return status & 0x03; }
		uint	ReadStatusEx();
		void	SetChannelMask(uint mask);
	
		void	DataSave(struct OPNABaseData* data);
		void	DataLoad(struct OPNABaseData* data);
		
	private:
		virtual void Intr(bool) {}

		void	MakeTable2();
	
	protected:
		bool	Init(uint c, uint r, bool);
		bool	SetRate(uint c, uint r, bool);

		void	Reset();
		void 	SetReg(uint addr, uint data);
		void	SetADPCMBReg(uint reg, uint data);
		uint	GetReg(uint addr);	
	
	protected:
		void	FMMix(Sample* buffer, int nsamples);
		void 	Mix6(Sample* buffer, int nsamples, int activech);
		
		void	MixSubS(int activech, ISample**);
		void	MixSubSL(int activech, ISample**);

		void	SetStatus(uint bit);
		void	ResetStatus(uint bit);
		void	UpdateStatus();
		void	LFO();

		void	DecodeADPCMB();
		void	ADPCMBMix(Sample* dest, uint count);

		void	WriteRAM(uint data);
		uint	ReadRAM();
		int		ReadRAMN();
		int		DecodeADPCMBSample(uint);
		
	// FM ֌W
		uint8	pan[6];
		uint8	fnum2[9];
		
		uint8	reg22;
		uint	reg29;		// OPNA only?
		
		uint	stmask;
		uint	statusnext;

		uint32	lfocount;
		uint32	lfodcount;
		
		uint	fnum[6];
		uint	fnum3[3];
		
	// ADPCM ֌W
		uint8*	adpcmbuf;		// ADPCM RAM
		uint	adpcmmask;		// AhXɑ΂rbg}XN
		uint	adpcmnotice;	// ADPCM ĐIɂrbg
		uint	startaddr;		// Start address
		uint	stopaddr;		// Stop address
		uint	memaddr;		// ĐAhX
		uint	limitaddr;		// Limit address/mask
		int		adpcmlevel;		// ADPCM 
		int		adpcmvolume;
		int		adpcmvol;
		uint	deltan;			// N
		int		adplc;			// gϊpϐ
		int		adpld;			// gϊpϐl
		uint	adplbase;		// adpld ̌
		int		adpcmx;			// ADPCM p x
		int		adpcmd;			// ADPCM p 
		int		adpcmout;		// ADPCM ̏o
		int		apout0;			// out(t-2)+out(t-1)
		int		apout1;			// out(t-1)+out(t)

		uint	adpcmreadbuf;	// ADPCM [hpobt@
		bool	adpcmplay;		// ADPCM Đ
		int8	granuality;		
		bool	adpcmmask_;

		uint8	control1;		// ADPCM Rg[WX^P
		uint8	control2;		// ADPCM Rg[WX^Q
		uint8	adpcmreg[8];	// ADPCM WX^̈ꕔ

		int		rhythmmask_;

		Channel4 ch[6];

		static void	BuildLFOTable();
		static int amtable[FM_LFOENTS];
		static int pmtable[FM_LFOENTS];
		static int32 tltable[FM_TLENTS+FM_TLPOS];
		static bool	tablehasmade;
	};

	//	YM2203(OPN) ----------------------------------------------------
	struct OPNData {
		struct OPNBaseData opnbase;
		uint	fnum[3];
		uint	fnum3[3];
		uint8	fnum2[6];
		struct Channel4Data ch[3];
	};

	class OPN : public OPNBase
	{
	public:
		OPN();
		virtual ~OPN() {}
		
		bool	Init(uint c, uint r, bool=false, const char* =0);
		bool	SetRate(uint c, uint r, bool=false);
		
		void	Reset();
		void 	Mix(Sample* buffer, int nsamples);
		void 	SetReg(uint addr, uint data);
		uint	GetReg(uint addr);
		uint	ReadStatus() { return status & 0x03; }
		uint	ReadStatusEx() { return 0xff; }
		
		void	SetChannelMask(uint mask);
		
		int		dbgGetOpOut(int c, int s) { return ch[c].op[s].dbgopout_; }
		int		dbgGetPGOut(int c, int s) { return ch[c].op[s].dbgpgout_; }
		Channel4* dbgGetCh(int c) { return &ch[c]; }
	
		void	DataSave(struct OPNData* data);
		void	DataLoad(struct OPNData* data);
		
	private:
		virtual void Intr(bool) {}
		
		void	SetStatus(uint bit);
		void	ResetStatus(uint bit);
		
		uint	fnum[3];
		uint	fnum3[3];
		uint8	fnum2[6];
		
		Channel4 ch[3];
	};

	//	YM2608(OPNA) ---------------------------------------------------
	struct Rhythm
	{
		uint8	pan;		// ς
		int8	level;		// 傤
		int		volume;		// 傤Ă
		int16*	sample;		// Ղ
		uint	size;		// 
		uint	pos;		// 
		uint	step;		// ĂՂ
		uint	rate;		// Ղ̂[
	};
	
	struct OPNAData {
		struct OPNABaseData opnabase;
		Rhythm	rhythm[6];
		int8	rhythmtl;
		int		rhythmtvol;		
		uint8	rhythmkey;
	};

	class OPNA : public OPNABase
	{
	public:
		OPNA();
		virtual ~OPNA();
		
		bool	Init(uint c, uint r, bool  = false, const char* rhythmpath=0);
		bool	LoadRhythmSample(const char*);
	
		bool	SetRate(uint c, uint r, bool = false);
		void 	Mix(Sample* buffer, int nsamples);

		void	Reset();
		void 	SetReg(uint addr, uint data);
		uint	GetReg(uint addr);

		void	SetVolumeADPCM(int db);
		void	SetVolumeRhythmTotal(int db);
		void	SetVolumeRhythm(int index, int db);

		uint8*	GetADPCMBuffer() { return adpcmbuf; }

		int		dbgGetOpOut(int c, int s) { return ch[c].op[s].dbgopout_; }
		int		dbgGetPGOut(int c, int s) { return ch[c].op[s].dbgpgout_; }
		Channel4* dbgGetCh(int c) { return &ch[c]; }

		void	DataSave(struct OPNAData* data);
		void	DataLoad(struct OPNAData* data);
		
	private:
		void	RhythmMix(Sample* buffer, uint count);

	// Y֌W
		Rhythm	rhythm[6];
		int8	rhythmtl;		// YŜ̉
		int		rhythmtvol;		
		uint8	rhythmkey;		// ỸL[
	};

	//	YM2610/B(OPNB) ---------------------------------------------------
	struct ADPCMA
	{
		uint8	pan;		// ς
		int8	level;		// 傤
		int		volume;		// 傤Ă
		uint	pos;		// 
		uint	step;		// ĂՂ

		uint	start;		// Jn
		uint	stop;		// I
		uint	nibble;		//  4 bit
		int		adpcmx;		// ϊp
		int		adpcmd;		// ϊp
	};
	
	struct OPNBData {
		struct OPNABaseData opnabase;
//		uint8*	adpcmabuf;
		int		adpcmasize;
		ADPCMA	adpcma[6];
		int8	adpcmatl;
		int		adpcmatvol;		
		uint8	adpcmakey;
		int		adpcmastep;
		uint8	adpcmareg[32];
		struct Channel4Data ch[6];
	};

	class OPNB : public OPNABase
	{
	public:
		OPNB();
		virtual ~OPNB();
		
		bool	Init(uint c, uint r, bool = false,
					 uint8 *_adpcma = 0, int _adpcma_size = 0,
					 uint8 *_adpcmb = 0, int _adpcmb_size = 0);
	
		bool	SetRate(uint c, uint r, bool = false);
		void 	Mix(Sample* buffer, int nsamples);

		void	Reset();
		void 	SetReg(uint addr, uint data);
		uint	GetReg(uint addr);
		uint	ReadStatusEx();

		void	SetVolumeADPCMATotal(int db);
		void	SetVolumeADPCMA(int index, int db);
		void	SetVolumeADPCMB(int db);

//		void	SetChannelMask(uint mask);
		
		void	DataSave(struct OPNBData* data, void* adpcmdata);
		void	DataLoad(struct OPNBData* data, void* adpcmdata);
		
	private:
		int		DecodeADPCMASample(uint);
		void	ADPCMAMix(Sample* buffer, uint count);
		static void InitADPCMATable();
		
	// ADPCMA ֌W
		uint8*	adpcmabuf;		// ADPCMA ROM
		int		adpcmasize;
		ADPCMA	adpcma[6];
		int8	adpcmatl;		// ADPCMA Ŝ̉
		int		adpcmatvol;		
		uint8	adpcmakey;		// ADPCMA ̃L[
		int		adpcmastep;
		uint8	adpcmareg[32];
 
		static int jedi_table[(48+1)*16];

		Channel4 ch[6];
	};

	//	YM2612/3438(OPN2) ----------------------------------------------------
	class OPN2 : public OPNBase
	{
	public:
		OPN2();
		virtual ~OPN2() {}
		
		bool	Init(uint c, uint r, bool=false, const char* =0);
		bool	SetRate(uint c, uint r, bool);
		
		void	Reset();
		void 	Mix(Sample* buffer, int nsamples);
		void 	SetReg(uint addr, uint data);
		uint	GetReg(uint addr);
		uint	ReadStatus() { return status & 0x03; }
		uint	ReadStatusEx() { return 0xff; }
		
		void	SetChannelMask(uint mask);
		
	private:
		virtual void Intr(bool) {}
		
		void	SetStatus(uint bit);
		void	ResetStatus(uint bit);
		
		uint	fnum[3];
		uint	fnum3[3];
		uint8	fnum2[6];
		
	// `ԗp[N
		int32	mixc, mixc1;
		
		Channel4 ch[3];
	};
}

// ---------------------------------------------------------------------------

inline void FM::OPNBase::RebuildTimeTable()
{
	int p = prescale;
	prescale = -1;
	SetPrescaler(p);
}

inline void FM::OPNBase::SetVolumePSG(int db)
{
	psg.SetVolume(db);
}

#endif // FM_OPNA_H
