/**
 * @file	externalopl3.cpp
 * @brief	O OPL3 tNX̓̒`s܂
 */

#include "compiler.h"
#include "externalopl3.h"

/**
 * RXgN^
 * @param[in] pChip `bv
 */
CExternalOpl3::CExternalOpl3(IExternalChip* pChip)
	: m_pChip(pChip)
{
	memset(m_cKon, 0x00, sizeof(m_cKon));
}

/**
 * fXgN^
 */
CExternalOpl3::~CExternalOpl3()
{
	delete m_pChip;
}

/**
 * `bv ^Cv𓾂
 * @return `bv ^Cv
 */
IExternalChip::ChipType CExternalOpl3::GetChipType()
{
	return m_pChip->GetChipType();
}

/**
 * Zbg
 */
void CExternalOpl3::Reset()
{
	m_pChip->Reset();
}

/**
 * WX^
 * @param[in] nAddr AhX
 * @param[in] cData f[^
 */
void CExternalOpl3::WriteRegister(UINT nAddr, UINT8 cData)
{
	if ((nAddr & 0xf0) == 0xb0)
	{
		m_cKon[(nAddr & 0x100) >> 8][nAddr & 0x0f] = cData;
	}
	WriteRegisterInner(nAddr, cData);
}

/**
 * bZ[W
 * @param[in] nMessage bZ[W
 * @param[in] nParameter p[^
 * @return 
 */
INTPTR CExternalOpl3::Message(UINT nMessage, INTPTR nParameter)
{
	switch (nMessage)
	{
		case kMute:
			Mute(nParameter != 0);
			break;
	}
	return 0;
}

/**
 * ~[g
 * @param[in] bMute ~[g
 */
void CExternalOpl3::Mute(bool bMute)
{
	if (bMute)
	{
		for (UINT i = 0; i < 2; i++)
		{
			for (UINT j = 0; j < 9; j++)
			{
				if (m_cKon[i][j] & 0x20)
				{
					m_cKon[i][j] &= 0xdf;
					WriteRegisterInner((i * 0x100) + j + 0xb0, m_cKon[i][j]);
				}
			}
		}
	}
}

/**
 * WX^()
 * @param[in] nAddr AhX
 * @param[in] cData f[^
 */
void CExternalOpl3::WriteRegisterInner(UINT nAddr, UINT8 cData) const
{
	m_pChip->WriteRegister(nAddr, cData);
}
