/**
 * @file	usbdev.h
 * @brief	USB ANZX NX̐錾уC^[tFCX̒`܂
 */

#pragma once

#include <IOKit/usb/IOUSBLib.h>

/**
 * @brief USB ANZX NX
 */
class CUsbDev
{
public:
	CUsbDev();
	~CUsbDev();
	bool Open(unsigned int vid, unsigned int pid, unsigned int nIndex = 0);
	void Close();
	int CtrlXfer(int nType, int nRequest, int nValue = 0, int nIndex = 0, void* lpBuffer = NULL, int cbBuffer = 0);
	int WriteBulk(const void* lpBuffer, int cbBuffer);
	int ReadBulk(void* lpBuffer, int cbBuffer);
	bool IsOpened() const;

private:
	IOUSBDeviceInterface** m_device;			/*!< foCX */
	IOUSBInterfaceInterface** m_interface;		/*!< C^tFCX */
	static IOReturn ConfigureDevice(IOUSBDeviceInterface** dev);
};

/**
 * I[v?
 * @retval true I[v
 * @retval false I[v
 */
inline bool CUsbDev::IsOpened() const
{
	return (m_interface != NULL);
}
