/**
 * @file	ucs2sjis.c
 * @brief	Implementation of converting UCS2 to S-JIS
 */

#include "compiler.h"
#include "codecnv.h"

//! undefined code
#define UDCODE		0x003f

//! 1st table
static const UINT32 s_level1[256] =
{
	0x00010000,0x00000000,0x00000000,0x02003991,0x02725101,0x00000000,
	0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
	0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
	0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
	0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
	0x00000000,0x00000000,0x03142c10,0x036cd203,0x0510c000,0x06900112,
	0x06921460,0x06baf000,0x089a6b05,0x00000000,0x00000000,0x00000000,
	0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
	0x0970ff00,0x00000000,0x0b6e7831,0x0c5ecb03,0x00000000,0x00000000,
	0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
	0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
	0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
	0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
	0x0df4fd00,0x0fef0000,0x11eef705,0x13dcff00,0x15db0000,0x17dafb00,
	0x19d0ff01,0x1bcefb04,0x1dc4fa06,0x1fb8fd00,0x21b2fe00,0x23aefe02,
	0x25aafb01,0x27a0f709,0x298efd01,0x2b88f807,0x2d78fe02,0x2f74ff01,
	0x3172ee0e,0x334f0000,0x354f0000,0x374efa01,0x3942f906,0x3b34fc00,
	0x3d2d0000,0x3f2d0000,0x412cfa01,0x43210000,0x4520fa02,0x4714f004,
	0x48f4ec08,0x4accf904,0x4cbefb05,0x4eb4fe01,0x50b0fd01,0x52aafc04,
	0x54a2f806,0x5692f50a,0x587cf603,0x5a68ff01,0x5c66fe01,0x5e62fc01,
	0x605afc02,0x6252fb01,0x64490000,0x6648f602,0x6834ff00,0x6a32fc00,
	0x6c2a9c01,0x6d62c736,0x6ef0fe00,0x70ecfd02,0x72e6fb01,0x74dcfd01,
	0x76d6fd03,0x78d0ff00,0x7acefd02,0x7cc8ff00,0x7ec6fa05,0x80baf702,
	0x82a8ff00,0x84a69b00,0x85dcc737,0x876afc04,0x8962f708,0x8b50fb03,
	0x8d46fe00,0x8f42fe02,0x913efa06,0x9332f702,0x95207f03,0x961e6f77,
	0x96fce01c,0x98bd0000,0x9abcfe01,0x9cb8fd03,0x9eb2fb01,0xa0a8f006,
	0xa288f700,0xa476fb03,0xa66ce519,0xa8369a07,0x00000000,0x00000000,
	0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
	0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
	0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
	0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
	0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
	0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
	0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
	0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
	0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
	0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
	0x00000000,0x00000000,0xa96b0000,0xab6b0000,0xad6b0000,0xaf6b0000,
	0xb16b0000,0xb36b0000,0xb56b0000,0xb76a5800,0x00000000,0x00000000,
	0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
	0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
	0x00000000,0x00000000,0xb81a04f0,0xb822b429,0xb98a200e,0x00000000,
	0x00000000,0x00000000,0x00000000,0xb9cae501
};

//! 2nd table
static const UINT32 s_level2[] =
{
	0x0000,0x0001,0x0002,0x0003,0x0004,0x0005,0x0006,0x0007,0x0008,
	0x0009,0x000a,0x000b,0x000c,0x000d,0x000e,0x000f,0x0010,0x0011,
	0x0012,0x0013,0x0014,0x0015,0x0016,0x0017,0x0018,0x0019,0x001a,
	0x001b,0x001c,0x001d,0x001e,0x001f,0x0020,0x0021,0x0022,0x0023,
	0x0024,0x0025,0x0026,0x0027,0x0028,0x0029,0x002a,0x002b,0x002c,
	0x002d,0x002e,0x002f,0x0030,0x0031,0x0032,0x0033,0x0034,0x0035,
	0x0036,0x0037,0x0038,0x0039,0x003a,0x003b,0x003c,0x003d,0x003e,
	0x003f,0x0040,0x0041,0x0042,0x0043,0x0044,0x0045,0x0046,0x0047,
	0x0048,0x0049,0x004a,0x004b,0x004c,0x004d,0x004e,0x004f,0x0050,
	0x0051,0x0052,0x0053,0x0054,0x0055,0x0056,0x0057,0x0058,0x0059,
	0x005a,0x005b,0x005c,0x005d,0x005e,0x005f,0x0060,0x0061,0x0062,
	0x0063,0x0064,0x0065,0x0066,0x0067,0x0068,0x0069,0x006a,0x006b,
	0x006c,0x006d,0x006e,0x006f,0x0070,0x0071,0x0072,0x0073,0x0074,
	0x0075,0x0076,0x0077,0x0078,0x0079,0x007a,0x007b,0x007c,0x007d,
	0x007e,0x007f,0x0080,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x0021,
	0x8191,0x8192,UDCODE,0x005c,0x007c,0x8198,0x814e,0x0063,0x0061,
	0x81e1,0x81ca,0x002d,0x0052,0x8150,0x818b,0x817d,0x0032,0x0033,
	0x814c,0x83ca,0x81f7,0x8145,0x8143,0x0031,0x006f,0x81e2,UDCODE,
	UDCODE,UDCODE,UDCODE,0x0041,0x0041,0x0041,0x0041,0x0041,0x0041,
	0x0041,0x0043,0x0045,0x0045,0x0045,0x0045,0x0049,0x0049,0x0049,
	0x0049,0x0044,0x004e,0x004f,0x004f,0x004f,0x004f,0x004f,0x817e,
	0x004f,0x0055,0x0055,0x0055,0x0055,0x0059,0x0054,0x0073,0x0061,
	0x0061,0x0061,0x0061,0x0061,0x0061,0x0061,0x0063,0x0065,0x0065,
	0x0065,0x0065,0x0069,0x0069,0x0069,0x0069,0x0064,0x006e,0x006f,
	0x006f,0x006f,0x006f,0x006f,0x8180,0x006f,0x0075,0x0075,0x0075,
	0x0075,0x0079,0x0074,0x0079,0x839f,0x83a0,0x83a1,0x83a2,0x83a3,
	0x83a4,0x83a5,0x83a6,0x83a7,0x83a8,0x83a9,0x83aa,0x83ab,0x83ac,
	0x83ad,0x83ae,0x83af,UDCODE,0x83b0,0x83b1,0x83b2,0x83b3,0x83b4,
	0x83b5,0x83b6,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	0x83bf,0x83c0,0x83c1,0x83c2,0x83c3,0x83c4,0x83c5,0x83c6,0x83c7,
	0x83c8,0x83c9,0x83ca,0x83cb,0x83cc,0x83cd,0x83ce,0x83cf,UDCODE,
	0x83d0,0x83d1,0x83d2,0x83d3,0x83d4,0x83d5,0x83d6,0x8446,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0x8440,0x8441,0x8442,0x8443,0x8444,
	0x8445,0x8447,0x8448,0x8449,0x844a,0x844b,0x844c,0x844d,0x844e,
	0x844f,0x8450,0x8451,0x8452,0x8453,0x8454,0x8455,0x8456,0x8457,
	0x8458,0x8459,0x845a,0x845b,0x845c,0x845d,0x845e,0x845f,0x8460,
	0x8470,0x8471,0x8472,0x8473,0x8474,0x8475,0x8477,0x8478,0x8479,
	0x847a,0x847b,0x847c,0x847d,0x847e,0x8480,0x8481,0x8482,0x8483,
	0x8484,0x8485,0x8486,0x8487,0x8488,0x8489,0x848a,0x848b,0x848c,
	0x848d,0x848e,0x848f,0x8490,0x8491,UDCODE,0x8476,0x815d,UDCODE,
	UDCODE,UDCODE,UDCODE,0x815c,UDCODE,UDCODE,0x8165,0x8166,UDCODE,
	UDCODE,0x8167,0x8168,UDCODE,UDCODE,0x81f5,0x81f6,UDCODE,UDCODE,
	UDCODE,0x8164,0x8163,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0x81f1,UDCODE,0x818c,0x818d,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x81a6,0x818e,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x8782,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	0x8784,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,0x81f0,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	0x8754,0x8755,0x8756,0x8757,0x8758,0x8759,0x875a,0x875b,0x875c,
	0x875d,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xfa40,0xfa41,
	0xfa42,0xfa43,0xfa44,0xfa45,0xfa46,0xfa47,0xfa48,0xfa49,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0x81a9,0x81aa,0x81a8,0x81ab,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x81cb,UDCODE,0x81cc,
	0x81cd,UDCODE,0x81dd,0x81ce,UDCODE,UDCODE,UDCODE,0x81de,0x81b8,
	UDCODE,UDCODE,0x81b9,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x8794,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x81e3,
	UDCODE,UDCODE,0x81e5,0x8187,0x8798,0x81da,UDCODE,UDCODE,UDCODE,
	UDCODE,0x8161,UDCODE,0x81c8,0x81c9,0x81bf,0x81be,0x81e7,0x81e8,
	UDCODE,0x8793,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x8188,0x81e6,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x81e4,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,0x81e0,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x8182,0x81df,UDCODE,
	UDCODE,UDCODE,UDCODE,0x8185,0x8186,UDCODE,UDCODE,0x81e1,0x81e2,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0x81bc,0x81bd,UDCODE,UDCODE,0x81ba,
	0x81bb,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0x81db,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,0x8799,0x81dc,0x8740,0x8741,0x8742,0x8743,0x8744,
	0x8745,0x8746,0x8747,0x8748,0x8749,0x874a,0x874b,0x874c,0x874d,
	0x874e,0x874f,0x8750,0x8751,0x8752,0x8753,0x849f,0x84aa,0x84a0,
	0x84ab,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	0x84a1,UDCODE,UDCODE,0x84ac,0x84a2,UDCODE,UDCODE,0x84ad,0x84a4,
	UDCODE,UDCODE,0x84af,0x84a3,UDCODE,UDCODE,0x84ae,0x84a5,0x84ba,
	UDCODE,UDCODE,0x84b5,UDCODE,UDCODE,0x84b0,0x84a7,0x84bc,UDCODE,
	UDCODE,0x84b7,UDCODE,UDCODE,0x84b2,0x84a6,UDCODE,UDCODE,0x84b6,
	0x84bb,UDCODE,UDCODE,0x84b1,0x84a8,UDCODE,UDCODE,0x84b8,0x84bd,
	UDCODE,UDCODE,0x84b3,0x84a9,UDCODE,UDCODE,0x84b9,UDCODE,UDCODE,
	0x84be,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	0x84b4,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0x81a1,0x81a0,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0x81a3,0x81a2,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x81a5,0x81a4,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x819f,0x819e,UDCODE,
	UDCODE,UDCODE,0x819b,UDCODE,UDCODE,0x819d,0x819c,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,0x81fc,0x819a,0x8199,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x818a,
	UDCODE,0x8189,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x81f4,UDCODE,UDCODE,0x81f3,
	UDCODE,0x81f2,0x8140,0x8141,0x8142,0x8156,UDCODE,0x8158,0x8159,
	0x815a,0x8171,0x8172,0x8173,0x8174,0x8175,0x8176,0x8177,0x8178,
	0x8179,0x817a,0x81a7,0x81ac,0x816b,0x816c,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0x8780,UDCODE,0x8781,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0x829f,0x82a0,0x82a1,0x82a2,0x82a3,
	0x82a4,0x82a5,0x82a6,0x82a7,0x82a8,0x82a9,0x82aa,0x82ab,0x82ac,
	0x82ad,0x82ae,0x82af,0x82b0,0x82b1,0x82b2,0x82b3,0x82b4,0x82b5,
	0x82b6,0x82b7,0x82b8,0x82b9,0x82ba,0x82bb,0x82bc,0x82bd,0x82be,
	0x82bf,0x82c0,0x82c1,0x82c2,0x82c3,0x82c4,0x82c5,0x82c6,0x82c7,
	0x82c8,0x82c9,0x82ca,0x82cb,0x82cc,0x82cd,0x82ce,0x82cf,0x82d0,
	0x82d1,0x82d2,0x82d3,0x82d4,0x82d5,0x82d6,0x82d7,0x82d8,0x82d9,
	0x82da,0x82db,0x82dc,0x82dd,0x82de,0x82df,0x82e0,0x82e1,0x82e2,
	0x82e3,0x82e4,0x82e5,0x82e6,0x82e7,0x82e8,0x82e9,0x82ea,0x82eb,
	0x82ec,0x82ed,0x82ee,0x82ef,0x82f0,0x82f1,0x8394,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0x814a,0x814b,0x8154,0x8155,UDCODE,
	UDCODE,0x8340,0x8341,0x8342,0x8343,0x8344,0x8345,0x8346,0x8347,
	0x8348,0x8349,0x834a,0x834b,0x834c,0x834d,0x834e,0x834f,0x8350,
	0x8351,0x8352,0x8353,0x8354,0x8355,0x8356,0x8357,0x8358,0x8359,
	0x835a,0x835b,0x835c,0x835d,0x835e,0x835f,0x8360,0x8361,0x8362,
	0x8363,0x8364,0x8365,0x8366,0x8367,0x8368,0x8369,0x836a,0x836b,
	0x836c,0x836d,0x836e,0x836f,0x8370,0x8371,0x8372,0x8373,0x8374,
	0x8375,0x8376,0x8377,0x8378,0x8379,0x837a,0x837b,0x837c,0x837d,
	0x837e,0x8380,0x8381,0x8382,0x8383,0x8384,0x8385,0x8386,0x8387,
	0x8388,0x8389,0x838a,0x838b,0x838c,0x838d,0x838e,0x838f,0x8390,
	0x8391,0x8392,0x8393,0x8394,0x8395,0x8396,UDCODE,UDCODE,UDCODE,
	UDCODE,0x8145,0x815b,0x8152,0x8153,0x878a,0x878b,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0x878c,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0x8785,0x8786,0x8787,0x8788,0x8789,0x8765,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	0x8769,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x8760,UDCODE,
	UDCODE,UDCODE,0x8763,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0x8761,0x876b,UDCODE,UDCODE,0x876a,0x8764,
	UDCODE,UDCODE,UDCODE,0x876c,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x8766,UDCODE,UDCODE,UDCODE,
	UDCODE,0x876e,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x875f,0x876d,UDCODE,
	UDCODE,0x8762,UDCODE,UDCODE,UDCODE,0x8767,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,0x8768,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,0x877e,0x878f,0x878e,0x878d,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0x8772,0x8773,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x876f,
	0x8770,0x8771,UDCODE,UDCODE,0x8775,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0x8774,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0x8783,0x88ea,0x929a,UDCODE,0x8eb5,UDCODE,
	UDCODE,UDCODE,0x969c,0x8fe4,0x8e4f,0x8fe3,0x89ba,UDCODE,0x9573,
	0x975e,UDCODE,0x98a0,0x894e,UDCODE,UDCODE,0x8a8e,0x98a1,0x90a2,
	0x99c0,0x8b75,0x95b8,UDCODE,UDCODE,UDCODE,UDCODE,0x8fe5,UDCODE,
	UDCODE,0x97bc,UDCODE,UDCODE,UDCODE,UDCODE,0x95c0,UDCODE,0xfa68,
	UDCODE,0x98a2,UDCODE,UDCODE,0x9286,UDCODE,UDCODE,UDCODE,0x98a3,
	0x8bf8,UDCODE,UDCODE,UDCODE,0x98a4,UDCODE,0x8adb,0x924f,UDCODE,
	0x8ee5,0x98a5,UDCODE,UDCODE,0x98a6,UDCODE,UDCODE,0x98a7,0x9454,
	UDCODE,0x8b76,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x9456,UDCODE,
	0x93e1,0x8cc1,0x9652,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe568,
	0x98a8,0x8fe6,0x98a9,0x89b3,UDCODE,UDCODE,UDCODE,0x8be3,0x8cee,
	0x96e7,UDCODE,UDCODE,0x9ba4,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	0x9790,UDCODE,0x93fb,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0x8aa3,UDCODE,0x8b54,UDCODE,0x98aa,
	UDCODE,UDCODE,0x98ab,0x97b9,UDCODE,0x975c,0x9188,0x98ad,0x8e96,
	0x93f1,UDCODE,0x98b0,UDCODE,UDCODE,0x895d,0x8cdd,UDCODE,0x8cdc,
	0x88e4,UDCODE,UDCODE,0x986a,0x9869,UDCODE,0x8db1,0x889f,UDCODE,
	0x98b1,0x98b2,0x98b3,0x9653,0x98b4,UDCODE,0x8cf0,0x88e5,0x9692,
	UDCODE,0x8b9c,UDCODE,UDCODE,0x8b9d,0x8b9e,0x92e0,0x97ba,UDCODE,
	0x98b5,UDCODE,UDCODE,0x98b6,UDCODE,UDCODE,0x98b7,UDCODE,UDCODE,
	UDCODE,0x906c,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x8f59,0x906d,
	0x98bc,UDCODE,0x98ba,UDCODE,0x98bb,0x8b77,UDCODE,UDCODE,0x8da1,
	0x89ee,UDCODE,0x98b9,0x98b8,0x95a7,UDCODE,UDCODE,UDCODE,UDCODE,
	0x8e65,0x8e64,0x91bc,0x98bd,0x9574,0x90e5,UDCODE,UDCODE,UDCODE,
	0x8157,0x98be,0x98c0,UDCODE,0xfa69,UDCODE,0x91e3,0x97df,0x88c8,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x98bf,0x89bc,
	UDCODE,0x8bc2,UDCODE,0x9287,UDCODE,UDCODE,UDCODE,0x8c8f,0x98c1,
	UDCODE,UDCODE,UDCODE,0x9443,0xfa6a,0xfa6b,0x8ae9,UDCODE,0xfa6c,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x98c2,0x88c9,UDCODE,UDCODE,
	0x8cde,0x8aea,0x959a,0x94b0,0x8b78,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0x89ef,UDCODE,0x98e5,0x9360,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x948c,0x98c4,
	UDCODE,UDCODE,UDCODE,0x94ba,UDCODE,0x97e0,UDCODE,0x904c,0xfa6d,
	0x8e66,UDCODE,0x8e97,0x89be,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	0x92cf,UDCODE,UDCODE,0x9241,0x98c8,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,0x88ca,0x92e1,0x8f5a,0x8db2,0x9743,UDCODE,0x91cc,UDCODE,
	0x89bd,0xfa6e,0x98c7,UDCODE,0x975d,0x98c3,0x98c5,0x8dec,0x98c6,
	0x9b43,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,0x98ce,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x98d1,
	0x98cf,UDCODE,UDCODE,0x89c0,UDCODE,0x95b9,0x98c9,UDCODE,UDCODE,
	UDCODE,UDCODE,0x98cd,0x8cf1,UDCODE,UDCODE,0x8e67,UDCODE,UDCODE,
	UDCODE,0x8aa4,UDCODE,UDCODE,0x98d2,UDCODE,0x98ca,UDCODE,0xfa70,
	0x97e1,UDCODE,0x8e98,UDCODE,0x98cb,UDCODE,0x98d0,0xfa6f,UDCODE,
	0xfa72,UDCODE,0x98d3,UDCODE,0x98cc,UDCODE,0xfa71,0x8b9f,UDCODE,
	0x88cb,UDCODE,UDCODE,0x8ba0,0x89bf,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x9b44,UDCODE,0x9699,0x958e,
	0x8cf2,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x904e,0x97b5,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x95d6,UDCODE,
	UDCODE,0x8c57,0x91a3,0x89e2,UDCODE,UDCODE,UDCODE,UDCODE,0xfa61,
	0x8f72,UDCODE,UDCODE,0xfa73,0x98d7,UDCODE,0x98dc,0x98da,UDCODE,
	UDCODE,0x98d5,UDCODE,UDCODE,0x91ad,0x98d8,UDCODE,0x98db,0x98d9,
	UDCODE,0x95db,UDCODE,0x98d6,UDCODE,0x904d,UDCODE,0x9693,0x98dd,
	0x98de,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	0x8f43,0x98eb,UDCODE,UDCODE,UDCODE,0x946f,UDCODE,0x9555,0x98e6,
	UDCODE,0x95ee,UDCODE,0x89b4,UDCODE,UDCODE,UDCODE,0x98ea,0xfa76,
	0x98e4,0x98ed,UDCODE,UDCODE,0x9171,UDCODE,0x8cc2,UDCODE,0x947b,
	UDCODE,0xe0c5,UDCODE,0x98ec,0x937c,UDCODE,0x98e1,UDCODE,0x8cf4,
	UDCODE,UDCODE,0x8cf3,0x98df,UDCODE,UDCODE,UDCODE,0xfa77,0x8ed8,
	UDCODE,0x98e7,0xfa75,0x95ed,0x926c,0x98e3,0x8c91,UDCODE,0x98e0,
	0x98e8,0x98e2,0x97cf,0x98e9,0x9860,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0x8be4,UDCODE,UDCODE,0x8c90,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xfa74,UDCODE,0xfa7a,0x98ee,
	UDCODE,UDCODE,0xfa78,0x98ef,0x98f3,0x88cc,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,0x95ce,0x98f2,UDCODE,UDCODE,UDCODE,UDCODE,0x98f1,
	0x98f5,UDCODE,UDCODE,UDCODE,0x98f4,UDCODE,0x92e2,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x8c92,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0x98f6,UDCODE,UDCODE,UDCODE,0xfa79,
	UDCODE,0x8ec3,UDCODE,0x91a4,0x92e3,0x8bf4,UDCODE,0x98f7,UDCODE,
	UDCODE,UDCODE,UDCODE,0x8b55,UDCODE,UDCODE,0x98f8,UDCODE,UDCODE,
	UDCODE,UDCODE,0x98fa,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,0x9654,UDCODE,UDCODE,UDCODE,0x8c86,UDCODE,UDCODE,0xfa7b,
	UDCODE,UDCODE,UDCODE,0x8e50,0x94f5,0x98f9,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x8dc3,0x9762,UDCODE,UDCODE,
	UDCODE,UDCODE,0x98fc,0x9942,0x98fb,0x8dc2,UDCODE,0x8f9d,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x8c58,UDCODE,UDCODE,UDCODE,
	0x9943,UDCODE,UDCODE,0x8bcd,UDCODE,UDCODE,UDCODE,0x9940,0x9941,
	UDCODE,UDCODE,0x93ad,UDCODE,0x919c,UDCODE,0x8ba1,UDCODE,UDCODE,
	UDCODE,0x966c,0x9944,UDCODE,0xfa7d,UDCODE,0x97bb,UDCODE,UDCODE,
	UDCODE,0x9945,UDCODE,UDCODE,UDCODE,UDCODE,0x9948,UDCODE,0x9946,
	UDCODE,0x916d,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x9947,0x9949,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xfa7c,0x994b,UDCODE,UDCODE,
	UDCODE,0x994a,UDCODE,0x95c6,0x8b56,0x994d,0x994e,UDCODE,0x89ad,
	UDCODE,UDCODE,UDCODE,UDCODE,0x994c,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0x8ef2,UDCODE,0x9951,0x9950,0x994f,
	UDCODE,0x98d4,UDCODE,0x9952,UDCODE,UDCODE,UDCODE,UDCODE,0x8f9e,
	UDCODE,0x9953,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,0x9744,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	0x96d7,UDCODE,UDCODE,UDCODE,UDCODE,0x9955,UDCODE,UDCODE,0x9954,
	0x9957,0x9956,UDCODE,UDCODE,0x9958,0x9959,0x88f2,UDCODE,0x8cb3,
	0x8c5a,0x8f5b,0x929b,0x8ba2,0x90e6,0x8cf5,0xfa7e,0x8d8e,0x995b,
	0x96c6,0x9365,UDCODE,0x8e99,UDCODE,0x995a,UDCODE,0x995c,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0x937d,UDCODE,0x8a95,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0x995d,UDCODE,0xfa80,0x93fc,UDCODE,UDCODE,
	0x9153,0x995f,0x9960,0x94aa,0x8cf6,0x985a,0x9961,UDCODE,UDCODE,
	0x8ba4,UDCODE,UDCODE,UDCODE,0x95ba,0x91b4,0x8bef,0x9354,UDCODE,
	UDCODE,UDCODE,0x8c93,UDCODE,UDCODE,UDCODE,0x9962,UDCODE,0x9963,
	UDCODE,UDCODE,0x93e0,0x897e,UDCODE,UDCODE,0x9966,0x8dfb,UDCODE,
	0x9965,0x8dc4,UDCODE,0x9967,0xe3ec,0x9968,0x9660,0x9969,UDCODE,
	0x996a,0x996b,0x8fe7,UDCODE,0x8eca,UDCODE,UDCODE,UDCODE,0xfa81,
	UDCODE,UDCODE,0x8aa5,UDCODE,0x996e,UDCODE,0x996c,0x96bb,0x996d,
	UDCODE,0x9579,0x996f,0x9970,0x9971,0x937e,UDCODE,UDCODE,UDCODE,
	0x9975,0x9973,0x9974,0x9972,0x8de1,0x9976,0x96e8,0x97e2,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0x9977,0xfa82,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,0x90a6,0x9978,0x8f79,UDCODE,UDCODE,0x9979,UDCODE,
	0x929c,0x97bd,0x9380,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,0x99c3,UDCODE,UDCODE,UDCODE,UDCODE,0x997a,0xeaa3,
	0x8bc3,UDCODE,UDCODE,0x997b,0x967d,UDCODE,UDCODE,UDCODE,UDCODE,
	0x8f88,0x91fa,UDCODE,0x997d,0x93e2,UDCODE,0xfa83,0x997e,UDCODE,
	UDCODE,0x9980,0x8a4d,UDCODE,UDCODE,UDCODE,0x9981,0x8ba5,UDCODE,
	0x93ca,0x899a,0x8f6f,UDCODE,UDCODE,0x949f,0x9982,0x9381,UDCODE,
	UDCODE,0x906e,0x9983,UDCODE,0x95aa,0x90d8,0x8aa0,UDCODE,0x8aa7,
	0x9984,UDCODE,UDCODE,0x9986,UDCODE,UDCODE,0x8c59,UDCODE,UDCODE,
	0x9985,0xfa84,UDCODE,0x97f1,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	0x8f89,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x94bb,0x95ca,
	UDCODE,0x9987,UDCODE,0x9798,0x9988,UDCODE,UDCODE,UDCODE,0x9989,
	UDCODE,0x939e,UDCODE,UDCODE,0x998a,UDCODE,UDCODE,0x90a7,0x8dfc,
	0x8c94,0x998b,0x8e68,0x8d8f,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,0x92e4,0x998d,UDCODE,UDCODE,0x91a5,UDCODE,UDCODE,
	0x8ded,0x998e,0x998f,0x914f,UDCODE,0x998c,UDCODE,UDCODE,UDCODE,
	UDCODE,0x9991,UDCODE,0x9655,UDCODE,UDCODE,UDCODE,UDCODE,0x8d84,
	UDCODE,UDCODE,0x9990,UDCODE,UDCODE,UDCODE,UDCODE,0x8c95,0x8ddc,
	0x948d,UDCODE,UDCODE,UDCODE,0x9994,0x9992,UDCODE,UDCODE,UDCODE,
	UDCODE,0x959b,0x8fe8,0x999b,0x8a84,0x9995,0x9993,0x916e,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x9997,UDCODE,0x9996,
	UDCODE,UDCODE,UDCODE,0x8a63,UDCODE,UDCODE,UDCODE,0x8c80,0x999c,
	0x97ab,UDCODE,UDCODE,UDCODE,0x9998,UDCODE,UDCODE,UDCODE,0x999d,
	0x999a,UDCODE,0x9999,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	0x97cd,0xfa85,UDCODE,UDCODE,0x8cf7,0x89c1,UDCODE,UDCODE,0x97f2,
	UDCODE,UDCODE,0xfa86,UDCODE,UDCODE,0x8f95,0x9377,0x8d85,0x99a0,
	0x99a1,UDCODE,0xfb77,UDCODE,0x97e3,UDCODE,UDCODE,0x984a,0x99a3,
	UDCODE,UDCODE,UDCODE,0x8cf8,UDCODE,UDCODE,0x99a2,UDCODE,0x8a4e,
	UDCODE,0xfa87,0x99a4,UDCODE,0x9675,UDCODE,0x92ba,UDCODE,0x9745,
	UDCODE,0x95d7,UDCODE,UDCODE,UDCODE,0x99a5,UDCODE,UDCODE,UDCODE,
	UDCODE,0xe8d3,UDCODE,UDCODE,0x93ae,UDCODE,0x99a6,0x8aa8,0x96b1,
	UDCODE,0xfa88,UDCODE,0x8f9f,0x99a7,0x95e5,0x99ab,UDCODE,0x90a8,
	0x99a8,0x8bce,UDCODE,0x99a9,0x8aa9,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x8c4d,0x99ac,UDCODE,
	0x99ad,UDCODE,UDCODE,0x99ae,0x99af,0x8ed9,UDCODE,UDCODE,UDCODE,
	0x8cf9,0x96dc,0xfa89,0x96e6,0x93f5,UDCODE,UDCODE,0x95ef,0x99b0,
	0xfa8a,0x99b1,UDCODE,UDCODE,UDCODE,UDCODE,0x99b3,UDCODE,0x99b5,
	0x99b4,UDCODE,UDCODE,UDCODE,UDCODE,0x99b6,0x89bb,0x966b,UDCODE,
	0x8dfa,0x99b7,UDCODE,UDCODE,0x9178,UDCODE,UDCODE,0x8fa0,0x8ba7,
	UDCODE,0x99b8,0xfa8b,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x94d9,
	UDCODE,UDCODE,UDCODE,UDCODE,0x99b9,UDCODE,0x99ba,UDCODE,0x99bb,
	UDCODE,UDCODE,UDCODE,UDCODE,0x99bc,0x9543,0x8be6,0x88e3,UDCODE,
	UDCODE,UDCODE,0x93bd,0x99bd,0x8f5c,UDCODE,0x90e7,UDCODE,0x99bf,
	0x99be,0x8fa1,0x8cdf,0x99c1,0x94bc,UDCODE,UDCODE,0x99c2,UDCODE,
	UDCODE,UDCODE,0x94da,0x91b2,0x91ec,0x8ba6,UDCODE,UDCODE,0x93ec,
	0x9250,UDCODE,0x948e,UDCODE,0x966d,UDCODE,0x99c4,UDCODE,0x90e8,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x8c54,UDCODE,UDCODE,0x99c5,
	UDCODE,UDCODE,UDCODE,UDCODE,0x99c6,0x894b,0x88f3,0x8aeb,0xfa8c,
	0x91a6,0x8b70,0x9791,UDCODE,0x99c9,0x89b5,UDCODE,UDCODE,0x99c8,
	UDCODE,UDCODE,UDCODE,0x8ba8,UDCODE,UDCODE,0x99ca,UDCODE,0x96ef,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xfa8d,UDCODE,UDCODE,0x99cb,
	UDCODE,0x97d0,UDCODE,0x8cfa,UDCODE,UDCODE,UDCODE,UDCODE,0x8cb4,
	0x99cc,UDCODE,UDCODE,UDCODE,UDCODE,0x99ce,0x99cd,UDCODE,0x907e,
	0x8958,UDCODE,UDCODE,UDCODE,0x897d,0x99cf,UDCODE,0x99d0,UDCODE,
	0xfa8e,0x8cb5,UDCODE,UDCODE,0x99d1,UDCODE,UDCODE,UDCODE,UDCODE,
	0x8b8e,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x8e51,0x99d2,
	UDCODE,UDCODE,UDCODE,UDCODE,0x9694,0x8db3,0x8b79,0x9746,0x916f,
	0x94bd,0x8efb,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x8f66,UDCODE,
	0x8ee6,0x8ef3,UDCODE,0x8f96,UDCODE,0x94be,UDCODE,0xfa8f,UDCODE,
	0x99d5,UDCODE,0x8962,0x9170,0x8cfb,0x8cc3,0x8be5,UDCODE,UDCODE,
	0x99d9,0x9240,0x91fc,0x8ba9,0x8fa2,0x99da,0x99d8,0x89c2,0x91e4,
	0x8eb6,0x8e6a,0x8945,UDCODE,UDCODE,0x8a90,0x8d86,0x8e69,UDCODE,
	0x99db,0x99dc,UDCODE,0x8b68,0x8a65,UDCODE,UDCODE,UDCODE,0x8d87,
	0x8b67,0x92dd,0x8944,0x93af,0x96bc,0x8d40,0x9799,0x9366,0x8cfc,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	0x8c4e,UDCODE,0x99e5,UDCODE,0x8be1,0x9669,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,0x94db,UDCODE,UDCODE,0x99e4,UDCODE,0x8adc,0x99df,
	0x99e0,0x99e2,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	0x99e3,UDCODE,0x8b7a,0x9081,UDCODE,0x95ab,0x99e1,0x99dd,0x8ce1,
	UDCODE,0x99de,UDCODE,0x9843,UDCODE,UDCODE,UDCODE,0x95f0,UDCODE,
	0x92e6,0x8ce0,0x8d90,UDCODE,UDCODE,UDCODE,0x99e6,UDCODE,UDCODE,
	0x93db,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x99ea,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x8efc,UDCODE,0x8ef4,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0x99ed,0x99eb,UDCODE,0x96a1,UDCODE,
	0x99e8,0x99f1,0x99ec,UDCODE,UDCODE,UDCODE,0x99ef,0x8cc4,0x96bd,
	UDCODE,UDCODE,0x99f0,UDCODE,UDCODE,UDCODE,0x99f2,UDCODE,0x99f4,
	UDCODE,UDCODE,UDCODE,0xfa92,0x8dee,0x9861,UDCODE,0x99e9,0x99e7,
	0x99f3,UDCODE,0x99ee,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0xfa91,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	0x99f6,UDCODE,0x9a42,0x99f8,UDCODE,UDCODE,0x99fc,0xfa93,UDCODE,
	0x9a40,0x99f9,UDCODE,UDCODE,0x9a5d,UDCODE,UDCODE,0x8de7,0x8a50,
	UDCODE,UDCODE,UDCODE,UDCODE,0x99f7,UDCODE,UDCODE,UDCODE,0x9a44,
	0x88f4,0x9a43,UDCODE,0x88a3,0x9569,0x9a41,UDCODE,0x99fa,UDCODE,
	UDCODE,0x99f5,0x99fb,0x8dc6,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	0x9a45,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	0x88f5,0x9a4e,UDCODE,UDCODE,0x9a46,0x9a47,UDCODE,0x8fa3,0x9689,
	UDCODE,UDCODE,UDCODE,0x9a4c,0x9a4b,UDCODE,UDCODE,UDCODE,0x934e,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x9a4d,UDCODE,
	UDCODE,0x9a4a,UDCODE,0xfa94,0x8953,UDCODE,0x8db4,0x904f,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x9a48,0x9382,UDCODE,
	UDCODE,UDCODE,0x9a49,UDCODE,0x88a0,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,0x9a53,0x9742,UDCODE,0x8fa5,UDCODE,0x9a59,UDCODE,UDCODE,
	UDCODE,UDCODE,0x9a58,0x9a4f,UDCODE,UDCODE,UDCODE,UDCODE,0x91c1,
	UDCODE,0x9a50,UDCODE,UDCODE,UDCODE,0x91ed,0x9a55,0x8fa4,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0x9a52,UDCODE,UDCODE,0x96e2,UDCODE,
	UDCODE,UDCODE,0x8c5b,UDCODE,UDCODE,0x9a56,0x9a57,UDCODE,UDCODE,
	UDCODE,UDCODE,0x9a54,0x9a5a,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	0x9a51,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x9a60,0x9a65,UDCODE,
	0x9a61,UDCODE,0x9a5c,UDCODE,UDCODE,0x9a66,0x9150,UDCODE,0xfa95,
	0x9a68,UDCODE,0x8d41,0x9a5e,0x929d,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x9a62,
	0x9a5b,0x8aab,UDCODE,0x8aec,0x8a85,0x9a63,0x9a5f,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x8c96,0x9a69,0x9a67,0x9172,
	0x8b69,0x8baa,UDCODE,0x9a64,UDCODE,0x8bf2,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,0x8963,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x9a6d,0x9a6b,
	UDCODE,0x9aa5,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x9a70,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,0x9a6a,UDCODE,0x9a6e,UDCODE,UDCODE,0x9a6c,UDCODE,
	UDCODE,UDCODE,0x8e6b,0x9a6f,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0x9a72,UDCODE,0x9a77,UDCODE,UDCODE,
	UDCODE,0x9a75,0x9a74,0x9251,UDCODE,UDCODE,0x89c3,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x9a71,
	UDCODE,0x9a73,0x8fa6,0x8952,UDCODE,UDCODE,0x9a76,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,0x89dc,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x9a82,
	UDCODE,0x8ffa,0x9a7d,UDCODE,0x9a7b,UDCODE,0x9a7c,UDCODE,0x9a7e,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	0x895c,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,0x9158,UDCODE,0x9a78,UDCODE,0x9a79,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x8a9a,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x9a81,UDCODE,
	UDCODE,UDCODE,0x8aed,UDCODE,0x9a84,0x9a80,0x9a83,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x95ac,UDCODE,UDCODE,UDCODE,
	0x93d3,UDCODE,0x94b6,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x9a86,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x9a85,0x8a64,UDCODE,UDCODE,
	0x9a87,UDCODE,UDCODE,UDCODE,UDCODE,0x9a8a,UDCODE,UDCODE,UDCODE,
	UDCODE,0x9a89,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0x9a88,UDCODE,0x9458,UDCODE,UDCODE,
	0x9a8b,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	0x9a8c,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x9a8e,UDCODE,0x9a8d,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x9a90,UDCODE,UDCODE,UDCODE,
	0x9a93,0x9a91,0x9a8f,0x9a92,UDCODE,UDCODE,UDCODE,UDCODE,0x9a94,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x9a95,UDCODE,UDCODE,0x9a96,
	UDCODE,0x9a97,UDCODE,UDCODE,UDCODE,0x9a98,0x9964,UDCODE,0x8efa,
	0x8e6c,UDCODE,UDCODE,0x89f1,UDCODE,0x88f6,UDCODE,UDCODE,0x9263,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,0x9a99,UDCODE,0x8da2,UDCODE,0x88cd,0x907d,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0x9a9a,0x8cc5,UDCODE,UDCODE,0x8d91,UDCODE,
	0x9a9c,0x9a9b,UDCODE,UDCODE,0x95de,0x9a9d,UDCODE,UDCODE,UDCODE,
	0x9a9f,0x9a9e,UDCODE,0x9aa0,UDCODE,0x9aa1,UDCODE,0x8c97,UDCODE,
	UDCODE,0x8980,0x9aa2,UDCODE,UDCODE,0x9aa4,UDCODE,0x9aa3,UDCODE,
	UDCODE,UDCODE,0x9aa6,UDCODE,UDCODE,0x9379,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0x9aa7,0x88b3,0x8ddd,UDCODE,UDCODE,UDCODE,
	UDCODE,0x8c5c,UDCODE,UDCODE,0x926e,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,0x9aa8,0x9aa9,UDCODE,UDCODE,0x9aab,UDCODE,UDCODE,
	UDCODE,UDCODE,0x9aac,UDCODE,0x8de2,UDCODE,UDCODE,UDCODE,UDCODE,
	0x8bcf,UDCODE,UDCODE,0x9656,UDCODE,UDCODE,UDCODE,0x9aaa,0x9aad,
	0x8dbf,0x8d42,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	0xfa96,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x9ab1,
	UDCODE,UDCODE,0x8da3,0xfa97,0x9252,UDCODE,UDCODE,0x9aae,0x92d8,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,0x9ab2,UDCODE,UDCODE,0x9082,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,0x9ab0,0x9ab3,UDCODE,0x8c5e,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0x9ab4,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x9ab5,
	UDCODE,0x8d43,0x8a5f,0x9ab7,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	0x9ab8,UDCODE,0xfa98,UDCODE,UDCODE,UDCODE,0x9ab9,UDCODE,UDCODE,
	0x9ab6,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0x9aaf,UDCODE,UDCODE,0x9aba,UDCODE,
	UDCODE,0x9abb,0xfa9a,0xfa99,UDCODE,UDCODE,0x9684,UDCODE,UDCODE,
	0x8fe9,UDCODE,UDCODE,UDCODE,0x9abd,0x9abe,0x9abc,UDCODE,0x9ac0,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x9457,UDCODE,UDCODE,0x88e6,
	0x9575,UDCODE,UDCODE,0x9ac1,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,0x8ffb,UDCODE,UDCODE,0x8eb7,UDCODE,0x947c,0x8aee,
	UDCODE,0x8de9,0x9678,UDCODE,0x93b0,UDCODE,UDCODE,0x8c98,0x91cd,
	UDCODE,UDCODE,UDCODE,0x9abf,0x9ac2,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x91c2,UDCODE,UDCODE,UDCODE,
	0x9ac3,UDCODE,UDCODE,UDCODE,0x9ac4,UDCODE,UDCODE,UDCODE,0x9ac6,
	UDCODE,UDCODE,0x92e7,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x8aac,
	UDCODE,UDCODE,UDCODE,UDCODE,0xea9f,0x8981,0x95f1,UDCODE,UDCODE,
	0x8fea,0x9367,UDCODE,UDCODE,UDCODE,UDCODE,0x8de4,UDCODE,UDCODE,
	0x9acc,UDCODE,UDCODE,0x95bb,0x97db,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0x89f2,0x9ac8,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,0x9159,0x9acb,UDCODE,0x9383,UDCODE,UDCODE,0x9368,
	0x9384,0x94b7,0x92cb,UDCODE,UDCODE,UDCODE,0x8dc7,UDCODE,UDCODE,
	UDCODE,0x9ac7,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x8996,
	UDCODE,0x9355,UDCODE,UDCODE,UDCODE,UDCODE,0x9ac9,UDCODE,0x9ac5,
	UDCODE,UDCODE,0x906f,UDCODE,UDCODE,UDCODE,0x9acd,UDCODE,UDCODE,
	UDCODE,UDCODE,0x8f6d,UDCODE,UDCODE,UDCODE,UDCODE,0x8bab,UDCODE,
	0x9ace,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x95e6,UDCODE,UDCODE,UDCODE,
	0x919d,UDCODE,UDCODE,UDCODE,UDCODE,0x92c4,UDCODE,0xfa9d,0x9ad0,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x966e,
	UDCODE,UDCODE,0x9ad1,UDCODE,UDCODE,0x9ad6,UDCODE,UDCODE,UDCODE,
	0xfa9e,0x95ad,UDCODE,UDCODE,UDCODE,UDCODE,0x9ad5,0x9acf,0x9ad2,
	0x9ad4,UDCODE,UDCODE,0x8da4,UDCODE,UDCODE,0x95c7,UDCODE,UDCODE,
	UDCODE,0x9ad7,UDCODE,0x9264,UDCODE,UDCODE,0x89f3,UDCODE,0x8feb,
	UDCODE,UDCODE,UDCODE,UDCODE,0x9ad9,UDCODE,0x9ad8,UDCODE,0x8d88,
	UDCODE,0x9ada,0x9adc,0x9adb,UDCODE,UDCODE,0x9ade,UDCODE,0x9ad3,
	0x9ae0,UDCODE,UDCODE,UDCODE,UDCODE,0x9adf,0x9add,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0x8e6d,0x9070,UDCODE,0x9173,0x9ae1,0x90ba,
	0x88eb,0x9484,UDCODE,UDCODE,UDCODE,UDCODE,0x92d9,UDCODE,0x9ae3,
	0x9ae2,0x9ae4,0x9ae5,0x9ae6,0x9ae7,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,0x95cf,0x9ae8,0xfa9f,UDCODE,UDCODE,UDCODE,0x89c4,
	0x9ae9,UDCODE,UDCODE,UDCODE,UDCODE,0x975b,0x8a4f,UDCODE,0x99c7,
	0x8f67,0x91bd,0x9aea,0x96e9,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	0x96b2,UDCODE,UDCODE,0x9aec,UDCODE,0x91e5,UDCODE,0x9356,0x91be,
	0x9576,0x9aed,0x9aee,0x899b,UDCODE,UDCODE,0x8eb8,0x9aef,UDCODE,
	UDCODE,UDCODE,UDCODE,0x88ce,0x9af0,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,0x9af1,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x8982,UDCODE,
	UDCODE,0x8aef,0x93de,0x95f2,UDCODE,UDCODE,UDCODE,UDCODE,0x9af5,
	0x9174,0x9af4,0x8c5f,UDCODE,0xfaa0,0x967a,0x9af3,UDCODE,0x9385,
	0x9af7,UDCODE,0x9af6,0xfaa1,UDCODE,0xfaa2,UDCODE,UDCODE,0x9af9,
	UDCODE,0x9af8,0xfaa3,UDCODE,0x899c,UDCODE,0x9afa,0x8fa7,0x9afc,
	0x9244,UDCODE,0x9afb,UDCODE,0x95b1,UDCODE,UDCODE,UDCODE,UDCODE,
	0x8f97,0x937a,UDCODE,UDCODE,UDCODE,0x9b40,UDCODE,UDCODE,UDCODE,
	UDCODE,0x8d44,UDCODE,UDCODE,UDCODE,0x9b41,0x9440,0x94dc,0x96cf,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x9444,UDCODE,UDCODE,0x9b4a,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x8b57,UDCODE,UDCODE,0x9764,
	UDCODE,UDCODE,0x96ad,UDCODE,0x9baa,UDCODE,0x9b42,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0x9b45,0xfaa4,0x91c3,UDCODE,UDCODE,0x9657,
	UDCODE,UDCODE,UDCODE,0x9369,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	0x9b46,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x9685,0xfaa5,
	0x8dc8,UDCODE,UDCODE,0x8fa8,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,0x9b47,UDCODE,UDCODE,0x8e6f,UDCODE,0x8e6e,UDCODE,
	UDCODE,UDCODE,UDCODE,0x88b7,0x8cc6,UDCODE,0x90a9,0x88cf,UDCODE,
	UDCODE,UDCODE,UDCODE,0x9b4b,0x9b4c,UDCODE,0x9b49,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x8957,0x8aad,UDCODE,
	0x9b48,UDCODE,0x96c3,0x9550,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x88a6,UDCODE,UDCODE,UDCODE,
	UDCODE,0x88f7,UDCODE,UDCODE,UDCODE,0x8e70,0x88d0,UDCODE,0x88a1,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x9b51,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0x9b4f,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,0x96ba,UDCODE,0x9b52,UDCODE,0x9b50,UDCODE,UDCODE,
	0x9b4e,0x9050,UDCODE,UDCODE,UDCODE,UDCODE,0x9b4d,UDCODE,UDCODE,
	UDCODE,0x95d8,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x8ce2,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0x9b56,0x9b57,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,0x8fa9,UDCODE,UDCODE,UDCODE,0x9b53,0x984b,UDCODE,
	UDCODE,UDCODE,UDCODE,0x946b,UDCODE,UDCODE,0x9b55,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x8da5,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0x9b58,UDCODE,UDCODE,UDCODE,0x9577,
	UDCODE,UDCODE,UDCODE,0x9b59,UDCODE,0x9b54,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x96b9,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x947d,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x9b5a,0x9551,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0x9b5b,0x9b5f,0x9b5c,UDCODE,UDCODE,
	0x89c5,0x9b5e,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x8eb9,
	UDCODE,0x9b5d,0x8c99,UDCODE,UDCODE,UDCODE,0x9b6b,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0x9b64,0x9b61,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x9284,UDCODE,0x9b60,UDCODE,
	UDCODE,0x9b62,UDCODE,UDCODE,0x9b63,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0x9b65,0x9b66,0x8af0,UDCODE,0x9b68,0x9b67,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	0x9b69,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0x8fec,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,0x9b6c,UDCODE,0x92da,UDCODE,UDCODE,UDCODE,0x8964,
	UDCODE,0x9b6a,UDCODE,UDCODE,UDCODE,0x9b6d,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0x9b6e,UDCODE,0x9b71,UDCODE,UDCODE,
	0x9b6f,UDCODE,0x9b70,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0x8e71,0x9b72,UDCODE,UDCODE,0x8d45,
	0x9b73,0xfaa6,0x8e9a,0x91b6,UDCODE,0x9b74,0x9b75,0x8e79,0x8d46,
	UDCODE,0x96d0,UDCODE,UDCODE,UDCODE,0x8b47,0x8cc7,0x9b76,0x8a77,
	UDCODE,UDCODE,0x9b77,UDCODE,0x91b7,UDCODE,UDCODE,UDCODE,UDCODE,
	0x9b78,0x9ba1,UDCODE,0x9b79,UDCODE,0x9b7a,UDCODE,UDCODE,0x9b7b,
	UDCODE,0x9b7d,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x9b7e,UDCODE,
	UDCODE,0x9b80,UDCODE,0x91ee,UDCODE,0x8946,0x8ee7,0x88c0,UDCODE,
	0x9176,0x8aae,0x8eb3,UDCODE,0x8d47,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,0x9386,UDCODE,0x8f40,0x8aaf,0x9288,0x92e8,0x88b6,0x8b58,
	0x95f3,UDCODE,0x8ec0,UDCODE,UDCODE,0x8b71,0x90e9,0x8eba,0x9747,
	0x9b81,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x8b7b,
	UDCODE,0x8dc9,UDCODE,UDCODE,0x8a51,0x8983,0x8faa,0x89c6,UDCODE,
	0x9b82,0x9765,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x8f68,0xfaa7,
	UDCODE,0x8ee2,0x9b83,0x8af1,0x93d0,0x96a7,0x9b84,UDCODE,0x9b85,
	UDCODE,UDCODE,0x9578,UDCODE,UDCODE,UDCODE,0x9b87,UDCODE,0x8aa6,
	0x8bf5,0x9b86,UDCODE,UDCODE,UDCODE,0xfaa9,UDCODE,UDCODE,0x8ab0,
	UDCODE,0x9051,0x9b8b,0x8e40,UDCODE,0x89c7,0x9b8a,UDCODE,0x9b88,
	0x9b8c,0x9b89,0x944a,0x9ecb,0x9052,UDCODE,0x9b8d,0xfaaa,UDCODE,
	0x97be,UDCODE,0x9b8e,UDCODE,UDCODE,0x9b90,UDCODE,0x929e,0x9b8f,
	UDCODE,0x90a1,UDCODE,0x8e9b,UDCODE,UDCODE,UDCODE,0x91ce,0x8ef5,
	0x9595,0x90ea,UDCODE,0x8ecb,0x9b91,0x8fab,0x9b92,0x9b93,0x88d1,
	0x91b8,0x9071,UDCODE,0x9b94,0x93b1,0x8fac,UDCODE,0x8fad,UDCODE,
	0x9b95,UDCODE,UDCODE,0x90eb,UDCODE,UDCODE,UDCODE,0x8fae,UDCODE,
	UDCODE,UDCODE,0xfaab,UDCODE,0x9b96,UDCODE,0x9b97,UDCODE,0x96de,
	UDCODE,UDCODE,UDCODE,0x9b98,UDCODE,UDCODE,UDCODE,UDCODE,0x8bc4,
	UDCODE,UDCODE,UDCODE,0x8f41,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,0x9b99,0x9b9a,0x8eda,0x904b,0x93f2,0x9073,0x94f6,0x9441,
	0x8bc7,0x9b9b,UDCODE,UDCODE,UDCODE,0x8b8f,0x9b9c,UDCODE,0x8bfc,
	UDCODE,0x93cd,0x89ae,UDCODE,0x8e72,0x9b9d,0x9ba0,0x9b9f,0x8bfb,
	UDCODE,0x9b9e,UDCODE,0x9357,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0x91ae,UDCODE,0x936a,0x8ec6,UDCODE,UDCODE,
	0x9177,0x979a,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x9ba2,
	UDCODE,0x9ba3,0x93d4,UDCODE,0x8e52,UDCODE,UDCODE,UDCODE,UDCODE,
	0x9ba5,UDCODE,UDCODE,0x9ba6,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0x9ba7,UDCODE,UDCODE,UDCODE,0x8af2,
	0x9ba8,UDCODE,UDCODE,0x9ba9,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x89aa,UDCODE,
	UDCODE,UDCODE,UDCODE,0xfaac,UDCODE,0x915a,0x8ae2,UDCODE,0x9bab,
	0x96a6,UDCODE,UDCODE,UDCODE,UDCODE,0x91d0,UDCODE,0x8a78,UDCODE,
	UDCODE,0x9bad,0x9baf,0x8add,UDCODE,0xfaad,0x9bac,0x9bae,UDCODE,
	0x9bb1,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x9bb0,UDCODE,
	0x9bb2,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	0x9bb3,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x93bb,0x8bac,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x89e3,0x9bb4,0x9bb9,
	UDCODE,UDCODE,0x9bb7,UDCODE,0x95f5,0x95f4,UDCODE,UDCODE,UDCODE,
	UDCODE,0xfaae,0x9387,UDCODE,UDCODE,UDCODE,0x9bb6,0x8f73,UDCODE,
	0x9bb5,0x9092,UDCODE,UDCODE,UDCODE,0x9bba,UDCODE,UDCODE,0x8de8,
	UDCODE,UDCODE,0x9bc0,UDCODE,UDCODE,0x9bc1,0x9bbb,0x8a52,0x9bbc,
	0x9bc5,0x9bc4,0x9bc3,0x9bbf,UDCODE,UDCODE,UDCODE,0x9bbe,UDCODE,
	UDCODE,0x9bc2,UDCODE,UDCODE,UDCODE,UDCODE,0xfaaf,UDCODE,0x95f6,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xfab2,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x9bc9,0x9bc6,UDCODE,
	0x9bc8,UDCODE,0x9792,UDCODE,0x9bc7,0xfab0,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x9bbd,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	0x9093,UDCODE,UDCODE,0x9bca,0xfab3,UDCODE,0x8db5,UDCODE,UDCODE,
	UDCODE,0x9bcb,UDCODE,UDCODE,0x9bcc,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x9bcf,UDCODE,
	0x9bce,UDCODE,UDCODE,0x9bcd,UDCODE,UDCODE,UDCODE,0x9388,0x9bb8,
	UDCODE,UDCODE,UDCODE,0x9bd5,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x9bd1,UDCODE,
	UDCODE,UDCODE,UDCODE,0x9bd0,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0x9bd2,UDCODE,0x9bd3,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x9bd6,0xfab4,0xfab5,
	0x97e4,UDCODE,0x9bd7,0x9bd4,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x9bd8,UDCODE,UDCODE,
	0x8ade,0x9bd9,UDCODE,UDCODE,0xfab6,UDCODE,0x9bdb,0x9bda,UDCODE,
	UDCODE,0x9bdc,UDCODE,UDCODE,UDCODE,UDCODE,0x9bdd,UDCODE,0x90ec,
	0x8f42,UDCODE,UDCODE,0x8f84,UDCODE,0x9183,UDCODE,0x8d48,0x8db6,
	0x8d49,0x8b90,UDCODE,UDCODE,0x9bde,UDCODE,UDCODE,0x8db7,UDCODE,
	UDCODE,0x8cc8,0x9bdf,0x96a4,0x9462,0x9be0,UDCODE,0x8d4a,UDCODE,
	UDCODE,UDCODE,0x8aaa,UDCODE,0x9246,0x8bd0,0x8e73,0x957a,UDCODE,
	UDCODE,0x94bf,UDCODE,UDCODE,UDCODE,UDCODE,0x9be1,0x8af3,UDCODE,
	UDCODE,UDCODE,UDCODE,0x9be4,UDCODE,UDCODE,UDCODE,UDCODE,0x929f,
	UDCODE,UDCODE,0x9be3,0x9be2,0x9be5,UDCODE,0x92e9,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x9083,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,0x8e74,UDCODE,0x90c8,UDCODE,0x91d1,0x8b41,UDCODE,
	UDCODE,0x92a0,UDCODE,UDCODE,0x9be6,0x9be7,0x8fed,UDCODE,UDCODE,
	UDCODE,UDCODE,0x9658,UDCODE,UDCODE,0x9bea,UDCODE,UDCODE,0x9be9,
	0x9be8,0x959d,UDCODE,0x9bf1,UDCODE,UDCODE,UDCODE,UDCODE,0x9679,
	UDCODE,0x9beb,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x9bed,0x968b,
	UDCODE,0x9bec,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	0x9bee,UDCODE,0x94a6,0x9bef,0x95bc,0x9bf0,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,0x8ab1,0x95bd,0x944e,0x9bf2,0x9bf3,UDCODE,0x8d4b,0x8ab2,
	0x9bf4,0x8cb6,0x9763,0x9748,0x8af4,0x9bf6,UDCODE,0x92a1,UDCODE,
	0x8d4c,0x8faf,UDCODE,UDCODE,0x94dd,UDCODE,UDCODE,0x8fb0,UDCODE,
	UDCODE,UDCODE,UDCODE,0x8f98,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	0x92ea,0x95f7,0x9358,UDCODE,UDCODE,0x8d4d,UDCODE,0x957b,UDCODE,
	UDCODE,UDCODE,0x9bf7,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x9378,
	0x8dc0,UDCODE,UDCODE,UDCODE,0x8cc9,UDCODE,0x92eb,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x88c1,0x8f8e,0x8d4e,0x9766,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x9bf8,
	0x9bf9,0x9470,UDCODE,UDCODE,UDCODE,UDCODE,0x9bfa,0x97f5,0x984c,
	UDCODE,UDCODE,UDCODE,UDCODE,0x9bfc,0x9bfb,UDCODE,UDCODE,0x8a66,
	UDCODE,UDCODE,0x9c40,UDCODE,UDCODE,UDCODE,0x9c43,0x9c44,UDCODE,
	0x9c42,UDCODE,0x955f,0x8fb1,0x9c46,0x9c45,0x9c41,UDCODE,UDCODE,
	UDCODE,UDCODE,0x9c47,0x9c48,UDCODE,UDCODE,0x9c49,UDCODE,UDCODE,
	UDCODE,0x9c4c,0x9c4a,UDCODE,0x9c4b,0x9c4d,UDCODE,0x8984,0x92ec,
	0x9c4e,UDCODE,0x8c9a,0x89f4,0x9455,UDCODE,0x9c4f,0x93f9,0x95d9,
	UDCODE,0x9c50,0x984d,UDCODE,UDCODE,UDCODE,UDCODE,0x9c51,0x95be,
	0x9c54,0x989f,0x98af,UDCODE,0x8eae,0x93f3,0x9c55,UDCODE,0x8b7c,
	0x92a2,0x88f8,0x9c56,0x95a4,0x8d4f,UDCODE,UDCODE,0x926f,UDCODE,
	UDCODE,UDCODE,0x92ed,UDCODE,0xfab7,UDCODE,UDCODE,UDCODE,0x96ed,
	0x8cb7,0x8cca,UDCODE,0x9c57,UDCODE,UDCODE,UDCODE,0x9c58,UDCODE,
	0x9c5e,UDCODE,0x8ee3,UDCODE,UDCODE,0xfab8,0x92a3,UDCODE,0x8bad,
	0x9c59,UDCODE,UDCODE,UDCODE,0x954a,UDCODE,0x9265,UDCODE,UDCODE,
	0x9c5a,UDCODE,UDCODE,UDCODE,0xfa67,UDCODE,UDCODE,0x9c5b,UDCODE,
	0x8bae,UDCODE,0x9c5c,UDCODE,0x9c5d,UDCODE,UDCODE,0x9c5f,UDCODE,
	0x9396,UDCODE,UDCODE,0x9c60,0x9c61,UDCODE,0x9c62,UDCODE,UDCODE,
	0x9c53,0x9c52,UDCODE,UDCODE,UDCODE,0x9c63,0x8c60,UDCODE,UDCODE,
	UDCODE,0x9546,0xfab9,UDCODE,0x8dca,0x9556,0x92a4,0x956a,0x9c64,
	UDCODE,UDCODE,0x8fb2,0x8965,UDCODE,0x9c65,UDCODE,UDCODE,UDCODE,
	0x9c66,UDCODE,0x96f0,UDCODE,UDCODE,0x94de,UDCODE,UDCODE,0x9c69,
	0x899d,0x90aa,0x9c68,0x9c67,0x8c61,0x91d2,UDCODE,0x9c6d,0x9c6b,
	UDCODE,0x9c6a,0x97a5,0x8ce3,UDCODE,UDCODE,UDCODE,0x8f99,0x9c6c,
	0x936b,0x8f5d,UDCODE,UDCODE,UDCODE,0x93be,0x9c70,0x9c6f,UDCODE,
	UDCODE,UDCODE,UDCODE,0x9c6e,UDCODE,0x9c71,0x8ce4,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0x9c72,0x959c,0x8f7a,UDCODE,UDCODE,
	0x9c73,0x94f7,UDCODE,UDCODE,UDCODE,UDCODE,0x93bf,0x92a5,UDCODE,
	UDCODE,0xfaba,UDCODE,0x934f,UDCODE,UDCODE,0x9c74,0x8b4a,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0x9053,UDCODE,0x954b,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0x8af5,0x9445,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x9c75,0x8e75,0x9659,0x965a,
	UDCODE,UDCODE,0x899e,0x9c7a,0xfabb,UDCODE,0x9289,UDCODE,UDCODE,
	UDCODE,0x9c77,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x89f5,
	UDCODE,UDCODE,UDCODE,UDCODE,0x9cab,0x9c79,UDCODE,UDCODE,UDCODE,
	0x944f,UDCODE,UDCODE,0x9c78,UDCODE,UDCODE,0x9c76,UDCODE,0x8d9a,
	UDCODE,0x9c7c,0x9c83,0x9c89,0x9c81,UDCODE,0x937b,UDCODE,UDCODE,
	0x9c86,0x957c,UDCODE,UDCODE,0x9c80,UDCODE,0x9c85,0x97e5,0x8e76,
	UDCODE,UDCODE,0x91d3,0x9c7d,UDCODE,UDCODE,UDCODE,0x8b7d,0x9c88,
	0x90ab,0x8985,0x9c82,0x89f6,0x9c87,UDCODE,UDCODE,UDCODE,0x8baf,
	UDCODE,0x9c84,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,0x9c8a,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x9c8c,
	0x9c96,0x9c94,UDCODE,UDCODE,0x9c91,UDCODE,UDCODE,UDCODE,0x9c90,
	0x97f6,UDCODE,0x9c92,UDCODE,UDCODE,0x8bb0,UDCODE,0x8d50,UDCODE,
	UDCODE,0x8f9a,UDCODE,UDCODE,UDCODE,0x9c99,0x9c8b,UDCODE,UDCODE,
	0xfabc,UDCODE,0x9c8f,0x9c7e,UDCODE,0x89f8,0x9c93,0x9c95,0x9270,
	UDCODE,UDCODE,0x8da6,0x89b6,0x9c8d,0x9c98,0x9c97,0x8bb1,UDCODE,
	0x91a7,0x8a86,UDCODE,UDCODE,UDCODE,UDCODE,0x8c62,UDCODE,0x9c8e,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	0x9c9a,UDCODE,0x9c9d,0x9c9f,0xfabd,UDCODE,UDCODE,UDCODE,0x8ebb,
	0xfabe,0x9ca5,0x92ee,0x9c9b,UDCODE,UDCODE,UDCODE,UDCODE,0x9ca3,
	UDCODE,0x89f7,UDCODE,0x9ca1,0x9ca2,UDCODE,UDCODE,0x9c9e,0x9ca0,
	UDCODE,UDCODE,UDCODE,0x8ce5,0x9749,UDCODE,UDCODE,0x8ab3,UDCODE,
	UDCODE,0x8978,0x9ca4,UDCODE,0x9459,0x88ab,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0x94df,0x9c7b,0x9caa,0x9cae,0x96e3,
	UDCODE,0x9ca7,UDCODE,UDCODE,UDCODE,0x9389,0x9cac,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x8fee,0x9cad,0x93d5,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x9866,
	UDCODE,0x9ca9,UDCODE,0xfac0,UDCODE,UDCODE,0x9caf,UDCODE,0x8d9b,
	UDCODE,0x90c9,UDCODE,0xfabf,0x88d2,0x9ca8,0x9ca6,UDCODE,0x9179,
	UDCODE,UDCODE,UDCODE,0x9c9c,0x8e53,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0x91c4,0x9cbb,0xfac2,0x917a,0x9cb6,UDCODE,
	0x9cb3,0x9cb4,UDCODE,0x8ee4,0x9cb7,0x9cba,0x9cb5,0x8f44,UDCODE,
	0x9cb8,UDCODE,UDCODE,0x9cb2,UDCODE,0x96fa,0x96f9,UDCODE,UDCODE,
	UDCODE,0x9cbc,0x9cbd,0x88d3,UDCODE,0xfac3,UDCODE,UDCODE,UDCODE,
	0x9cb1,UDCODE,UDCODE,UDCODE,UDCODE,0x8bf0,0x88a4,UDCODE,UDCODE,
	UDCODE,0x8ab4,0xfac1,0x9cb9,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	0x9cc1,0x9cc0,UDCODE,UDCODE,UDCODE,0x9cc5,UDCODE,UDCODE,UDCODE,
	0xfac5,UDCODE,UDCODE,UDCODE,0x9cc6,UDCODE,UDCODE,0xfac4,UDCODE,
	UDCODE,UDCODE,UDCODE,0x9cc4,0x9cc7,0x9cbf,0x9cc3,UDCODE,UDCODE,
	0x9cc8,UDCODE,0x9cc9,UDCODE,UDCODE,0x9cbe,0x8e9c,UDCODE,0x9cc2,
	0x91d4,0x8d51,0x9cb0,0x9054,UDCODE,UDCODE,UDCODE,UDCODE,0x9cd6,
	UDCODE,0x95e7,UDCODE,UDCODE,0x9ccc,0x9ccd,0x9cce,UDCODE,UDCODE,
	0x9cd5,UDCODE,0x9cd4,UDCODE,UDCODE,0x969d,0x8ab5,UDCODE,0x9cd2,
	UDCODE,0x8c64,0x8a53,UDCODE,UDCODE,0x9ccf,UDCODE,UDCODE,0x97b6,
	0x9cd1,0x88d4,0x9cd3,UDCODE,0x9cca,0x9cd0,0x9cd7,0x8c63,0x9ccb,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x977c,UDCODE,UDCODE,
	UDCODE,0x974a,UDCODE,UDCODE,UDCODE,UDCODE,0x9cda,UDCODE,UDCODE,
	0x9cde,UDCODE,UDCODE,UDCODE,0x919e,UDCODE,0x97f7,0x9cdf,UDCODE,
	UDCODE,0x9cdc,UDCODE,0x9cd9,UDCODE,0xfac6,0x9cd8,0x9cdd,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x95ae,
	UDCODE,UDCODE,0x93b2,UDCODE,0x8c65,UDCODE,0x9ce0,0x9cdb,UDCODE,
	0x9ce1,UDCODE,UDCODE,UDCODE,0x8c9b,UDCODE,UDCODE,UDCODE,0x89af,
	UDCODE,UDCODE,UDCODE,0x9ce9,UDCODE,UDCODE,UDCODE,0x8ab6,UDCODE,
	UDCODE,UDCODE,UDCODE,0x9ce7,UDCODE,UDCODE,0x9ce8,0x8da7,0x9ce6,
	0x9ce4,0x9ce3,0x9cea,0x9ce2,0x9cec,UDCODE,UDCODE,0x89f9,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x9cee,
	UDCODE,UDCODE,0x9ced,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x92a6,UDCODE,0x9cf1,UDCODE,
	0x9cef,0x9ce5,0x8c9c,UDCODE,0x9cf0,UDCODE,0x9cf4,0x9cf3,0x9cf5,
	0x9cf2,0x9cf6,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	0x9cf7,0x9cf8,0x95e8,UDCODE,0x9cfa,0x9cf9,0x8f5e,UDCODE,0x90ac,
	0x89e4,0x89fa,0xfac7,0x9cfb,UDCODE,0x88bd,UDCODE,UDCODE,UDCODE,
	0x90ca,0x9cfc,UDCODE,0xe6c1,0x9d40,0x8c81,UDCODE,0x9d41,UDCODE,
	UDCODE,UDCODE,UDCODE,0x90ed,UDCODE,UDCODE,UDCODE,0x9d42,UDCODE,
	UDCODE,UDCODE,0x9d43,0x8b59,0x9d44,UDCODE,0x9d45,0x9d46,0x91d5,
	UDCODE,UDCODE,UDCODE,0x8ccb,UDCODE,UDCODE,0x96df,UDCODE,UDCODE,
	UDCODE,0x965b,0x8f8a,0x9d47,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	0x90ee,0xe7bb,0x94e0,UDCODE,0x8ee8,UDCODE,0x8dcb,0x9d48,UDCODE,
	UDCODE,UDCODE,UDCODE,0x91c5,UDCODE,0x95a5,UDCODE,UDCODE,0x91ef,
	UDCODE,UDCODE,0x9d4b,UDCODE,UDCODE,0x9d49,UDCODE,0x9d4c,UDCODE,
	UDCODE,0x9d4a,UDCODE,UDCODE,UDCODE,UDCODE,0x9d4d,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0x95af,UDCODE,UDCODE,0x88b5,UDCODE,UDCODE,
	UDCODE,UDCODE,0x957d,UDCODE,UDCODE,0x94e1,UDCODE,UDCODE,0x9d4e,
	UDCODE,0x9d51,0x8fb3,0x8b5a,UDCODE,0x9d4f,0x9d56,0x8fb4,UDCODE,
	UDCODE,UDCODE,UDCODE,0x9d50,0x9463,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,0x977d,0x9d52,0x9d53,0x9d57,0x938a,0x9d54,0x8d52,
	0x90dc,UDCODE,UDCODE,0x9d65,0x94b2,UDCODE,0x91f0,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xfac8,UDCODE,UDCODE,UDCODE,
	UDCODE,0x94e2,0x9dab,UDCODE,UDCODE,UDCODE,UDCODE,0x95f8,UDCODE,
	UDCODE,UDCODE,0x92ef,UDCODE,UDCODE,UDCODE,0x9695,UDCODE,0x9d5a,
	0x899f,0x928a,UDCODE,UDCODE,UDCODE,UDCODE,0x9d63,UDCODE,UDCODE,
	0x9253,0x9d5d,0x9d64,0x9d5f,0x9d66,0x9d62,UDCODE,0x9d61,0x948f,
	UDCODE,0x9d5b,0x89fb,0x9d59,0x8b91,0x91f1,0x9d55,UDCODE,UDCODE,
	0x9d58,0x8d53,0x90d9,UDCODE,0x8fb5,0x9d60,0x9471,UDCODE,UDCODE,
	0x8b92,0x8a67,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0x8a87,0x9040,0x9d68,0x9d6d,UDCODE,0x9d69,
	UDCODE,0x8c9d,UDCODE,0x9d6e,0x8e41,0x8d89,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0x8f45,0x9d5c,0x8e9d,0x9d6b,UDCODE,UDCODE,
	UDCODE,UDCODE,0x8e77,0x9d6c,0x88c2,UDCODE,UDCODE,0x9d67,UDCODE,
	UDCODE,UDCODE,UDCODE,0x92a7,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,0x8b93,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x8bb2,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x9d6a,0x88a5,
	UDCODE,UDCODE,0x8dc1,UDCODE,UDCODE,UDCODE,0x9055,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x92f0,
	UDCODE,UDCODE,0x94d2,0x9d70,0x917d,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x91a8,UDCODE,UDCODE,0x8e4a,
	0x9d71,UDCODE,0x9d73,0x9d6f,UDCODE,UDCODE,UDCODE,UDCODE,0x95df,
	UDCODE,0x92bb,UDCODE,UDCODE,UDCODE,UDCODE,0x917b,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x95f9,
	0x8ecc,0x9d80,UDCODE,0x9d7e,UDCODE,UDCODE,0x9098,UDCODE,UDCODE,
	UDCODE,0x8c9e,UDCODE,UDCODE,UDCODE,0x9d78,0x8fb7,UDCODE,UDCODE,
	0x93e6,0x9450,UDCODE,UDCODE,UDCODE,UDCODE,0x9d76,UDCODE,UDCODE,
	0x917c,UDCODE,UDCODE,UDCODE,UDCODE,0x8ef6,0x9d7b,UDCODE,UDCODE,
	0x8fb6,UDCODE,0x9d75,0x9d7a,UDCODE,UDCODE,0x9472,UDCODE,UDCODE,
	UDCODE,0x9d74,UDCODE,0x8c40,UDCODE,UDCODE,0x8a7c,UDCODE,UDCODE,
	UDCODE,0x9d7c,0x97a9,0x8dcc,0x9254,0x9d79,UDCODE,0x90da,UDCODE,
	0x8d54,0x9084,0x8986,0x915b,0x9d77,0x8b64,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,0x8c66,UDCODE,0x92cd,0x9d7d,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,0x917e,UDCODE,UDCODE,0x9d81,UDCODE,0x9d83,UDCODE,
	UDCODE,0x91b5,0x9d89,UDCODE,0x9d84,UDCODE,UDCODE,0x9d86,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0x9560,0x92f1,UDCODE,0x9d87,UDCODE,
	UDCODE,UDCODE,0x974b,UDCODE,UDCODE,UDCODE,0x9767,0x8ab7,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0x88ac,UDCODE,0x9d85,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0x9d82,UDCODE,UDCODE,UDCODE,UDCODE,0x8af6,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x8987,0xfac9,0x9d88,UDCODE,
	UDCODE,UDCODE,0x9768,0x9d8c,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,0x91b9,UDCODE,0x9d93,UDCODE,UDCODE,UDCODE,0x9d8d,UDCODE,
	UDCODE,0x9d8a,0x9d91,UDCODE,UDCODE,UDCODE,UDCODE,0x9d72,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x9d8e,
	UDCODE,0x9d92,UDCODE,UDCODE,UDCODE,0x94c0,0x938b,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0x9d8b,UDCODE,0x9d8f,UDCODE,UDCODE,
	UDCODE,0x8c67,UDCODE,UDCODE,UDCODE,0x8def,UDCODE,UDCODE,UDCODE,
	0x90db,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0x9d97,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0x9345,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0xfaca,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,0x9d94,UDCODE,0x9680,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	0x9d95,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x9d96,UDCODE,
	0x96cc,UDCODE,0x90a0,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,0x8c82,UDCODE,UDCODE,UDCODE,UDCODE,0x9d9d,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x8e54,
	0x9d9a,UDCODE,0x9d99,UDCODE,UDCODE,UDCODE,UDCODE,0x9451,UDCODE,
	UDCODE,0xfacb,0x93b3,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x9350,
	0x9d9b,UDCODE,UDCODE,UDCODE,0x9d9c,UDCODE,0x958f,UDCODE,0x9464,
	0x8e42,UDCODE,0x90ef,UDCODE,0x966f,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,0x8a68,UDCODE,0x9da3,0x9d9e,UDCODE,UDCODE,UDCODE,
	UDCODE,0x9769,0x9da5,UDCODE,UDCODE,0x9da1,UDCODE,0x9da2,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0x9180,0xfacc,UDCODE,UDCODE,UDCODE,
	0x9da0,UDCODE,0x9d5e,UDCODE,UDCODE,UDCODE,0x9da4,UDCODE,0x9d9f,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x9da9,0x9daa,0x9346,0x9dac,
	UDCODE,UDCODE,0x8e43,0x9da7,UDCODE,UDCODE,UDCODE,UDCODE,0x8b5b,
	UDCODE,UDCODE,0x9dad,UDCODE,0x9da6,0x9db1,UDCODE,0x9db0,UDCODE,
	0x9daf,UDCODE,UDCODE,UDCODE,0x9db2,UDCODE,UDCODE,0x9db4,0x8fef,
	0x9db3,UDCODE,UDCODE,UDCODE,UDCODE,0x9db7,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x9db5,UDCODE,UDCODE,
	UDCODE,0x9db6,0x9d90,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x9db9,
	0x9db8,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x9d98,0x9dba,0x9dae,
	UDCODE,UDCODE,0x8e78,UDCODE,UDCODE,UDCODE,UDCODE,0x9dbb,0x9dbc,
	0x9dbe,0x9dbd,0x9dbf,0x89fc,UDCODE,0x8d55,UDCODE,UDCODE,0x95fa,
	0x90ad,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x8ccc,UDCODE,UDCODE,
	0x9dc1,UDCODE,UDCODE,UDCODE,UDCODE,0x9dc4,0xfacd,0x9571,UDCODE,
	0x8b7e,UDCODE,UDCODE,UDCODE,0x9dc3,0x9dc2,0x9473,0x9dc5,0x8bb3,
	UDCODE,UDCODE,UDCODE,0x9dc7,0x9dc6,UDCODE,UDCODE,UDCODE,0x8ab8,
	0x8e55,UDCODE,UDCODE,0x93d6,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	0x8c68,UDCODE,UDCODE,UDCODE,0x9094,UDCODE,0x9dc8,UDCODE,0x90ae,
	0x9347,UDCODE,0x957e,0x9dc9,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0x9dca,0x9dcb,UDCODE,UDCODE,UDCODE,
	0x95b6,0x9b7c,0x90c4,UDCODE,UDCODE,0x956b,UDCODE,0x8dd6,UDCODE,
	0x94e3,0x94c1,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x936c,UDCODE,
	0x97bf,UDCODE,0x9dcd,0x8ece,UDCODE,UDCODE,0x9dce,UDCODE,0x88b4,
	UDCODE,UDCODE,0x8bd2,0x90cb,UDCODE,0x9580,UDCODE,UDCODE,UDCODE,
	0x9dcf,0x8e61,0x9266,UDCODE,0x8e7a,0x9056,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0x9dd0,UDCODE,0x95fb,UDCODE,UDCODE,0x8997,
	0x8e7b,UDCODE,UDCODE,UDCODE,0x9dd3,UDCODE,0x9dd1,0x9dd4,0x97b7,
	0x9dd2,UDCODE,UDCODE,UDCODE,UDCODE,0x90f9,0x9dd5,UDCODE,UDCODE,
	0x91b0,UDCODE,UDCODE,0x9dd6,UDCODE,UDCODE,UDCODE,UDCODE,0x8af8,
	UDCODE,0x9dd8,UDCODE,0x9dd7,UDCODE,UDCODE,UDCODE,UDCODE,0x9dd9,
	0x9dda,0x8af9,UDCODE,UDCODE,0x93fa,0x9255,0x8b8c,0x8e7c,0x9181,
	UDCODE,UDCODE,0x8f7b,0x88ae,UDCODE,UDCODE,UDCODE,0x9ddb,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x89a0,0x9ddf,
	0xface,UDCODE,0x8d56,0x9dde,UDCODE,UDCODE,0x8da9,0x8fb8,UDCODE,
	0xfad1,0x9ddd,UDCODE,0x8fb9,UDCODE,0x96be,0x8da8,UDCODE,UDCODE,
	UDCODE,0x88d5,0x90cc,0xfacf,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,0x9de4,UDCODE,0xfad3,0x90af,0x8966,UDCODE,UDCODE,UDCODE,
	0xfad4,0x8f74,UDCODE,0x9686,0x8df0,UDCODE,UDCODE,UDCODE,UDCODE,
	0x8fba,0xfad2,0x90a5,UDCODE,0xfa63,UDCODE,UDCODE,0x9de3,0x9de1,
	0x9de2,UDCODE,UDCODE,UDCODE,UDCODE,0xfad0,0x928b,UDCODE,UDCODE,
	0x9e45,UDCODE,0x9de8,0x8e9e,0x8d57,0x9de6,UDCODE,UDCODE,UDCODE,
	UDCODE,0x9de7,UDCODE,0x9057,UDCODE,UDCODE,UDCODE,0x9de5,UDCODE,
	UDCODE,0x8e4e,UDCODE,UDCODE,UDCODE,UDCODE,0xfad6,UDCODE,0xfad7,
	UDCODE,UDCODE,UDCODE,0x9dea,0x9de9,0x9dee,UDCODE,UDCODE,0x9def,
	UDCODE,0x9deb,0xfad5,0x8a41,0x9dec,0x9ded,0x94d3,UDCODE,UDCODE,
	UDCODE,UDCODE,0x9581,0x8c69,0x9df0,UDCODE,UDCODE,0xfad9,0x90b0,
	UDCODE,0x8fbb,UDCODE,UDCODE,UDCODE,0x9271,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0x8bc5,UDCODE,0x9df1,0x9df5,UDCODE,UDCODE,
	0x89c9,0x9df2,0x9df4,UDCODE,UDCODE,UDCODE,UDCODE,0x9df3,UDCODE,
	UDCODE,0x8f8b,UDCODE,UDCODE,UDCODE,UDCODE,0x9267,0x88c3,0x9df6,
	0xfada,UDCODE,UDCODE,UDCODE,0x9df7,UDCODE,UDCODE,0xfadb,UDCODE,
	0x92a8,UDCODE,UDCODE,UDCODE,0x97ef,UDCODE,UDCODE,UDCODE,UDCODE,
	0x8e62,UDCODE,UDCODE,0x95e9,UDCODE,UDCODE,UDCODE,0xfadc,UDCODE,
	0x965c,UDCODE,UDCODE,UDCODE,0x9e41,0x9df9,UDCODE,UDCODE,0x9dfc,
	UDCODE,0x9dfb,0xfadd,UDCODE,0x9df8,UDCODE,UDCODE,0x9e40,UDCODE,
	UDCODE,0x93dc,UDCODE,0x9dfa,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x9e42,UDCODE,
	UDCODE,0x8f8c,0x9e43,UDCODE,0x976a,0x9498,UDCODE,UDCODE,0x9e44,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x9e46,UDCODE,UDCODE,0x9e47,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x9e48,UDCODE,0x8bc8,
	0x8967,0x8d58,0x9e49,UDCODE,0x9e4a,0x8f91,0x9182,0xfade,0xfa66,
	0x99d6,0x915d,0x915c,0x91d6,0x8dc5,UDCODE,UDCODE,0x98f0,UDCODE,
	UDCODE,UDCODE,UDCODE,0x8c8e,0x974c,UDCODE,0x95fc,UDCODE,0x959e,
	0xfadf,0x9e4b,UDCODE,UDCODE,UDCODE,UDCODE,0x8df1,0x92bd,0x9e4c,
	0x984e,UDCODE,UDCODE,UDCODE,0x965d,UDCODE,0x92a9,0x9e4d,0x8afa,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x9e4e,0x9e4f,0x96d8,
	UDCODE,0x96a2,0x9696,0x967b,0x8e44,0x9e51,UDCODE,UDCODE,0x8ee9,
	UDCODE,UDCODE,0x9670,UDCODE,0x9e53,0x9e56,0x9e55,UDCODE,0x8af7,
	UDCODE,UDCODE,0x8b80,UDCODE,0x9e52,UDCODE,0x9e54,UDCODE,UDCODE,
	UDCODE,UDCODE,0x9e57,UDCODE,UDCODE,0x9099,UDCODE,UDCODE,UDCODE,
	UDCODE,0x979b,0x88c7,0x8dde,0x91ba,UDCODE,0x8edb,UDCODE,UDCODE,
	0x8ff1,UDCODE,UDCODE,0x9e5a,UDCODE,UDCODE,0x936d,UDCODE,0x9e58,
	0x91a9,0x9e59,0x8ff0,0x96db,0x9e5b,0x9e5c,0x9788,0xfae1,UDCODE,
	UDCODE,UDCODE,0x9e61,UDCODE,UDCODE,0x8d59,UDCODE,0x9474,0x9e5e,
	0x938c,0x9ddc,0x9de0,UDCODE,0x8b6e,UDCODE,0x9466,UDCODE,UDCODE,
	UDCODE,UDCODE,0x9e60,UDCODE,0x8fbc,0x94c2,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,0x9e66,UDCODE,0x94f8,UDCODE,0x9e5d,UDCODE,0x9e63,
	0x9e62,UDCODE,UDCODE,UDCODE,0x90cd,UDCODE,UDCODE,UDCODE,UDCODE,
	0x968d,UDCODE,0x97d1,UDCODE,UDCODE,0x9687,UDCODE,0x89ca,0x8e7d,
	UDCODE,UDCODE,0x9867,0x9e65,0x9095,UDCODE,UDCODE,UDCODE,0x9e64,
	UDCODE,UDCODE,0x9e5f,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x8ccd,
	UDCODE,UDCODE,UDCODE,0x9e6b,0x9e69,UDCODE,0x89cb,0x9e67,0x9e6d,
	0x9e73,UDCODE,0xfae2,UDCODE,UDCODE,UDCODE,UDCODE,0xfae4,0x91c6,
	UDCODE,UDCODE,0x95bf,UDCODE,0x9e75,UDCODE,UDCODE,UDCODE,0x9541,
	UDCODE,UDCODE,UDCODE,0x9e74,0x9490,0x965e,0x8ab9,UDCODE,0x90f5,
	0x8f5f,UDCODE,UDCODE,UDCODE,0x92d1,UDCODE,0x974d,UDCODE,UDCODE,
	0x9e70,0x9e6f,UDCODE,UDCODE,UDCODE,0x9e71,UDCODE,0x9e6e,UDCODE,
	UDCODE,0x9e76,UDCODE,0x9e6c,UDCODE,UDCODE,0x9e6a,UDCODE,0x9e72,
	0x9e68,UDCODE,0x928c,UDCODE,0x96f6,0x8ec4,0x8df2,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0x8db8,UDCODE,UDCODE,0x968f,0x8a60,0xfae5,
	0x92cc,0x93c8,0x8968,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x90f0,
	UDCODE,UDCODE,0x90b2,0x8c49,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,0x9e78,UDCODE,UDCODE,0x8d5a,0x8a9c,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0x9e7a,0x8a94,0x9e81,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0x9e7d,UDCODE,0x90f1,UDCODE,UDCODE,UDCODE,
	0x8a6a,0x8daa,UDCODE,UDCODE,0x8a69,0x8dcd,UDCODE,UDCODE,0x9e7b,
	0x8c85,0x8c6a,0x938d,0xfae6,UDCODE,0x9e79,UDCODE,0x88c4,UDCODE,
	UDCODE,UDCODE,UDCODE,0x9e7c,0x9e7e,UDCODE,0x8bcb,0x8c4b,0xfae3,
	0x8aba,0x8b6a,UDCODE,UDCODE,UDCODE,UDCODE,0x9e82,UDCODE,UDCODE,
	0x8df7,0x9691,UDCODE,0x8e56,UDCODE,UDCODE,UDCODE,0x9e83,UDCODE,
	UDCODE,UDCODE,0x954f,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x9e8f,UDCODE,0x89b1,
	0x9e84,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x9e95,0x9e85,
	UDCODE,0x97c0,UDCODE,0x9e8c,UDCODE,0x947e,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0x9e94,UDCODE,0x9e87,UDCODE,UDCODE,
	UDCODE,0x88b2,0x9e89,UDCODE,UDCODE,0x8d5b,UDCODE,UDCODE,UDCODE,
	0x9e8b,UDCODE,0x9e8a,UDCODE,0x9e86,0x9e91,UDCODE,0x8fbd,UDCODE,
	UDCODE,UDCODE,0x9aeb,0x8ce6,0x979c,UDCODE,UDCODE,UDCODE,UDCODE,
	0x9e88,UDCODE,0x92f2,0x8a42,0x8dab,UDCODE,0x9e80,UDCODE,0x9e90,
	0x8a81,UDCODE,UDCODE,0x9e8e,0x9e92,UDCODE,0x938e,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x8afc,UDCODE,0x9eb0,UDCODE,
	0xfa64,0x96c7,0x9e97,0x8afb,UDCODE,0x9e9e,UDCODE,0xfae7,UDCODE,
	UDCODE,0x965f,UDCODE,0x9e9f,0x9ea1,UDCODE,0x9ea5,0x9e99,UDCODE,
	0x9249,UDCODE,UDCODE,UDCODE,UDCODE,0x938f,0x9ea9,0x9e9c,UDCODE,
	0x9ea6,UDCODE,UDCODE,UDCODE,0x9ea0,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,0x9058,0x9eaa,UDCODE,UDCODE,0x90b1,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0x9ea8,0x8abb,0x986f,0x9e96,UDCODE,
	UDCODE,0x9ea4,0x88d6,UDCODE,UDCODE,0x9e98,UDCODE,UDCODE,0x96b8,
	0x9e9d,0x9041,0x92c5,0x9e93,UDCODE,UDCODE,0x9ea3,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0x909a,0x9ead,0x8a91,0x8c9f,UDCODE,
	UDCODE,UDCODE,UDCODE,0x9eaf,0x9e9a,0x9eae,UDCODE,0x9ea7,0x9e9b,
	UDCODE,0x9eab,UDCODE,0x9eac,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	0x9ebd,UDCODE,UDCODE,UDCODE,0x93cc,UDCODE,0x9ea2,UDCODE,UDCODE,
	0x9eb9,UDCODE,UDCODE,UDCODE,0x9ebb,UDCODE,0x92d6,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x976b,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x9596,
	0x9eb6,0x91c8,UDCODE,UDCODE,UDCODE,0x9ebc,0x915e,UDCODE,0x9eb3,
	0x9ec0,0x9ebf,UDCODE,0x93ed,0x9ebe,0x93e8,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,0xfae9,UDCODE,0x9ec2,0x9eb5,UDCODE,0x8bc6,0x9eb8,
	0x8f7c,UDCODE,UDCODE,UDCODE,0x9480,0x9eba,0x8bc9,UDCODE,0x9eb2,
	0x9eb4,0x9eb1,UDCODE,UDCODE,0x984f,0x8a79,0x9eb7,UDCODE,UDCODE,
	0x9ec1,0x8a54,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	0x8de5,UDCODE,UDCODE,UDCODE,0x897c,UDCODE,UDCODE,0x9ed2,UDCODE,
	UDCODE,0x9850,0x9ed5,UDCODE,UDCODE,0xfaeb,UDCODE,UDCODE,0x9059,
	0x9ed4,UDCODE,UDCODE,UDCODE,0x9ed3,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,0x9ed0,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	0x9ec4,UDCODE,UDCODE,0x9ee1,0x9ec3,UDCODE,0x9ed6,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0x9ece,UDCODE,UDCODE,0x9ec9,0x9ec6,
	UDCODE,0x9ec7,UDCODE,0x9ecf,UDCODE,UDCODE,UDCODE,0xeaa0,UDCODE,
	UDCODE,0x9ecc,0x8d5c,0x92c6,0x9184,0x9eca,UDCODE,0x9ec5,UDCODE,
	UDCODE,0x9ec8,UDCODE,UDCODE,UDCODE,UDCODE,0x976c,0x968a,UDCODE,
	UDCODE,UDCODE,0x9ecd,0x9ed7,UDCODE,UDCODE,UDCODE,0xfaec,UDCODE,
	UDCODE,UDCODE,UDCODE,0x9edf,0x9ed8,UDCODE,UDCODE,0x9ee5,UDCODE,
	0x9ee3,UDCODE,UDCODE,UDCODE,UDCODE,0x9ede,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0x9edd,UDCODE,0x92ce,UDCODE,0x9185,UDCODE,
	0x9edb,0x9ed9,UDCODE,UDCODE,0x9ee0,UDCODE,UDCODE,UDCODE,UDCODE,
	0x9ee6,0x94f3,0x9eec,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x9ee7,
	0x9eea,0x9ee4,UDCODE,UDCODE,0x9294,UDCODE,0x9557,UDCODE,0x9eda,
	UDCODE,UDCODE,0x9ee2,0x8fbe,UDCODE,0x96cd,0x9ef6,0x9ee9,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0x8ca0,0x89a1,0x8a7e,UDCODE,UDCODE,
	0x9ed1,UDCODE,0xfaed,UDCODE,UDCODE,UDCODE,UDCODE,0x8fbf,0x9eee,
	UDCODE,0x9ef5,0x8ef7,0x8a92,UDCODE,UDCODE,0x924d,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0x9eeb,UDCODE,0xfaef,0x9ef0,0x9ef4,
	UDCODE,UDCODE,0x8bb4,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x8b6b,0x9ef2,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0x8b40,UDCODE,0x93c9,0x9ef1,UDCODE,
	UDCODE,UDCODE,0x9ef3,UDCODE,UDCODE,UDCODE,UDCODE,0xfaee,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x9eed,0xfaf0,UDCODE,UDCODE,
	UDCODE,UDCODE,0x9eef,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xfaf1,
	0x8a80,0x9268,UDCODE,UDCODE,UDCODE,0x9efa,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x9ef8,0x8ce7,UDCODE,0x9ef7,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x9f40,UDCODE,UDCODE,
	UDCODE,UDCODE,0x9e77,UDCODE,UDCODE,UDCODE,0x9ef9,UDCODE,0x9efb,
	0x9efc,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x9f4b,UDCODE,
	0x9f47,UDCODE,0x9e8d,UDCODE,UDCODE,UDCODE,UDCODE,0x9f46,UDCODE,
	UDCODE,UDCODE,UDCODE,0x9f45,UDCODE,UDCODE,0x9f42,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0x9ee8,0x9f44,0x9f43,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,0x9f49,UDCODE,0x9845,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,0x9f4c,0x8bf9,UDCODE,UDCODE,0x9f48,0x9f4a,UDCODE,UDCODE,
	0xfaf2,UDCODE,0xfaf3,UDCODE,UDCODE,UDCODE,0x94a5,UDCODE,0x9f4d,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x9f51,0x9f4e,0x9793,
	0x9f4f,UDCODE,UDCODE,UDCODE,UDCODE,0x9edc,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0x9f52,UDCODE,UDCODE,UDCODE,0x9f53,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x8954,UDCODE,0x9f55,
	0x8c87,0x8e9f,UDCODE,0x8bd3,UDCODE,UDCODE,UDCODE,0x89a2,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	0x977e,UDCODE,UDCODE,UDCODE,UDCODE,0x9f57,0x9f56,0x9f59,0x8b5c,
	UDCODE,UDCODE,0x8bd4,0x8abc,UDCODE,UDCODE,UDCODE,UDCODE,0x9f5c,
	UDCODE,UDCODE,UDCODE,0x9f5b,UDCODE,0x9f5d,UDCODE,UDCODE,0x89cc,
	UDCODE,0x9256,UDCODE,0x9f5e,UDCODE,UDCODE,0x8abd,0x9f60,UDCODE,
	UDCODE,UDCODE,UDCODE,0x9f5f,UDCODE,0x9f61,UDCODE,UDCODE,UDCODE,
	0x9f62,UDCODE,0x9f63,0x8e7e,0x90b3,0x8d9f,UDCODE,0x9590,UDCODE,
	UDCODE,0x95e0,0x9863,UDCODE,UDCODE,UDCODE,UDCODE,0x8e95,UDCODE,
	UDCODE,UDCODE,0x8dce,0x97f0,UDCODE,UDCODE,UDCODE,0x9f64,0x9f65,
	UDCODE,0x8e80,UDCODE,UDCODE,UDCODE,0x9f66,0x9f67,UDCODE,UDCODE,
	0x9f69,0x9f68,UDCODE,0x9677,UDCODE,UDCODE,0x8f7d,0x8eea,0x8e63,
	UDCODE,0x9f6a,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	0x9f6c,0x9042,UDCODE,0x9f6b,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	0x9f6d,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x9f6e,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0x9f6f,0x9f70,UDCODE,UDCODE,UDCODE,0x9f71,
	UDCODE,0x9f73,0x9f72,0x9f74,0x89a3,0x9269,UDCODE,0x9f75,UDCODE,
	UDCODE,0x8e45,0x8a6b,0x9f76,UDCODE,UDCODE,0x9361,0x9aca,UDCODE,
	UDCODE,UDCODE,UDCODE,0x8b42,0x9f77,UDCODE,UDCODE,UDCODE,UDCODE,
	0x9f78,UDCODE,0x95ea,0x9688,UDCODE,UDCODE,UDCODE,0x93c5,0x9f79,
	0x94e4,UDCODE,0xfaf4,UDCODE,0x94f9,UDCODE,UDCODE,0x96d1,UDCODE,
	UDCODE,UDCODE,0x9f7a,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x9f7c,0x9f7b,UDCODE,UDCODE,
	0x9f7e,UDCODE,UDCODE,UDCODE,0x9f7d,0x9f81,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0x8e81,UDCODE,0x96af,UDCODE,0x9f82,0x9f83,
	UDCODE,UDCODE,0x8b43,UDCODE,UDCODE,UDCODE,0x9f84,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x9f86,0x9f85,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0x9085,UDCODE,UDCODE,0x9558,0x8969,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x94c3,0xfaf5,0x92f3,0x8f60,
	0x8b81,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0x94c4,UDCODE,0x8eac,UDCODE,UDCODE,UDCODE,
	UDCODE,0x9f88,UDCODE,0x8abe,UDCODE,UDCODE,0x8998,UDCODE,0xfaf6,
	0x93f0,0x9f87,0x8d5d,0x9272,UDCODE,0x9f89,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,0x9f91,UDCODE,0x9f8a,UDCODE,UDCODE,UDCODE,UDCODE,
	0xfaf8,0x91bf,UDCODE,0x8b82,0x9f92,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,0x8c88,UDCODE,UDCODE,0x8b44,0x9f90,UDCODE,UDCODE,
	0x9f8e,0x9f8b,0x9780,UDCODE,UDCODE,0xfaf7,UDCODE,0x92be,UDCODE,
	UDCODE,UDCODE,0x93d7,0x9f8c,UDCODE,UDCODE,0x9f94,UDCODE,0x9f93,
	0x8c42,UDCODE,UDCODE,0x89ab,UDCODE,UDCODE,0x8db9,0x9f8d,0x9f8f,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x9676,0x91f2,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x9697,UDCODE,UDCODE,
	0x9f9c,UDCODE,UDCODE,0x9f9d,UDCODE,0x89cd,UDCODE,UDCODE,UDCODE,
	UDCODE,0x95a6,0x96fb,0x9f9f,0x8ea1,0x8fc0,0x9f98,0x9f9e,0x8988,
	UDCODE,0x8bb5,UDCODE,UDCODE,0x9f95,0x9f9a,UDCODE,UDCODE,UDCODE,
	0x90f2,0x9491,UDCODE,0x94e5,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,0x9f97,UDCODE,0x9640,UDCODE,0x9f99,UDCODE,0x9fa2,0xfaf9,
	0x9fa0,UDCODE,0x9f9b,UDCODE,UDCODE,UDCODE,0x9641,0x9467,0x8b83,
	UDCODE,0x9344,UDCODE,UDCODE,0x928d,UDCODE,0x9fa3,UDCODE,UDCODE,
	UDCODE,UDCODE,0x9fa1,0x91d7,0x9f96,UDCODE,0x896a,0xfafa,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x976d,0x9fae,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0x9fad,UDCODE,UDCODE,UDCODE,UDCODE,0x90f4,
	UDCODE,0x9faa,UDCODE,0x978c,UDCODE,UDCODE,0x93b4,0x9fa4,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0x92c3,UDCODE,UDCODE,UDCODE,0x896b,
	0x8d5e,0x9fa7,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x8f46,
	0x9fac,UDCODE,0x9fab,0x9fa6,UDCODE,0x9fa9,UDCODE,UDCODE,0x8a88,
	UDCODE,0x9fa8,0x9468,UDCODE,UDCODE,0x97ac,UDCODE,UDCODE,0x8ff2,
	0x90f3,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,0x9fb4,0x9fb2,UDCODE,0x956c,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0x9faf,0x9fb1,UDCODE,0x8959,UDCODE,UDCODE,
	0x8d5f,0x9851,UDCODE,0x8a5c,UDCODE,0x9582,0xfafc,UDCODE,UDCODE,
	UDCODE,UDCODE,0x9781,UDCODE,UDCODE,0x8a43,0x905a,0x9fb3,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,0x9fb8,UDCODE,0xfafb,0x8fc1,UDCODE,UDCODE,UDCODE,0x974f,
	UDCODE,0x9fb5,UDCODE,UDCODE,UDCODE,UDCODE,0x9fb0,UDCODE,0x9fb6,
	0xfb40,UDCODE,UDCODE,0x97dc,UDCODE,0x9393,0x93c0,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0xfb41,UDCODE,UDCODE,0x8a55,UDCODE,
	UDCODE,0x8974,UDCODE,UDCODE,0x9fbc,UDCODE,UDCODE,0x9fbf,UDCODE,
	UDCODE,UDCODE,0x97c1,UDCODE,UDCODE,UDCODE,0x9784,UDCODE,UDCODE,
	UDCODE,UDCODE,0x9fc6,0x9fc0,0x9fbd,UDCODE,UDCODE,UDCODE,0x97d2,
	0x9fc3,UDCODE,UDCODE,0xfb42,UDCODE,0x8f69,0x9fc5,UDCODE,UDCODE,
	0x9fca,UDCODE,UDCODE,0x9391,0x9fc8,UDCODE,UDCODE,UDCODE,UDCODE,
	0x9fc2,UDCODE,UDCODE,0x9257,UDCODE,UDCODE,0x9fc9,UDCODE,0x9fbe,
	UDCODE,0x9fc4,UDCODE,0x9fcb,0x88fa,0x9fc1,UDCODE,0x9fcc,UDCODE,
	UDCODE,0x905b,0xfb44,0x8f7e,UDCODE,0x95a3,UDCODE,0x8dac,0xfb43,
	0x9fb9,0x9fc7,0x9359,0xfb45,0x90b4,UDCODE,0x8a89,0x8dcf,0x8fc2,
	0x9fbb,0x8f61,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	0x8c6b,UDCODE,0x9fba,UDCODE,UDCODE,UDCODE,0x9fd0,0x8f8d,0x8cb8,
	UDCODE,0x9fdf,UDCODE,0x9fd9,0x8b94,0x936e,UDCODE,0x9fd4,0x9fdd,
	0x88ad,0x8951,0xfb48,UDCODE,0x89b7,UDCODE,0x9fd6,0x91aa,0x9fcd,
	0x9fcf,0x8d60,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,0x9fe0,0xfb46,0x9fdb,UDCODE,0xfb49,UDCODE,0x9fd3,UDCODE,
	UDCODE,UDCODE,UDCODE,0x9fda,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,0x96a9,UDCODE,UDCODE,0x9fd8,0x9fdc,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0x8cce,UDCODE,0x8fc3,UDCODE,UDCODE,
	0x9258,0xfb47,UDCODE,UDCODE,0x9fd2,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0x974e,UDCODE,UDCODE,UDCODE,0x9fd5,UDCODE,
	UDCODE,0x9fce,0x9392,UDCODE,UDCODE,0x9fd1,UDCODE,UDCODE,UDCODE,
	0x9fd7,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x9870,
	0x8ebc,0x969e,UDCODE,0x9fe1,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0x94ac,UDCODE,UDCODE,0x9fed,0x8cb9,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x8f80,UDCODE,0x9fe3,UDCODE,
	UDCODE,UDCODE,0x97ad,0x8d61,UDCODE,0x9ff0,UDCODE,UDCODE,0x88ec,
	UDCODE,UDCODE,0x9fee,UDCODE,UDCODE,UDCODE,UDCODE,0x9fe2,UDCODE,
	UDCODE,UDCODE,UDCODE,0x9fe8,UDCODE,UDCODE,0x9fea,UDCODE,UDCODE,
	UDCODE,0x976e,0x9fe5,UDCODE,UDCODE,0x934d,UDCODE,UDCODE,0x9fe7,
	UDCODE,0xfb4a,UDCODE,UDCODE,0x9fef,UDCODE,0x9fe9,0x96c5,UDCODE,
	UDCODE,UDCODE,0x9fe4,UDCODE,0x8ea0,0x9ffc,UDCODE,UDCODE,UDCODE,
	UDCODE,0x8a8a,UDCODE,0x9fe6,0x9feb,0x9fec,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0x91ea,0x91d8,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,0x9ff4,UDCODE,UDCODE,0x9ffa,UDCODE,UDCODE,0x9ff8,UDCODE,
	0x9348,UDCODE,UDCODE,0xe042,0x9ff5,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,0x9ff6,0x9fde,0x8b99,0x9559,UDCODE,UDCODE,UDCODE,0x8ebd,
	UDCODE,UDCODE,0x8d97,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x9852,
	UDCODE,0x9ff2,UDCODE,0xe041,0x8989,0x9186,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x9499,UDCODE,
	0x8abf,0x97f8,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	0x969f,0x92d0,UDCODE,UDCODE,UDCODE,UDCODE,0x9ff9,0x9ffb,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0x9151,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,0xe040,0x9ff7,UDCODE,0x9ff1,UDCODE,UDCODE,UDCODE,0x8ac1,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x8c89,UDCODE,UDCODE,UDCODE,
	0xe04e,UDCODE,UDCODE,0xe049,0x90f6,UDCODE,UDCODE,0x8a83,UDCODE,
	UDCODE,UDCODE,UDCODE,0x8f81,UDCODE,0xe052,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0xe04b,0x92aa,0xe048,0x92d7,UDCODE,UDCODE,
	UDCODE,0xe06b,UDCODE,UDCODE,UDCODE,0xe045,UDCODE,0xe044,UDCODE,
	0xe04d,UDCODE,UDCODE,UDCODE,0xe047,0xe046,0xe04c,UDCODE,0x909f,
	UDCODE,0xe043,UDCODE,0xfb4b,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	0xe04f,UDCODE,UDCODE,0xe050,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	0x8ac0,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,0xe055,UDCODE,0xe054,0xe056,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,0xe059,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x9362,
	UDCODE,0xe053,UDCODE,0xfb4c,UDCODE,UDCODE,UDCODE,0xe057,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x8c83,0x91f7,0xe051,0x945a,
	UDCODE,UDCODE,0xe058,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe05d,0xe05b,
	UDCODE,UDCODE,0xe05e,UDCODE,UDCODE,0xe061,UDCODE,UDCODE,UDCODE,
	0xe05a,0x8d8a,0x9447,UDCODE,UDCODE,0x9fb7,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0x9794,0xe05c,UDCODE,0xe060,0x91f3,UDCODE,
	0xe05f,UDCODE,0xe04a,UDCODE,0xfb4d,0xe889,UDCODE,UDCODE,UDCODE,
	0xe064,UDCODE,UDCODE,UDCODE,0xe068,0xe066,UDCODE,UDCODE,UDCODE,
	0xfb4e,UDCODE,0xfb4f,UDCODE,0xe062,UDCODE,0xe063,UDCODE,UDCODE,
	UDCODE,0xe067,UDCODE,0xe065,UDCODE,UDCODE,UDCODE,0x956d,UDCODE,
	UDCODE,0xe06d,UDCODE,0xe06a,0xe069,UDCODE,0xe06c,0x93d2,0xe06e,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x9295,0x91eb,0xfb50,
	UDCODE,UDCODE,UDCODE,0x90a3,UDCODE,UDCODE,UDCODE,0xe06f,UDCODE,
	0xe071,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0xe070,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x9ff3,
	UDCODE,UDCODE,UDCODE,UDCODE,0xe072,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,0x93e5,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0xe073,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0x89ce,UDCODE,UDCODE,UDCODE,0x9394,0x8a44,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x8b84,UDCODE,
	UDCODE,UDCODE,0x8edc,0x8dd0,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,0xfb51,UDCODE,UDCODE,UDCODE,0x9846,0x9086,UDCODE,
	UDCODE,UDCODE,0x898a,UDCODE,UDCODE,UDCODE,0xe075,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0xe074,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0xfb52,0xe078,0x9259,0xe07b,0xe076,
	UDCODE,UDCODE,UDCODE,0xe07a,UDCODE,UDCODE,UDCODE,UDCODE,0xe079,
	0x935f,0x88d7,0xfa62,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x97f3,UDCODE,UDCODE,
	0xe07d,UDCODE,UDCODE,UDCODE,0x8947,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe080,UDCODE,UDCODE,UDCODE,
	0xe07e,UDCODE,0xe07c,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,0xe077,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,0x9642,UDCODE,UDCODE,UDCODE,0xe082,0xfb54,UDCODE,UDCODE,
	UDCODE,UDCODE,0xe081,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xfb53,
	UDCODE,UDCODE,UDCODE,UDCODE,0x898b,UDCODE,UDCODE,UDCODE,UDCODE,
	0xe084,0x95b0,UDCODE,0xe083,UDCODE,UDCODE,UDCODE,UDCODE,0x96b3,
	UDCODE,UDCODE,UDCODE,UDCODE,0x8fc5,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,0x9152,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x8fc4,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	0xfb56,0xfb57,UDCODE,0x97f9,UDCODE,UDCODE,0xe08a,UDCODE,0x90f7,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe086,0xe08b,UDCODE,
	UDCODE,0x898c,UDCODE,UDCODE,0xfb55,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,0xe089,UDCODE,0x9481,0xe085,0xe088,0x8fc6,UDCODE,0x94cf,
	UDCODE,UDCODE,0xe08c,UDCODE,0x8ecf,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,0x90f8,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe08f,
	UDCODE,UDCODE,UDCODE,0xe087,UDCODE,0x8c46,UDCODE,UDCODE,UDCODE,
	UDCODE,0xe08d,UDCODE,UDCODE,UDCODE,UDCODE,0x976f,0xe090,UDCODE,
	UDCODE,UDCODE,0xeaa4,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x8f6e,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe091,
	UDCODE,UDCODE,UDCODE,0xe092,UDCODE,UDCODE,UDCODE,UDCODE,0x944d,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe094,UDCODE,
	UDCODE,UDCODE,UDCODE,0xe095,UDCODE,UDCODE,0xfb59,UDCODE,0x9452,
	UDCODE,UDCODE,UDCODE,UDCODE,0x9395,0xe097,UDCODE,UDCODE,UDCODE,
	UDCODE,0xe099,UDCODE,0x97d3,UDCODE,0xe096,UDCODE,0xe098,0x898d,
	UDCODE,0xe093,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	0x9a7a,0xe09a,UDCODE,UDCODE,UDCODE,UDCODE,0x9187,0x8e57,0xe09c,
	UDCODE,UDCODE,UDCODE,UDCODE,0xe09b,0x9043,0x99d7,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0xe09d,UDCODE,UDCODE,UDCODE,0xe09f,
	UDCODE,0xe08e,0xe09e,UDCODE,0xfb5a,0xe0a0,0x949a,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0xe0a1,UDCODE,UDCODE,0xe0a2,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	0xe0a3,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0xe0a4,UDCODE,0x92dc,UDCODE,0xe0a6,
	0xe0a5,UDCODE,UDCODE,0xe0a7,UDCODE,0xe0a8,UDCODE,UDCODE,0x8edd,
	0x9583,UDCODE,UDCODE,UDCODE,0x96ea,0xe0a9,0xe0aa,0x9175,0x8ea2,
	0xe0ab,0xe0ac,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe0ad,0x95d0,
	0x94c5,UDCODE,UDCODE,0xe0ae,0x9476,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,0x92ab,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe0af,0x89e5,
	UDCODE,0x8b8d,UDCODE,0x96c4,UDCODE,0x96b4,UDCODE,0x89b2,0x9853,
	UDCODE,UDCODE,UDCODE,UDCODE,0x9671,UDCODE,0x95a8,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x90b5,UDCODE,0xe0b0,
	UDCODE,UDCODE,UDCODE,UDCODE,0x93c1,UDCODE,UDCODE,UDCODE,0x8ca1,
	0xe0b1,UDCODE,0x8dd2,0xe0b3,0xe0b2,UDCODE,UDCODE,UDCODE,UDCODE,
	0xe0b4,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,0xe0b5,UDCODE,UDCODE,UDCODE,0xe0b6,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x8b5d,UDCODE,
	0xe0b7,UDCODE,UDCODE,UDCODE,UDCODE,0xe0b8,UDCODE,UDCODE,UDCODE,
	UDCODE,0x8ca2,UDCODE,UDCODE,0x94c6,UDCODE,0xfb5b,0xe0ba,UDCODE,
	UDCODE,UDCODE,0x8ff3,UDCODE,UDCODE,0xe0b9,UDCODE,UDCODE,UDCODE,
	UDCODE,0xfb5c,UDCODE,UDCODE,UDCODE,0x8bb6,0xe0bb,0xe0bd,UDCODE,
	0xe0bc,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe0be,
	UDCODE,0x8ccf,UDCODE,0xe0bf,UDCODE,UDCODE,UDCODE,UDCODE,0x8be7,
	UDCODE,0x915f,UDCODE,0x8d9d,UDCODE,UDCODE,UDCODE,UDCODE,0xe0c1,
	0xe0c2,0xe0c0,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x8eeb,
	UDCODE,UDCODE,0x93c6,0x8bb7,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0xe0c4,0x924b,0xe0c3,UDCODE,UDCODE,
	0x9854,0x9482,0xe0c7,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe0c9,0xe0c6,UDCODE,UDCODE,
	UDCODE,0x96d2,0xe0c8,0xe0ca,UDCODE,0x97c2,UDCODE,UDCODE,UDCODE,
	UDCODE,0xfb5d,0xe0ce,UDCODE,UDCODE,UDCODE,0xe0cd,0x9296,0x944c,
	UDCODE,UDCODE,0x8ca3,0xe0cc,UDCODE,UDCODE,UDCODE,UDCODE,0xe0cb,
	UDCODE,0x9750,0x9751,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	0xe0cf,0x898e,UDCODE,UDCODE,UDCODE,UDCODE,0x8d96,0x8e82,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe0d0,0xe0d1,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe0d3,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,0x8f62,UDCODE,UDCODE,UDCODE,UDCODE,0xe0d5,UDCODE,0xe0d4,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe0d6,UDCODE,0x8a6c,UDCODE,
	UDCODE,0xe0d8,UDCODE,0xfb5f,0xe0d7,UDCODE,0xe0da,0xe0d9,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x8cba,UDCODE,
	UDCODE,0x97a6,UDCODE,0x8bca,UDCODE,0x89a4,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x8be8,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x8adf,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x97e6,
	0xe0dc,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe0de,
	UDCODE,0xfb60,UDCODE,UDCODE,0xe0df,UDCODE,0x89cf,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0xe0db,0xfb61,0x8e58,UDCODE,UDCODE,0x92bf,
	0xe0dd,UDCODE,UDCODE,UDCODE,0xfb64,UDCODE,UDCODE,UDCODE,0xfb62,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe0e2,UDCODE,
	0x8eec,UDCODE,UDCODE,0xfb63,UDCODE,0xe0e0,UDCODE,UDCODE,UDCODE,
	UDCODE,0x8c5d,UDCODE,UDCODE,0x94c7,0xe0e1,UDCODE,UDCODE,0xe0fc,
	UDCODE,UDCODE,UDCODE,0xfb66,UDCODE,UDCODE,0xe0e7,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0x8cbb,0x8b85,UDCODE,0xe0e4,0x979d,0xfb65,
	UDCODE,0x97ae,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x91f4,
	UDCODE,UDCODE,0xe0e6,0xfb67,UDCODE,UDCODE,0xfb69,0xfb68,UDCODE,
	UDCODE,UDCODE,0xfb6a,UDCODE,UDCODE,UDCODE,0xe0e8,0x97d4,0x8bd5,
	0x94fa,0x9469,UDCODE,UDCODE,UDCODE,0xe0e9,UDCODE,UDCODE,UDCODE,
	UDCODE,0xe0eb,UDCODE,0xe0ee,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe0ea,UDCODE,UDCODE,UDCODE,
	0xe0ed,0x8ce8,0x896c,0xe0ef,UDCODE,0x9090,0xe0ec,0x97da,UDCODE,
	0xfb6b,0xe0f2,0xeaa2,UDCODE,UDCODE,UDCODE,UDCODE,0xe0f0,0xe0f3,
	UDCODE,UDCODE,UDCODE,UDCODE,0xe0e5,0xe0f1,UDCODE,UDCODE,0x8dba,
	UDCODE,UDCODE,0xe0f4,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,0xe0f5,UDCODE,UDCODE,UDCODE,UDCODE,0x979e,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0xfb6c,UDCODE,0xe0f6,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe0f7,0xfb6d,UDCODE,
	UDCODE,0xe0e3,UDCODE,UDCODE,UDCODE,UDCODE,0xe0f8,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x8ac2,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,0x8ea3,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe0f9,UDCODE,UDCODE,UDCODE,
	UDCODE,0xe0fa,UDCODE,UDCODE,UDCODE,UDCODE,0xe0fb,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x895a,UDCODE,UDCODE,UDCODE,
	0xe140,UDCODE,0x955a,0xe141,UDCODE,UDCODE,0x8aa2,0xe142,UDCODE,
	0xe143,UDCODE,UDCODE,UDCODE,UDCODE,0xe144,UDCODE,0xe146,0xe147,
	0xe145,UDCODE,UDCODE,UDCODE,0x9572,0xe149,0xe148,0xfb6e,UDCODE,
	0xe14b,0xe14a,0xe14c,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	0xe14d,0xe14f,0xe14e,UDCODE,UDCODE,0x8d99,UDCODE,0xe151,UDCODE,
	0xe150,UDCODE,UDCODE,0x8ac3,UDCODE,0x9072,UDCODE,0x935b,UDCODE,
	0xe152,0x90b6,UDCODE,UDCODE,UDCODE,0x8e59,UDCODE,0x8999,0xe153,
	UDCODE,0x9770,UDCODE,UDCODE,0x95e1,0xe154,UDCODE,UDCODE,0xfaa8,
	0x9363,0x9752,0x8d62,0x905c,UDCODE,UDCODE,UDCODE,0x926a,0x99b2,
	UDCODE,0x92ac,0x89e6,0xe155,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,0xe156,UDCODE,0xe15b,UDCODE,UDCODE,0xe159,0xe158,
	0x9dc0,0x8a45,0xe157,UDCODE,0x88d8,UDCODE,0x94a8,UDCODE,UDCODE,
	0x94c8,UDCODE,UDCODE,UDCODE,UDCODE,0x97af,0xe15c,0xe15a,0x927b,
	0x90a4,UDCODE,UDCODE,0x94a9,UDCODE,0x954c,UDCODE,0xe15e,0x97aa,
	0x8c6c,0xe15f,UDCODE,0xe15d,0x94d4,0xe160,UDCODE,0xe161,UDCODE,
	0xfb6f,0x88d9,UDCODE,UDCODE,0x8ff4,0xe166,UDCODE,0xe163,0x93eb,
	0xe162,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x8b45,UDCODE,
	UDCODE,0xe169,UDCODE,UDCODE,UDCODE,0xe164,0xe165,UDCODE,0xe168,
	0xe167,0x9544,UDCODE,UDCODE,0x9161,0x9160,UDCODE,0x8b5e,UDCODE,
	UDCODE,0xe16a,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe16b,UDCODE,
	UDCODE,0xe16c,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe16e,UDCODE,
	0xe16d,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x8975,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0xe176,0x94e6,0xe170,UDCODE,0xe172,UDCODE,
	UDCODE,0xe174,0x905d,UDCODE,UDCODE,0xe175,0xe173,0x8ebe,UDCODE,
	UDCODE,UDCODE,0xe16f,0xe171,UDCODE,0x9561,UDCODE,0x8fc7,UDCODE,
	UDCODE,0xe178,UDCODE,UDCODE,0xe177,UDCODE,UDCODE,UDCODE,UDCODE,
	0xe179,UDCODE,0x8ea4,0x8dad,UDCODE,UDCODE,0x9397,0xe17a,UDCODE,
	0x92c9,UDCODE,UDCODE,0xe17c,UDCODE,UDCODE,UDCODE,0x979f,0xe17b,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x9189,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0xe182,UDCODE,0xe184,0xe185,0x9273,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0xe183,UDCODE,0xe180,UDCODE,0xe17d,
	0xe17e,0xe181,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	0xe188,UDCODE,0xe186,UDCODE,0xe187,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0xe189,0xe18b,0xe18c,0xe18d,UDCODE,
	0xe18e,UDCODE,UDCODE,0xe18a,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0xe190,UDCODE,UDCODE,UDCODE,0xe18f,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe191,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0x97c3,UDCODE,UDCODE,UDCODE,0xe194,0xe192,
	0xe193,UDCODE,UDCODE,UDCODE,0x8ae0,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,0x96fc,UDCODE,UDCODE,UDCODE,0x95c8,UDCODE,0xe196,UDCODE,
	UDCODE,UDCODE,0xe195,UDCODE,UDCODE,UDCODE,UDCODE,0xe197,0xe198,
	UDCODE,UDCODE,UDCODE,UDCODE,0xe19c,0xe199,0xe19a,0xe19b,UDCODE,
	0xe19d,UDCODE,UDCODE,UDCODE,0xe19e,UDCODE,0xe19f,UDCODE,UDCODE,
	UDCODE,0xe1a0,UDCODE,0xe1a1,UDCODE,0x94ad,0x936f,0xe1a2,0x9492,
	0x9553,UDCODE,0xe1a3,UDCODE,0xfb70,0xe1a4,0x9349,UDCODE,0x8a46,
	0x8d63,0xe1a5,UDCODE,UDCODE,0xe1a6,UDCODE,UDCODE,0xe1a7,UDCODE,
	0x8e48,UDCODE,UDCODE,0xe1a9,UDCODE,UDCODE,0xe1a8,UDCODE,UDCODE,
	0xe1aa,0xe1ab,0xfb73,0xfb71,UDCODE,0xfb72,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0xfb74,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0x94e7,UDCODE,0xe1ac,UDCODE,UDCODE,UDCODE,
	0xe1ad,UDCODE,UDCODE,0xea89,0xe1ae,0xe1af,0xe1b0,UDCODE,UDCODE,
	UDCODE,UDCODE,0x8e4d,UDCODE,UDCODE,0xe1b1,0x9475,UDCODE,UDCODE,
	0x967e,UDCODE,0x896d,UDCODE,0x8976,UDCODE,UDCODE,0xe1b2,UDCODE,
	UDCODE,UDCODE,UDCODE,0xe1b4,UDCODE,UDCODE,UDCODE,0xe1b3,0x9390,
	UDCODE,UDCODE,UDCODE,0x90b7,0x9f58,UDCODE,0xe1b5,0x96bf,UDCODE,
	0xe1b6,UDCODE,0x8ac4,0x94d5,0xe1b7,UDCODE,0xe1b8,UDCODE,UDCODE,
	0xe1b9,UDCODE,UDCODE,UDCODE,0x96da,UDCODE,UDCODE,UDCODE,0x96d3,
	UDCODE,0x92bc,UDCODE,UDCODE,UDCODE,0x918a,UDCODE,UDCODE,0xe1bb,
	UDCODE,UDCODE,0x8f82,0x8fc8,UDCODE,UDCODE,0xe1be,UDCODE,UDCODE,
	0xe1bd,0xe1bc,0x94fb,UDCODE,0x8ac5,0x8ca7,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,0xe1c4,UDCODE,UDCODE,0xe1c1,0x905e,0x96b0,UDCODE,
	UDCODE,UDCODE,0xe1c0,0xe1c2,0xe1c3,UDCODE,UDCODE,0xe1bf,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0xe1c5,0xe1c6,UDCODE,0x92ad,UDCODE,0x8ae1,
	UDCODE,UDCODE,UDCODE,0x9285,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	0xfb76,0xe1c7,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,0xe1c8,0xe1cb,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	0x9087,UDCODE,0x93c2,UDCODE,0xe1cc,0x9672,UDCODE,0xe1c9,UDCODE,
	UDCODE,0xe1ca,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe1cf,UDCODE,UDCODE,
	UDCODE,UDCODE,0xe1ce,0xe1cd,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe1d1,UDCODE,UDCODE,
	0xe1d0,UDCODE,UDCODE,0xe1d2,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe1d4,UDCODE,
	0xe1d3,UDCODE,UDCODE,UDCODE,UDCODE,0x95cb,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0x8f75,0x97c4,UDCODE,UDCODE,0xe1d5,UDCODE,
	UDCODE,0x93b5,UDCODE,UDCODE,0xe1d6,UDCODE,UDCODE,0xe1d7,UDCODE,
	0xe1db,0xe1d9,0xe1da,UDCODE,0xe1d8,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0xe1dc,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	0xe1dd,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,0xe1de,UDCODE,UDCODE,0xe1df,0x96b5,0xe1e0,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0x96ee,0xe1e1,UDCODE,0x926d,UDCODE,0x948a,
	UDCODE,0x8be9,UDCODE,UDCODE,UDCODE,0x925a,0xe1e2,0x8bb8,UDCODE,
	UDCODE,UDCODE,0x90ce,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,0xe1e3,0x8dbb,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0xe1e4,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,0xe1e5,UDCODE,0x8ca4,0x8dd3,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe1e7,0xfb78,UDCODE,
	UDCODE,UDCODE,0x9375,0x8dd4,0x8b6d,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x9643,UDCODE,0x946a,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x9376,UDCODE,UDCODE,UDCODE,
	UDCODE,0x8d7b,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe1e9,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xfb79,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0x8fc9,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,0xfb7a,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	0x97b0,0x8d64,UDCODE,UDCODE,0x8ca5,UDCODE,UDCODE,0x94a1,UDCODE,
	0xe1eb,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xfb7b,UDCODE,0xe1ed,
	UDCODE,UDCODE,UDCODE,UDCODE,0x8ce9,UDCODE,UDCODE,UDCODE,UDCODE,
	0xe1ec,0x92f4,UDCODE,UDCODE,UDCODE,UDCODE,0xe1ef,0x8a56,0xe1ea,
	UDCODE,UDCODE,0x94e8,UDCODE,0x894f,UDCODE,0x8dea,UDCODE,0x9871,
	UDCODE,UDCODE,0xe1ee,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,0xe1f0,UDCODE,UDCODE,UDCODE,0x95c9,UDCODE,0x90d7,
	0xe1f2,UDCODE,UDCODE,UDCODE,UDCODE,0xe1f3,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,0xe1f1,UDCODE,UDCODE,UDCODE,UDCODE,0x8a6d,UDCODE,
	0xe1f9,UDCODE,0xe1f8,UDCODE,UDCODE,0x8ea5,UDCODE,UDCODE,UDCODE,
	0xe1fa,0xe1f5,UDCODE,UDCODE,UDCODE,0xe1fb,0xe1f6,UDCODE,UDCODE,
	UDCODE,UDCODE,0x94d6,0xe1f4,UDCODE,UDCODE,0xe1f7,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0xe241,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe240,0x9681,
	UDCODE,UDCODE,UDCODE,0xe1fc,UDCODE,UDCODE,0x88e9,UDCODE,UDCODE,
	UDCODE,UDCODE,0xe243,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,0xe242,0x8fca,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	0xe244,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x9162,UDCODE,
	UDCODE,0xe246,0xe245,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	0xe247,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0xe1e6,UDCODE,UDCODE,UDCODE,0xe1e8,
	0xe249,0xe248,UDCODE,UDCODE,UDCODE,0xfb7c,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x8ea6,UDCODE,0x97e7,
	UDCODE,0x8ed0,UDCODE,0xe24a,0x8c56,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,0x8b5f,0x8b46,0x8e83,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,0x9753,UDCODE,UDCODE,0xe250,UDCODE,0xe24f,0x9163,0xe24c,
	UDCODE,UDCODE,0xe24e,UDCODE,UDCODE,0x8f6a,0x905f,0xe24d,0xe24b,
	UDCODE,0x9449,UDCODE,UDCODE,0x8fcb,UDCODE,UDCODE,0x955b,UDCODE,
	UDCODE,UDCODE,UDCODE,0x8dd5,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0x9398,UDCODE,UDCODE,0xe251,UDCODE,
	UDCODE,UDCODE,UDCODE,0xe252,0xe268,0x8bd6,UDCODE,UDCODE,0x985c,
	0x9154,UDCODE,UDCODE,UDCODE,UDCODE,0xe253,UDCODE,UDCODE,0x89d0,
	0x92f5,0x959f,UDCODE,UDCODE,UDCODE,UDCODE,0xfb81,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0xfb83,UDCODE,0xe254,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x8b9a,0xe255,UDCODE,
	UDCODE,0xe257,UDCODE,UDCODE,UDCODE,0xe258,UDCODE,0x9448,UDCODE,
	UDCODE,0xe259,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe25a,0xe25b,
	UDCODE,UDCODE,0x8bd7,0x89d1,0x93c3,0x8f47,0x8e84,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe25c,UDCODE,0x8f48,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0x89c8,0x9562,UDCODE,UDCODE,0xe25d,
	UDCODE,UDCODE,0x94e9,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	0x9164,UDCODE,0xe260,UDCODE,0xe261,0x9489,UDCODE,0x9060,0xe25e,
	UDCODE,0x9281,UDCODE,UDCODE,0xe25f,UDCODE,UDCODE,UDCODE,0x8fcc,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,0x88da,0x8b48,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,0xe262,UDCODE,UDCODE,0x92f6,UDCODE,0xe263,0x90c5,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0x96ab,UDCODE,UDCODE,0x9542,0xe264,
	0xe265,0x9274,UDCODE,0x97c5,UDCODE,UDCODE,0xe267,0xe266,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0x8eed,UDCODE,UDCODE,0xe269,0x88ee,UDCODE,
	UDCODE,UDCODE,UDCODE,0xe26c,UDCODE,UDCODE,UDCODE,0xe26a,0x89d2,
	0x8c6d,0xe26b,0x8d65,0x8d92,UDCODE,0x95e4,0xe26d,UDCODE,UDCODE,
	0x9673,UDCODE,UDCODE,0xe26f,UDCODE,UDCODE,UDCODE,0x90cf,0x896e,
	0x89b8,0x88aa,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe26e,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	0xe270,0xe271,0x8ff5,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe272,
	UDCODE,0x8a6e,UDCODE,UDCODE,UDCODE,UDCODE,0xe274,UDCODE,UDCODE,
	UDCODE,0x8c8a,UDCODE,0x8b86,UDCODE,UDCODE,0xe275,0x8bf3,UDCODE,
	UDCODE,0xe276,UDCODE,0x90fa,UDCODE,0x93cb,UDCODE,0x90de,0x8df3,
	UDCODE,UDCODE,UDCODE,0xe277,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0x9282,0x918b,UDCODE,0xe279,0xe27b,
	0xe278,0xe27a,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x8c41,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	0xe27c,0x8c45,UDCODE,UDCODE,UDCODE,0x8b87,0x9771,0xe27e,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0xe280,UDCODE,UDCODE,UDCODE,0x894d,
	UDCODE,UDCODE,UDCODE,UDCODE,0xe283,UDCODE,UDCODE,UDCODE,0x8a96,
	0xe282,0xe281,UDCODE,0xe285,0xe27d,UDCODE,0xe286,0x97a7,UDCODE,
	0xe287,UDCODE,0xe288,UDCODE,0xfb84,0x9af2,0xe28a,UDCODE,0xe289,
	UDCODE,UDCODE,UDCODE,0xe28b,0xe28c,UDCODE,0x97b3,0xe28d,UDCODE,
	0xe8ed,0x8fcd,0xe28e,0xe28f,0x8f76,UDCODE,0x93b6,0xe290,0xfb85,
	UDCODE,UDCODE,0x9247,0xfb87,UDCODE,0xe291,UDCODE,0x925b,0xe292,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x8ba3,UDCODE,0x995e,0x927c,
	0x8eb1,UDCODE,UDCODE,UDCODE,UDCODE,0x8ac6,0xe293,UDCODE,0xe2a0,
	UDCODE,0xe296,UDCODE,0x8b88,UDCODE,0xe295,0xe2a2,UDCODE,UDCODE,
	UDCODE,0xe294,UDCODE,0x8fce,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,0xe298,0xe299,UDCODE,0x934a,UDCODE,UDCODE,0xe29a,UDCODE,
	0x8a7d,UDCODE,UDCODE,UDCODE,UDCODE,0x9079,0x9584,UDCODE,0xe29c,
	UDCODE,UDCODE,UDCODE,0x91e6,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,0xe297,UDCODE,0xe29b,0xe29d,UDCODE,UDCODE,0x8df9,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,0xe2a4,0x954d,UDCODE,0x94a4,0x9399,UDCODE,0x8bd8,0xe2a3,
	0xe2a1,UDCODE,0x94b3,0xe29e,0x927d,0x939b,UDCODE,0x939a,UDCODE,
	0x8df4,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe2b6,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe2a6,UDCODE,0xe2a8,
	UDCODE,UDCODE,UDCODE,UDCODE,0xe2ab,UDCODE,0xe2ac,UDCODE,0xe2a9,
	0xe2aa,UDCODE,UDCODE,0xe2a7,0xe2a5,UDCODE,UDCODE,UDCODE,UDCODE,
	0xe29f,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0x95cd,0x89d3,UDCODE,UDCODE,UDCODE,0xe2b3,
	UDCODE,0xe2b0,UDCODE,0xe2b5,UDCODE,UDCODE,0xe2b4,UDCODE,0x9493,
	0x96a5,UDCODE,0x8e5a,0xe2ae,0xe2b7,0xe2b2,UDCODE,0xe2b1,0xe2ad,
	0xfb88,0xe2af,UDCODE,0x8ac7,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0x925c,UDCODE,UDCODE,0x90fb,UDCODE,UDCODE,
	UDCODE,0x94a0,UDCODE,UDCODE,0xe2bc,UDCODE,UDCODE,UDCODE,0x94a2,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x90df,0xe2b9,
	UDCODE,UDCODE,0x94cd,UDCODE,0xe2bd,0x95d1,UDCODE,0x927a,UDCODE,
	0xe2b8,0xe2ba,UDCODE,UDCODE,0xe2bb,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	0xe2be,UDCODE,UDCODE,0x8ec2,UDCODE,UDCODE,UDCODE,0x93c4,0xe2c3,
	0xe2c2,UDCODE,UDCODE,0xe2bf,UDCODE,UDCODE,UDCODE,0x9855,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0xe2c8,UDCODE,UDCODE,0xe2cc,0xe2c9,
	0xe2c5,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe2c6,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0xe2cb,UDCODE,UDCODE,UDCODE,0xe2c0,
	0x99d3,0xe2c7,0xe2c1,UDCODE,UDCODE,0xe2ca,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0xe2d0,UDCODE,0x8ac8,UDCODE,0xe2cd,
	UDCODE,UDCODE,UDCODE,0xe2ce,UDCODE,UDCODE,0xe2cf,0xe2d2,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,0xe2d1,0x94f4,UDCODE,UDCODE,UDCODE,UDCODE,0xe2d3,0x97fa,
	0x95eb,0xe2d8,UDCODE,UDCODE,0xe2d5,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0xe2d4,0x90d0,UDCODE,0xe2d7,0xe2d9,
	UDCODE,UDCODE,UDCODE,0xe2d6,UDCODE,0xe2dd,UDCODE,0xe2da,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe2db,0xe2c4,UDCODE,UDCODE,
	UDCODE,0xe2dc,0xe2de,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	0xe2df,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x95c4,UDCODE,
	0xe2e0,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	0x96e0,UDCODE,UDCODE,0x8bcc,0x8c48,0xe2e1,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,0x95b2,UDCODE,0x9088,UDCODE,0x96ae,UDCODE,UDCODE,
	0xe2e2,UDCODE,0x97b1,UDCODE,UDCODE,0x9494,UDCODE,0x9165,0x9453,
	UDCODE,UDCODE,0x8f6c,UDCODE,UDCODE,UDCODE,0x88be,UDCODE,0xe2e7,
	0xe2e5,UDCODE,0xe2e3,0x8a9f,UDCODE,0x8fcf,0xe2e8,UDCODE,UDCODE,
	0xe2e6,UDCODE,0xe2e4,0xe2ec,UDCODE,UDCODE,0xe2eb,0xe2ea,0xe2e9,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe2ed,UDCODE,UDCODE,UDCODE,
	0xe2ee,0x90b8,UDCODE,0xe2ef,UDCODE,0xe2f1,UDCODE,UDCODE,0xe2f0,
	UDCODE,UDCODE,UDCODE,UDCODE,0x8cd0,UDCODE,UDCODE,UDCODE,0x9157,
	UDCODE,UDCODE,UDCODE,0xe2f3,UDCODE,UDCODE,UDCODE,0x939c,UDCODE,
	0xe2f2,UDCODE,UDCODE,UDCODE,0xe2f4,UDCODE,0x95b3,0x918c,0x8d66,
	UDCODE,0xe2f5,UDCODE,UDCODE,UDCODE,UDCODE,0x97c6,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe2f7,UDCODE,UDCODE,0xe2f8,
	UDCODE,0xe2f9,UDCODE,0xe2fa,UDCODE,0x8e85,UDCODE,0xe2fb,0x8c6e,
	UDCODE,UDCODE,0x8b8a,0x8b49,UDCODE,0xe340,UDCODE,0x96f1,0x8d67,
	0xe2fc,UDCODE,UDCODE,UDCODE,0xe343,0x96e4,UDCODE,0x945b,UDCODE,
	UDCODE,0x9552,UDCODE,UDCODE,UDCODE,0x8f83,0xe342,UDCODE,0x8ed1,
	0x8d68,0x8e86,0x8b89,0x95b4,0xe341,UDCODE,UDCODE,UDCODE,0x9166,
	0x9661,0x8df5,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,0x8e87,0x92db,UDCODE,0xe346,0x97dd,0x8dd7,UDCODE,0xe347,
	0x9061,UDCODE,0xe349,UDCODE,UDCODE,UDCODE,0x8fd0,0x8dae,UDCODE,
	UDCODE,UDCODE,UDCODE,0xe348,UDCODE,UDCODE,0x8f49,0x8cbc,0x9167,
	0xe344,0xe34a,UDCODE,0xfb8a,UDCODE,UDCODE,0xe345,0x8c6f,UDCODE,
	0xe34d,0xe351,0x8c8b,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe34c,
	UDCODE,UDCODE,UDCODE,UDCODE,0xe355,0xfb8b,UDCODE,0x8d69,UDCODE,
	UDCODE,0x978d,0x88ba,0xe352,UDCODE,UDCODE,0x8b8b,UDCODE,0xe34f,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe350,UDCODE,UDCODE,0x939d,
	0xe34e,0xe34b,UDCODE,0x8a47,0x90e2,UDCODE,UDCODE,0x8ca6,UDCODE,
	UDCODE,UDCODE,0xe357,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe354,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,0xe356,UDCODE,UDCODE,UDCODE,0xe353,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0x8c70,0x91b1,0xe358,0x918e,UDCODE,UDCODE,
	0xe365,0xfb8d,UDCODE,0xe361,0xe35b,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0xe35f,0x8ef8,0x88db,0xe35a,0xe362,0xe366,
	0x8d6a,0x96d4,UDCODE,0x92d4,0xe35c,UDCODE,0xfb8c,0xe364,UDCODE,
	0xe359,0x925d,UDCODE,0xe35e,0x88bb,0x96c8,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0xe35d,UDCODE,UDCODE,0x8bd9,0x94ea,
	UDCODE,UDCODE,UDCODE,0x918d,UDCODE,0x97ce,0x8f8f,UDCODE,UDCODE,
	0xe38e,0xfb8e,UDCODE,0xe367,UDCODE,0x90fc,UDCODE,0xe363,0xe368,
	0xe36a,UDCODE,0x92f7,0xe36d,UDCODE,UDCODE,0xe369,UDCODE,UDCODE,
	UDCODE,0x95d2,0x8ac9,UDCODE,UDCODE,0x96c9,UDCODE,UDCODE,0x88dc,
	UDCODE,UDCODE,0xe36c,UDCODE,0x97fb,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,0xe36b,0x898f,UDCODE,UDCODE,0x93ea,0xe36e,UDCODE,
	UDCODE,UDCODE,0xe375,0xe36f,0xe376,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,0xe372,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,0x949b,UDCODE,UDCODE,0x8ec8,0xe374,UDCODE,0xe371,
	0xe377,0xe370,UDCODE,UDCODE,0x8f63,UDCODE,UDCODE,UDCODE,UDCODE,
	0x9644,UDCODE,UDCODE,0x8f6b,UDCODE,UDCODE,0xe373,0xe380,UDCODE,
	UDCODE,0xe37b,UDCODE,0xe37e,UDCODE,0xe37c,0xe381,0xe37a,UDCODE,
	0xe360,0x90d1,UDCODE,UDCODE,0x94c9,UDCODE,0xe37d,UDCODE,UDCODE,
	0xe378,UDCODE,UDCODE,UDCODE,0x9140,0x8c71,UDCODE,0x8f4a,UDCODE,
	UDCODE,UDCODE,UDCODE,0xfb8f,UDCODE,0x9044,0x9155,0xe384,UDCODE,
	UDCODE,0xe386,0xe387,UDCODE,UDCODE,0xe383,0xe385,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe379,0xe382,UDCODE,0xe38a,
	0xe389,UDCODE,UDCODE,0x969a,UDCODE,UDCODE,0x8c4a,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe388,UDCODE,0xe38c,
	0xe38b,0xe38f,UDCODE,0xe391,UDCODE,UDCODE,0x8e5b,0xe38d,UDCODE,
	UDCODE,UDCODE,UDCODE,0xe392,0xe393,0xfa5c,UDCODE,0xe394,UDCODE,
	0xe39a,0x935a,0xe396,UDCODE,0xe395,0xe397,0xe398,UDCODE,0xe399,
	UDCODE,UDCODE,UDCODE,UDCODE,0xe39b,0xe39c,0x8aca,UDCODE,0xe39d,
	UDCODE,0xe39e,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0xe39f,UDCODE,0xfb90,UDCODE,UDCODE,UDCODE,
	UDCODE,0xe3a0,0xe3a1,0xe3a2,UDCODE,0xe3a3,0xe3a4,UDCODE,UDCODE,
	0xe3a6,0xe3a5,UDCODE,UDCODE,0xe3a7,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,0xe3a8,0xe3a9,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,0xe3ac,0xe3aa,0xe3ab,0x8ddf,0x8c72,UDCODE,UDCODE,0x9275,
	UDCODE,0x94b1,UDCODE,0x8f90,UDCODE,UDCODE,0x946c,UDCODE,0x94eb,
	0xe3ad,0x9ceb,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,0xe3ae,0xe3b0,UDCODE,0x9785,0xe3af,0xe3b2,0xe3b1,UDCODE,
	0x9772,UDCODE,0xe3b3,UDCODE,0x94fc,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,0xe3b4,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe3b7,UDCODE,
	UDCODE,0xe3b6,0xe3b5,UDCODE,UDCODE,0xfb91,UDCODE,0xe3b8,0x8c51,
	UDCODE,UDCODE,UDCODE,0x9141,0x8b60,UDCODE,UDCODE,UDCODE,UDCODE,
	0xe3bc,0xe3b9,UDCODE,UDCODE,0xe3ba,UDCODE,UDCODE,UDCODE,0xe3bd,
	UDCODE,0xe3be,0xe3bb,UDCODE,UDCODE,UDCODE,0x8948,UDCODE,UDCODE,
	UDCODE,0x89a5,UDCODE,UDCODE,UDCODE,0xe3c0,0xe3c1,UDCODE,UDCODE,
	UDCODE,0xe3c2,UDCODE,0x9782,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	0x8f4b,UDCODE,0xe3c4,0xe3c3,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x9089,0xe3c5,UDCODE,UDCODE,
	UDCODE,UDCODE,0xe3c6,UDCODE,UDCODE,0xe3c7,UDCODE,0x8ae3,UDCODE,
	UDCODE,UDCODE,UDCODE,0x8acb,UDCODE,UDCODE,0xe3c8,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0xe3c9,UDCODE,0x967c,0x9783,0x9773,0x9856,
	UDCODE,0x8d6c,0xe3cc,0x8ed2,0xe3cb,UDCODE,UDCODE,UDCODE,UDCODE,
	0xe3cd,0x8ea7,UDCODE,UDCODE,UDCODE,0x91cf,UDCODE,0xe3ce,UDCODE,
	UDCODE,0x8d6b,UDCODE,0x96d5,0xe3cf,0xe3d0,UDCODE,UDCODE,0xe3d1,
	UDCODE,UDCODE,UDCODE,UDCODE,0xe3d2,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,0xe3d3,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0x8ea8,UDCODE,UDCODE,0x96eb,UDCODE,
	UDCODE,UDCODE,UDCODE,0xe3d5,UDCODE,0x925e,UDCODE,0xe3d4,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe3d7,UDCODE,UDCODE,UDCODE,
	0xe3d6,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe3d8,
	UDCODE,UDCODE,UDCODE,0x90b9,UDCODE,0xe3d9,UDCODE,0xe3da,UDCODE,
	UDCODE,UDCODE,0x95b7,0xe3db,UDCODE,0x918f,0xe3dc,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0xe3dd,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,0x97fc,0xe3e0,UDCODE,0xe3df,0xe3de,0x92ae,UDCODE,0xe3e1,
	0x9045,UDCODE,0xe3e2,UDCODE,UDCODE,UDCODE,0xe3e3,0x9857,0xe3e4,
	UDCODE,UDCODE,UDCODE,UDCODE,0xe3e5,0xe3e7,0xe3e6,0x94a3,UDCODE,
	0x93f7,UDCODE,0x985d,0x94a7,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,0xe3e9,UDCODE,UDCODE,0x8fd1,UDCODE,0x9549,UDCODE,0xe3ea,
	0xe3e8,UDCODE,0x8acc,UDCODE,UDCODE,UDCODE,0x8cd2,0x8e88,UDCODE,
	UDCODE,0x94ec,UDCODE,UDCODE,UDCODE,0x8ca8,0x9662,UDCODE,0xe3ed,
	0xe3eb,UDCODE,0x8d6d,UDCODE,0x8d6e,0x88e7,UDCODE,0x8de6,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0x9478,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0x88dd,0xe3f2,UDCODE,0x925f,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0x9477,UDCODE,0x91d9,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe3f4,UDCODE,UDCODE,0xe3f0,
	0xe3f3,0xe3ee,UDCODE,0xe3f1,0x9645,UDCODE,UDCODE,0x8cd3,UDCODE,
	UDCODE,0x88fb,0xe3ef,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0xe3f6,UDCODE,0xe3f7,UDCODE,UDCODE,0x93b7,
	UDCODE,UDCODE,UDCODE,0x8bb9,UDCODE,UDCODE,UDCODE,0xe445,0x945c,
	0x8e89,UDCODE,UDCODE,0x8bba,0x90c6,0x9865,0x96ac,0xe3f5,0x90d2,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x8b72,0xe3f8,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe3fa,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0xe3f9,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	0xe3fb,UDCODE,0x9245,UDCODE,0x945d,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,0x92af,UDCODE,UDCODE,UDCODE,UDCODE,0xe442,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe441,UDCODE,UDCODE,UDCODE,
	UDCODE,0xe3fc,UDCODE,UDCODE,0x9074,UDCODE,0x9585,0xe444,UDCODE,
	0xe443,0x8d6f,0x9872,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0xe454,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	0xe448,0xe449,UDCODE,UDCODE,UDCODE,UDCODE,0x8eee,UDCODE,UDCODE,
	0xe447,UDCODE,0x8d98,0xe446,UDCODE,UDCODE,0xe44a,UDCODE,UDCODE,
	UDCODE,0x92b0,0x95a0,0x9142,UDCODE,UDCODE,UDCODE,UDCODE,0x91da,
	0xe44e,UDCODE,0xe44f,0xe44b,UDCODE,UDCODE,UDCODE,UDCODE,0xe44c,
	UDCODE,0xe44d,UDCODE,UDCODE,UDCODE,UDCODE,0x8d70,UDCODE,UDCODE,
	UDCODE,0xe455,UDCODE,0xe451,UDCODE,UDCODE,UDCODE,UDCODE,0x9586,
	UDCODE,0x968c,0x9547,UDCODE,UDCODE,0xe450,UDCODE,UDCODE,0xe453,
	0xe452,UDCODE,UDCODE,UDCODE,0x9663,0xe456,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0xe457,UDCODE,UDCODE,0x9156,UDCODE,0xe458,
	UDCODE,UDCODE,0xe45a,UDCODE,0xe45e,UDCODE,UDCODE,0xe45b,0xe459,
	0x945e,0xe45c,UDCODE,0xe45d,UDCODE,UDCODE,UDCODE,0x89b0,UDCODE,
	0xe464,0xe45f,UDCODE,UDCODE,UDCODE,0xe460,UDCODE,UDCODE,UDCODE,
	0xe461,UDCODE,0x919f,UDCODE,UDCODE,UDCODE,UDCODE,0xe463,0xe462,
	0xe465,UDCODE,UDCODE,UDCODE,UDCODE,0xe466,0xe467,UDCODE,UDCODE,
	0x9062,UDCODE,0x89e7,UDCODE,0xe468,0x97d5,UDCODE,0x8ea9,UDCODE,
	UDCODE,0x8f4c,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x8e8a,0x9276,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe469,0xe46a,0x8950,UDCODE,
	0xe46b,0xe46c,0xe46d,UDCODE,UDCODE,0xe46e,UDCODE,0xe46f,0x8bbb,
	0x9da8,0xe470,UDCODE,0x90e3,0xe471,0x8ec9,UDCODE,0xe472,UDCODE,
	0x98ae,UDCODE,UDCODE,UDCODE,0xe473,0x95dc,0x8ada,UDCODE,UDCODE,
	0x9143,0x8f77,UDCODE,0x9591,0x8f4d,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe474,0x8d71,0xe475,0x94ca,
	UDCODE,0xe484,UDCODE,UDCODE,UDCODE,UDCODE,0xe477,UDCODE,0x91c7,
	0x9495,0x8cbd,0xe476,0x9144,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,0xe478,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x92f8,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe47a,0xe479,
	0xe47c,UDCODE,UDCODE,0xe47b,UDCODE,0xe47d,UDCODE,UDCODE,0xe480,
	UDCODE,0xe47e,UDCODE,0x8acd,UDCODE,0xe481,UDCODE,0xe482,0xe483,
	UDCODE,UDCODE,0x8daf,0x97c7,UDCODE,0xe485,0x9046,UDCODE,UDCODE,
	UDCODE,0x8990,0xe486,0xe487,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	0xe488,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0x88f0,UDCODE,0xe489,UDCODE,UDCODE,
	UDCODE,UDCODE,0xe48a,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	0x9587,UDCODE,UDCODE,UDCODE,0x8ec5,UDCODE,0xe48c,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0x8a48,0x88b0,UDCODE,UDCODE,UDCODE,UDCODE,
	0xe48b,0xe48e,0x946d,UDCODE,0x9063,UDCODE,0x89d4,UDCODE,0x9646,
	UDCODE,UDCODE,UDCODE,UDCODE,0x8c7c,0x8bda,UDCODE,0xe48d,UDCODE,
	0x89e8,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x8aa1,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,0x8991,0xe492,0x97e8,0x91db,UDCODE,UDCODE,0x9563,
	UDCODE,0xe49e,UDCODE,0x89d5,0xe49c,UDCODE,0xe49a,0xe491,UDCODE,
	0xe48f,UDCODE,0xe490,UDCODE,0x8ee1,0x8bea,0x9297,UDCODE,UDCODE,
	UDCODE,0x93cf,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x8970,UDCODE,
	0xe494,0xe493,UDCODE,UDCODE,UDCODE,UDCODE,0xe499,0xe495,0xe498,
	0xfb93,0x96ce,0xe497,0x89d6,0x8a9d,0xe49b,UDCODE,UDCODE,0xe49d,
	UDCODE,UDCODE,UDCODE,UDCODE,0x8c73,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0xe4a1,0xe4aa,0xe4ab,UDCODE,UDCODE,UDCODE,
	0x88a9,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe4b2,UDCODE,
	UDCODE,UDCODE,UDCODE,0x88ef,UDCODE,UDCODE,0xe4a9,UDCODE,UDCODE,
	UDCODE,0xe4a8,UDCODE,0xe4a3,0xe4a2,UDCODE,0xe4a0,0xe49f,0x9283,
	UDCODE,0x91f9,0xe4a5,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	0xe4a4,UDCODE,UDCODE,UDCODE,UDCODE,0xe4a7,UDCODE,UDCODE,UDCODE,
	0x9190,0x8c74,UDCODE,UDCODE,UDCODE,UDCODE,0x8960,0xe4a6,UDCODE,
	0x8d72,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x9191,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xfb94,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe4b8,UDCODE,0xe4b9,
	UDCODE,0x89d7,UDCODE,UDCODE,UDCODE,0x89ac,0xe4b6,UDCODE,UDCODE,
	0xfb95,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe4ac,UDCODE,0xe4b4,
	UDCODE,0xe4bb,0xe4b5,UDCODE,UDCODE,UDCODE,0xe4b3,UDCODE,UDCODE,
	UDCODE,UDCODE,0xe496,UDCODE,UDCODE,0xe4b1,UDCODE,UDCODE,UDCODE,
	0xe4ad,UDCODE,UDCODE,UDCODE,0x8ace,0xe4af,0xe4ba,UDCODE,0xe4b0,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe4bc,UDCODE,0xe4ae,0x949c,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x9789,UDCODE,UDCODE,UDCODE,
	0xe4b7,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe4cd,
	UDCODE,UDCODE,UDCODE,0xe4c5,UDCODE,UDCODE,UDCODE,0x909b,UDCODE,
	0xfb96,UDCODE,UDCODE,0x8b65,UDCODE,0x8bdb,UDCODE,0xe4c0,UDCODE,
	UDCODE,UDCODE,UDCODE,0x89d9,UDCODE,UDCODE,0x8fd2,UDCODE,0xe4c3,
	UDCODE,UDCODE,UDCODE,0x8dd8,UDCODE,UDCODE,0x9370,0xe4c8,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x95ec,UDCODE,
	0xe4bf,UDCODE,UDCODE,UDCODE,0x89d8,0x8cd4,0x9548,0xe4c9,UDCODE,
	0xe4bd,UDCODE,0xfb97,0xe4c6,UDCODE,UDCODE,UDCODE,0xe4d0,UDCODE,
	0xe4c1,0xe4c2,0x93b8,UDCODE,UDCODE,0xe4c7,UDCODE,UDCODE,UDCODE,
	0xe4c4,0x9647,0xe4ca,0x88de,UDCODE,UDCODE,UDCODE,UDCODE,0xe4be,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0xe4cc,UDCODE,0xe4cb,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0x948b,0xe4d2,UDCODE,0xe4dd,UDCODE,UDCODE,
	UDCODE,UDCODE,0x8a9e,UDCODE,UDCODE,UDCODE,0xe4e0,UDCODE,UDCODE,
	0xe4ce,UDCODE,UDCODE,UDCODE,0xe4d3,0x978e,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe4dc,UDCODE,0xfb98,0x9774,
	UDCODE,UDCODE,UDCODE,UDCODE,0x97a8,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0x9298,UDCODE,UDCODE,UDCODE,0x8a8b,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x9592,0xe4e2,0x939f,UDCODE,
	UDCODE,0x88af,UDCODE,UDCODE,0xe4db,UDCODE,0xe4d7,0x9192,0xe4d1,
	0xe4d9,0xe4de,UDCODE,0x944b,UDCODE,UDCODE,UDCODE,0x88a8,UDCODE,
	0xe4d6,UDCODE,0xe4df,0x9598,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,0xe4da,UDCODE,0xe4d5,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,0x8fd3,UDCODE,UDCODE,UDCODE,UDCODE,0x8f4e,UDCODE,
	UDCODE,UDCODE,0x8eaa,UDCODE,UDCODE,UDCODE,UDCODE,0x96d6,UDCODE,
	UDCODE,0x9566,UDCODE,UDCODE,0xe4e5,UDCODE,0xe4ee,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	0xe4d8,UDCODE,UDCODE,UDCODE,UDCODE,0x8a97,UDCODE,0xfb99,UDCODE,
	UDCODE,UDCODE,0x8ff6,0xe4e3,UDCODE,0xe4e8,0x9193,UDCODE,UDCODE,
	0xe4e4,UDCODE,0xe4eb,UDCODE,UDCODE,0x927e,UDCODE,0xe4ec,UDCODE,
	UDCODE,0x9775,0xe4e1,0x8a57,UDCODE,0xe4e7,UDCODE,UDCODE,0xe4ea,
	0x96aa,UDCODE,UDCODE,UDCODE,UDCODE,0xe4ed,UDCODE,UDCODE,0xe4e6,
	0xe4e9,UDCODE,0xfa60,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	0x9648,UDCODE,0x9840,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe4f1,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe4f8,UDCODE,
	UDCODE,0xe4f0,0x8ec1,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe4cf,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,0x95cc,UDCODE,0x96a0,0xe4f7,0xe4f6,UDCODE,0xe4f2,0xe4f3,
	UDCODE,0x8955,UDCODE,UDCODE,UDCODE,UDCODE,0xe4f5,UDCODE,0xe4ef,
	UDCODE,UDCODE,UDCODE,UDCODE,0x92d3,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,0xe4f4,0x88fc,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,0x91a0,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	0x95c1,UDCODE,UDCODE,0xe4f9,0xe540,UDCODE,0x94d7,UDCODE,UDCODE,
	UDCODE,UDCODE,0xe4fc,0x8fd4,0x8ec7,0xe542,UDCODE,UDCODE,0x8bbc,
	UDCODE,UDCODE,UDCODE,UDCODE,0xfb9a,UDCODE,0xe543,UDCODE,0x9599,
	0xe4fb,0xfb9b,0xe4d4,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,0xe4fa,UDCODE,UDCODE,UDCODE,UDCODE,0x986e,0x93a0,
	0x9593,0xfb9c,UDCODE,0xe54a,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0xe550,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,0xe551,UDCODE,0xe544,UDCODE,UDCODE,UDCODE,0x9496,
	UDCODE,UDCODE,0xe54e,0xe546,UDCODE,0xe548,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,0xe552,0xe547,UDCODE,UDCODE,0xe54b,UDCODE,UDCODE,
	0x8992,UDCODE,0x93e3,UDCODE,0xe54c,0xe54f,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0xe545,UDCODE,0x9145,UDCODE,0xe549,
	0x8e46,0x9064,0x8c4f,0x96f2,UDCODE,0x96f7,0x8f92,0xfb9e,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe556,0xe554,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x986d,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe553,UDCODE,UDCODE,UDCODE,
	0x9795,UDCODE,0xe555,0xe557,UDCODE,UDCODE,UDCODE,UDCODE,0xe558,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe55b,0xe559,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x93a1,0xe55a,UDCODE,UDCODE,
	UDCODE,0x94cb,0xe54d,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x8f93,UDCODE,0xe55c,
	0xe561,0x9194,UDCODE,UDCODE,0xe560,0xe541,UDCODE,UDCODE,UDCODE,
	0xe562,0x9168,UDCODE,UDCODE,0xe55d,0xe55f,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0xe55e,UDCODE,UDCODE,0x9f50,0x9f41,
	UDCODE,UDCODE,0xe564,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,0xe563,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0x9796,UDCODE,0xe1ba,0xe565,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0xe566,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe567,
	0x8cd5,UDCODE,0x8b73,UDCODE,UDCODE,UDCODE,0xe569,0x997c,UDCODE,
	UDCODE,UDCODE,UDCODE,0x8b95,UDCODE,0x97b8,UDCODE,0x8bf1,0xe56a,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe56b,UDCODE,
	UDCODE,UDCODE,0x928e,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe56c,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x93f8,UDCODE,
	0x88b8,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x89e1,0xe571,0xe572,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe56d,UDCODE,0x8e5c,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0xe56e,0x9461,UDCODE,UDCODE,UDCODE,
	UDCODE,0xe56f,0xe570,0xe57a,UDCODE,UDCODE,UDCODE,0xe574,0xe577,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe573,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,0xe575,UDCODE,0xe576,0x8ed6,UDCODE,0xe578,UDCODE,0x9260,
	UDCODE,0x8c75,0x8a61,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe57b,
	UDCODE,UDCODE,UDCODE,UDCODE,0x8a5e,UDCODE,0xe581,UDCODE,UDCODE,
	0xe57c,0xe580,UDCODE,UDCODE,UDCODE,UDCODE,0x94b8,UDCODE,UDCODE,
	UDCODE,UDCODE,0xe57d,UDCODE,UDCODE,0xe57e,0x9567,0x94d8,0xe582,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x91fb,
	0xe58c,UDCODE,0xe588,UDCODE,UDCODE,0x89e9,0xe586,UDCODE,0x9649,
	0xe587,UDCODE,UDCODE,0xe584,UDCODE,0xe585,0xe58a,0xe58d,UDCODE,
	UDCODE,0xe58b,UDCODE,UDCODE,UDCODE,0xe589,0xe583,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0x9277,UDCODE,0xe594,UDCODE,0x96a8,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe592,UDCODE,
	UDCODE,UDCODE,0xe593,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0xe58e,UDCODE,UDCODE,0xe590,UDCODE,
	UDCODE,UDCODE,0xe591,UDCODE,UDCODE,UDCODE,0xe58f,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x90e4,UDCODE,
	0x9858,0xe598,UDCODE,0xe599,UDCODE,UDCODE,UDCODE,UDCODE,0xe59f,
	UDCODE,0x9049,UDCODE,0xe59b,UDCODE,0xe59e,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,0xe596,0xe595,UDCODE,UDCODE,0xe5a0,UDCODE,UDCODE,
	0x89da,UDCODE,0xe59c,UDCODE,0xe5a1,UDCODE,UDCODE,UDCODE,0xe59d,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe59a,UDCODE,0x92b1,UDCODE,
	0xe597,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x9488,UDCODE,
	UDCODE,0xe5a5,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0x975a,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0xe5a4,UDCODE,UDCODE,0xe5a3,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe5ac,UDCODE,UDCODE,
	UDCODE,0xe5a6,UDCODE,UDCODE,UDCODE,0xe5ae,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0x9786,0xe5b1,UDCODE,0xe5a8,UDCODE,UDCODE,
	0xe5a9,UDCODE,UDCODE,UDCODE,0xe5ad,UDCODE,0xe5b0,0xe5af,UDCODE,
	UDCODE,UDCODE,0xe5a7,UDCODE,UDCODE,UDCODE,UDCODE,0xe5aa,UDCODE,
	0xe5bb,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe5b4,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,0xe5b2,UDCODE,UDCODE,0xe5b3,UDCODE,UDCODE,UDCODE,
	0xe5b8,0xe5b9,UDCODE,0x8a49,UDCODE,0x8b61,UDCODE,UDCODE,0xe5b7,
	0xe5a2,UDCODE,0xfba1,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe5b6,
	0xe5ba,0xe5b5,UDCODE,0xe5bc,UDCODE,UDCODE,UDCODE,0xe5be,0xe5bd,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,0xe5c0,0xe5bf,0xe579,UDCODE,UDCODE,UDCODE,0xe5c4,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe5c1,
	UDCODE,UDCODE,UDCODE,UDCODE,0xe5c2,UDCODE,UDCODE,0xe5c3,UDCODE,
	0xe5c5,UDCODE,UDCODE,UDCODE,UDCODE,0x8c8c,UDCODE,0xe5c7,UDCODE,
	0xe5c6,UDCODE,0x8f4f,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x8d73,
	0x9fa5,UDCODE,UDCODE,UDCODE,UDCODE,0xe5c8,0x8f70,UDCODE,UDCODE,
	UDCODE,0x8a58,UDCODE,0xe5c9,UDCODE,0x8971,UDCODE,0x8fd5,0xe5ca,
	UDCODE,UDCODE,0x8d74,0xe5cb,0x88df,UDCODE,UDCODE,UDCODE,UDCODE,
	0x955c,UDCODE,UDCODE,0xe5cc,UDCODE,UDCODE,UDCODE,UDCODE,0x908a,
	UDCODE,0xe5d3,UDCODE,UDCODE,0xe5d0,UDCODE,0x928f,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0xe5d1,0xe5ce,0x8bdc,UDCODE,0xe5cd,0xe5d4,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x8c55,UDCODE,UDCODE,0x91dc,
	UDCODE,0xe5da,UDCODE,UDCODE,UDCODE,UDCODE,0xe5d6,UDCODE,UDCODE,
	UDCODE,0x91b3,0xe5d5,UDCODE,0xe5d8,UDCODE,UDCODE,UDCODE,UDCODE,
	0xe5cf,UDCODE,UDCODE,UDCODE,0xe5d9,UDCODE,0xe5db,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0x94ed,UDCODE,UDCODE,0xe5d7,UDCODE,
	0xe5dc,0xe5de,UDCODE,UDCODE,0x8cd1,0xe5d2,UDCODE,0x88bf,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe5dd,UDCODE,0x8dd9,
	0x97f4,0xe5df,0xe5e0,0x9195,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0x97a0,UDCODE,UDCODE,UDCODE,UDCODE,
	0xe5e1,0x9754,UDCODE,UDCODE,0xe5e2,0xe5e3,UDCODE,UDCODE,0x95e2,
	0xe5e4,UDCODE,0x8dbe,UDCODE,0x97a1,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,0xe5e9,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0xe5ea,0x8fd6,0xe5e8,0xfba2,UDCODE,UDCODE,
	0x9787,0xe5e5,UDCODE,UDCODE,0xe5e7,0x90bb,0x909e,0xe5e6,UDCODE,
	0xe5eb,UDCODE,UDCODE,0x95a1,UDCODE,UDCODE,0xe5ed,UDCODE,0xe5ec,
	UDCODE,UDCODE,UDCODE,0x8a8c,UDCODE,0x964a,0xe5ee,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xfa5d,0xe5fa,0xe5f0,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe5f1,UDCODE,UDCODE,
	UDCODE,UDCODE,0xe5f2,0xe5f3,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe5f7,UDCODE,0xe5f8,UDCODE,
	UDCODE,0xe5f6,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe5f4,UDCODE,
	0xe5ef,0xe5f5,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	0xe5f9,0xe8b5,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,0x89a6,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	0xe5fc,0x8bdd,0xe5fb,UDCODE,UDCODE,UDCODE,0xe641,UDCODE,0xe640,
	UDCODE,UDCODE,UDCODE,0xe643,UDCODE,UDCODE,0xe642,UDCODE,0xe644,
	UDCODE,UDCODE,0x8f50,UDCODE,0xe645,UDCODE,UDCODE,0xe646,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe647,0x90bc,UDCODE,0x9776,
	UDCODE,0xe648,UDCODE,UDCODE,0x95a2,0x9465,0xe649,UDCODE,0xe64a,
	0x8ca9,UDCODE,UDCODE,UDCODE,0x8b4b,UDCODE,UDCODE,UDCODE,0xe64b,
	UDCODE,UDCODE,0x8e8b,0x9460,0xe64c,UDCODE,0x8a6f,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0xe64d,UDCODE,UDCODE,UDCODE,UDCODE,
	0xe64f,0x9797,UDCODE,0xe64e,0x9065,UDCODE,0xe650,UDCODE,UDCODE,
	0xe651,UDCODE,UDCODE,0xe652,0x8acf,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,0xe653,UDCODE,UDCODE,0xe654,UDCODE,0xe655,0xe656,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x8a70,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe657,UDCODE,
	0xe658,0xe659,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x89f0,UDCODE,
	UDCODE,0x9047,0xe65a,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe65b,UDCODE,UDCODE,
	UDCODE,0xe65c,0x8cbe,UDCODE,0x92f9,0xe65d,UDCODE,UDCODE,UDCODE,
	UDCODE,0x8c76,UDCODE,0x9075,UDCODE,0xe660,UDCODE,0x93a2,UDCODE,
	0xe65f,UDCODE,0xfba3,0x8c50,UDCODE,UDCODE,0xe65e,0x91f5,0x8b4c,
	UDCODE,UDCODE,0xe661,UDCODE,0xe662,UDCODE,0x8fd7,UDCODE,UDCODE,
	UDCODE,0x8c8d,UDCODE,0xe663,UDCODE,UDCODE,UDCODE,UDCODE,0x964b,
	UDCODE,UDCODE,0x90dd,UDCODE,UDCODE,UDCODE,0x8b96,UDCODE,0x96f3,
	0x9169,UDCODE,0xe664,0xfba4,UDCODE,UDCODE,0x9066,0x9290,0x8fd8,
	UDCODE,UDCODE,UDCODE,UDCODE,0xe665,UDCODE,UDCODE,UDCODE,UDCODE,
	0xe668,UDCODE,0xe669,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,0x8dbc,0x91c0,0xe667,UDCODE,0x8fd9,0x955d,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0xe666,UDCODE,UDCODE,0x8e8c,UDCODE,0x8972,
	UDCODE,0xe66d,0x8c77,UDCODE,UDCODE,0x8e8e,UDCODE,UDCODE,0x8e8d,
	UDCODE,0x986c,0xe66c,0xe66b,0x9146,UDCODE,0x8b6c,0x9862,0x8a59,
	0x8fda,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xfba5,UDCODE,UDCODE,
	0xe66a,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe66f,UDCODE,0xe670,
	0xe66e,UDCODE,0x8cd6,UDCODE,0x975f,UDCODE,UDCODE,0x8e8f,0x9446,
	UDCODE,UDCODE,UDCODE,0xe673,UDCODE,0x90be,UDCODE,0x9261,UDCODE,
	UDCODE,0x9755,UDCODE,0xe676,UDCODE,UDCODE,UDCODE,0x8cea,UDCODE,
	0x90bd,0xe672,UDCODE,0xe677,0x8ceb,0xe674,0xe675,0xfba6,0xe671,
	UDCODE,UDCODE,UDCODE,0x90e0,0x93c7,UDCODE,UDCODE,0x924e,UDCODE,
	0x89db,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x94ee,UDCODE,
	UDCODE,0x8b62,UDCODE,0xfba7,0x92b2,UDCODE,UDCODE,0xe67a,UDCODE,
	0xe678,UDCODE,UDCODE,0x926b,UDCODE,UDCODE,UDCODE,0x90bf,0x8ad0,
	0xe679,UDCODE,0x907a,UDCODE,UDCODE,0x97c8,UDCODE,UDCODE,UDCODE,
	0x985f,UDCODE,UDCODE,UDCODE,0xe67b,0xe687,0x92b3,UDCODE,0xe686,
	0xfba8,0xe683,0xe68b,0xe684,UDCODE,0xe680,UDCODE,0x92fa,0xe67e,
	UDCODE,UDCODE,UDCODE,0xe67c,UDCODE,0x9740,0x8e90,UDCODE,UDCODE,
	0xe681,UDCODE,0xe67d,UDCODE,UDCODE,0xfbaa,0xe685,0x8f94,UDCODE,
	0x8cbf,UDCODE,UDCODE,UDCODE,0x91f8,0x9664,0x8979,0x88e0,UDCODE,
	0x93a3,UDCODE,UDCODE,0xe689,UDCODE,UDCODE,UDCODE,UDCODE,0xe688,
	UDCODE,0x93e4,UDCODE,0xe68d,UDCODE,UDCODE,UDCODE,0xe682,UDCODE,
	0xe68c,0xe68e,UDCODE,0x8caa,0xe68a,0x8d75,UDCODE,0x8ed3,UDCODE,
	UDCODE,0xe68f,0x9777,UDCODE,UDCODE,UDCODE,UDCODE,0xe692,UDCODE,
	0xe695,UDCODE,UDCODE,0xe693,0x9554,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,0xe690,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x8bde,
	UDCODE,UDCODE,UDCODE,UDCODE,0xe694,UDCODE,UDCODE,0xe696,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe69a,UDCODE,UDCODE,
	0xe697,UDCODE,0xe699,0xe698,UDCODE,UDCODE,UDCODE,0xfbab,UDCODE,
	UDCODE,0xe69b,UDCODE,0x8eaf,UDCODE,0xe69d,0xe69c,0x9588,UDCODE,
	UDCODE,0xe69f,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x8c78,
	UDCODE,UDCODE,UDCODE,UDCODE,0xe69e,0xe6a0,UDCODE,UDCODE,0xe6a1,
	0x8b63,0xe3bf,0x8ff7,UDCODE,0xe6a2,UDCODE,UDCODE,0x8cec,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0xe6a3,UDCODE,0xfbac,0xe6a4,UDCODE,
	UDCODE,0x8e5d,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x9dcc,
	UDCODE,0xe6a5,UDCODE,0xe6a6,UDCODE,0x8f51,UDCODE,0xe6a7,0xe6a8,
	UDCODE,UDCODE,0xe6a9,UDCODE,UDCODE,0xe6aa,0xe6ab,0x924a,UDCODE,
	UDCODE,0xe6ac,UDCODE,UDCODE,UDCODE,UDCODE,0xe6ae,UDCODE,0xe6ad,
	UDCODE,UDCODE,UDCODE,UDCODE,0x93a4,UDCODE,0xe6af,UDCODE,0x964c,
	UDCODE,0xe6b0,UDCODE,0xe6b1,UDCODE,0xe6b2,UDCODE,UDCODE,UDCODE,
	UDCODE,0xe6b3,UDCODE,UDCODE,UDCODE,UDCODE,0x93d8,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0x8fdb,0xe6b4,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0x8d8b,0x98ac,0xe6b5,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	0xe6b6,0x955e,0xe6b7,UDCODE,0xe6bf,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,0xe6b8,UDCODE,UDCODE,0xe6ba,UDCODE,UDCODE,UDCODE,0xe6b9,
	0xe6bb,UDCODE,0x9665,0xe6bc,0xe6bd,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,0xe6be,UDCODE,UDCODE,UDCODE,0xe6c0,UDCODE,UDCODE,UDCODE,
	UDCODE,0x8a4c,0x92e5,UDCODE,0x9589,0x8de0,0x8d76,UDCODE,UDCODE,
	UDCODE,UDCODE,0x956e,0x89dd,0x94cc,0xe6c3,0x8ad1,0x90d3,0xe6c2,
	0xe6c7,0x9299,0x96e1,UDCODE,0xe6c5,0xe6c6,0x8b4d,UDCODE,0xe6c8,
	0x9483,0x91dd,UDCODE,UDCODE,0x94ef,0x935c,0xe6c4,UDCODE,0x9666,
	0x89ea,0xe6ca,0x9847,0x92c0,0x9864,UDCODE,UDCODE,0x8e91,0xe6c9,
	UDCODE,0x91af,UDCODE,UDCODE,0xe6da,0x9147,UDCODE,UDCODE,0x93f6,
	UDCODE,0x956f,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe6cd,
	0x8e5e,0x8e92,UDCODE,0x8fdc,UDCODE,0x9485,UDCODE,0x8cab,0xe6cc,
	0xe6cb,UDCODE,0x958a,UDCODE,UDCODE,UDCODE,0x8ebf,UDCODE,UDCODE,
	0x9371,UDCODE,UDCODE,0xfbad,UDCODE,UDCODE,UDCODE,0xfbae,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0xe6cf,0xe6d0,0x8d77,0xe6ce,0xe6d1,
	0xe6d2,UDCODE,0xe6d4,0x91a1,UDCODE,0xe6d3,0x8ae4,UDCODE,0xe6d6,
	UDCODE,0xe6d5,0xe6d7,UDCODE,0xfbaf,0xe6d9,0xe6db,UDCODE,0xe6dc,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x90d4,UDCODE,0x8ecd,0xe6dd,
	UDCODE,UDCODE,UDCODE,0x8a71,UDCODE,0xe6de,UDCODE,UDCODE,0x9196,
	0xe6df,UDCODE,0xe6e0,0x958b,UDCODE,0xfbb0,0x8b4e,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe6e1,UDCODE,
	UDCODE,UDCODE,0x92b4,UDCODE,UDCODE,UDCODE,UDCODE,0x897a,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0xe6e2,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x8eef,UDCODE,UDCODE,UDCODE,
	UDCODE,0x9096,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0x91ab,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,0xe6e5,UDCODE,UDCODE,UDCODE,0xe6e4,UDCODE,UDCODE,UDCODE,
	0xe6e3,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	0xe6eb,0xe6e9,UDCODE,UDCODE,0xe6e6,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,0xe6e8,UDCODE,UDCODE,UDCODE,0xe6e7,0xe6ea,UDCODE,
	0x8b97,UDCODE,0xe6ee,UDCODE,0x90d5,UDCODE,0xe6ef,UDCODE,UDCODE,
	UDCODE,UDCODE,0x8cd7,UDCODE,0xe6ec,0xe6ed,UDCODE,UDCODE,UDCODE,
	0x9848,UDCODE,UDCODE,UDCODE,0x92b5,UDCODE,0x9148,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0xe6f0,UDCODE,UDCODE,0xe6f3,0xe6f1,
	0xe6f2,0x9778,UDCODE,UDCODE,UDCODE,UDCODE,0x93a5,0xe6f6,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,0xe6f4,0xe6f5,0xe6f7,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe748,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0xe6fa,UDCODE,UDCODE,UDCODE,0xe6fb,0xe6f9,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0xe6f8,UDCODE,0x92fb,UDCODE,UDCODE,0xe740,
	0xe744,0xe741,0xe6fc,UDCODE,0xe742,UDCODE,UDCODE,UDCODE,0xe743,
	UDCODE,UDCODE,UDCODE,UDCODE,0xe74a,UDCODE,UDCODE,UDCODE,0xe745,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x90d6,0xe747,UDCODE,UDCODE,
	0xe749,0xe746,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe74c,UDCODE,0x8f52,
	UDCODE,0xe74b,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe74d,UDCODE,
	UDCODE,UDCODE,UDCODE,0xe74e,UDCODE,UDCODE,0xe751,0xe750,UDCODE,
	0xe74f,UDCODE,UDCODE,0xe753,0xe752,UDCODE,0x96f4,UDCODE,UDCODE,
	UDCODE,0xe755,UDCODE,0xe754,0xe756,UDCODE,UDCODE,UDCODE,UDCODE,
	0xe757,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe759,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe758,
	0x9067,0xe75a,UDCODE,UDCODE,0x8beb,0xe75b,0xe75d,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,0xe75e,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe75f,
	0xe75c,UDCODE,0xe760,UDCODE,0x8ed4,0xe761,0x8b4f,0x8c52,UDCODE,
	0xfbb2,UDCODE,UDCODE,0x8cac,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0xe762,UDCODE,UDCODE,UDCODE,0x93ee,UDCODE,
	UDCODE,0x935d,0xe763,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,0xe766,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x8eb2,UDCODE,UDCODE,0xe765,
	0xe764,0x8c79,0xe767,0x8a72,UDCODE,0xe769,UDCODE,UDCODE,UDCODE,
	0x8dda,0xe768,UDCODE,0xe771,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	0xe76b,0xe76d,0x95e3,0xe76a,UDCODE,UDCODE,UDCODE,0xe76c,UDCODE,
	0xe770,0xe76e,0x8b50,UDCODE,0xe76f,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,0xe772,UDCODE,UDCODE,0x9479,0x97d6,UDCODE,UDCODE,
	UDCODE,UDCODE,0x8f53,UDCODE,UDCODE,UDCODE,0xe773,UDCODE,UDCODE,
	UDCODE,UDCODE,0x9741,0xe775,UDCODE,0xe774,UDCODE,UDCODE,0xe778,
	0x9760,UDCODE,UDCODE,0xe777,UDCODE,0x8a8d,0xe776,0xe77b,UDCODE,
	UDCODE,0xe77a,UDCODE,UDCODE,0xe779,0x9351,0xe77c,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe77d,UDCODE,UDCODE,
	UDCODE,UDCODE,0xe77e,UDCODE,UDCODE,0x8d8c,UDCODE,0x8c44,0xe780,
	0xe781,0xe782,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,0x9068,0xe783,UDCODE,0x8eab,0xe784,UDCODE,UDCODE,
	UDCODE,0xe785,UDCODE,UDCODE,UDCODE,0x999f,0x999e,UDCODE,UDCODE,
	UDCODE,UDCODE,0xe786,0xe390,0xe787,0x9243,0x904a,0x945f,UDCODE,
	UDCODE,UDCODE,UDCODE,0xe788,UDCODE,UDCODE,0x95d3,0x92d2,0x8d9e,
	UDCODE,UDCODE,0x9248,UDCODE,UDCODE,0x8949,UDCODE,0x9698,0x9076,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x8c7d,
	UDCODE,UDCODE,0x8bdf,UDCODE,UDCODE,0x95d4,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,0xe789,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,0xe78b,UDCODE,UDCODE,0xe78a,0x89de,UDCODE,UDCODE,0x93f4,
	0xe78c,0x9497,UDCODE,0x9352,UDCODE,0xe78d,0x8f71,UDCODE,UDCODE,
	UDCODE,0xe78f,UDCODE,UDCODE,0x96c0,0xe79e,0xe791,0xe792,UDCODE,
	UDCODE,0x92c7,0x91de,0x9197,UDCODE,0x93a6,UDCODE,0xe790,0x8b74,
	UDCODE,UDCODE,UDCODE,UDCODE,0xe799,UDCODE,0xe796,0xe7a3,0x93a7,
	0x9280,0xe793,UDCODE,0x92fc,0x9372,0xe794,0xe798,0x9080,UDCODE,
	0x9487,0x92ca,UDCODE,UDCODE,0x90c0,0xe797,0x91ac,0x91a2,0xe795,
	0x88a7,0x9841,UDCODE,UDCODE,UDCODE,0xe79a,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0x91df,UDCODE,UDCODE,0x8f54,0x9069,UDCODE,
	UDCODE,0xe79c,0xe79b,UDCODE,0x88ed,0xe79d,UDCODE,UDCODE,0x954e,
	UDCODE,0xe7a5,UDCODE,UDCODE,0x93d9,0x908b,UDCODE,UDCODE,0x9278,
	UDCODE,0x8bf6,UDCODE,0xe7a4,0x9756,0x895e,UDCODE,0x95d5,0x89df,
	0xe79f,0xe7a0,0xe7a1,0xe7a2,0x93b9,0x9242,0x88e1,0xe7a6,UDCODE,
	0xe7a7,0xeaa1,UDCODE,UDCODE,0x91bb,UDCODE,0xe7a8,UDCODE,0x8993,
	0x916b,UDCODE,0x8cad,UDCODE,0x9779,UDCODE,0xfbb5,0xe7a9,0x934b,
	UDCODE,UDCODE,UDCODE,0x9198,0x8ed5,0xe7aa,UDCODE,UDCODE,0xe7ad,
	UDCODE,UDCODE,0x8f85,0xe7ab,0x914a,0x9149,UDCODE,0x88e2,UDCODE,
	0x97c9,0xe7af,UDCODE,0x94f0,0xe7b1,0xe7b0,0xe7ae,0xe284,0x8ad2,
	UDCODE,UDCODE,0xe78e,UDCODE,0xe7b3,0xe7b2,UDCODE,UDCODE,UDCODE,
	UDCODE,0xe7b4,UDCODE,0x9757,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0x93df,UDCODE,UDCODE,0x964d,UDCODE,0xe7b5,
	UDCODE,0x8ed7,UDCODE,UDCODE,UDCODE,UDCODE,0xe7b6,UDCODE,0xe7b7,
	UDCODE,UDCODE,UDCODE,0xe7b8,UDCODE,UDCODE,0x9340,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x88e8,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x8d78,UDCODE,UDCODE,
	UDCODE,0x9859,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe7bc,UDCODE,UDCODE,0xfbb6,
	UDCODE,UDCODE,0x8c53,0xe7b9,UDCODE,0xe7ba,UDCODE,UDCODE,UDCODE,
	0x9594,UDCODE,UDCODE,UDCODE,UDCODE,0x8a73,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0x9758,UDCODE,0x8bbd,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0x9373,0xe7bd,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,0xe7be,UDCODE,UDCODE,0xfbb8,UDCODE,UDCODE,UDCODE,
	0xe7bf,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xfbb9,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,0x9341,UDCODE,UDCODE,0xe7c1,UDCODE,0xe7c0,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0x93d1,0xe7c2,0x8f55,0x8ede,0x947a,0x9291,
	UDCODE,UDCODE,UDCODE,0x8ef0,UDCODE,0x908c,UDCODE,0xe7c3,UDCODE,
	0xe7c4,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,0x907c,0xe7c5,UDCODE,0xe7c6,UDCODE,UDCODE,UDCODE,0xe7c7,
	0x978f,UDCODE,0x8f56,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe7c9,
	0xe7c8,UDCODE,0x8d79,UDCODE,0x8d93,0x8e5f,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe7cc,UDCODE,UDCODE,
	UDCODE,UDCODE,0x8f86,UDCODE,0xe7cb,UDCODE,0xe7ca,UDCODE,0x91e7,
	UDCODE,UDCODE,0x8ced,UDCODE,0x90c1,UDCODE,UDCODE,UDCODE,UDCODE,
	0x94ae,UDCODE,UDCODE,UDCODE,UDCODE,0x8f58,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,0xe7cd,UDCODE,0x8fdd,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,0xe7d0,0xe7ce,UDCODE,UDCODE,UDCODE,0xe7cf,UDCODE,UDCODE,
	UDCODE,UDCODE,0xe7d2,0xe7d1,UDCODE,UDCODE,0x8ff8,UDCODE,0xe7d3,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe7d4,0xe7d5,UDCODE,UDCODE,
	UDCODE,UDCODE,0x94ce,0x8dd1,0x8edf,0xe7d6,UDCODE,0xe7d7,0x97a2,
	0x8f64,0x96ec,0x97ca,0xe7d8,0x8be0,UDCODE,UDCODE,UDCODE,UDCODE,
	0xe7d9,0xfbbb,0x9342,UDCODE,0xfbba,0xe7dc,0x8a98,0x906a,0xfbbc,
	0xe7da,UDCODE,0xe7db,UDCODE,0x92de,0xfbbf,0xfbc0,0x9674,0x8bfa,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xfbbd,0xfbbe,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0xe7de,0xe7df,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,0xe7dd,UDCODE,UDCODE,0xe7e1,0xfbc1,UDCODE,UDCODE,
	UDCODE,0xfbc3,UDCODE,UDCODE,0x93dd,0x8a62,UDCODE,0xfbc2,0xe7e5,
	UDCODE,UDCODE,0xe7e2,0xe7e4,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0xe7e0,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe86e,UDCODE,UDCODE,0xe7e3,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x97e9,UDCODE,
	UDCODE,0x8cd8,UDCODE,0xfbca,0xfbc4,UDCODE,0xfbc6,UDCODE,UDCODE,
	0xe7ed,0xfbc5,UDCODE,UDCODE,UDCODE,0x9353,0xe7e8,UDCODE,UDCODE,
	0xe7eb,0xe7e9,UDCODE,0xe7ee,UDCODE,UDCODE,0xfbc7,UDCODE,0xe7ef,
	0xfbc9,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe7e7,UDCODE,0xfbc8,
	0xe7f4,0x8994,UDCODE,UDCODE,0xe7e6,UDCODE,UDCODE,UDCODE,0x94ab,
	UDCODE,0xe7ea,UDCODE,0x8fde,0xfbcb,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x8d7a,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,0xfbcd,0xfbce,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	0x9667,UDCODE,0x8be2,UDCODE,UDCODE,0x8f65,UDCODE,0x93ba,UDCODE,
	UDCODE,0xfa5f,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,0x914c,UDCODE,0xe7f2,UDCODE,0xe7ec,0xe7f1,UDCODE,0x96c1,
	UDCODE,0x92b6,0xe7f3,0xe7f0,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xfbcc,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,0x914b,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0xe7f7,UDCODE,0xe7f6,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	0xe7f5,0xfbd2,UDCODE,0x964e,0xfbd6,UDCODE,0xfbd4,UDCODE,0xfbd0,
	UDCODE,0xfbd1,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xfbd5,
	UDCODE,UDCODE,UDCODE,0x8f9b,UDCODE,UDCODE,0xfbcf,UDCODE,0xe7f8,
	0x95dd,UDCODE,UDCODE,0x8973,UDCODE,UDCODE,UDCODE,UDCODE,0x9565,
	0x9292,UDCODE,UDCODE,UDCODE,UDCODE,0x8b98,0xfa65,0xe7fa,0xfbd9,
	0x8d7c,UDCODE,UDCODE,0xfbdc,0xfbde,UDCODE,UDCODE,UDCODE,0x8e4b,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe7f9,
	0x908d,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x908e,
	0xe840,0xe842,UDCODE,UDCODE,0xfbdd,0xfbdb,UDCODE,0x8ff9,0xfbd8,
	0xe841,0xe843,UDCODE,0xfbd7,0x8bd1,UDCODE,0x9564,UDCODE,UDCODE,
	0x8ee0,0x9842,UDCODE,0xe7fc,0x8df6,UDCODE,UDCODE,0x985e,UDCODE,
	UDCODE,0xe845,UDCODE,UDCODE,UDCODE,UDCODE,0xe844,0xe846,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe7fb,UDCODE,
	UDCODE,UDCODE,0xfa5e,UDCODE,UDCODE,0x93e7,UDCODE,0x9374,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x92d5,UDCODE,0xe84b,0xfbe0,
	UDCODE,UDCODE,UDCODE,0x9262,0xe847,UDCODE,UDCODE,UDCODE,0xe848,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,0x8c4c,UDCODE,0xe84a,UDCODE,0xfbdf,UDCODE,UDCODE,
	UDCODE,UDCODE,0x8cae,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	0xe849,UDCODE,0x8fdf,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x8a99,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe84f,UDCODE,0x8dbd,
	0x9199,UDCODE,UDCODE,0x92c8,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0xfbe1,UDCODE,UDCODE,0x8a5a,UDCODE,
	UDCODE,UDCODE,UDCODE,0xe84d,0xe84e,0x92c1,UDCODE,0xe84c,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe850,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe856,
	UDCODE,UDCODE,0xfbe2,UDCODE,0xe859,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0xe858,0x934c,UDCODE,UDCODE,UDCODE,UDCODE,
	0xe851,0xe852,0xe855,UDCODE,UDCODE,UDCODE,UDCODE,0xe857,0xfbe3,
	UDCODE,UDCODE,0x8bbe,UDCODE,UDCODE,0xe85a,0xe854,UDCODE,UDCODE,
	0xe853,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xfbe4,0xe85e,
	UDCODE,UDCODE,UDCODE,0xe85f,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0xe860,UDCODE,UDCODE,0xe85d,0xe85c,UDCODE,
	UDCODE,UDCODE,0x8fe0,0x93a8,0xe85b,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,0xe864,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0xe862,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	0xfbe5,UDCODE,UDCODE,UDCODE,0xe863,0xe861,UDCODE,0x91f6,UDCODE,
	0xe865,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe866,UDCODE,
	UDCODE,0xe868,0xfbe6,UDCODE,UDCODE,0xfbe7,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x8ad3,0xe867,0x96f8,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe873,0xe869,UDCODE,UDCODE,
	0xe86c,UDCODE,0xe86a,UDCODE,0xe86b,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0xe86d,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	0xe86f,UDCODE,UDCODE,UDCODE,UDCODE,0xe870,UDCODE,0xe871,UDCODE,
	UDCODE,UDCODE,UDCODE,0xe874,0xe872,0xe875,0xe877,UDCODE,0xe876,
	0x92b7,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	0x96e5,UDCODE,0xe878,0x914d,UDCODE,UDCODE,UDCODE,0xe879,UDCODE,
	0x95c2,0xe87a,0x8a4a,UDCODE,UDCODE,UDCODE,0x895b,UDCODE,0x8ad5,
	0xfbe8,0x8ad4,0xe87b,UDCODE,0xe87c,UDCODE,0xe87d,0xe87e,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe880,UDCODE,0x8ad6,0x8a74,
	0x8d7d,0x94b4,UDCODE,0xe882,0xe881,UDCODE,UDCODE,UDCODE,UDCODE,
	0xe883,UDCODE,UDCODE,UDCODE,UDCODE,0x897b,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0xe886,UDCODE,0xe885,0xe884,UDCODE,0xe887,
	UDCODE,UDCODE,UDCODE,UDCODE,0xe88a,UDCODE,UDCODE,UDCODE,0x88c5,
	UDCODE,UDCODE,0xe888,UDCODE,0xe88c,0xe88b,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0xe88e,0xe88d,0xe88f,UDCODE,0x93ac,UDCODE,
	UDCODE,UDCODE,0xe890,UDCODE,UDCODE,UDCODE,UDCODE,0xe891,0xe893,
	UDCODE,UDCODE,0xe892,0x958c,UDCODE,UDCODE,UDCODE,UDCODE,0xe894,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe895,UDCODE,0x8de3,
	UDCODE,UDCODE,UDCODE,0xe896,0xe897,UDCODE,UDCODE,0x9668,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x916a,UDCODE,
	UDCODE,UDCODE,0x88a2,0x91c9,UDCODE,0xe898,UDCODE,0x958d,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe89b,0xe899,0x8d7e,UDCODE,
	0xe89a,0x8cc0,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0x95c3,0xe89d,0xe89f,0xe89e,0xe8a0,UDCODE,
	UDCODE,0x8940,0x9077,0x8f9c,0x8ad7,0xe8a1,UDCODE,UDCODE,UDCODE,
	0x9486,UDCODE,0xe8a3,UDCODE,UDCODE,UDCODE,0x8941,UDCODE,0xe8a2,
	0x92c2,UDCODE,0x97cb,0x93a9,0xe89c,0x97a4,UDCODE,0x8caf,UDCODE,
	UDCODE,0x977a,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	0x8bf7,0x97b2,UDCODE,0x8c47,UDCODE,0x91e0,0xe440,UDCODE,0xe8a4,
	0x8a4b,0x908f,UDCODE,UDCODE,UDCODE,UDCODE,0x8a75,0xe8a6,UDCODE,
	0xe8a7,0xe8a5,0x8c84,UDCODE,0x8ddb,0x8fe1,0xfbeb,UDCODE,UDCODE,
	0x8942,UDCODE,UDCODE,0x97d7,UDCODE,UDCODE,UDCODE,0xe8a9,0xe7ac,
	UDCODE,0xe8a8,UDCODE,UDCODE,UDCODE,UDCODE,0xfbec,0xe8ac,0xe8aa,
	0xe8ab,UDCODE,0xe8ad,UDCODE,0xe8ae,0x97ea,0xe8af,0xe8b0,UDCODE,
	0x90c7,0x94b9,UDCODE,UDCODE,UDCODE,0x909d,0x8ae5,UDCODE,UDCODE,
	0x9759,0x89eb,0x8f57,0x8cd9,UDCODE,0xe8b3,UDCODE,0xe8b2,0x8e93,
	0xe8b4,0xe8b1,UDCODE,UDCODE,0x8e47,UDCODE,UDCODE,UDCODE,0xe8b8,
	0xe5ab,UDCODE,UDCODE,0x99d4,UDCODE,0x9097,0xe8b6,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0x97a3,0x93ef,UDCODE,UDCODE,UDCODE,UDCODE,
	0x894a,UDCODE,0x90e1,0x8eb4,UDCODE,UDCODE,UDCODE,UDCODE,0x95b5,
	UDCODE,0x895f,UDCODE,UDCODE,UDCODE,0x97eb,0x978b,UDCODE,0xe8b9,
	UDCODE,0x9364,0x8ef9,UDCODE,UDCODE,UDCODE,0xe8ba,UDCODE,0xe8bb,
	0x906b,0xe8bc,UDCODE,0x97ec,UDCODE,UDCODE,0xe8b7,0xe8be,0xe8c0,
	UDCODE,0xe8bf,UDCODE,0xe8bd,UDCODE,UDCODE,0xe8c1,UDCODE,UDCODE,
	0xe8c2,UDCODE,UDCODE,0x919a,UDCODE,0x89e0,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,0xe8c3,UDCODE,UDCODE,0x96b6,UDCODE,UDCODE,0xe8c4,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe8c5,UDCODE,0x9849,0xfbed,
	UDCODE,UDCODE,UDCODE,UDCODE,0x9e50,0xe8c6,UDCODE,0xfbee,UDCODE,
	0xe8c7,0xe8c8,UDCODE,UDCODE,UDCODE,0xe8cc,0xfbef,0xe8c9,UDCODE,
	0xe8ca,UDCODE,0xe8cb,0xe8cd,UDCODE,UDCODE,UDCODE,0xfbf0,UDCODE,
	0xfbf1,UDCODE,0xfbf2,0x90c2,UDCODE,UDCODE,0xfbf3,0x96f5,UDCODE,
	UDCODE,0x90c3,UDCODE,UDCODE,0xe8ce,UDCODE,0x94f1,UDCODE,0xe8cf,
	0xea72,0x96ca,UDCODE,0xe8d0,UDCODE,0xe8d1,UDCODE,0xe8d2,0x8a76,
	UDCODE,0xe8d4,UDCODE,0x9078,UDCODE,UDCODE,UDCODE,0xe8d5,UDCODE,
	UDCODE,0x8c43,UDCODE,UDCODE,UDCODE,UDCODE,0xe8d6,0xe8da,UDCODE,
	0xe8d8,UDCODE,UDCODE,UDCODE,UDCODE,0xe8d9,UDCODE,UDCODE,0x8a93,
	0xe8d7,0xe8db,UDCODE,UDCODE,UDCODE,UDCODE,0xe8dc,UDCODE,0x88c6,
	UDCODE,0xe8dd,0xe8de,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,0x8fe2,UDCODE,UDCODE,UDCODE,0xe8df,UDCODE,UDCODE,UDCODE,
	0x8b66,UDCODE,UDCODE,0xe8e2,UDCODE,UDCODE,0xe8e1,UDCODE,0xe8e0,
	UDCODE,UDCODE,0xe691,UDCODE,0x95da,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,0xe8e3,0xe8e4,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe8e5,
	UDCODE,UDCODE,0xe8e6,UDCODE,0xe8e7,UDCODE,UDCODE,0xe8e8,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x8ad8,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe8e9,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe8ea,0x9442,UDCODE,UDCODE,
	UDCODE,0xe8ec,0x89b9,UDCODE,0xe8ef,0xe8ee,UDCODE,UDCODE,UDCODE,
	UDCODE,0x8943,UDCODE,UDCODE,UDCODE,0x8bbf,0x95c5,0x92b8,0x8da0,
	UDCODE,0x8d80,0x8f87,UDCODE,0x907b,UDCODE,UDCODE,UDCODE,0xe8f1,
	UDCODE,UDCODE,0xe8f0,0x9761,0x8ae6,0x94d0,0x93da,UDCODE,UDCODE,
	UDCODE,0x909c,0x97cc,UDCODE,0x8c7a,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,0xe8f4,UDCODE,UDCODE,0xe8f3,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0x966a,0x93aa,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0x896f,UDCODE,UDCODE,0xe8f5,0xe8f2,UDCODE,
	UDCODE,0x9570,0x978a,0xe8f6,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0xe8f7,UDCODE,UDCODE,UDCODE,UDCODE,0xe8f9,
	0x91e8,0x8a7a,0x8a7b,0xe8f8,UDCODE,UDCODE,UDCODE,UDCODE,0x8ae7,
	0x8cb0,UDCODE,0xfbf4,0x8ae8,UDCODE,UDCODE,0x935e,UDCODE,UDCODE,
	0x97de,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xfbf5,UDCODE,
	0x8cda,UDCODE,UDCODE,UDCODE,0xe8fa,UDCODE,UDCODE,UDCODE,0xe8fb,
	0xe8fc,0xe940,UDCODE,0xe942,0xe941,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,0x9597,UDCODE,0xe943,UDCODE,UDCODE,UDCODE,UDCODE,
	0xe944,UDCODE,0xe945,UDCODE,UDCODE,UDCODE,UDCODE,0xe946,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,0xe948,0xe947,UDCODE,0xe949,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x94f2,
	0xe3ca,UDCODE,UDCODE,0x9048,UDCODE,UDCODE,0x8b51,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0xe94a,UDCODE,0xe94b,UDCODE,0x99aa,
	0x9f5a,0x94d1,UDCODE,UDCODE,0x88f9,UDCODE,0x88b9,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x8e94,0x964f,0x8ffc,0xe94c,
	UDCODE,0x96dd,UDCODE,UDCODE,UDCODE,0xe94d,0x977b,UDCODE,0x8961,
	UDCODE,UDCODE,UDCODE,0x8e60,UDCODE,0xe94e,0x89ec,0xe94f,UDCODE,
	UDCODE,UDCODE,0xe950,UDCODE,UDCODE,UDCODE,UDCODE,0xe952,0xe953,
	UDCODE,0xe955,0xe951,UDCODE,UDCODE,0xe954,UDCODE,UDCODE,0xfbf8,
	0x8ad9,UDCODE,UDCODE,UDCODE,0xe956,UDCODE,0xe957,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0xe958,0xe959,UDCODE,UDCODE,UDCODE,0xe95a,
	UDCODE,UDCODE,0xe95c,UDCODE,UDCODE,UDCODE,0xe95b,UDCODE,0xe95e,
	0xe961,UDCODE,UDCODE,UDCODE,0xe95d,0xe95f,0xe960,UDCODE,UDCODE,
	0xe962,UDCODE,0x8bc0,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,0x8ef1,0xe963,0xe964,0x8d81,UDCODE,UDCODE,UDCODE,
	UDCODE,0xfbfa,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe965,
	UDCODE,UDCODE,0x8a5d,UDCODE,UDCODE,UDCODE,0x946e,0xe966,0xe967,
	UDCODE,UDCODE,UDCODE,UDCODE,0x9279,0x93e9,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0xe968,UDCODE,UDCODE,UDCODE,UDCODE,
	0x949d,UDCODE,UDCODE,0x91ca,0x8977,0x8bec,UDCODE,0x8bed,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x9293,0xe96d,0x8bee,
	UDCODE,UDCODE,0x89ed,UDCODE,UDCODE,0xe96c,UDCODE,UDCODE,0xe96a,
	UDCODE,0xe96b,UDCODE,0xe969,UDCODE,UDCODE,0xe977,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe96e,
	0xe96f,UDCODE,UDCODE,0xe970,0xe971,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,0xe973,UDCODE,UDCODE,0xe972,UDCODE,UDCODE,UDCODE,0x8f78,
	0xe974,UDCODE,UDCODE,UDCODE,0xe976,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0x8b52,0xe975,UDCODE,UDCODE,0x919b,
	0x8cb1,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe978,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0x91cb,UDCODE,UDCODE,0xe979,UDCODE,UDCODE,
	UDCODE,UDCODE,0x93ab,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	0xe97a,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe980,UDCODE,
	0xe97d,UDCODE,0xe97c,0xe97e,UDCODE,0xe97b,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0xe982,0xfbfb,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0xe981,UDCODE,0xe984,UDCODE,UDCODE,0x8bc1,
	0xe983,UDCODE,UDCODE,UDCODE,0xe985,UDCODE,UDCODE,0xe986,UDCODE,
	0xe988,0xe987,UDCODE,UDCODE,UDCODE,0xe989,0xe98b,0xe98a,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x8d9c,UDCODE,UDCODE,UDCODE,
	UDCODE,0xe98c,UDCODE,UDCODE,0xe98d,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0x8a5b,UDCODE,UDCODE,UDCODE,0xe98e,UDCODE,
	UDCODE,UDCODE,0xe98f,UDCODE,UDCODE,UDCODE,0x9091,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe990,
	UDCODE,0xe991,UDCODE,0xe992,0xe993,UDCODE,UDCODE,UDCODE,0x8d82,
	0xfbfc,UDCODE,UDCODE,0xfc40,UDCODE,0xe994,0xe995,UDCODE,UDCODE,
	0xe996,0xe997,UDCODE,UDCODE,0xe998,UDCODE,UDCODE,UDCODE,0x94af,
	0xe99a,UDCODE,0x9545,0xe99b,0xe999,UDCODE,0xe99d,UDCODE,UDCODE,
	0xe99c,UDCODE,UDCODE,0xe99e,UDCODE,UDCODE,UDCODE,0xe99f,0xe9a0,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe9a1,
	UDCODE,0xe9a2,UDCODE,UDCODE,UDCODE,UDCODE,0xe9a3,UDCODE,UDCODE,
	0xe9a4,0xe9a5,UDCODE,0xe9a6,UDCODE,0xe9a7,0xe9a8,0xe9a9,0xe9aa,
	UDCODE,UDCODE,UDCODE,0xe9ab,0xe9ac,UDCODE,0x9f54,0xe9ad,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe2f6,0x8b53,
	UDCODE,UDCODE,UDCODE,UDCODE,0x8a40,0x8db0,0xe9af,0xe9ae,0x96a3,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe9b1,0xe9b2,
	0xe9b0,UDCODE,0xe9b3,UDCODE,UDCODE,0x9682,UDCODE,UDCODE,UDCODE,
	0xe9b4,UDCODE,0x8b9b,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x9844,UDCODE,UDCODE,0xfc42,
	UDCODE,0xe9b5,0xfc41,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe9b7,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	0x88bc,0xfc43,UDCODE,0xe9b8,0x95a9,0xe9b6,UDCODE,UDCODE,0xe9b9,
	0xe9ba,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe9bb,
	0xe9bc,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe9bd,
	UDCODE,0x968e,0x8e4c,UDCODE,0x8df8,0x914e,UDCODE,UDCODE,0xfc44,
	UDCODE,UDCODE,0xe9be,UDCODE,UDCODE,UDCODE,UDCODE,0xe9c1,UDCODE,
	0xfc45,UDCODE,UDCODE,UDCODE,UDCODE,0xe9bf,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,0xe9c2,UDCODE,UDCODE,0x8cef,0xe9c0,UDCODE,UDCODE,
	UDCODE,UDCODE,0xe9c3,UDCODE,0xe9c4,0xe9c5,UDCODE,0xe9c9,UDCODE,
	0x8e49,UDCODE,UDCODE,UDCODE,UDCODE,0x91e2,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,0xe9ca,0xe9c7,0xe9c6,0xe9c8,UDCODE,UDCODE,UDCODE,
	0x8c7e,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe9ce,
	0xe9cd,0xe9cc,UDCODE,UDCODE,0x88b1,0xfc46,UDCODE,UDCODE,UDCODE,
	0xe9d8,UDCODE,0xe9d4,UDCODE,0xe9d5,0xe9d1,0xe9d7,UDCODE,0xe9d3,
	0x8a82,UDCODE,UDCODE,0x986b,UDCODE,0xe9d6,0xe9d2,0xe9d0,0xe9cf,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe9da,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,0xe9dd,UDCODE,UDCODE,0xe9dc,0xe9db,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x9568,0xe9d9,0x88f1,0xe9de,
	UDCODE,0xe9e0,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x8a8f,
	0xe9cb,0x8956,UDCODE,UDCODE,0xe9e2,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,0xe9e1,0xe9df,0x924c,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x9690,UDCODE,UDCODE,
	UDCODE,UDCODE,0x97d8,UDCODE,UDCODE,0xe9e3,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,0xe9e4,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	0xe9e5,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xe9e6,UDCODE,0xe9e7,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	0x92b9,UDCODE,0xe9e8,UDCODE,0x94b5,UDCODE,0xe9ed,0xe9e9,UDCODE,
	UDCODE,UDCODE,0xe9ea,UDCODE,UDCODE,0x9650,0x96c2,UDCODE,0x93ce,
	0xe9ee,UDCODE,UDCODE,0xe9ef,0x93bc,0xe9ec,0xe9eb,UDCODE,UDCODE,
	UDCODE,UDCODE,0x89a8,UDCODE,UDCODE,UDCODE,0xe9f7,UDCODE,UDCODE,
	0xe9f6,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x8995,UDCODE,UDCODE,
	UDCODE,0xe9f4,UDCODE,UDCODE,UDCODE,0xe9f3,UDCODE,UDCODE,0xe9f1,
	UDCODE,0x8a9b,UDCODE,0xe9f0,0x8eb0,0x89a7,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,0x8d83,UDCODE,UDCODE,0xe9fa,0xe9f9,UDCODE,0xe9f8,
	UDCODE,UDCODE,0xe9f5,UDCODE,0xe9fb,UDCODE,0xe9fc,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xea44,0xea43,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xea45,UDCODE,UDCODE,0x894c,
	0xea40,0xea41,UDCODE,0x8d94,0x96b7,UDCODE,UDCODE,0xea42,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xfc48,0x9651,UDCODE,UDCODE,
	0xea4a,0xfc47,UDCODE,0xea46,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,0xea4b,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xea48,UDCODE,0xea47,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0x8c7b,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xea4c,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xea4d,
	UDCODE,UDCODE,UDCODE,UDCODE,0xea4e,UDCODE,0xea49,UDCODE,UDCODE,
	UDCODE,0xe9f2,UDCODE,UDCODE,0xea4f,UDCODE,0x92df,UDCODE,UDCODE,
	UDCODE,0xea53,UDCODE,0xea54,0xea52,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,0xea51,0xea57,UDCODE,0xea50,UDCODE,0xea55,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xea56,UDCODE,UDCODE,
	UDCODE,0xea59,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xea58,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,0xea5b,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	0xea5c,UDCODE,0xea5d,UDCODE,UDCODE,0x9868,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,0xea5a,0x91e9,0x8deb,UDCODE,UDCODE,0xea5e,0xfc4a,
	0xea5f,0xea60,UDCODE,UDCODE,0xea61,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,0xea62,UDCODE,UDCODE,0x8cb2,0xea63,UDCODE,UDCODE,UDCODE,
	0xea64,UDCODE,0x8ead,UDCODE,0xea65,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,0xea66,UDCODE,UDCODE,0xea67,0xea68,UDCODE,UDCODE,
	UDCODE,UDCODE,0xea6b,0xea69,0x985b,UDCODE,0xea6a,UDCODE,0x97ed,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xea6c,UDCODE,0x97d9,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0xea6d,0x949e,UDCODE,UDCODE,0xea6e,
	0xea70,UDCODE,UDCODE,0xea71,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xea6f,0x8d8d,0x96cb,0x9683,
	0x9bf5,UDCODE,0x9f80,0x969b,UDCODE,UDCODE,UDCODE,UDCODE,0x89a9,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xea73,0x8b6f,
	0xea74,0xea75,0xea76,0xfc4b,0x8d95,UDCODE,0xea77,UDCODE,UDCODE,
	UDCODE,0xe0d2,0x96d9,UDCODE,0x91e1,0xea78,0xea7a,0xea79,UDCODE,
	0xea7b,UDCODE,UDCODE,UDCODE,UDCODE,0xea7c,UDCODE,UDCODE,0xea7d,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xea7e,UDCODE,UDCODE,
	UDCODE,UDCODE,0xea80,UDCODE,0xea81,0xea82,UDCODE,0xea83,UDCODE,
	0xea84,0xea85,0xea86,0xea87,0xea88,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,0x9343,UDCODE,UDCODE,UDCODE,UDCODE,0x8cdb,UDCODE,0xea8a,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,0x916c,0xea8b,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,0xea8c,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,0x9540,UDCODE,UDCODE,0xea8d,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xea8e,0xe256,
	UDCODE,UDCODE,0xe6d8,0xe8eb,UDCODE,UDCODE,0xea8f,UDCODE,0xea90,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,0xea92,0xea93,0xea94,0x97ee,0xea91,UDCODE,UDCODE,0xea95,
	0xea96,UDCODE,UDCODE,0xea98,UDCODE,0xea97,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,0xea9a,UDCODE,UDCODE,UDCODE,0xea9b,0xea99,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,0x97b4,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,0xea9c,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xea9d,
	0xe273,UDCODE,UDCODE,0xea9e,0xf040,0xf041,0xf042,0xf043,0xf044,
	0xf045,0xf046,0xf047,0xf048,0xf049,0xf04a,0xf04b,0xf04c,0xf04d,
	0xf04e,0xf04f,0xf050,0xf051,0xf052,0xf053,0xf054,0xf055,0xf056,
	0xf057,0xf058,0xf059,0xf05a,0xf05b,0xf05c,0xf05d,0xf05e,0xf05f,
	0xf060,0xf061,0xf062,0xf063,0xf064,0xf065,0xf066,0xf067,0xf068,
	0xf069,0xf06a,0xf06b,0xf06c,0xf06d,0xf06e,0xf06f,0xf070,0xf071,
	0xf072,0xf073,0xf074,0xf075,0xf076,0xf077,0xf078,0xf079,0xf07a,
	0xf07b,0xf07c,0xf07d,0xf07e,0xf080,0xf081,0xf082,0xf083,0xf084,
	0xf085,0xf086,0xf087,0xf088,0xf089,0xf08a,0xf08b,0xf08c,0xf08d,
	0xf08e,0xf08f,0xf090,0xf091,0xf092,0xf093,0xf094,0xf095,0xf096,
	0xf097,0xf098,0xf099,0xf09a,0xf09b,0xf09c,0xf09d,0xf09e,0xf09f,
	0xf0a0,0xf0a1,0xf0a2,0xf0a3,0xf0a4,0xf0a5,0xf0a6,0xf0a7,0xf0a8,
	0xf0a9,0xf0aa,0xf0ab,0xf0ac,0xf0ad,0xf0ae,0xf0af,0xf0b0,0xf0b1,
	0xf0b2,0xf0b3,0xf0b4,0xf0b5,0xf0b6,0xf0b7,0xf0b8,0xf0b9,0xf0ba,
	0xf0bb,0xf0bc,0xf0bd,0xf0be,0xf0bf,0xf0c0,0xf0c1,0xf0c2,0xf0c3,
	0xf0c4,0xf0c5,0xf0c6,0xf0c7,0xf0c8,0xf0c9,0xf0ca,0xf0cb,0xf0cc,
	0xf0cd,0xf0ce,0xf0cf,0xf0d0,0xf0d1,0xf0d2,0xf0d3,0xf0d4,0xf0d5,
	0xf0d6,0xf0d7,0xf0d8,0xf0d9,0xf0da,0xf0db,0xf0dc,0xf0dd,0xf0de,
	0xf0df,0xf0e0,0xf0e1,0xf0e2,0xf0e3,0xf0e4,0xf0e5,0xf0e6,0xf0e7,
	0xf0e8,0xf0e9,0xf0ea,0xf0eb,0xf0ec,0xf0ed,0xf0ee,0xf0ef,0xf0f0,
	0xf0f1,0xf0f2,0xf0f3,0xf0f4,0xf0f5,0xf0f6,0xf0f7,0xf0f8,0xf0f9,
	0xf0fa,0xf0fb,0xf0fc,0xf140,0xf141,0xf142,0xf143,0xf144,0xf145,
	0xf146,0xf147,0xf148,0xf149,0xf14a,0xf14b,0xf14c,0xf14d,0xf14e,
	0xf14f,0xf150,0xf151,0xf152,0xf153,0xf154,0xf155,0xf156,0xf157,
	0xf158,0xf159,0xf15a,0xf15b,0xf15c,0xf15d,0xf15e,0xf15f,0xf160,
	0xf161,0xf162,0xf163,0xf164,0xf165,0xf166,0xf167,0xf168,0xf169,
	0xf16a,0xf16b,0xf16c,0xf16d,0xf16e,0xf16f,0xf170,0xf171,0xf172,
	0xf173,0xf174,0xf175,0xf176,0xf177,0xf178,0xf179,0xf17a,0xf17b,
	0xf17c,0xf17d,0xf17e,0xf180,0xf181,0xf182,0xf183,0xf184,0xf185,
	0xf186,0xf187,0xf188,0xf189,0xf18a,0xf18b,0xf18c,0xf18d,0xf18e,
	0xf18f,0xf190,0xf191,0xf192,0xf193,0xf194,0xf195,0xf196,0xf197,
	0xf198,0xf199,0xf19a,0xf19b,0xf19c,0xf19d,0xf19e,0xf19f,0xf1a0,
	0xf1a1,0xf1a2,0xf1a3,0xf1a4,0xf1a5,0xf1a6,0xf1a7,0xf1a8,0xf1a9,
	0xf1aa,0xf1ab,0xf1ac,0xf1ad,0xf1ae,0xf1af,0xf1b0,0xf1b1,0xf1b2,
	0xf1b3,0xf1b4,0xf1b5,0xf1b6,0xf1b7,0xf1b8,0xf1b9,0xf1ba,0xf1bb,
	0xf1bc,0xf1bd,0xf1be,0xf1bf,0xf1c0,0xf1c1,0xf1c2,0xf1c3,0xf1c4,
	0xf1c5,0xf1c6,0xf1c7,0xf1c8,0xf1c9,0xf1ca,0xf1cb,0xf1cc,0xf1cd,
	0xf1ce,0xf1cf,0xf1d0,0xf1d1,0xf1d2,0xf1d3,0xf1d4,0xf1d5,0xf1d6,
	0xf1d7,0xf1d8,0xf1d9,0xf1da,0xf1db,0xf1dc,0xf1dd,0xf1de,0xf1df,
	0xf1e0,0xf1e1,0xf1e2,0xf1e3,0xf1e4,0xf1e5,0xf1e6,0xf1e7,0xf1e8,
	0xf1e9,0xf1ea,0xf1eb,0xf1ec,0xf1ed,0xf1ee,0xf1ef,0xf1f0,0xf1f1,
	0xf1f2,0xf1f3,0xf1f4,0xf1f5,0xf1f6,0xf1f7,0xf1f8,0xf1f9,0xf1fa,
	0xf1fb,0xf1fc,0xf240,0xf241,0xf242,0xf243,0xf244,0xf245,0xf246,
	0xf247,0xf248,0xf249,0xf24a,0xf24b,0xf24c,0xf24d,0xf24e,0xf24f,
	0xf250,0xf251,0xf252,0xf253,0xf254,0xf255,0xf256,0xf257,0xf258,
	0xf259,0xf25a,0xf25b,0xf25c,0xf25d,0xf25e,0xf25f,0xf260,0xf261,
	0xf262,0xf263,0xf264,0xf265,0xf266,0xf267,0xf268,0xf269,0xf26a,
	0xf26b,0xf26c,0xf26d,0xf26e,0xf26f,0xf270,0xf271,0xf272,0xf273,
	0xf274,0xf275,0xf276,0xf277,0xf278,0xf279,0xf27a,0xf27b,0xf27c,
	0xf27d,0xf27e,0xf280,0xf281,0xf282,0xf283,0xf284,0xf285,0xf286,
	0xf287,0xf288,0xf289,0xf28a,0xf28b,0xf28c,0xf28d,0xf28e,0xf28f,
	0xf290,0xf291,0xf292,0xf293,0xf294,0xf295,0xf296,0xf297,0xf298,
	0xf299,0xf29a,0xf29b,0xf29c,0xf29d,0xf29e,0xf29f,0xf2a0,0xf2a1,
	0xf2a2,0xf2a3,0xf2a4,0xf2a5,0xf2a6,0xf2a7,0xf2a8,0xf2a9,0xf2aa,
	0xf2ab,0xf2ac,0xf2ad,0xf2ae,0xf2af,0xf2b0,0xf2b1,0xf2b2,0xf2b3,
	0xf2b4,0xf2b5,0xf2b6,0xf2b7,0xf2b8,0xf2b9,0xf2ba,0xf2bb,0xf2bc,
	0xf2bd,0xf2be,0xf2bf,0xf2c0,0xf2c1,0xf2c2,0xf2c3,0xf2c4,0xf2c5,
	0xf2c6,0xf2c7,0xf2c8,0xf2c9,0xf2ca,0xf2cb,0xf2cc,0xf2cd,0xf2ce,
	0xf2cf,0xf2d0,0xf2d1,0xf2d2,0xf2d3,0xf2d4,0xf2d5,0xf2d6,0xf2d7,
	0xf2d8,0xf2d9,0xf2da,0xf2db,0xf2dc,0xf2dd,0xf2de,0xf2df,0xf2e0,
	0xf2e1,0xf2e2,0xf2e3,0xf2e4,0xf2e5,0xf2e6,0xf2e7,0xf2e8,0xf2e9,
	0xf2ea,0xf2eb,0xf2ec,0xf2ed,0xf2ee,0xf2ef,0xf2f0,0xf2f1,0xf2f2,
	0xf2f3,0xf2f4,0xf2f5,0xf2f6,0xf2f7,0xf2f8,0xf2f9,0xf2fa,0xf2fb,
	0xf2fc,0xf340,0xf341,0xf342,0xf343,0xf344,0xf345,0xf346,0xf347,
	0xf348,0xf349,0xf34a,0xf34b,0xf34c,0xf34d,0xf34e,0xf34f,0xf350,
	0xf351,0xf352,0xf353,0xf354,0xf355,0xf356,0xf357,0xf358,0xf359,
	0xf35a,0xf35b,0xf35c,0xf35d,0xf35e,0xf35f,0xf360,0xf361,0xf362,
	0xf363,0xf364,0xf365,0xf366,0xf367,0xf368,0xf369,0xf36a,0xf36b,
	0xf36c,0xf36d,0xf36e,0xf36f,0xf370,0xf371,0xf372,0xf373,0xf374,
	0xf375,0xf376,0xf377,0xf378,0xf379,0xf37a,0xf37b,0xf37c,0xf37d,
	0xf37e,0xf380,0xf381,0xf382,0xf383,0xf384,0xf385,0xf386,0xf387,
	0xf388,0xf389,0xf38a,0xf38b,0xf38c,0xf38d,0xf38e,0xf38f,0xf390,
	0xf391,0xf392,0xf393,0xf394,0xf395,0xf396,0xf397,0xf398,0xf399,
	0xf39a,0xf39b,0xf39c,0xf39d,0xf39e,0xf39f,0xf3a0,0xf3a1,0xf3a2,
	0xf3a3,0xf3a4,0xf3a5,0xf3a6,0xf3a7,0xf3a8,0xf3a9,0xf3aa,0xf3ab,
	0xf3ac,0xf3ad,0xf3ae,0xf3af,0xf3b0,0xf3b1,0xf3b2,0xf3b3,0xf3b4,
	0xf3b5,0xf3b6,0xf3b7,0xf3b8,0xf3b9,0xf3ba,0xf3bb,0xf3bc,0xf3bd,
	0xf3be,0xf3bf,0xf3c0,0xf3c1,0xf3c2,0xf3c3,0xf3c4,0xf3c5,0xf3c6,
	0xf3c7,0xf3c8,0xf3c9,0xf3ca,0xf3cb,0xf3cc,0xf3cd,0xf3ce,0xf3cf,
	0xf3d0,0xf3d1,0xf3d2,0xf3d3,0xf3d4,0xf3d5,0xf3d6,0xf3d7,0xf3d8,
	0xf3d9,0xf3da,0xf3db,0xf3dc,0xf3dd,0xf3de,0xf3df,0xf3e0,0xf3e1,
	0xf3e2,0xf3e3,0xf3e4,0xf3e5,0xf3e6,0xf3e7,0xf3e8,0xf3e9,0xf3ea,
	0xf3eb,0xf3ec,0xf3ed,0xf3ee,0xf3ef,0xf3f0,0xf3f1,0xf3f2,0xf3f3,
	0xf3f4,0xf3f5,0xf3f6,0xf3f7,0xf3f8,0xf3f9,0xf3fa,0xf3fb,0xf3fc,
	0xf440,0xf441,0xf442,0xf443,0xf444,0xf445,0xf446,0xf447,0xf448,
	0xf449,0xf44a,0xf44b,0xf44c,0xf44d,0xf44e,0xf44f,0xf450,0xf451,
	0xf452,0xf453,0xf454,0xf455,0xf456,0xf457,0xf458,0xf459,0xf45a,
	0xf45b,0xf45c,0xf45d,0xf45e,0xf45f,0xf460,0xf461,0xf462,0xf463,
	0xf464,0xf465,0xf466,0xf467,0xf468,0xf469,0xf46a,0xf46b,0xf46c,
	0xf46d,0xf46e,0xf46f,0xf470,0xf471,0xf472,0xf473,0xf474,0xf475,
	0xf476,0xf477,0xf478,0xf479,0xf47a,0xf47b,0xf47c,0xf47d,0xf47e,
	0xf480,0xf481,0xf482,0xf483,0xf484,0xf485,0xf486,0xf487,0xf488,
	0xf489,0xf48a,0xf48b,0xf48c,0xf48d,0xf48e,0xf48f,0xf490,0xf491,
	0xf492,0xf493,0xf494,0xf495,0xf496,0xf497,0xf498,0xf499,0xf49a,
	0xf49b,0xf49c,0xf49d,0xf49e,0xf49f,0xf4a0,0xf4a1,0xf4a2,0xf4a3,
	0xf4a4,0xf4a5,0xf4a6,0xf4a7,0xf4a8,0xf4a9,0xf4aa,0xf4ab,0xf4ac,
	0xf4ad,0xf4ae,0xf4af,0xf4b0,0xf4b1,0xf4b2,0xf4b3,0xf4b4,0xf4b5,
	0xf4b6,0xf4b7,0xf4b8,0xf4b9,0xf4ba,0xf4bb,0xf4bc,0xf4bd,0xf4be,
	0xf4bf,0xf4c0,0xf4c1,0xf4c2,0xf4c3,0xf4c4,0xf4c5,0xf4c6,0xf4c7,
	0xf4c8,0xf4c9,0xf4ca,0xf4cb,0xf4cc,0xf4cd,0xf4ce,0xf4cf,0xf4d0,
	0xf4d1,0xf4d2,0xf4d3,0xf4d4,0xf4d5,0xf4d6,0xf4d7,0xf4d8,0xf4d9,
	0xf4da,0xf4db,0xf4dc,0xf4dd,0xf4de,0xf4df,0xf4e0,0xf4e1,0xf4e2,
	0xf4e3,0xf4e4,0xf4e5,0xf4e6,0xf4e7,0xf4e8,0xf4e9,0xf4ea,0xf4eb,
	0xf4ec,0xf4ed,0xf4ee,0xf4ef,0xf4f0,0xf4f1,0xf4f2,0xf4f3,0xf4f4,
	0xf4f5,0xf4f6,0xf4f7,0xf4f8,0xf4f9,0xf4fa,0xf4fb,0xf4fc,0xf540,
	0xf541,0xf542,0xf543,0xf544,0xf545,0xf546,0xf547,0xf548,0xf549,
	0xf54a,0xf54b,0xf54c,0xf54d,0xf54e,0xf54f,0xf550,0xf551,0xf552,
	0xf553,0xf554,0xf555,0xf556,0xf557,0xf558,0xf559,0xf55a,0xf55b,
	0xf55c,0xf55d,0xf55e,0xf55f,0xf560,0xf561,0xf562,0xf563,0xf564,
	0xf565,0xf566,0xf567,0xf568,0xf569,0xf56a,0xf56b,0xf56c,0xf56d,
	0xf56e,0xf56f,0xf570,0xf571,0xf572,0xf573,0xf574,0xf575,0xf576,
	0xf577,0xf578,0xf579,0xf57a,0xf57b,0xf57c,0xf57d,0xf57e,0xf580,
	0xf581,0xf582,0xf583,0xf584,0xf585,0xf586,0xf587,0xf588,0xf589,
	0xf58a,0xf58b,0xf58c,0xf58d,0xf58e,0xf58f,0xf590,0xf591,0xf592,
	0xf593,0xf594,0xf595,0xf596,0xf597,0xf598,0xf599,0xf59a,0xf59b,
	0xf59c,0xf59d,0xf59e,0xf59f,0xf5a0,0xf5a1,0xf5a2,0xf5a3,0xf5a4,
	0xf5a5,0xf5a6,0xf5a7,0xf5a8,0xf5a9,0xf5aa,0xf5ab,0xf5ac,0xf5ad,
	0xf5ae,0xf5af,0xf5b0,0xf5b1,0xf5b2,0xf5b3,0xf5b4,0xf5b5,0xf5b6,
	0xf5b7,0xf5b8,0xf5b9,0xf5ba,0xf5bb,0xf5bc,0xf5bd,0xf5be,0xf5bf,
	0xf5c0,0xf5c1,0xf5c2,0xf5c3,0xf5c4,0xf5c5,0xf5c6,0xf5c7,0xf5c8,
	0xf5c9,0xf5ca,0xf5cb,0xf5cc,0xf5cd,0xf5ce,0xf5cf,0xf5d0,0xf5d1,
	0xf5d2,0xf5d3,0xf5d4,0xf5d5,0xf5d6,0xf5d7,0xf5d8,0xf5d9,0xf5da,
	0xf5db,0xf5dc,0xf5dd,0xf5de,0xf5df,0xf5e0,0xf5e1,0xf5e2,0xf5e3,
	0xf5e4,0xf5e5,0xf5e6,0xf5e7,0xf5e8,0xf5e9,0xf5ea,0xf5eb,0xf5ec,
	0xf5ed,0xf5ee,0xf5ef,0xf5f0,0xf5f1,0xf5f2,0xf5f3,0xf5f4,0xf5f5,
	0xf5f6,0xf5f7,0xf5f8,0xf5f9,0xf5fa,0xf5fb,0xf5fc,0xf640,0xf641,
	0xf642,0xf643,0xf644,0xf645,0xf646,0xf647,0xf648,0xf649,0xf64a,
	0xf64b,0xf64c,0xf64d,0xf64e,0xf64f,0xf650,0xf651,0xf652,0xf653,
	0xf654,0xf655,0xf656,0xf657,0xf658,0xf659,0xf65a,0xf65b,0xf65c,
	0xf65d,0xf65e,0xf65f,0xf660,0xf661,0xf662,0xf663,0xf664,0xf665,
	0xf666,0xf667,0xf668,0xf669,0xf66a,0xf66b,0xf66c,0xf66d,0xf66e,
	0xf66f,0xf670,0xf671,0xf672,0xf673,0xf674,0xf675,0xf676,0xf677,
	0xf678,0xf679,0xf67a,0xf67b,0xf67c,0xf67d,0xf67e,0xf680,0xf681,
	0xf682,0xf683,0xf684,0xf685,0xf686,0xf687,0xf688,0xf689,0xf68a,
	0xf68b,0xf68c,0xf68d,0xf68e,0xf68f,0xf690,0xf691,0xf692,0xf693,
	0xf694,0xf695,0xf696,0xf697,0xf698,0xf699,0xf69a,0xf69b,0xf69c,
	0xf69d,0xf69e,0xf69f,0xf6a0,0xf6a1,0xf6a2,0xf6a3,0xf6a4,0xf6a5,
	0xf6a6,0xf6a7,0xf6a8,0xf6a9,0xf6aa,0xf6ab,0xf6ac,0xf6ad,0xf6ae,
	0xf6af,0xf6b0,0xf6b1,0xf6b2,0xf6b3,0xf6b4,0xf6b5,0xf6b6,0xf6b7,
	0xf6b8,0xf6b9,0xf6ba,0xf6bb,0xf6bc,0xf6bd,0xf6be,0xf6bf,0xf6c0,
	0xf6c1,0xf6c2,0xf6c3,0xf6c4,0xf6c5,0xf6c6,0xf6c7,0xf6c8,0xf6c9,
	0xf6ca,0xf6cb,0xf6cc,0xf6cd,0xf6ce,0xf6cf,0xf6d0,0xf6d1,0xf6d2,
	0xf6d3,0xf6d4,0xf6d5,0xf6d6,0xf6d7,0xf6d8,0xf6d9,0xf6da,0xf6db,
	0xf6dc,0xf6dd,0xf6de,0xf6df,0xf6e0,0xf6e1,0xf6e2,0xf6e3,0xf6e4,
	0xf6e5,0xf6e6,0xf6e7,0xf6e8,0xf6e9,0xf6ea,0xf6eb,0xf6ec,0xf6ed,
	0xf6ee,0xf6ef,0xf6f0,0xf6f1,0xf6f2,0xf6f3,0xf6f4,0xf6f5,0xf6f6,
	0xf6f7,0xf6f8,0xf6f9,0xf6fa,0xf6fb,0xf6fc,0xf740,0xf741,0xf742,
	0xf743,0xf744,0xf745,0xf746,0xf747,0xf748,0xf749,0xf74a,0xf74b,
	0xf74c,0xf74d,0xf74e,0xf74f,0xf750,0xf751,0xf752,0xf753,0xf754,
	0xf755,0xf756,0xf757,0xf758,0xf759,0xf75a,0xf75b,0xf75c,0xf75d,
	0xf75e,0xf75f,0xf760,0xf761,0xf762,0xf763,0xf764,0xf765,0xf766,
	0xf767,0xf768,0xf769,0xf76a,0xf76b,0xf76c,0xf76d,0xf76e,0xf76f,
	0xf770,0xf771,0xf772,0xf773,0xf774,0xf775,0xf776,0xf777,0xf778,
	0xf779,0xf77a,0xf77b,0xf77c,0xf77d,0xf77e,0xf780,0xf781,0xf782,
	0xf783,0xf784,0xf785,0xf786,0xf787,0xf788,0xf789,0xf78a,0xf78b,
	0xf78c,0xf78d,0xf78e,0xf78f,0xf790,0xf791,0xf792,0xf793,0xf794,
	0xf795,0xf796,0xf797,0xf798,0xf799,0xf79a,0xf79b,0xf79c,0xf79d,
	0xf79e,0xf79f,0xf7a0,0xf7a1,0xf7a2,0xf7a3,0xf7a4,0xf7a5,0xf7a6,
	0xf7a7,0xf7a8,0xf7a9,0xf7aa,0xf7ab,0xf7ac,0xf7ad,0xf7ae,0xf7af,
	0xf7b0,0xf7b1,0xf7b2,0xf7b3,0xf7b4,0xf7b5,0xf7b6,0xf7b7,0xf7b8,
	0xf7b9,0xf7ba,0xf7bb,0xf7bc,0xf7bd,0xf7be,0xf7bf,0xf7c0,0xf7c1,
	0xf7c2,0xf7c3,0xf7c4,0xf7c5,0xf7c6,0xf7c7,0xf7c8,0xf7c9,0xf7ca,
	0xf7cb,0xf7cc,0xf7cd,0xf7ce,0xf7cf,0xf7d0,0xf7d1,0xf7d2,0xf7d3,
	0xf7d4,0xf7d5,0xf7d6,0xf7d7,0xf7d8,0xf7d9,0xf7da,0xf7db,0xf7dc,
	0xf7dd,0xf7de,0xf7df,0xf7e0,0xf7e1,0xf7e2,0xf7e3,0xf7e4,0xf7e5,
	0xf7e6,0xf7e7,0xf7e8,0xf7e9,0xf7ea,0xf7eb,0xf7ec,0xf7ed,0xf7ee,
	0xf7ef,0xf7f0,0xf7f1,0xf7f2,0xf7f3,0xf7f4,0xf7f5,0xf7f6,0xf7f7,
	0xf7f8,0xf7f9,0xf7fa,0xf7fb,0xf7fc,0xf840,0xf841,0xf842,0xf843,
	0xf844,0xf845,0xf846,0xf847,0xf848,0xf849,0xf84a,0xf84b,0xf84c,
	0xf84d,0xf84e,0xf84f,0xf850,0xf851,0xf852,0xf853,0xf854,0xf855,
	0xf856,0xf857,0xf858,0xf859,0xf85a,0xf85b,0xf85c,0xf85d,0xf85e,
	0xf85f,0xf860,0xf861,0xf862,0xf863,0xf864,0xf865,0xf866,0xf867,
	0xf868,0xf869,0xf86a,0xf86b,0xf86c,0xf86d,0xf86e,0xf86f,0xf870,
	0xf871,0xf872,0xf873,0xf874,0xf875,0xf876,0xf877,0xf878,0xf879,
	0xf87a,0xf87b,0xf87c,0xf87d,0xf87e,0xf880,0xf881,0xf882,0xf883,
	0xf884,0xf885,0xf886,0xf887,0xf888,0xf889,0xf88a,0xf88b,0xf88c,
	0xf88d,0xf88e,0xf88f,0xf890,0xf891,0xf892,0xf893,0xf894,0xf895,
	0xf896,0xf897,0xf898,0xf899,0xf89a,0xf89b,0xf89c,0xf89d,0xf89e,
	0xf89f,0xf8a0,0xf8a1,0xf8a2,0xf8a3,0xf8a4,0xf8a5,0xf8a6,0xf8a7,
	0xf8a8,0xf8a9,0xf8aa,0xf8ab,0xf8ac,0xf8ad,0xf8ae,0xf8af,0xf8b0,
	0xf8b1,0xf8b2,0xf8b3,0xf8b4,0xf8b5,0xf8b6,0xf8b7,0xf8b8,0xf8b9,
	0xf8ba,0xf8bb,0xf8bc,0xf8bd,0xf8be,0xf8bf,0xf8c0,0xf8c1,0xf8c2,
	0xf8c3,0xf8c4,0xf8c5,0xf8c6,0xf8c7,0xf8c8,0xf8c9,0xf8ca,0xf8cb,
	0xf8cc,0xf8cd,0xf8ce,0xf8cf,0xf8d0,0xf8d1,0xf8d2,0xf8d3,0xf8d4,
	0xf8d5,0xf8d6,0xf8d7,0xf8d8,0xf8d9,0xf8da,0xf8db,0xf8dc,0xf8dd,
	0xf8de,0xf8df,0xf8e0,0xf8e1,0xf8e2,0xf8e3,0xf8e4,0xf8e5,0xf8e6,
	0xf8e7,0xf8e8,0xf8e9,0xf8ea,0xf8eb,0xf8ec,0xf8ed,0xf8ee,0xf8ef,
	0xf8f0,0xf8f1,0xf8f2,0xf8f3,0xf8f4,0xf8f5,0xf8f6,0xf8f7,0xf8f8,
	0xf8f9,0xf8fa,0xf8fb,0xf8fc,0xf940,0xf941,0xf942,0xf943,0xf944,
	0xf945,0xf946,0xf947,0xf948,0xf949,0xf94a,0xf94b,0xf94c,0xf94d,
	0xf94e,0xf94f,0xf950,0xf951,0xf952,0xf953,0xf954,0xf955,0xf956,
	0xf957,0xf958,0xf959,0xf95a,0xf95b,0xf95c,0xf95d,0xf95e,0xf95f,
	0xf960,0xf961,0xf962,0xf963,0xf964,0xf965,0xf966,0xf967,0xf968,
	0xf969,0xf96a,0xf96b,0xf96c,0xf96d,0xf96e,0xf96f,0xf970,0xf971,
	0xf972,0xf973,0xf974,0xf975,0xf976,0xf977,0xf978,0xf979,0xf97a,
	0xf97b,0xf97c,0xf97d,0xf97e,0xf980,0xf981,0xf982,0xf983,0xf984,
	0xf985,0xf986,0xf987,0xf988,0xf989,0xf98a,0xf98b,0xf98c,0xf98d,
	0xf98e,0xf98f,0xf990,0xf991,0xf992,0xf993,0xf994,0xf995,0xf996,
	0xf997,0xf998,0xf999,0xf99a,0xf99b,0xf99c,0xf99d,0xf99e,0xf99f,
	0xf9a0,0xf9a1,0xf9a2,0xf9a3,0xf9a4,0xf9a5,0xf9a6,0xf9a7,0xf9a8,
	0xf9a9,0xf9aa,0xf9ab,0xf9ac,0xf9ad,0xf9ae,0xf9af,0xf9b0,0xf9b1,
	0xf9b2,0xf9b3,0xf9b4,0xf9b5,0xf9b6,0xf9b7,0xf9b8,0xf9b9,0xf9ba,
	0xf9bb,0xf9bc,0xf9bd,0xf9be,0xf9bf,0xf9c0,0xf9c1,0xf9c2,0xf9c3,
	0xf9c4,0xf9c5,0xf9c6,0xf9c7,0xf9c8,0xf9c9,0xf9ca,0xf9cb,0xf9cc,
	0xf9cd,0xf9ce,0xf9cf,0xf9d0,0xf9d1,0xf9d2,0xf9d3,0xf9d4,0xf9d5,
	0xf9d6,0xf9d7,0xf9d8,0xf9d9,0xf9da,0xf9db,0xf9dc,0xf9dd,0xf9de,
	0xf9df,0xf9e0,0xf9e1,0xf9e2,0xf9e3,0xf9e4,0xf9e5,0xf9e6,0xf9e7,
	0xf9e8,0xf9e9,0xf9ea,0xf9eb,0xf9ec,0xf9ed,0xf9ee,0xf9ef,0xf9f0,
	0xf9f1,0xf9f2,0xf9f3,0xf9f4,0xf9f5,0xf9f6,0xf9f7,0xf9f8,0xf9f9,
	0xf9fa,0xf9fb,0xf9fc,0x00a0,0x00fd,0x00fe,0x00ff,0xfae0,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,0xfbe9,0xfa90,0xfa9b,
	0xfa9c,0xfab1,0xfad8,0xfae8,0xfaea,0xfb58,0xfb5e,0xfb75,0xfb7d,
	0xfb7e,0xfb80,0xfb82,0xfb86,0xfb89,0xfb92,0xfb9d,0xfb9f,0xfba0,
	0xfba9,0xfbb1,0xfbb3,0xfbb4,0xfbb7,0xfbd3,0xfbda,0xfbea,0xfbf6,
	0xfbf7,0xfbf9,0xfc49,0x8149,0xfa57,0x8194,0x8190,0x8193,0x8195,
	0xfa56,0x8169,0x816a,0x8196,0x817b,0x8143,0x817c,0x8144,0x815e,
	0x824f,0x8250,0x8251,0x8252,0x8253,0x8254,0x8255,0x8256,0x8257,
	0x8258,0x8146,0x8147,0x8183,0x8181,0x8184,0x8148,0x8197,0x8260,
	0x8261,0x8262,0x8263,0x8264,0x8265,0x8266,0x8267,0x8268,0x8269,
	0x826a,0x826b,0x826c,0x826d,0x826e,0x826f,0x8270,0x8271,0x8272,
	0x8273,0x8274,0x8275,0x8276,0x8277,0x8278,0x8279,0x816d,0x815f,
	0x816e,0x814f,0x8151,0x814d,0x8281,0x8282,0x8283,0x8284,0x8285,
	0x8286,0x8287,0x8288,0x8289,0x828a,0x828b,0x828c,0x828d,0x828e,
	0x828f,0x8290,0x8291,0x8292,0x8293,0x8294,0x8295,0x8296,0x8297,
	0x8298,0x8299,0x829a,0x816f,0x8162,0x8170,0x8160,UDCODE,UDCODE,
	0x00a1,0x00a2,0x00a3,0x00a4,0x00a5,0x00a6,0x00a7,0x00a8,0x00a9,
	0x00aa,0x00ab,0x00ac,0x00ad,0x00ae,0x00af,0x00b0,0x00b1,0x00b2,
	0x00b3,0x00b4,0x00b5,0x00b6,0x00b7,0x00b8,0x00b9,0x00ba,0x00bb,
	0x00bc,0x00bd,0x00be,0x00bf,0x00c0,0x00c1,0x00c2,0x00c3,0x00c4,
	0x00c5,0x00c6,0x00c7,0x00c8,0x00c9,0x00ca,0x00cb,0x00cc,0x00cd,
	0x00ce,0x00cf,0x00d0,0x00d1,0x00d2,0x00d3,0x00d4,0x00d5,0x00d6,
	0x00d7,0x00d8,0x00d9,0x00da,0x00db,0x00dc,0x00dd,0x00de,0x00df,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,UDCODE,
	UDCODE,0x8191,0x8192,0x81ca,0x8150,0xfa55,0x818f
};

static UINT ucs2len(const UINT16 *lpString);
static UINT ucs2tosjis(char *lpOutput, UINT cchOutput, const UINT16 *lpInput, UINT cbInput);
static UINT utf8tosjis(char *lpOutput, UINT cchOutput, const char *lpInput, UINT cbInput);

/**
 * Maps a UTF-16 string to a S-SJIS string
 * @param[out] lpOutput Pointer to a buffer that receives the converted string
 * @param[in] cchOutput Size, in characters, of the buffer indicated by lpOutput
 * @param[in] lpInput Pointer to the character string to convert
 * @param[in] cbInput Size, in characters, of the buffer indicated by lpInput
 * @return The number of characters written to the buffer indicated by lpOutput
 */
UINT codecnv_ucs2tosjis(char *lpOutput, UINT cchOutput, const UINT16 *lpInput, UINT cbInput)
{
	UINT nLength;

	if (lpInput == NULL)
	{
		return 0;
	}

	if (cchOutput == 0)
	{
		lpOutput = NULL;
		cchOutput = (UINT)-1;
	}

	if (cbInput != (UINT)-1)
	{
		// Binary mode
		return ucs2tosjis(lpOutput, cchOutput, lpInput, cbInput);
	}
	else
	{
		// String mode
		nLength = ucs2tosjis(lpOutput, cchOutput - 1, lpInput, ucs2len(lpInput));
		if (lpOutput)
		{
			lpOutput[nLength] = '\0';
		}
		return nLength + 1;
	}
}

/**
 * Get the length of a string
 * @param[in] lpString Null-terminated string
 * @return the number of characters in lpString
 */
static UINT ucs2len(const UINT16 *lpString)
{
	const UINT16 *p = lpString;
	while (*p != 0)
	{
		p++;
	}
	return (UINT)(p - lpString);
}

/**
 * Maps a UTF-16 string to a S-JIS string (inner)
 * @param[out] lpOutput Pointer to a buffer that receives the converted string
 * @param[in] cchOutput Size, in characters, of the buffer indicated by lpOutput
 * @param[in] lpInput Pointer to the character string to convert
 * @param[in] cbInput Size, in characters, of the buffer indicated by lpInput
 * @return The number of characters written to the buffer indicated by lpOutput
 */
static UINT ucs2tosjis(char *lpOutput, UINT cchOutput, const UINT16 *lpInput, UINT cbInput)
{
	UINT nRemain;
	UINT c;
	UINT r;

	nRemain = cchOutput;
	while ((cbInput > 0) && (nRemain > 0))
	{
		c = *lpInput++;
		cbInput--;

		r = s_level1[c >> 8];
		c = (c - r) & 0xff;
		if (c < ((r >> 8) & 0x1ff))
		{
			c = s_level2[(r >> 17) + c];
		}
		else
		{
			c = UDCODE;
		}

		if (c < 0x100)
		{
			nRemain--;
			if (lpOutput)
			{
				*lpOutput++ = (char)c;
			}
		}
		else
		{
			if (nRemain < 2)
			{
				break;
			}
			nRemain -= 2;
			if (lpOutput)
			{
				*lpOutput++ = (char)(c >> 8);
				*lpOutput++ = (char)(c >> 0);
			}
		}
	}
	return (UINT)(cchOutput - nRemain);
}

/**
 * Maps a UTF-8 string to a S-SJIS string
 * @param[out] lpOutput Pointer to a buffer that receives the converted string
 * @param[in] cchOutput Size, in characters, of the buffer indicated by lpOutput
 * @param[in] lpInput Pointer to the character string to convert
 * @param[in] cbInput Size, in characters, of the buffer indicated by lpInput
 * @return The number of characters written to the buffer indicated by lpOutput
 */
UINT codecnv_utf8tosjis(char *lpOutput, UINT cchOutput, const char *lpInput, UINT cbInput)
{
	UINT nLength;

	if (lpInput == NULL)
	{
		return 0;
	}

	if (cchOutput == 0)
	{
		lpOutput = NULL;
		cchOutput = (UINT)-1;
	}

	if (cbInput != (UINT)-1)
	{
		// Binary mode
		return utf8tosjis(lpOutput, cchOutput, lpInput, cbInput);
	}
	else
	{
		// String mode
		nLength = utf8tosjis(lpOutput, cchOutput - 1, lpInput, (UINT)strlen(lpInput));
		if (lpOutput)
		{
			lpOutput[nLength] = '\0';
		}
		return nLength + 1;
	}
}

/**
 * Maps a UTF-8 string to a S-JIS string (inner)
 * @param[out] lpOutput Pointer to a buffer that receives the converted string
 * @param[in] cchOutput Size, in characters, of the buffer indicated by lpOutput
 * @param[in] lpInput Pointer to the character string to convert
 * @param[in] cbInput Size, in characters, of the buffer indicated by lpInput
 * @return The number of characters written to the buffer indicated by lpOutput
 */
static UINT utf8tosjis(char *lpOutput, UINT cchOutput, const char *lpInput, UINT cbInput)
{
	UINT nRemain;
	UINT c;
	int nBits;
	UINT r;

	nRemain = cchOutput;
	while ((cbInput > 0) && (nRemain > 0))
	{
		c = *lpInput++;
		cbInput--;

		if (c & 0x80)
		{
			nBits = 0;
			while ((nBits < 6) && (c & (0x80 >> nBits)))
			{
				nBits++;
			}

			c &= (0x7f >> nBits);
			nBits--;

			while ((nBits > 0) && (cbInput > 0) && (((*lpInput) & 0xc0) == 0x80))
			{
				c = (c << 6) | ((*lpInput++) & 0x3f);
				cbInput--;
				nBits--;
			}

			r = 0;
			if (c < 0x10000)
			{
				r = s_level1[c >> 8];
			}
			c = (c - r) & 0xff;
			if (c < ((r >> 8) & 0x1ff))
			{
				c = s_level2[(r >> 17) + c];
			}
			else
			{
				c = UDCODE;
			}
		}

		if (c < 0x100)
		{
			nRemain--;
			if (lpOutput)
			{
				*lpOutput++ = (char)c;
			}
		}
		else
		{
			if (nRemain < 2)
			{
				break;
			}
			nRemain -= 2;
			if (lpOutput)
			{
				*lpOutput++ = (char)(c >> 8);
				*lpOutput++ = (char)(c >> 0);
			}
		}
	}
	return (UINT)(cchOutput - nRemain);
}
