#!/usr/bin/perl
# debug.cgi - This will test the debug methods of the HTMLObject Normal object.

use HTMLObject::Normal;
use strict;

my $doc = HTMLObject::Normal->new();

$doc->setHTMLInfo(dtd => "strict", xhtml => 1);

# since I am testing XHTML code, I have to set the background color, etc. via CSS.
$doc->setStyleEntry(tag => "body", string => "color: #ffffff; background-color: #555555; font-size: 10pt;");
$doc->setStyleEntry(tag => "a:link", string => "color: blue; text-decoration: none;");

$doc->setTitle("Debug2.cgi");

$doc->setBodyFgcolor("red");
$doc->setBodyBgcolor("blue");

$doc->setFocus("head");

$doc->setLinkDecorations();

$doc->setFocus("body");
$doc->print("This is debug2.cgi...<br>\n");
$doc->print("This is a test!<TESTTAG>\n<br>");

$doc->printTag(tag => "<TESTTAG>", value => "\n<br />This was inserted via <b>printTag</b>.");
$doc->printTag(tag => "<TESTTAG>", value => "&nbsp;I just added some more text to this tag!");

my $testTagValue = $doc->readTag(tag => "<TESTTAG>");
$doc->deleteTag(tag => "<TESTTAG>");

$doc->printTag(tag => "<TESTTAG>", value => "The following content was printed, read and then deleted and then re-printed ($testTagValue)\n", mode => "single");

$doc->displayError(title => "Testing Debug Code", message => "Just Testing Debug Code in displayError method.", debug => 1);
