/*
 * Copyright (C) 1995-2011 University of Karlsruhe.  All right reserved.
 *
 * This file is part of libFirm.
 *
 * This file may be distributed and/or modified under the terms of the
 * GNU General Public License version 2 as published by the Free Software
 * Foundation and appearing in the file LICENSE.GPL included in the
 * packaging of this file.
 *
 * Licensees holding valid libFirm Professional Edition licenses may use
 * this file in accordance with the libFirm Commercial License.
 * Agreement provided with the Software.
 *
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE.
 */

/**
 * @file
 * @brief       Methods to compute when a value will be used again.
 * @author      Sebastian Hack, Matthias Braun
 * @date        27.06.2005
 */
#ifndef FIRM_BE_BEUSES_H
#define FIRM_BE_BEUSES_H

#include "firm_types.h"
#include "belive.h"

/**
 * Describes a use of a value.
 */
typedef struct be_next_use_t {
	unsigned       time;
	unsigned       outermost_loop;
	/* point of the next use is at the beginning of this node. */
	const ir_node *before;
} be_next_use_t;

#define USES_INFINITY  10000000
#define USES_PENDING   9999999

static inline bool USES_IS_INFINITE(unsigned time)
{
	return time >= USES_INFINITY;
}

static inline bool USES_IS_PENDING(unsigned time)
{
	return time == USES_PENDING;
}

typedef struct be_uses_t be_uses_t;

be_next_use_t be_get_next_use(be_uses_t *uses, ir_node *from,
                              const ir_node *def, int skip_from_uses);

/**
 * Creates a new uses environment for a graph.
 *
 * @param irg  the graph
 * @param lv   liveness information for the graph
 */
be_uses_t *be_begin_uses(ir_graph *irg, const be_lv_t *lv);

/**
 * Destroys the given uses environment.
 *
 * @param uses  the environment
 */
void be_end_uses(be_uses_t *uses);

#endif
