/**
 * @file utils.h Zip utility functions
 * 
 * $Id: utils.h,v 1.4 2003/01/01 06:22:34 chipx86 Exp $
 *
 * @Copyright (C) 2001-2003 The GNUpdate Project.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */
#ifndef _MOD_ZIP_UTILS_H_
#define _MOD_ZIP_UTILS_H_

#include <libcomprex/internal.h>

unsigned char  cxZipGet8(unsigned char *buffer,  int *counter);
unsigned short cxZipGet16(unsigned char *buffer, int *counter);
unsigned int   cxZipGet32(unsigned char *buffer, int *counter);
time_t cxDosDateToUnix(unsigned int dosDate);
size_t cxZipRead(void *ptr, size_t size, size_t nmemb, CxFile *file);

#endif /* _MOD_ZIP_UTILS_H_ */

