/**
 * @file utils.c Zip utility functions
 * 
 * $Id: utils.c,v 1.5 2003/01/01 06:22:34 chipx86 Exp $
 *
 * @Copyright (C) 2001-2003 The GNUpdate Project.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */
#include <libcomprex/internal.h>
#include <stdio.h>

#include "zip.h"

unsigned char
cxZipGet8(unsigned char *buffer, int *counter)
{
	char i = (buffer[*counter] & 0xFF);

	(*counter)++;

	return i;
}

unsigned short
cxZipGet16(unsigned char *buffer, int *counter)
{
#if 0
	short i = ((buffer[*counter] & 0xFF) |
			   ((buffer[*counter + 1] & 0xFF) << 8));

	*counter += 2;
#endif
	
	return ((short)cxZipGet8(buffer, counter) |
			((short)cxZipGet8(buffer, counter) << 8));
}

unsigned int
cxZipGet32(unsigned char *buffer, int *counter)
{
	return (cxZipGet16(buffer, counter) |
			((int)cxZipGet16(buffer, counter) << 16));
}

time_t
cxDosDateToUnix(unsigned int dosDate)
{
	struct tm *t;
	time_t clock = time(NULL);

	t = localtime(&clock);
	t->tm_isdst = -1;      /* let mktime() determine if DST is in effect */

	/* Convert DOS time to UNIX time_t format */
	t->tm_sec  = ((((int)dosDate) <<  1) & 0x3E);
	t->tm_min  = ((((int)dosDate) >>  5) & 0x3F);
	t->tm_hour = ((((int)dosDate) >> 11) & 0x1F);
	t->tm_mday = ((int)(dosDate   >> 16) & 0x1F);
	t->tm_mon  = ((int)(dosDate   >> 21) & 0x0F) - 1;
	t->tm_year = ((int)(dosDate   >> 25) & 0x7F) + 80;

	return mktime(t);
}

