/**
 * @file utils.c Utility functions
 * 
 * $Id: utils.c,v 1.2 2003/01/01 06:22:32 chipx86 Exp $
 *
 * @Copyright (C) 2001-2003 The GNUpdate Project.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */
#include <libcomprex/internal.h>

unsigned char
cxCabGet8(unsigned char *buffer, int *counter)
{
	char i = (buffer[*counter] & 0xFF);

	(*counter)++;

	return i;
}

unsigned short
cxCabGet16(unsigned char *buffer, int *counter)
{
	return ((short)cxCabGet8(buffer, counter) |
			((short)cxCabGet8(buffer, counter) << 8));
}

unsigned int
cxCabGet32(unsigned char *buffer, int *counter)
{
	return (cxCabGet16(buffer, counter) |
			((int)cxCabGet16(buffer, counter) << 16));
}

