'\"-
'\" Copyright (c)1997-2005 Hartmut Brandt.
'\" All rights reserved.
'\"
'\" Author: Harti Brandt <harti@freebsd.org>
'\"
'\" Redistribution and use in source and binary forms, with or without
'\" modification, are permitted provided that the following conditions
'\" are met:
'\" 1. Redistributions of source code must retain the above copyright
'\"    notice, this list of conditions and the following disclaimer.
'\" 2. Redistributions in binary form must reproduce the above copyright
'\"    notice, this list of conditions and the following disclaimer in the
'\"    documentation and/or other materials provided with the distribution.
'\"
'\" THIS SOFTWARE IS PROVIDED BY AUTHOR AND CONTRIBUTORS ``AS IS'' AND
'\" ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
'\" IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
'\" ARE DISCLAIMED.  IN NO EVENT SHALL AUTHOR OR CONTRIBUTORS BE LIABLE
'\" FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
'\" DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
'\" OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
'\" HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
'\" LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
'\" OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
'\" SUCH DAMAGE.
'\"
'\" $Begemot: libbegemot/panic.man,v 1.11 2005/06/01 07:50:54 brandt_h Exp $
'\"
.TH panic l "28 Mar 2000" "BEGEMOT" "BEGEMOT Library"
.SH NAME
panic, warn \- print error or warning message and eventualy exit
.SH SYNOPSIS
.nf
.LP
.B "# include <begemot.h>"
.LP
.BI "volatile void panic(const char *" "fmt" ", ...);"
.LP
.BI "volatile void bug(const char *" "fmt" ", ...);"
.LP
.BI "void error(const char *" "fmt" ", ...);"
.LP
.BI "void warn(const char *" "fmt" ", ...);"
.LP
.BI "void inform(const char *" "fmt" ", ...);"
.LP
.B "int geterrorcnt();"
.LP
.B "int getwarncnt();"
.LP
.BI "void set_errmode(int" " mode" ");"
.LP
.BI "void set_argv0(char *" "argv0" ");"
.fi
.SH DESCRIPTION
The functions
.BR panic , " bug" , " error" , " warn" " and " inform
are used to print messages in a standardized format to
.BR stderr .
.P
.B panic
should be used, when the program encounters an error of that kind, that
it's better to stop the program. It calles
.BR exit (3)
with a value of
.IR 1 .
If the environment variable
.B BEGEMOT_ABORT
is set, the program calls
.BR abort (3)
instead.
.B error
on the other hand should be used, when there is a severe error,
but the program can continue (but the user should expect bad things).
.B error
returns to the caller.
.B bug
should be used, if the program encounters an error, that is obviously a
programming error. A good example is putting
.B bug
in the default case of a switch statement, if it 'should not happen'.
.B warn
can be called if there may be an error and it's better to inform the user
about it.
.B inform
is called to print informative messages.
.P
There are also
.BR v -versions
of this functions, which take a
.B "va_list"
as second argument.
.P
There are two message formats: a simple one and a complicated one. The
simple one is the default. It consists of one of the words
.IR panic , " error" , " warning" , " info" " or " bug ,
followed by a colon, the formatted message and a new-line. For the complicated
format this is prefixed with the program name, which can be set with
.BR set_argv0 .
If it is not set, nothing is printed.
The name is followed by the program's pid, the current time.
.P
The mode can be selected with
.BR set_errmode .
An argument of zero selects the simple mode, non-zero values
the complicated one. This setting may be overriden with the environment
variable
.BR "BEGEMOT_ERR" .
Setting the error mode to a value greater than 1 produces the current time
as the number of seconds (as a floating point value) from some point in time.
This number of seconds is obtained: with the
.BR gethrtime (2)
system call on systems that provide it (Solaris), else with
.BR clock_gettime (2)
and a clockid of CLOCK_REALTIME on Posix systems, and with
.BR gettimeofday (2)
if everything else failes. This mode is intended for parsing the output.
.P
It is often not simple to decide which of these functions to call in a certain situation. If the program
comes in a situation, where continuation will most probably make things worse, then call
.BR panic .
Examples of this are: memory cannot be allocated (exhaustion of virtual memory
under UNIX is in almost
all cases the outcome of a bug), a critical file cannot be found.
A warning should be issued, if the program cannot decide what the user's indentation was, but continuation will
do no harm. The error function should be called, if the program can not continue as needed, but manual
user actions can correct things. If the program finds, for example, after a long computation, that it cannot
write the output to the desired file because of protection, it may write the output to /tmp and give the
user a hint where to find it.
.P
The calls to
.B error
and
.B warn
are counted. These counts can be retrieved with
.B geterrorcnt
and
.BR getwarncnt .
.SH "RETURN VALUE"
.B panic
and
.B bug
never return.
.BR warn ,
.B error
and
.B inform
return nothing.
.B geterrorcnt
and
.B getwarncnt
return the respective counts. This may be wrong if the functions are
called more the 4 billion times.
.SH "ENVIRONMENT"
.TP
BEGEMOT_ERR
Overrides the format mode.
.TP
BEGEMOT_ABORT
Generate a core dump on call to
.BR panic .
.SH "SEE ALSO"
.BR abort (3),
.BR clock_gettime (2)
.BR exit (2),
.BR fprintf (3),
.BR gethrtime (2),
.BR gettimeofday (2),
.BR stdarg (3),
.BR vfprintf (3)
.SH AUTHOR
Harti Brandt
