/*
 * ksi_conf.c
 *
 * Copyright (C) 1997-2010, ivan demakov
 *
 * The software is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or (at your
 * option) any later version.
 *
 * The software is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with the software; see the file COPYING.LESSER.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 *
 * Author:        ivan demakov <ksion@users.sourceforge.net>
 * Creation date: Sun May 19 21:36:23 2002
 * Last Update:   Mon Apr 12 02:37:27 2010
 *
 */


#include "ksi_conf.h"
#include "ksi_printf.h"
#include "ksi_util.h"
#include "ksi_int.h"

#ifdef _MSC_VER
#  include <io.h>
#  define F_OK 0
#endif


#ifdef KSI_DEFINE_BZERO
void
bzero(void *p, int n)
{
  char *ptr = (char *) p;
  while(--n >= 0)
    ptr++ = 0;
}
#endif


#ifdef KSI_DEFINE_MEMMOVE
void
memmove(void *p1, const void *p2, int n)
{
  int i;
  char *ptr1 = (char*)p1, ptr2 = (char *)p2;
  if (ptr1 < ptr2) {
    for (i = 0; i < n; i++)
      ptr1[i] = ptr2[i];
  } else if (ptr1 > ptr2) {
    for (i = n-1; i >= 0; --i)
      *ptr1[i] = ptr2[i];
  }
}
#endif

/*
 * Function ksi_version
 * Function ksi_major_version
 * Function ksi_minor_version
 * Function ksi_patch_level
 *
 *	KSI_VERSION, KSI_MAJOR_VERSION, KSI_MINOR_VERSION and KSI_PATCH_LEVEL
 *	defined in "ksi_ver.h" which is autogenerated
 *
 */

const char*
ksi_version ()
{
  return KSI_VERSION;
}

int
ksi_major_version ()
{
  return KSI_MAJOR_VERSION;
}

int
ksi_minor_version ()
{
  return KSI_MINOR_VERSION;
}

int
ksi_patch_level ()
{
  return KSI_PATCH_LEVEL;
}

const char*
ksi_cpu ()
{
  return KSI_CPU;
}

const char*
ksi_os ()
{
  return KSI_OS;
}

const char*
ksi_host ()
{
  return KSI_HOST;
}


static char *scm_lib = 0;

void
ksi_set_scheme_lib_dir (const char *dir)
{
    if (dir) {
        scm_lib = ksi_malloc_atomic(strlen(dir) + 1);
        strcpy(scm_lib, dir);
    } else {
        scm_lib = 0;
    }
}

const char*
ksi_scheme_lib_dir ()
{
    if (scm_lib == 0) {
        char *lib = getenv("KSI_LIBRARY");

#if defined(WIN32)
        if (!lib) {
            int i;
            char *p;
#if defined(KSIDLL)
            HMODULE hm = GetModuleHandle (KSIDLL_NAME ".dll");
#else
            HMODULE hm = GetModuleHandle (0);
#endif
            if (hm) {
                char dir[MAX_PATH_LENGTH + 1];
                if (GetModuleFileName (hm, dir, MAX_PATH_LENGTH) > 0) {
                    for (i = strlen (dir) - 1; i > 0; --i)
                        if (IS_DIR_SUFFIX (dir[i]))
                            break;
                    dir[i] = '\0';

                    /* lib subdir exists in the dll directory? */
                    p = ksi_aprintf ("%s\\%d.%d.%d", dir, KSI_MAJOR_VERSION, KSI_MINOR_VERSION, KSI_PATCH_LEVEL);
                    if (access (p, F_OK) == 0) {
                        lib = ksi_expand_file_name (p);
                    } else {
                        /* now try parent directory */
                        p = ksi_aprintf ("%s\\..\\%d.%d.%d", dir, KSI_MAJOR_VERSION, KSI_MINOR_VERSION, KSI_PATCH_LEVEL);
                        if (access (p, F_OK) == 0) {
                            lib = ksi_expand_file_name (p);
                        }
                    }
                } else {
                    ksi_exn_error(0, 0, "unknown module filename: %s", ksi_get_last_error(""));
                }
            } else {
                ksi_exn_error(0, 0, "unknown module: %s", ksi_get_last_error(""));
            }
        }
#endif

        scm_lib = (lib ? lib : KSI_SCM_LIB_DIR DIR_SEP KSI_VERSION);
    }

    return scm_lib;
}

const char*
ksi_instal_include_dir ()
{
  return KSI_INSTAL_INCLUDE_DIR;
}

const char*
ksi_instal_lib_dir ()
{
  return KSI_INSTAL_LIB_DIR;
}

const char*
ksi_instal_bin_dir ()
{
  return KSI_INSTAL_BIN_DIR;
}

const char*
ksi_instal_info_dir ()
{
  return KSI_INSTAL_INFO_DIR;
}

const char*
ksi_instal_man_dir ()
{
  return KSI_INSTAL_MAN_DIR;
}

const char*
ksi_build_cflags ()
{
  return KSI_BUILD_CFLAGS;
}

const char*
ksi_build_libs ()
{
  return KSI_BUILD_LIBS;
}


#ifdef WIN32

static const char*
ksi_win_error_text (char *msg, unsigned long err)
{
  char buf[256];

  buf[0] = '\0';
  buf[sizeof buf - 1] = '\0';
  FormatMessage (FORMAT_MESSAGE_FROM_SYSTEM
                 | FORMAT_MESSAGE_IGNORE_INSERTS
                 | FORMAT_MESSAGE_MAX_WIDTH_MASK,
                 NULL,
                 err,
                 0,
                 buf,
                 sizeof buf - 1,
                 NULL);

  if (buf[0])
    {
      char *ptr = (char*) ksi_malloc_data (strlen (buf));
      strcpy (ptr, buf);
      return ptr;
    }

  return ksi_aprintf ("%s: error code 0x%x", msg, err);
}

const char*
ksi_get_last_error (char *msg)
{
  return ksi_win_error_text (msg, GetLastError ());
}

#endif

/* End of code */
