/*
  Copyright (C) 2004-2005 Tommi Tervonen, Petteri Klemola, Pasi Orovuo

  This file is part of Kajaani Kombat.

  Kajaani Kombat is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  Kajaani Kombat is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with Kajaani Kombat; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef __PLAYER_H
#define __PLAYER_H

#include "SDL.h"
#include "SDL_net.h"
#include <string>
#include "connects.h"

const SDL_Color PLAYER_COLORS[MAX_PLAYERS+1] = {
  { 200, 23, 6, 255 },
  { 209, 70, 176, 255 },
  { 242, 229, 24, 255 },
  { 0, 73, 243, 255 },
  { 255, 255, 255, 255}
};

using namespace std;

class player
{
public:
  player(connects *conn, const string& _name);
  player (const player&);
  player();

  bool is_connected() const;
  bool is_alive() const;

  void disconnect();

  void kill();
  void rebirth();

  void win();

  int get_kredits() const;
  void set_kredits(int x);
  int get_wins() const;
  const string & get_name() const;
  SDL_Color get_color() const;
  connects * get_connect();

  void put_character(int ch);
  int get_character() const;

protected:
  bool alive;
  connects *conns;
  string name;
  SDL_Color color;
  bool ready_to_change;
  int wins, kredits, character;

    
};


#endif
