/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.contrib.demo;

import com.sun.jna.platform.WindowUtils;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Calendar;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.MouseInputAdapter;

public class ShapedWindowDemo {
    public static final int ICON_SIZE = 64;

    public static void main(String[] args) {
        try {
            System.setProperty("sun.java2d.noddraw", "true");
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        final JFrame frame = new JFrame("Shaped Window Demo");
        MouseInputAdapter handler = new MouseInputAdapter(){
            private Point offset;

            private void showPopup(MouseEvent e) {
                JPopupMenu m = new JPopupMenu();
                m.add(new AbstractAction("Hide"){
                    private static final long serialVersionUID = 1L;

                    public void actionPerformed(ActionEvent e) {
                        frame.setState(1);
                    }
                });
                m.add(new AbstractAction("Close"){
                    private static final long serialVersionUID = 1L;

                    public void actionPerformed(ActionEvent e) {
                        System.exit(0);
                    }
                });
                m.pack();
                m.show(e.getComponent(), e.getX(), e.getY());
            }

            public void mousePressed(MouseEvent e) {
                this.offset = e.getPoint();
                if (e.isPopupTrigger()) {
                    this.showPopup(e);
                }
            }

            public void mouseDragged(MouseEvent e) {
                if (!SwingUtilities.isLeftMouseButton(e)) {
                    return;
                }
                Point where = e.getPoint();
                where.translate(-this.offset.x, -this.offset.y);
                Point loc = frame.getLocationOnScreen();
                loc.translate(where.x, where.y);
                frame.setLocation(loc.x, loc.y);
            }

            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.showPopup(e);
                }
            }
        };
        frame.addMouseListener(handler);
        frame.addMouseMotionListener(handler);
        ClockFace face = new ClockFace(new Dimension(150, 150));
        frame.getContentPane().setCursor(Cursor.getPredefinedCursor(13));
        frame.getContentPane().add(face);
        frame.setUndecorated(true);
        try {
            Area mask = new Area(new Ellipse2D.Float(0.0f, 0.0f, 150.0f, 150.0f));
            WindowUtils.setWindowMask((Window)frame, mask);
            if (WindowUtils.isWindowAlphaSupported()) {
                WindowUtils.setWindowAlpha(frame, 0.7f);
            }
            frame.setIconImage(face.getIconImage());
            frame.setResizable(false);
            frame.setDefaultCloseOperation(3);
            frame.pack();
            frame.setLocation(100, 100);
            frame.setVisible(true);
        }
        catch (UnsatisfiedLinkError e) {
            e.printStackTrace();
            String msg = e.getMessage() + "\nError loading the JNA library";
            JTextArea area = new JTextArea(msg);
            area.setOpaque(false);
            area.setFont(UIManager.getFont("Label.font"));
            area.setEditable(false);
            area.setColumns(80);
            area.setRows(8);
            area.setWrapStyleWord(true);
            area.setLineWrap(true);
            JOptionPane.showMessageDialog(frame, new JScrollPane(area), "Library Load Error: " + System.getProperty("os.name") + "/" + System.getProperty("os.arch"), 0);
            System.exit(1);
        }
    }

    private static class ClockFace
    extends JComponent {
        private static final long serialVersionUID = 1L;
        private Stroke border;
        private Stroke secondHand;
        private Stroke minuteHand;
        private Stroke hourHand;
        private Stroke ticks;

        public ClockFace(Dimension size) {
            this.setPreferredSize(size);
            this.setSize(size);
            this.setOpaque(false);
            Timer timer = new Timer(1000, new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ClockFace.this.repaint();
                    Window w = SwingUtilities.getWindowAncestor(ClockFace.this);
                    while (!(w instanceof Frame)) {
                        w = w.getOwner();
                    }
                    if (w instanceof Frame) {
                        ((Frame)w).setIconImage(ClockFace.this.getIconImage());
                    }
                }
            });
            timer.setRepeats(true);
            timer.start();
        }

        private String getRomanNumeral(int number) {
            switch (number) {
                case 1: {
                    return "I";
                }
                case 2: {
                    return "II";
                }
                case 3: {
                    return "III";
                }
                case 4: {
                    return "IV";
                }
                case 5: {
                    return "V";
                }
                case 6: {
                    return "VI";
                }
                case 7: {
                    return "VII";
                }
                case 8: {
                    return "VIII";
                }
                case 9: {
                    return "IX";
                }
                case 10: {
                    return "X";
                }
                case 11: {
                    return "XI";
                }
            }
            return "XII";
        }

        protected void paintComponent(Graphics graphics) {
            this.paintFace(graphics, Math.min(this.getWidth(), this.getHeight()));
        }

        protected void paintFace(Graphics graphics, int size) {
            int i;
            Point center = new Point(size / 2, size / 2);
            int radius = center.x;
            int margin = radius / 20;
            int w = size;
            this.border = new BasicStroke(Math.max(1.0f, (float)w / 150.0f), 1, 1);
            this.secondHand = new BasicStroke(Math.max(1.0f, (float)w / 75.0f), 1, 1);
            this.minuteHand = new BasicStroke(Math.max(1.0f, (float)w / 38.0f), 1, 1);
            this.hourHand = new BasicStroke(Math.max(1.5f, (float)w / 20.0f), 1, 1);
            this.ticks = new BasicStroke(1.0f);
            Graphics2D g = (Graphics2D)graphics.create();
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            Color bg = this.getBackground();
            g.setColor(new Color(bg.getRed(), bg.getGreen(), bg.getBlue()));
            g.fill(new Ellipse2D.Float(0.0f, 0.0f, size, size));
            Font font = this.getFont();
            g.setFont(font.deriveFont(1, size / 12));
            g.setColor(new Color(0, 0, 0, 128));
            g.setStroke(this.border);
            g.draw(new Ellipse2D.Float(0.0f, 0.0f, size - 1, size - 1));
            g.draw(new Ellipse2D.Float(margin, margin, size - margin * 2 - 1, size - margin * 2 - 1));
            Calendar c = Calendar.getInstance();
            int minute = c.get(12);
            int hour = c.get(10);
            int second = c.get(13);
            g.translate(center.x, center.y);
            g.setColor(this.getForeground());
            int numbers = radius * 3 / 4;
            for (i = 0; i < 12; ++i) {
                double theta = Math.PI * 2 * (double)i / 12.0;
                String str = this.getRomanNumeral((i + 2) % 12 + 1);
                Rectangle2D rect = g.getFontMetrics().getStringBounds(str, g);
                g.drawString(str, (float)Math.round((double)numbers * Math.cos(theta) - rect.getWidth() / 2.0), (float)Math.round((double)numbers * Math.sin(theta) + (double)(margin * 2)));
            }
            for (i = 0; i < 60; ++i) {
                g.setColor(this.getForeground());
                g.setStroke(this.ticks);
                g.drawLine(radius - margin * 2, 0, radius - margin, 0);
                if (i % 5 == 0) {
                    g.drawLine(radius - margin * 3, 0, radius - margin, 0);
                }
                if ((i + 15) % 60 == minute) {
                    g.setStroke(this.minuteHand);
                    g.drawLine(0, 0, radius - margin * 4, 0);
                }
                if ((i + 15) % 60 == hour * 5 + minute * 5 / 60) {
                    g.setStroke(this.hourHand);
                    g.drawLine(0, 0, radius / 2, 0);
                }
                if ((i + 15) % 60 == second) {
                    g.setColor(new Color(255, 0, 0, 128));
                    g.setStroke(this.secondHand);
                    g.drawLine(0, 0, radius - margin * 4, 0);
                }
                g.rotate(0.10471975511965977);
            }
            g.dispose();
        }

        public Image getIconImage() {
            BufferedImage image = new BufferedImage(64, 64, 2);
            Graphics2D g = image.createGraphics();
            g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            Composite old = g.getComposite();
            g.setComposite(AlphaComposite.Clear);
            g.fillRect(0, 0, image.getWidth(), image.getHeight());
            g.setComposite(old);
            this.paintFace(g, 64);
            return image;
        }
    }
}

