/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.win32.COM.util.office;

import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.COM.Helper;
import com.sun.jna.platform.win32.COM.util.AbstractComEventCallbackListener;
import com.sun.jna.platform.win32.COM.util.Factory;
import com.sun.jna.platform.win32.COM.util.IComEventCallbackCookie;
import com.sun.jna.platform.win32.COM.util.office.excel.ComExcel_Application;
import com.sun.jna.platform.win32.COM.util.office.excel.ComIAppEvents;
import com.sun.jna.platform.win32.COM.util.office.excel.ComIApplication;
import com.sun.jna.platform.win32.COM.util.office.excel.ComIRange;
import com.sun.jna.platform.win32.COM.util.office.excel.ComIWorkbook;
import com.sun.jna.platform.win32.COM.util.office.excel.ComIWorksheet;
import com.sun.jna.platform.win32.Ole32;
import java.io.File;
import java.io.IOException;

public class MSOfficeExcelDemo {
    private static final String currentWorkingDir = new File("").getAbsolutePath() + File.separator;

    public static void main(String[] argv) throws IOException {
        Ole32.INSTANCE.CoInitializeEx(Pointer.NULL, 0);
        try {
            MSOfficeExcelDemo.testExcel();
        }
        finally {
            Ole32.INSTANCE.CoUninitialize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void testExcel() throws IOException {
        File demoDocument = null;
        ComIApplication msExcel = null;
        Factory factory = new Factory();
        try {
            System.out.println("Files in temp dir: " + Helper.tempDir.getAbsolutePath());
            ComExcel_Application excelObject = factory.createObject(ComExcel_Application.class);
            msExcel = excelObject.queryInterface(ComIApplication.class);
            System.out.println("MSExcel version: " + msExcel.getVersion());
            msExcel.setVisible(true);
            Helper.sleep(5);
            demoDocument = Helper.createNotExistingFile("jnatest", ".xls");
            Helper.extractClasspathFileToReal("/com/sun/jna/platform/win32/COM/util/office/resources/jnatest.xls", demoDocument);
            ComIWorkbook workbook = msExcel.getWorkbooks().Open(demoDocument.getAbsolutePath());
            msExcel.getActiveSheet().getRange("A1").setValue("Hello from JNA!");
            Helper.sleep(1);
            File output = new File(Helper.tempDir, "jnatest.xls");
            output.delete();
            workbook.SaveAs(output.getAbsolutePath());
            msExcel.getActiveWorkbook().Close(false);
            msExcel.getWorkbooks().Open(output.getAbsolutePath());
            msExcel.getActiveSheet().getRange("A2").setValue("Hello again from JNA!");
            class Listener
            extends AbstractComEventCallbackListener
            implements ComIAppEvents {
                volatile boolean SheetSelectionChange_called;

                Listener() {
                }

                public void errorReceivingCallbackEvent(String message, Exception exception) {
                }

                public void SheetSelectionChange(ComIWorksheet sheet, ComIRange target) {
                    this.SheetSelectionChange_called = true;
                }
            }
            Listener listener = new Listener();
            IComEventCallbackCookie cookie = msExcel.advise(ComIAppEvents.class, listener);
            Helper.sleep(1);
            msExcel.getActiveSheet().getRange("A5").Activate();
            Helper.sleep(1);
            msExcel.unadvise(ComIAppEvents.class, cookie);
            System.out.println("Listener was fired: " + listener.SheetSelectionChange_called);
            msExcel.getActiveWorkbook().Close(false);
        }
        finally {
            if (null != msExcel) {
                msExcel.Quit();
            }
            factory.disposeAll();
            if (demoDocument != null && demoDocument.exists()) {
                demoDocument.delete();
            }
        }
    }
}

