/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.registry.format;

import com.atlassian.clover.api.instrumentation.ConcurrentInstrumentationException;
import com.atlassian.clover.api.registry.CloverRegistryException;
import com.atlassian.clover.registry.ReadOnlyRegistryException;
import com.atlassian.clover.registry.RegistryFormatException;
import com.atlassian.clover.registry.RegistryUpdate;
import com.atlassian.clover.registry.format.InaccessibleRegFileException;
import com.atlassian.clover.registry.format.InstrSessionSegment;
import com.atlassian.clover.registry.format.NoSuchRegistryFileException;
import com.atlassian.clover.registry.format.RegAccessMode;
import com.atlassian.clover.registry.format.RegContents;
import com.atlassian.clover.registry.format.RegContentsConsumer;
import com.atlassian.clover.registry.format.RegFile;
import com.atlassian.clover.registry.format.RegHeader;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdatableRegFile
extends RegFile<UpdatableRegFile> {
    private final RegHeader header;

    public UpdatableRegFile(File file) throws IOException, NoSuchRegistryFileException, InaccessibleRegFileException, RegistryFormatException {
        this(UpdatableRegFile.ensureFileAccessible(file), RegHeader.readFrom(file));
    }

    UpdatableRegFile(File file, RegHeader header) throws NoSuchRegistryFileException, InaccessibleRegFileException {
        super(UpdatableRegFile.ensureFileAccessible(file));
        this.header = header;
    }

    private long calcMinSessionPosition() {
        return this.header.getCoverageLocation() == -1L ? 308L : this.header.getCoverageLocation();
    }

    public RegHeader getHeader() {
        return this.header;
    }

    private RegContents startReading() throws IOException {
        return new RegContents(new RandomAccessFile(this.getFile(), "r"), this.header.getCoverageLocation(), this.header.getLastSessionLocation(), this.calcMinSessionPosition());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readContents(RegContentsConsumer consumer) throws IOException, CloverRegistryException {
        RegContents contents = this.startReading();
        try {
            consumer.consume(contents);
        }
        finally {
            contents.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdatableRegFile saveImpl(List<? extends RegistryUpdate> deltas) throws IOException, CloverRegistryException {
        if (deltas.size() == 0) {
            throw new IllegalArgumentException("At least one registry update is required");
        }
        if (this.header.getAccessMode() == RegAccessMode.READONLY) {
            throw new ReadOnlyRegistryException();
        }
        File registryFile = this.getFile();
        RandomAccessFile randomAccessFile = new RandomAccessFile(registryFile, "rw");
        try {
            FileChannel channel = randomAccessFile.getChannel();
            LinkedList<InstrSessionSegment> sessions = new LinkedList<InstrSessionSegment>();
            RegHeader currentHeader = RegHeader.readFrom(this.getFile().getAbsolutePath(), channel);
            if (currentHeader.getVersion() != this.header.getVersion()) {
                throw new ConcurrentInstrumentationException(new StringBuffer().append("The on-disk registry version (").append(currentHeader.getVersion()).append(") differs from the in-memory version (").append(this.header.getVersion()).append(")").toString());
            }
            int maxSlotLength = this.header.getSlotCount();
            long latestVersion = System.currentTimeMillis();
            channel.position(this.header.getLastSessionLocation() + 1L);
            for (RegistryUpdate updatableRegFile : deltas) {
                latestVersion = updatableRegFile.getVersion();
                maxSlotLength = Math.max(maxSlotLength, updatableRegFile.getSlotCount());
                InstrSessionSegment session = new InstrSessionSegment(updatableRegFile.getVersion(), updatableRegFile.getStartTs(), updatableRegFile.getEndTs(), this.toRecords(updatableRegFile.getFileInfos()), updatableRegFile.getContextStore());
                session.write(channel);
                sessions.add(session);
            }
            RegHeader header = new RegHeader(this.header.getAccessMode(), latestVersion, maxSlotLength, this.header.getCoverageLocation(), channel.position() - 1L, this.getName());
            channel.position(0L);
            header.write(channel);
            registryFile.setLastModified(latestVersion);
            UpdatableRegFile updatableRegFile = new UpdatableRegFile(this.getFile(), header);
            return updatableRegFile;
        }
        finally {
            randomAccessFile.close();
        }
    }

    @Override
    public String getName() {
        return this.header.getName();
    }

    public long getVersion() {
        return this.header.getVersion();
    }

    @Override
    public RegAccessMode getAccessMode() {
        return this.header.getAccessMode();
    }

    public int getSlotCount() {
        return this.header.getSlotCount();
    }

    private static File ensureFileAccessible(File file) throws NoSuchRegistryFileException, InaccessibleRegFileException {
        File absFile = file.getAbsoluteFile();
        if (!absFile.exists()) {
            throw new NoSuchRegistryFileException(new StringBuffer().append("Clover registry file: ").append(absFile.getAbsolutePath()).append(" does not exist.").toString());
        }
        if (!absFile.isFile()) {
            throw new InaccessibleRegFileException(new StringBuffer().append("Clover registry file: ").append(absFile.getAbsolutePath()).append(" is not a file.").toString());
        }
        if (!absFile.canRead()) {
            throw new InaccessibleRegFileException(new StringBuffer().append("Clover registry file: ").append(absFile.getAbsolutePath()).append(" can not be read by Clover. Please ensure read/write access is granted to this file.").toString());
        }
        return absFile;
    }

    @Override
    public boolean isAppendable() {
        try {
            return RegHeader.readFrom(this.getFile()).getVersion() == this.header.getVersion();
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public /* synthetic */ RegFile saveImpl(List x0) throws IOException, CloverRegistryException {
        return this.saveImpl(x0);
    }
}

