/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.recorder;

import com.atlassian.clover.recorder.BaseCoverageRecording;
import com.atlassian.clover.recorder.FOSFactory;
import com.atlassian.clover.recorder.LiveGlobalCoverageRecording;
import com.atlassian.clover.util.CoverageUtils;
import com.atlassian.clover.util.FileUtils;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

public class FileBasedGlobalCoverageRecording
extends BaseCoverageRecording
implements LiveGlobalCoverageRecording {
    static final Class[] REQUIRED_CLASSES;
    private static final boolean USE_RLE_COMPRESSION;
    private final int[][] elements;
    private final int numElements;
    static /* synthetic */ Class class$java$io$BufferedOutputStream;
    static /* synthetic */ Class class$java$io$OutputStream;
    static /* synthetic */ Class class$java$util$zip$DeflaterOutputStream;
    static /* synthetic */ Class class$java$util$zip$Deflater;
    static /* synthetic */ Class class$com$atlassian$clover$util$CoverageUtils;
    static /* synthetic */ Class class$java$io$FileNotFoundException;
    static /* synthetic */ Class class$java$lang$ArrayIndexOutOfBoundsException;
    static /* synthetic */ Class class$java$io$IOException;
    static /* synthetic */ Class class$java$io$DataOutputStream;
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class class$java$io$FileOutputStream;
    static /* synthetic */ Class class$com$atlassian$clover$recorder$FOSFactory;
    static /* synthetic */ Class class$com$atlassian$clover$recorder$BaseCoverageRecording$Header;

    public FileBasedGlobalCoverageRecording(String path, long dbVersion, long timeStamp, int[][] elements, int numElements) {
        super(new BaseCoverageRecording.Header(dbVersion, timeStamp, 0), new File(path));
        this.elements = elements;
        this.numElements = numElements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String write() throws IOException {
        File file = this.createCoverageFolderFor(this.fileOnDisk);
        DataOutputStream out = new DataOutputStream(FileUtils.createDeflateOutputStream(file));
        try {
            this.header.write(out);
            out.writeInt(this.numElements);
            if (USE_RLE_COMPRESSION) {
                CoverageUtils.rleCompressAndWriteCoverage(out, this.elements, this.numElements);
            } else {
                CoverageUtils.writeUncompressedCoverage(out, this.elements, this.numElements);
            }
            out.flush();
        }
        finally {
            FileUtils.close(out);
        }
        return file.getAbsolutePath();
    }

    static void flushToDisk(String dbname, long dbversion, long writeTS, int[] elements) throws IOException {
        new FileBasedGlobalCoverageRecording(dbname, dbversion, writeTS, new int[][]{elements}, elements.length).write();
    }

    static {
        Class<?> clazz;
        Class<?> clazz2;
        Class<?> clazz3;
        Class clazz4;
        Class clazz5;
        Class clazz6;
        Class clazz7;
        Class clazz8;
        Class clazz9;
        Class clazz10;
        Class[] classArray = new Class[15];
        Class clazz11 = class$java$io$IOException;
        if (clazz11 == null) {
            clazz11 = classArray[0] = (class$java$io$IOException = new IOException[0].getClass().getComponentType());
        }
        if ((clazz10 = class$java$io$DataOutputStream) == null) {
            clazz10 = classArray[1] = (class$java$io$DataOutputStream = new DataOutputStream[0].getClass().getComponentType());
        }
        if ((clazz9 = class$java$io$OutputStream) == null) {
            clazz9 = classArray[2] = (class$java$io$OutputStream = new OutputStream[0].getClass().getComponentType());
        }
        if ((clazz8 = class$java$io$FileNotFoundException) == null) {
            clazz8 = classArray[3] = (class$java$io$FileNotFoundException = new FileNotFoundException[0].getClass().getComponentType());
        }
        if ((clazz7 = class$java$io$BufferedOutputStream) == null) {
            clazz7 = classArray[4] = (class$java$io$BufferedOutputStream = new BufferedOutputStream[0].getClass().getComponentType());
        }
        if ((clazz6 = class$java$io$FileOutputStream) == null) {
            clazz6 = classArray[5] = (class$java$io$FileOutputStream = new FileOutputStream[0].getClass().getComponentType());
        }
        if ((clazz5 = class$java$util$zip$Deflater) == null) {
            clazz5 = classArray[6] = (class$java$util$zip$Deflater = new Deflater[0].getClass().getComponentType());
        }
        if ((clazz4 = class$java$util$zip$DeflaterOutputStream) == null) {
            clazz4 = classArray[7] = (class$java$util$zip$DeflaterOutputStream = new DeflaterOutputStream[0].getClass().getComponentType());
        }
        if ((clazz3 = class$com$atlassian$clover$recorder$FOSFactory) == null) {
            clazz3 = class$com$atlassian$clover$recorder$FOSFactory = new FOSFactory[0].getClass().getComponentType();
        }
        classArray[8] = clazz3;
        classArray[9] = FOSFactory.REQUIRED_CLASSES.getClass();
        Class clazz12 = class$com$atlassian$clover$recorder$BaseCoverageRecording$Header;
        if (clazz12 == null) {
            clazz12 = classArray[10] = (class$com$atlassian$clover$recorder$BaseCoverageRecording$Header = new BaseCoverageRecording.Header[0].getClass().getComponentType());
        }
        if ((clazz2 = class$java$io$File) == null) {
            clazz2 = class$java$io$File = new File[0].getClass().getComponentType();
        }
        classArray[11] = clazz2;
        classArray[12] = FileUtils.getInstance().getClass();
        Class clazz13 = class$com$atlassian$clover$util$CoverageUtils;
        if (clazz13 == null) {
            clazz13 = classArray[13] = (class$com$atlassian$clover$util$CoverageUtils = new CoverageUtils[0].getClass().getComponentType());
        }
        if ((clazz = class$java$lang$ArrayIndexOutOfBoundsException) == null) {
            clazz = class$java$lang$ArrayIndexOutOfBoundsException = new ArrayIndexOutOfBoundsException[0].getClass().getComponentType();
        }
        classArray[14] = clazz;
        REQUIRED_CLASSES = classArray;
        USE_RLE_COMPRESSION = Boolean.valueOf(System.getProperty("clover.rle.coverage", Boolean.TRUE.toString()));
    }
}

