/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.instr.java;

import clover.retrotranslator.net.sf.retrotranslator.runtime.java.lang._Integer;
import clover.retrotranslator.net.sf.retrotranslator.runtime.java.lang._String;
import com.atlassian.clover.instr.Bindings;
import com.atlassian.clover.instr.java.Emitter;
import com.atlassian.clover.instr.java.InstrumentationConfig;
import com.atlassian.clover.instr.java.InstrumentationState;
import com_cenqua_clover.CloverProfile;
import com_cenqua_clover.CloverVersionInfo;
import com_cenqua_clover.CoverageRecorder;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecorderInstrEmitter
extends Emitter {
    private static final String INCOMPATIBLE_MSG = "[CLOVER] WARNING: The Clover version used in instrumentation does not match the runtime version. You need to run instrumented classes against the same version of Clover that you instrumented with.";
    private static final String DEFAULT_CLASSNOTFOUND_MSG = "[CLOVER] FATAL ERROR: Clover could not be initialised. Are you sure you have Clover in the runtime classpath?";
    private static final String UNEXPECTED_MSG = "[CLOVER] FATAL ERROR: Clover could not be initialised because of an unexpected error.";
    private boolean isEnum;
    private boolean reportInitErrors;
    private boolean classInstrStrategy;
    private String recorderPrefix;
    private long recorderCfg;
    private String initString;
    private long registryVersion;
    private int maxDataIndex;
    private String javaLangPrefix;
    private boolean testClass;
    private String distributedConfig;
    private String classNotFoundMsg;
    private boolean shouldEmitWarningMethod;
    private List<CloverProfile> profiles;
    static /* synthetic */ Class class$com_cenqua_clover$CloverProfile;
    static /* synthetic */ Class class$com_cenqua_clover$CoverageRecorder;

    public RecorderInstrEmitter(boolean isEnum) {
        this.isEnum = isEnum;
    }

    @Override
    public void init(InstrumentationState state) {
        this.recorderCfg = RecorderInstrEmitter.getConfigBits(state.getCfg());
        this.recorderPrefix = state.getRecorderPrefix();
        this.classInstrStrategy = state.getCfg().isClassInstrStrategy();
        this.reportInitErrors = state.getCfg().isReportInitErrors();
        this.initString = state.getCfg().getInitString();
        this.distributedConfig = state.getCfg().getDistributedConfigString();
        this.profiles = state.getCfg().getProfiles();
        this.registryVersion = state.getSession().getVersion();
        this.javaLangPrefix = state.getCfg().getJavaLangPrefix();
        this.testClass = state.isDetectTests();
        this.classNotFoundMsg = state.getCfg().getClassNotFoundMsg() != null ? state.getCfg().getClassNotFoundMsg() : DEFAULT_CLASSNOTFOUND_MSG;
        boolean bl = this.shouldEmitWarningMethod = !state.hasInstrumented();
        if (!state.hasInstrumented()) {
            state.setHasInstrumented(true);
        }
    }

    @Override
    public String getInstr() {
        String instrString;
        if (this.classInstrStrategy || this.isEnum) {
            String recorderBase = this.recorderPrefix.substring(0, this.recorderPrefix.lastIndexOf(46));
            String recorderSuffix = this.recorderPrefix.substring(this.recorderPrefix.lastIndexOf(46) + 1);
            instrString = new StringBuffer().append(this.testClass ? "" : "public ").append("static class ").append(recorderBase).append("{").toString();
            StringBuffer stringBuffer = new StringBuffer().append(instrString).append("public static ");
            Class<?> clazz = class$com_cenqua_clover$CoverageRecorder;
            if (clazz == null) {
                clazz = class$com_cenqua_clover$CoverageRecorder = new CoverageRecorder[0].getClass().getComponentType();
            }
            instrString = stringBuffer.append(clazz.getName()).append(" ").append(recorderSuffix).append(";").toString();
            instrString = new StringBuffer().append(instrString).append(RecorderInstrEmitter.generateCloverProfilesField(this.profiles)).toString();
            instrString = new StringBuffer().append(instrString).append("static{").toString();
            StringBuffer stringBuffer2 = new StringBuffer().append(instrString);
            Class<?> clazz2 = class$com_cenqua_clover$CoverageRecorder;
            if (clazz2 == null) {
                clazz2 = class$com_cenqua_clover$CoverageRecorder = new CoverageRecorder[0].getClass().getComponentType();
            }
            instrString = stringBuffer2.append(clazz2.getName()).append(" _").append(recorderSuffix).append("=null;").toString();
            if (this.reportInitErrors) {
                instrString = new StringBuffer().append(instrString).append("try{").append(this.shouldEmitWarningMethod ? new StringBuffer().append(Bindings.$CloverVersionInfo$oldVersionInClasspath()).append(";").toString() : "").append("if(").append(CloverVersionInfo.getBuildStamp()).append("L!=").append(Bindings.$CloverVersionInfo$getBuildStamp()).append(")").append("{").append(Bindings.$Clover$l("\"[CLOVER] WARNING: The Clover version used in instrumentation does not match the runtime version. You need to run instrumented classes against the same version of Clover that you instrumented with.\"")).append(";").append(Bindings.$Clover$l(new StringBuffer().append("\"[CLOVER] WARNING: Instr=").append(CloverVersionInfo.getReleaseNum()).append("#").append(CloverVersionInfo.getBuildStamp()).append(",Runtime=\"+").append(Bindings.$CloverVersionInfo$getReleaseNum()).append("+\"#\"+").append(Bindings.$CloverVersionInfo$getBuildStamp()).toString())).append(";}").toString();
            }
            instrString = new StringBuffer().append(instrString).append(recorderSuffix).append("=").append(Bindings.$Clover$getNullRecorder()).append(";").toString();
            instrString = new StringBuffer().append(instrString).append("_").append(recorderSuffix).append("=").append(Bindings.$Clover$getNullRecorder()).append(";").toString();
            instrString = new StringBuffer().append(instrString).append("_").append(recorderSuffix).append("=").append(Bindings.$Clover$getRecorder(RecorderInstrEmitter.asUnicodeString(this.initString), new StringBuffer().append(this.registryVersion).append("L").toString(), new StringBuffer().append(this.recorderCfg).append("L").toString(), Integer.toString(this.maxDataIndex), "profiles", new StringBuffer().append("new String[]{\"clover.distributed.coverage\",").append(RecorderInstrEmitter.asUnicodeString(this.distributedConfig)).append("}").toString())).append(";").toString();
            if (this.reportInitErrors) {
                instrString = new StringBuffer().append(instrString).append("}catch(").append(this.javaLangPrefix).append("SecurityException e){").append(this.javaLangPrefix).append("System.err.println(\"").append("[CLOVER] FATAL ERROR: Clover could not be initialised because it has insufficient security privileges. Please consult the Clover documentation on the security policy file changes required.").append(" (\"+e.getClass()+\":\"+e.getMessage()+\")\");").toString();
                instrString = new StringBuffer().append(instrString).append("}catch(").append(this.javaLangPrefix).append("NoClassDefFoundError e){").append(this.javaLangPrefix).append("System.err.println(\"").append(this.classNotFoundMsg).append(" (\"+e.getClass()+\":\"+e.getMessage()+\")\");").toString();
                instrString = new StringBuffer().append(instrString).append("}catch(").append(this.javaLangPrefix).append("Throwable t){").append(this.javaLangPrefix).append("System.err.println(\"").append(UNEXPECTED_MSG).append(" (\"+t.getClass()+\":\"+t.getMessage()+\")\");}").toString();
            }
            instrString = new StringBuffer().append(instrString).append(recorderSuffix).append("=").append("_").append(recorderSuffix).append(";").toString();
            instrString = new StringBuffer().append(instrString).append("}}").toString();
        } else {
            StringBuffer stringBuffer = new StringBuffer().append("public static ");
            Class<?> clazz = class$com_cenqua_clover$CoverageRecorder;
            if (clazz == null) {
                clazz = class$com_cenqua_clover$CoverageRecorder = new CoverageRecorder[0].getClass().getComponentType();
            }
            instrString = stringBuffer.append(clazz.getName()).append(" ").append(this.recorderPrefix).append("=").append(Bindings.$Clover$getRecorder(RecorderInstrEmitter.asUnicodeString(this.initString), new StringBuffer().append(this.registryVersion).append("L").toString(), new StringBuffer().append(this.recorderCfg).append("L").toString(), Integer.toString(this.maxDataIndex), RecorderInstrEmitter.generateCloverProfilesInline(this.profiles), new StringBuffer().append("new String[]{\"clover.distributed.coverage\",").append(RecorderInstrEmitter.asUnicodeString(this.distributedConfig)).append("}").toString())).append(";").toString();
        }
        return instrString;
    }

    static String generateCloverProfilesField(List<CloverProfile> profiles) {
        StringBuffer stringBuffer = new StringBuffer().append("public static ");
        Class<?> clazz = class$com_cenqua_clover$CloverProfile;
        if (clazz == null) {
            clazz = class$com_cenqua_clover$CloverProfile = new CloverProfile[0].getClass().getComponentType();
        }
        String str = stringBuffer.append(clazz.getName()).append("[] profiles = { ").toString();
        str = new StringBuffer().append(str).append(RecorderInstrEmitter.generateCloverProfilesNewInstances(profiles)).toString();
        str = new StringBuffer().append(str).append("};").toString();
        return str;
    }

    public static String generateCloverProfilesInline(List<CloverProfile> profiles) {
        StringBuffer stringBuffer = new StringBuffer().append("new ");
        Class<?> clazz = class$com_cenqua_clover$CloverProfile;
        if (clazz == null) {
            clazz = class$com_cenqua_clover$CloverProfile = new CloverProfile[0].getClass().getComponentType();
        }
        return stringBuffer.append(clazz.getName()).append("[] {").append(RecorderInstrEmitter.generateCloverProfilesNewInstances(profiles)).append("}").toString();
    }

    private static String generateCloverProfilesNewInstances(List<CloverProfile> profiles) {
        String str = "";
        if (profiles != null) {
            Iterator<CloverProfile> iter = profiles.iterator();
            while (iter.hasNext()) {
                CloverProfile profile = iter.next();
                StringBuffer stringBuffer = new StringBuffer().append(str).append("new ");
                Class<?> clazz = class$com_cenqua_clover$CloverProfile;
                if (clazz == null) {
                    clazz = new CloverProfile[0].getClass().getComponentType();
                }
                str = stringBuffer.append(clazz.getName()).append("(").toString();
                str = new StringBuffer().append(str).append(RecorderInstrEmitter.asUnicodeString(profile.getName())).append(", ").toString();
                str = new StringBuffer().append(str).append("\"").append(profile.getCoverageRecorder()).append("\", ").toString();
                str = profile.getDistributedCoverage() != null ? new StringBuffer().append(str).append(RecorderInstrEmitter.asUnicodeString(profile.getDistributedCoverage().getConfigString())).append(")").toString() : new StringBuffer().append(str).append("null)").toString();
                if (!iter.hasNext()) continue;
                str = new StringBuffer().append(str).append(",").toString();
            }
        }
        return str;
    }

    public static String asUnicodeString(String str) {
        if (str == null) {
            return "null";
        }
        String res = "\"";
        for (char c : str.toCharArray()) {
            res = c == '\\' ? new StringBuffer().append(res).append(_String.format(Locale.US, "\\u%04x\\u%04x", new Object[]{_Integer.valueOf(c), _Integer.valueOf(c)})).toString() : new StringBuffer().append(res).append(_String.format(Locale.US, "\\u%04x", new Object[]{_Integer.valueOf(c)})).toString();
        }
        res = new StringBuffer().append(res).append("\"").toString();
        return res;
    }

    public void setMaxDataIndex(int maxIndex) {
        this.maxDataIndex = maxIndex;
    }

    private static long getConfigBits(InstrumentationConfig cfg) {
        return CoverageRecorder.getConfigBits(cfg.getFlushPolicy(), cfg.getFlushInterval(), false, false, !cfg.isSliceRecording());
    }
}

