/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.instr;

import com.atlassian.clover.api.CloverException;
import com.atlassian.clover.api.instrumentation.ConcurrentInstrumentationException;
import com.atlassian.clover.api.instrumentation.InstrumentationSession;
import com.atlassian.clover.api.registry.MethodInfo;
import com.atlassian.clover.api.registry.PackageInfo;
import com.atlassian.clover.api.registry.SourceInfo;
import com.atlassian.clover.registry.ReadOnlyRegistryException;
import com.atlassian.clover.registry.RegistryUpdate;
import com.atlassian.clover.spi.lang.LanguageConstruct;
import com.cenqua.clover.context.ContextSet;
import com.cenqua.clover.context.ContextStore;
import com.cenqua.clover.registry.BaseFileInfo;
import com.cenqua.clover.registry.BranchInfo;
import com.cenqua.clover.registry.ClassInfo;
import com.cenqua.clover.registry.Clover2Registry;
import com.cenqua.clover.registry.FileInfo;
import com.cenqua.clover.registry.MethodSignature;
import com.cenqua.clover.registry.StatementInfo;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstrumentationSessionImpl
implements InstrumentationSession {
    private final Clover2Registry reg;
    private final long startVersion;
    private final LinkedList<ClassInfo> classStack;
    private final LinkedList<com.cenqua.clover.registry.MethodInfo> methodStack;
    private final Map<String, SessionPackageInfo> changedPackages;
    private final long startTS;
    private final long version;
    private long endTS;
    private SessionPackageInfo currentPackage;
    private FileInfo currentFile;
    private int currentFileIndex;
    private int currentOffsetFromFile;
    private String activeEncoding;
    private int nextIndexForNewFile;

    public InstrumentationSessionImpl(Clover2Registry reg, String activeEncoding) throws CloverException {
        this.activeEncoding = activeEncoding;
        if (reg.isReadOnly()) {
            throw new ReadOnlyRegistryException();
        }
        this.reg = reg;
        this.startVersion = reg.getVersion();
        this.classStack = new LinkedList();
        this.methodStack = new LinkedList();
        this.changedPackages = new HashMap<String, SessionPackageInfo>();
        this.nextIndexForNewFile = this.currentFileIndex = reg.getProject().getDataLength();
        this.startTS = this.endTS = System.currentTimeMillis();
        this.version = this.startTS > this.startVersion ? this.startTS : this.startVersion + 1L;
        this.currentOffsetFromFile = 0;
    }

    public RegistryUpdate finishAndApply() throws ConcurrentInstrumentationException {
        return this.reg.applyUpdate(this.startVersion, this.finish());
    }

    public Update finish() {
        this.endTS = System.currentTimeMillis();
        if (this.currentPackage != null) {
            this.exitPackage();
        }
        return new Update(this.version, this.startTS, System.currentTimeMillis(), this.nextIndexForNewFile, this.toPackages(this.changedPackages.values()), this.reg.getContextStore());
    }

    private Collection<com.cenqua.clover.registry.PackageInfo> toPackages(Collection<SessionPackageInfo> shadowPackageInfos) {
        LinkedList<com.cenqua.clover.registry.PackageInfo> pkgInfos = new LinkedList<com.cenqua.clover.registry.PackageInfo>();
        for (SessionPackageInfo shadowPackageInfo : shadowPackageInfos) {
            pkgInfos.add(shadowPackageInfo.getSessionPkg());
        }
        return pkgInfos;
    }

    @Override
    public int getCurrentIndex() {
        return this.currentFileIndex;
    }

    @Override
    public int getCurrentFileMaxIndex() {
        return this.currentFileIndex + this.currentOffsetFromFile;
    }

    @Override
    public int getCurrentOffsetFromFile() {
        return this.currentOffsetFromFile;
    }

    public Clover2Registry getRegistry() {
        return this.reg;
    }

    @Override
    public FileInfo enterFile(String packageName, File file, int lineCount, int ncLineCount, long timestamp, long filesize, long checksum) {
        this.currentOffsetFromFile = 0;
        this.enterPackage(packageName);
        FileInfo finfo = (FileInfo)this.currentPackage.getFileInPackage(file.getName());
        long minVersion = -1L;
        if (finfo != null) {
            if (finfo.getChecksum() == checksum && finfo.getFilesize() == filesize) {
                this.currentFileIndex = finfo.getDataIndex();
                minVersion = finfo.getMinVersion();
            } else {
                this.currentFileIndex = this.nextIndexForNewFile;
            }
        } else {
            this.currentFileIndex = this.nextIndexForNewFile;
        }
        finfo = new FileInfo(this.currentPackage.getSessionPkg(), file, this.activeEncoding, this.currentFileIndex, lineCount, ncLineCount, timestamp, filesize, checksum, this.version);
        if (minVersion != -1L) {
            finfo.addVersions(minVersion, this.startTS);
        }
        this.currentFile = finfo;
        return finfo;
    }

    @Override
    public void exitFile() {
        this.currentFile.setDataLength(this.currentOffsetFromFile);
        this.currentPackage.addFile(this.currentFile);
        this.nextIndexForNewFile = Math.max(this.currentFileIndex + this.currentOffsetFromFile, this.nextIndexForNewFile);
        this.currentPackage.setDataLength(Math.max(this.currentPackage.getDataLength(), this.currentFileIndex + this.currentOffsetFromFile - this.currentPackage.getDataIndex()));
        this.currentFile = null;
    }

    @Override
    public ClassInfo enterClass(String name, SourceInfo region, boolean isInterface, boolean isEnum, boolean isAnnotation) {
        ClassInfo clazz = new ClassInfo(this.currentPackage.getSessionPkg(), this.currentFile, this.currentOffsetFromFile, name, region, isInterface, isEnum, isAnnotation);
        this.currentFile.addClass(clazz);
        this.pushCurrentClass(clazz);
        return clazz;
    }

    @Override
    public ClassInfo exitClass(int endLine, int endCol) {
        ClassInfo clazz = this.popCurrentClass();
        clazz.setRegionEnd(endLine, endCol);
        clazz.setDataLength(this.currentOffsetFromFile - clazz.getRelativeDataIndex());
        if (this.getCurrentClass() != null) {
            this.getCurrentClass().increaseAggregatedStatements(clazz.getAggregatedStatementCount());
            this.getCurrentClass().increaseAggregatedComplexity(clazz.getAggregatedComplexity());
        }
        return this.getCurrentClass();
    }

    public com.cenqua.clover.registry.MethodInfo enterMethod(ContextSet context, SourceInfo region, MethodSignature signature, boolean test, int complexity) {
        return this.enterMethod(context, region, signature, test, complexity, LanguageConstruct.Builtin.METHOD);
    }

    @Override
    public com.cenqua.clover.registry.MethodInfo enterMethod(ContextSet context, SourceInfo region, MethodSignature signature, boolean test, int complexity, LanguageConstruct construct) {
        com.cenqua.clover.registry.MethodInfo method = new com.cenqua.clover.registry.MethodInfo(this.getCurrentClass(), this.currentOffsetFromFile, context, region, signature, test, complexity, construct);
        this.currentOffsetFromFile += method.getDataLength();
        this.pushCurrentMethod(method);
        return method;
    }

    public com.cenqua.clover.registry.MethodInfo enterMethod(ContextSet context, SourceInfo region, MethodSignature signature, boolean test) {
        return this.enterMethod(context, region, signature, test, 1);
    }

    @Override
    public void exitMethod(int endLine, int endCol) {
        com.cenqua.clover.registry.MethodInfo method = this.popCurrentMethod();
        method.setRegionEnd(endLine, endCol);
        method.setDataLength(this.currentOffsetFromFile - method.getRelativeDataIndex());
        int statementCount = method.getStatementCount();
        int complexity = method.getRawMetrics().getComplexity();
        method.increaseAggregatedStatementCount(statementCount);
        method.increaseAggregatedComplexity(complexity);
        if (this.getCurrentMethod() != null) {
            this.getCurrentMethod().increaseAggregatedStatementCount(method.getAggregatedStatementCount());
            this.getCurrentMethod().increaseAggregatedComplexity(method.getAggregatedComplexity());
        } else {
            this.getCurrentClass().increaseAggregatedStatements(method.getAggregatedStatementCount());
            this.getCurrentClass().increaseAggregatedComplexity(method.getAggregatedComplexity());
        }
        this.getCurrentClass().addMethod(method);
    }

    public StatementInfo addStatement(ContextSet context, SourceInfo region, int complexity) {
        return this.addStatement(context, region, complexity, LanguageConstruct.Builtin.STATEMENT);
    }

    @Override
    public StatementInfo addStatement(ContextSet context, SourceInfo region, int complexity, LanguageConstruct construct) {
        com.cenqua.clover.registry.MethodInfo currentMethod = this.getCurrentMethod();
        StatementInfo stmt = new StatementInfo(currentMethod, this.currentOffsetFromFile, context, region, complexity, construct);
        this.currentOffsetFromFile += stmt.getDataLength();
        currentMethod.addStatement(stmt);
        return stmt;
    }

    public BranchInfo addBranch(ContextSet context, SourceInfo region, boolean instrumented, int complexity) {
        return this.addBranch(context, region, instrumented, complexity, LanguageConstruct.Builtin.BRANCH);
    }

    @Override
    public BranchInfo addBranch(ContextSet context, SourceInfo region, boolean instrumented, int complexity, LanguageConstruct construct) {
        com.cenqua.clover.registry.MethodInfo currentMethod = this.getCurrentMethod();
        BranchInfo branch = null;
        if (currentMethod != null) {
            branch = new BranchInfo(currentMethod, this.currentOffsetFromFile, context, region, complexity, instrumented, construct);
            this.currentOffsetFromFile += branch.getDataLength();
            currentMethod.addBranch(branch);
        }
        return branch;
    }

    @Override
    public void setSourceEncoding(String encoding) {
        this.activeEncoding = encoding;
    }

    @Override
    public com.cenqua.clover.registry.PackageInfo enterPackage(String name) {
        SessionPackageInfo pkg;
        if (this.currentPackage != null) {
            if (this.currentPackage.isNamed(name)) {
                return this.currentPackage.getSessionPkg();
            }
            this.exitPackage();
        }
        if ((pkg = this.changedPackages.get(name)) == null) {
            com.cenqua.clover.registry.PackageInfo modelPkg = (com.cenqua.clover.registry.PackageInfo)this.reg.getProject().getNamedPackage(name);
            pkg = new SessionPackageInfo(modelPkg, new com.cenqua.clover.registry.PackageInfo(this.reg.getProject(), name, modelPkg == null ? this.currentFileIndex : modelPkg.getDataIndex()));
        }
        this.currentPackage = pkg;
        return this.currentPackage.getSessionPkg();
    }

    @Override
    public void exitPackage() {
        this.changedPackages.put(this.currentPackage.getName(), this.currentPackage);
        this.currentPackage = null;
    }

    @Override
    public FileInfo getCurrentFile() {
        return this.currentFile;
    }

    @Override
    public com.cenqua.clover.registry.PackageInfo getCurrentPackage() {
        return this.currentPackage.getSessionPkg();
    }

    @Override
    public ClassInfo getCurrentClass() {
        if (this.classStack.size() > 0) {
            return this.classStack.getLast();
        }
        return null;
    }

    public void pushCurrentClass(ClassInfo clazz) {
        this.classStack.add(clazz);
    }

    public ClassInfo popCurrentClass() {
        if (this.classStack.size() > 0) {
            return this.classStack.removeLast();
        }
        return null;
    }

    @Override
    public com.cenqua.clover.registry.MethodInfo getCurrentMethod() {
        if (this.methodStack.size() > 0) {
            return this.methodStack.getLast();
        }
        return null;
    }

    @Override
    public void close() throws ConcurrentInstrumentationException {
        this.finishAndApply();
    }

    public void pushCurrentMethod(com.cenqua.clover.registry.MethodInfo clazz) {
        this.methodStack.add(clazz);
    }

    public com.cenqua.clover.registry.MethodInfo popCurrentMethod() {
        if (this.methodStack.size() > 0) {
            return this.methodStack.removeLast();
        }
        return null;
    }

    @Override
    public long getStartTs() {
        return this.startTS;
    }

    @Override
    public long getEndTS() {
        return this.endTS;
    }

    @Override
    public long getVersion() {
        return this.version;
    }

    @Override
    public /* synthetic */ MethodInfo getCurrentMethod() {
        return this.getCurrentMethod();
    }

    @Override
    public /* synthetic */ com.atlassian.clover.api.registry.ClassInfo getCurrentClass() {
        return this.getCurrentClass();
    }

    @Override
    public /* synthetic */ PackageInfo getCurrentPackage() {
        return this.getCurrentPackage();
    }

    @Override
    public /* synthetic */ com.atlassian.clover.api.registry.FileInfo getCurrentFile() {
        return this.getCurrentFile();
    }

    @Override
    public /* synthetic */ MethodInfo enterMethod(ContextSet x0, SourceInfo x1, MethodSignature x2, boolean x3, int x4, LanguageConstruct x5) {
        return this.enterMethod(x0, x1, x2, x3, x4, x5);
    }

    @Override
    public /* synthetic */ com.atlassian.clover.api.registry.ClassInfo exitClass(int x0, int x1) {
        return this.exitClass(x0, x1);
    }

    @Override
    public /* synthetic */ com.atlassian.clover.api.registry.ClassInfo enterClass(String x0, SourceInfo x1, boolean x2, boolean x3, boolean x4) {
        return this.enterClass(x0, x1, x2, x3, x4);
    }

    @Override
    public /* synthetic */ com.atlassian.clover.api.registry.FileInfo enterFile(String x0, File x1, int x2, int x3, long x4, long x5, long x6) {
        return this.enterFile(x0, x1, x2, x3, x4, x5, x6);
    }

    @Override
    public /* synthetic */ PackageInfo enterPackage(String x0) {
        return this.enterPackage(x0);
    }

    public static class SessionPackageInfo {
        private com.cenqua.clover.registry.PackageInfo modelPkg;
        private com.cenqua.clover.registry.PackageInfo sessionPkg;

        public SessionPackageInfo(com.cenqua.clover.registry.PackageInfo modelPkg, com.cenqua.clover.registry.PackageInfo sessionPkg) {
            this.modelPkg = modelPkg;
            this.sessionPkg = sessionPkg;
        }

        public BaseFileInfo getFileInPackage(String name) {
            BaseFileInfo fileInfo = this.sessionPkg.getFileInPackage(name);
            if (fileInfo == null) {
                fileInfo = this.modelPkg == null ? null : this.modelPkg.getFileInPackage(name);
            }
            return fileInfo;
        }

        public com.cenqua.clover.registry.PackageInfo getModelPkg() {
            return this.modelPkg;
        }

        public com.cenqua.clover.registry.PackageInfo getSessionPkg() {
            return this.sessionPkg;
        }

        public int getDataIndex() {
            return this.sessionPkg.getDataIndex();
        }

        public int getDataLength() {
            return this.sessionPkg.getDataLength();
        }

        public void setDataLength(int len) {
            this.sessionPkg.setDataLength(len);
        }

        public void addFile(FileInfo currentFile) {
            this.sessionPkg.addFile(currentFile);
        }

        public boolean isNamed(String name) {
            return this.sessionPkg.isNamed(name);
        }

        public String getName() {
            return this.sessionPkg.getName();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Update
    implements RegistryUpdate {
        private final long version;
        private final long startTS;
        private final long endTS;
        private final int slotCount;
        private final Collection<com.cenqua.clover.registry.PackageInfo> changedPkgInfos;
        private final ContextStore ctxStore;
        private final List<FileInfo> fileInfos;

        public Update(long version, long startTS, long endTS, int slotCount, Collection<com.cenqua.clover.registry.PackageInfo> changedPkgInfos, ContextStore ctxStore) {
            this.version = version;
            this.startTS = startTS;
            this.endTS = endTS;
            this.slotCount = slotCount;
            this.changedPkgInfos = changedPkgInfos;
            this.ctxStore = ctxStore;
            this.fileInfos = this.collectFileInfos();
        }

        private List<FileInfo> collectFileInfos() {
            LinkedList<FileInfo> fileInfos = new LinkedList<FileInfo>();
            for (com.cenqua.clover.registry.PackageInfo newPkgInfo : this.changedPkgInfos) {
                for (FileInfo fileInfo : newPkgInfo.getFiles()) {
                    fileInfos.add(fileInfo);
                }
            }
            return fileInfos;
        }

        @Override
        public long getVersion() {
            return this.version;
        }

        @Override
        public long getStartTs() {
            return this.startTS;
        }

        @Override
        public long getEndTs() {
            return this.endTS;
        }

        @Override
        public int getSlotCount() {
            return this.slotCount;
        }

        @Override
        public List<FileInfo> getFileInfos() {
            return this.fileInfos;
        }

        public Collection<com.cenqua.clover.registry.PackageInfo> getChangedPkgInfos() {
            return this.changedPkgInfos;
        }

        @Override
        public ContextStore getContextStore() {
            return this.ctxStore;
        }
    }
}

