/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.ci;

import clover.retrotranslator.net.sf.retrotranslator.runtime.java.lang._String;
import com.atlassian.clover.api.ci.CIOptions;
import com.atlassian.clover.api.ci.Integrator;
import java.util.List;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenIntegrator
implements Integrator {
    static final String GROUP_ID = "com.atlassian.maven.plugins";
    static final String ARTIFACT_ID = "maven-clover2-plugin";
    static final String PREFIX = _String.format("%s::%s:", new Object[]{"com.atlassian.maven.plugins", "maven-clover2-plugin"});
    private final CIOptions options;

    public MavenIntegrator(CIOptions options) {
        this.options = options;
    }

    @Override
    public void decorateArguments(List<String> args) {
        if (this.options.isFullClean()) {
            args.add("clean");
        }
        args.add(new StringBuffer().append(PREFIX).append("setup").toString());
        if (this.options.isOptimize()) {
            args.add(new StringBuffer().append(PREFIX).append("optimize").toString());
            args.add("test");
            args.add(new StringBuffer().append(PREFIX).append("snapshot").toString());
        } else {
            args.add("verify");
            args.add(new StringBuffer().append(PREFIX).append("aggregate").toString());
            args.add(new StringBuffer().append(PREFIX).append("clover").toString());
            if (this.options.isHistorical()) {
                String histDir = this.options.getHistoryDir() != null ? this.options.getHistoryDir().getAbsolutePath() : ".cloverhistory";
                args.add(new StringBuffer().append("-Dmaven.clover.historyDir=").append(histDir).toString());
                args.add(new StringBuffer().append(PREFIX).append("save-history").toString());
            }
            args.add(new StringBuffer().append("-Dmaven.clover.generateJson=").append(this.options.isJson()).toString());
        }
        if (this.options.getLicenseCert() != null && !this.options.getLicenseCert().trim().equals("")) {
            args.add(new StringBuffer().append("-Dmaven.clover.license=").append(this.options.getLicenseCert()).toString());
        }
        if (this.options.getLicense() != null) {
            args.add(new StringBuffer().append("-Dmaven.clover.licenseLocation=").append(this.options.getLicense().getAbsolutePath()).toString());
        }
    }
}

