/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.ci;

import clover.retrotranslator.net.sf.retrotranslator.runtime.java.lang._Class;
import com.atlassian.clover.api.CloverException;
import com.atlassian.clover.api.optimization.Optimizable;
import com.atlassian.clover.api.optimization.OptimizationOptions;
import com.cenqua.clover.Logger;
import com.cenqua.clover.tasks.AntInstrumentationConfig;
import com.cenqua.clover.tasks.CloverEnvTask;
import com.cenqua.clover.test.optimization.LocalSnapshotOptimizer;
import com.cenqua.clover.test.optimization.Snapshot;
import com.cenqua.clover.util.ClassPathUtil;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.UnknownElement;
import org.apache.tools.ant.taskdefs.CloverCompilerAdapter;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.taskdefs.Javac;
import org.apache.tools.ant.taskdefs.Javadoc;
import org.apache.tools.ant.taskdefs.optional.junit.BatchTest;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTask;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTest;
import org.apache.tools.ant.types.Path;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AntIntegrationListener
implements BuildListener {
    private OptimizationOptions optimizationOptions;
    private boolean instrumentationOccured;
    private boolean executionOccured;
    private boolean importOccured;
    static /* synthetic */ Class class$org$apache$tools$ant$taskdefs$CloverCompilerAdapter;

    public void buildStarted(BuildEvent buildEvent) {
        AntInstrumentationConfig cfg = this.getConfigForProject(buildEvent.getProject());
        this.optimizationOptions = new OptimizationOptions.Builder().initStringAndSnapshotFrom(cfg.resolveInitString()).build();
    }

    public void buildFinished(BuildEvent buildEvent) {
        StringBuffer msg = new StringBuffer("[clover]");
        if (!this.instrumentationOccured && !this.executionOccured) {
            msg.append(" No Clover reports written. ");
            this.appendReason(msg);
            buildEvent.getProject().log(msg.toString());
            return;
        }
        if (this.isOptimizationEnabled()) {
            this.createSnapshot();
        }
        if (this.executionOccured && this.instrumentationOccured && this.importOccured) {
            Vector<String> targets = new Vector<String>(Arrays.asList("clover.current", "clover.json", "clover.report"));
            buildEvent.getProject().executeTargets(targets);
        } else {
            msg.append(" Clover reports not being generated.");
            this.appendReason(msg);
            buildEvent.getProject().log(msg.toString());
        }
    }

    private void appendReason(StringBuffer msg) {
        if (!this.instrumentationOccured) {
            msg.append(" No Clover instrumentation was done.");
        }
        if (!this.executionOccured) {
            msg.append(" No tests were run.");
        }
        if (!this.importOccured) {
            msg.append(" Clover targets could not be imported into this project.");
        }
    }

    private void createSnapshot() {
        try {
            Snapshot.generateFor(this.optimizationOptions.getInitString()).store();
        }
        catch (IOException e) {
            Logger.getInstance().debug("Exception when writing snapshot", e);
            Logger.getInstance().error(new StringBuffer().append("Problem writing snapshot file: ").append(e.getMessage()).toString());
        }
        catch (CloverException e) {
            Logger.getInstance().debug("Exception when writing snapshot", e);
            Logger.getInstance().error(new StringBuffer().append("Problem writing snapshot file: ").append(e.getMessage()).toString());
        }
    }

    public void targetStarted(BuildEvent buildEvent) {
    }

    public void targetFinished(BuildEvent buildEvent) {
    }

    public void taskStarted(BuildEvent buildEvent) {
        Object maybeTask;
        if (!this.importOccured) {
            this.importOccured = true;
            this.setSystemProperties(buildEvent);
            this.importCloverTargets(buildEvent);
        }
        Task task = buildEvent.getTask();
        if (Logger.isDebug()) {
            Logger.getInstance().debug(new StringBuffer().append("Started task: ").append(task.getTaskName()).toString());
        }
        if ((maybeTask = this.getConfiguredTask(task)) instanceof Task) {
            Task configuredTask = (Task)maybeTask;
            String name = _Class.getSimpleName(configuredTask.getClass());
            if (Logger.isDebug()) {
                Logger.getInstance().debug(new StringBuffer().append("Started task class.getSimpleName(): ").append(name).toString());
            }
            if ("javac".equalsIgnoreCase(name)) {
                this.injectClover((Javac)configuredTask);
            } else if ("junittask".equalsIgnoreCase(name)) {
                this.injectClover((JUnitTask)configuredTask, this.isOptimizationEnabled());
            } else if ("java".equalsIgnoreCase(name)) {
                this.injectClover((Java)configuredTask);
            } else if ("javadoc".equalsIgnoreCase(name)) {
                this.injectClover((Javadoc)configuredTask);
            }
        }
    }

    private boolean isOptimizationEnabled() {
        return Boolean.getBoolean(this.getCloverOptimizeProperty());
    }

    public String getCloverOptimizeProperty() {
        return "clover.optimization.enabled";
    }

    private void importCloverTargets(BuildEvent buildEvent) {
        CloverEnvTask envTask = new CloverEnvTask();
        envTask.setProject(buildEvent.getProject());
        envTask.setTaskName("clover-env");
        envTask.init();
        envTask.execute();
    }

    private void setSystemProperties(BuildEvent buildEvent) {
        Hashtable cloverProps = buildEvent.getProject().getProperties();
        for (Map.Entry entry : cloverProps.entrySet()) {
            if (!entry.getKey().toString().startsWith("clover.")) continue;
            System.setProperty(entry.getKey().toString(), entry.getValue().toString());
        }
    }

    public void taskFinished(BuildEvent buildEvent) {
    }

    public void messageLogged(BuildEvent buildEvent) {
    }

    private AntInstrumentationConfig getConfigForProject(Project project) {
        AntInstrumentationConfig instrConfig = (AntInstrumentationConfig)project.getReference("clover.config");
        if (instrConfig == null) {
            instrConfig = new AntInstrumentationConfig(project);
            project.addReference("clover.config", (Object)instrConfig);
        }
        return instrConfig;
    }

    private Object getConfiguredTask(Task task) {
        Object proxy = task.getRuntimeConfigurableWrapper().getProxy();
        if (proxy instanceof UnknownElement) {
            UnknownElement ue = (UnknownElement)proxy;
            ue.maybeConfigure();
            return ue.getRealThing();
        }
        return task;
    }

    private void injectClover(Javac javac) {
        javac.setClasspath(new Path(javac.getProject(), ClassPathUtil.getCloverJarPath()));
        String origCompiler = javac.getCompiler();
        Class<?> clazz = class$org$apache$tools$ant$taskdefs$CloverCompilerAdapter;
        if (clazz == null) {
            clazz = class$org$apache$tools$ant$taskdefs$CloverCompilerAdapter = new CloverCompilerAdapter[0].getClass().getComponentType();
        }
        javac.setCompiler(clazz.getName());
        if (origCompiler != null) {
            this.getConfigForProject(javac.getProject()).setCompilerDelegate(origCompiler);
        }
        this.instrumentationOccured = true;
    }

    private void injectClover(Java java) {
        this.executionOccured = true;
        Path cloverJarPath = java.createClasspath();
        cloverJarPath.add(new Path(java.getProject(), ClassPathUtil.getCloverJarPath()));
    }

    private void injectClover(Javadoc javadoc) {
        this.executionOccured = true;
        this.addCloverToDoclets(javadoc);
        this.addCloverToTaglets(javadoc);
    }

    private void addCloverToTaglets(Javadoc javadoc) {
        try {
            Field tagsField = javadoc.getClass().getDeclaredField("tagsField");
            tagsField.setAccessible(true);
            Vector tags = (Vector)tagsField.get(javadoc);
            if (tags != null && tags.size() > 0) {
                for (int i = 0; i < tags.size(); ++i) {
                    Javadoc.ExtensionInfo tagInfo = (Javadoc.ExtensionInfo)tags.elementAt(i);
                    this.addCloverToPath(javadoc, tagInfo);
                }
            }
        }
        catch (NoSuchFieldException e) {
            Logger.getInstance().debug("Could not inject Clover onto classpath of javadoc task", e);
        }
        catch (IllegalAccessException e) {
            Logger.getInstance().debug("Could not inject Clover onto classpath of javadoc task", e);
        }
    }

    private void addCloverToDoclets(Javadoc javadoc) {
        try {
            Field docletField = javadoc.getClass().getDeclaredField("doclet");
            docletField.setAccessible(true);
            if (docletField.get(javadoc) != null) {
                Javadoc.DocletInfo doclet = javadoc.createDoclet();
                this.addCloverToPath(javadoc, (Javadoc.ExtensionInfo)doclet);
            }
        }
        catch (NoSuchFieldException e) {
            Logger.getInstance().debug("Could not inject Clover onto classpath of javadoc task", e);
        }
        catch (IllegalAccessException e) {
            Logger.getInstance().debug("Could not inject Clover onto classpath of javadoc task", e);
        }
    }

    private void addCloverToPath(Javadoc javadoc, Javadoc.ExtensionInfo tagInfo) {
        Path cloverJarPath = tagInfo.createPath();
        cloverJarPath.add(new Path(javadoc.getProject(), ClassPathUtil.getCloverJarPath()));
        javadoc.log(new StringBuffer().append("Injected Clover into javadoc doclet classpath: ").append(cloverJarPath).toString());
    }

    private void injectClover(JUnitTask junit, boolean optimize) {
        this.executionOccured = true;
        Path cloverJarPath = junit.createClasspath();
        cloverJarPath.add(new Path(junit.getProject(), ClassPathUtil.getCloverJarPath()));
        if (optimize) {
            this.injectOptimization(junit);
        }
    }

    private void injectOptimization(JUnitTask junit) {
        Vector batchTests;
        Vector individualTests;
        try {
            Field individualTestsField = junit.getClass().getDeclaredField("tests");
            Field batchTestsField = junit.getClass().getDeclaredField("batchTests");
            individualTestsField.setAccessible(true);
            batchTestsField.setAccessible(true);
            individualTests = (Vector)individualTestsField.get(junit);
            batchTests = (Vector)batchTestsField.get(junit);
            Logger.getInstance().debug(new StringBuffer().append("batchTests.size() = ").append(batchTests.size()).toString());
            Logger.getInstance().debug(new StringBuffer().append("individualTests.size() = ").append(individualTests.size()).toString());
        }
        catch (IllegalAccessException e) {
            Logger.getInstance().debug("Unable to access JUnit test field", e);
            Logger.getInstance().warn("Unable to configure JUnit for test optimization");
            return;
        }
        catch (NoSuchFieldException e) {
            Logger.getInstance().debug("Unable to access JUnit test field", e);
            Logger.getInstance().warn("Unable to configure JUnit for test optimization");
            return;
        }
        List<OptimizableJUnitTest> wrappedTests = this.getIndividualWrappedTests(batchTests, individualTests);
        try {
            wrappedTests = LocalSnapshotOptimizer.optimize(wrappedTests, this.optimizationOptions);
        }
        catch (CloverException e) {
            Logger.getInstance().debug("Exception when optimizing tests", e);
            Logger.getInstance().error("Optimization failed. Running all specified tests.");
            return;
        }
        individualTests.clear();
        batchTests.clear();
        for (OptimizableJUnitTest test : wrappedTests) {
            individualTests.add(test.getJUnitTest());
        }
    }

    private List<OptimizableJUnitTest> getIndividualWrappedTests(Vector batchTests, Vector<JUnitTest> individualTests) {
        ArrayList<OptimizableJUnitTest> wrappedTests = new ArrayList<OptimizableJUnitTest>();
        for (BatchTest batchTest : batchTests) {
            Enumeration test = batchTest.elements();
            while (test.hasMoreElements()) {
                wrappedTests.add(new OptimizableJUnitTest((JUnitTest)test.nextElement()));
            }
        }
        for (JUnitTest test : individualTests) {
            wrappedTests.add(new OptimizableJUnitTest(test));
        }
        return wrappedTests;
    }

    private static class OptimizableJUnitTest
    implements Optimizable {
        private JUnitTest test;

        public OptimizableJUnitTest(JUnitTest test) {
            this.test = test;
        }

        public String getName() {
            return this.test.getName();
        }

        public JUnitTest getJUnitTest() {
            return this.test;
        }
    }
}

