/*
 * Decompiled with CFR 0.152.
 */
package clover.com.lowagie.text.rtf.document;

import clover.com.lowagie.text.HeaderFooter;
import clover.com.lowagie.text.rtf.RtfElement;
import clover.com.lowagie.text.rtf.document.RtfCodePage;
import clover.com.lowagie.text.rtf.document.RtfDocument;
import clover.com.lowagie.text.rtf.document.RtfInfoElement;
import clover.com.lowagie.text.rtf.document.RtfInfoGroup;
import clover.com.lowagie.text.rtf.document.RtfPageSetting;
import clover.com.lowagie.text.rtf.headerfooter.RtfHeaderFooter;
import clover.com.lowagie.text.rtf.headerfooter.RtfHeaderFooterGroup;
import clover.com.lowagie.text.rtf.list.RtfList;
import clover.com.lowagie.text.rtf.list.RtfListTable;
import clover.com.lowagie.text.rtf.style.RtfColor;
import clover.com.lowagie.text.rtf.style.RtfColorList;
import clover.com.lowagie.text.rtf.style.RtfFont;
import clover.com.lowagie.text.rtf.style.RtfFontList;
import clover.com.lowagie.text.rtf.style.RtfParagraphStyle;
import clover.com.lowagie.text.rtf.style.RtfStylesheetList;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class RtfDocumentHeader
extends RtfElement {
    private static final byte[] TITLE_PAGE = "\\titlepg".getBytes();
    private static final byte[] FACING_PAGES = "\\facingp".getBytes();
    private RtfCodePage codePage = null;
    private RtfColorList colorList = null;
    private RtfFontList fontList = null;
    private RtfListTable listTable = null;
    private RtfStylesheetList stylesheetList = null;
    private RtfInfoGroup infoGroup = null;
    private RtfPageSetting pageSetting = null;
    private HeaderFooter header = null;
    private HeaderFooter footer = null;

    protected RtfDocumentHeader(RtfDocument doc) {
        super(doc);
    }

    protected void init() {
        this.codePage = new RtfCodePage(this.document);
        this.colorList = new RtfColorList(this.document);
        this.fontList = new RtfFontList(this.document);
        this.listTable = new RtfListTable(this.document);
        this.stylesheetList = new RtfStylesheetList(this.document);
        this.infoGroup = new RtfInfoGroup(this.document);
        this.pageSetting = new RtfPageSetting(this.document);
        this.header = new RtfHeaderFooterGroup(this.document, 1);
        this.footer = new RtfHeaderFooterGroup(this.document, 2);
    }

    public byte[] write() {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            result.write(this.codePage.writeDefinition());
            result.write(this.fontList.writeDefinition());
            result.write(this.colorList.writeDefinition());
            result.write(this.stylesheetList.writeDefinition());
            result.write(this.listTable.writeDefinition());
            result.write(this.infoGroup.write());
            result.write(this.pageSetting.writeDefinition());
            result.write(this.writeSectionDefinition());
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return result.toByteArray();
    }

    public byte[] writeSectionDefinition() {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            RtfHeaderFooterGroup header = this.convertHeaderFooter(this.header, 1);
            RtfHeaderFooterGroup footer = this.convertHeaderFooter(this.footer, 2);
            if (header.hasTitlePage() || footer.hasTitlePage()) {
                result.write(TITLE_PAGE);
                header.setHasTitlePage();
                footer.setHasTitlePage();
            }
            if (header.hasFacingPages() || footer.hasFacingPages()) {
                result.write(FACING_PAGES);
                header.setHasFacingPages();
                footer.setHasFacingPages();
            }
            result.write(footer.write());
            result.write(header.write());
            result.write(this.pageSetting.writeSectionDefinition());
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return result.toByteArray();
    }

    public int getFontNumber(RtfFont font) {
        return this.fontList.getFontNumber(font);
    }

    public int getColorNumber(RtfColor color) {
        return this.colorList.getColorNumber(color);
    }

    public int getListNumber(RtfList list) {
        return this.listTable.getListNumber(list);
    }

    public RtfParagraphStyle getRtfParagraphStyle(String styleName) {
        return this.stylesheetList.getRtfParagraphStyle(styleName);
    }

    public void freeListNumber(RtfList list) {
        this.listTable.freeListNumber(list);
    }

    public RtfPageSetting getPageSetting() {
        return this.pageSetting;
    }

    public void addInfoElement(RtfInfoElement rtfInfoElement) {
        this.infoGroup.add(rtfInfoElement);
    }

    public void setHeader(HeaderFooter header) {
        this.header = header;
    }

    public void setFooter(HeaderFooter footer) {
        this.footer = footer;
    }

    public void registerParagraphStyle(RtfParagraphStyle rtfParagraphStyle) {
        this.stylesheetList.registerParagraphStyle(rtfParagraphStyle);
    }

    private RtfHeaderFooterGroup convertHeaderFooter(HeaderFooter hf, int type) {
        if (hf != null) {
            if (hf instanceof RtfHeaderFooterGroup) {
                return new RtfHeaderFooterGroup(this.document, (RtfHeaderFooterGroup)hf, type);
            }
            if (hf instanceof RtfHeaderFooter) {
                return new RtfHeaderFooterGroup(this.document, (RtfHeaderFooter)hf, type);
            }
            return new RtfHeaderFooterGroup(this.document, hf, type);
        }
        return new RtfHeaderFooterGroup(this.document, type);
    }
}

