/*
 * Decompiled with CFR 0.152.
 */
package clover.com.lowagie.text.rtf;

import clover.com.lowagie.text.DocWriter;
import clover.com.lowagie.text.Document;
import clover.com.lowagie.text.DocumentException;
import clover.com.lowagie.text.Element;
import clover.com.lowagie.text.HeaderFooter;
import clover.com.lowagie.text.Rectangle;
import clover.com.lowagie.text.rtf.RtfBasicElement;
import clover.com.lowagie.text.rtf.direct.RtfImportMappings;
import clover.com.lowagie.text.rtf.direct.RtfParser;
import clover.com.lowagie.text.rtf.document.RtfDocument;
import clover.com.lowagie.text.rtf.document.RtfDocumentSettings;
import clover.com.lowagie.text.rtf.text.RtfNewPage;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;

public class RtfWriter2
extends DocWriter {
    private RtfDocument rtfDoc = null;

    protected RtfWriter2(Document doc, OutputStream os) {
        super(doc, os);
        doc.addDocListener(this);
        this.rtfDoc = new RtfDocument();
    }

    public static RtfWriter2 getInstance(Document doc, OutputStream os) {
        return new RtfWriter2(doc, os);
    }

    public void setHeader(HeaderFooter hf) {
        this.rtfDoc.getDocumentHeader().setHeader(hf);
    }

    public void resetHeader() {
        this.rtfDoc.getDocumentHeader().setHeader(null);
    }

    public void setFooter(HeaderFooter hf) {
        this.rtfDoc.getDocumentHeader().setFooter(hf);
    }

    public void resetFooter() {
        this.rtfDoc.getDocumentHeader().setFooter(null);
    }

    public void setPageCount(int i) {
    }

    public void resetPageCount() {
    }

    public void clearTextWrap() {
    }

    public void open() {
        super.open();
        this.rtfDoc.open();
    }

    public void close() {
        if (this.open) {
            this.rtfDoc.writeDocument(this.os);
            super.close();
            this.rtfDoc = new RtfDocument();
        }
    }

    public boolean add(Element element) throws DocumentException {
        if (this.pause) {
            return false;
        }
        RtfBasicElement rtfElement = this.rtfDoc.getMapper().mapElement(element);
        if (rtfElement != null) {
            this.rtfDoc.add(rtfElement);
            return true;
        }
        return false;
    }

    public boolean newPage() {
        this.rtfDoc.add(new RtfNewPage(this.rtfDoc));
        return true;
    }

    public boolean setMargins(float left, float right, float top, float bottom) {
        this.rtfDoc.getDocumentHeader().getPageSetting().setMarginLeft((int)((double)left * 20.0));
        this.rtfDoc.getDocumentHeader().getPageSetting().setMarginRight((int)((double)right * 20.0));
        this.rtfDoc.getDocumentHeader().getPageSetting().setMarginTop((int)((double)top * 20.0));
        this.rtfDoc.getDocumentHeader().getPageSetting().setMarginBottom((int)((double)bottom * 20.0));
        return true;
    }

    public boolean setPageSize(Rectangle rect) {
        this.rtfDoc.getDocumentHeader().getPageSetting().setPageSize(rect);
        return true;
    }

    public void setAutogenerateTOCEntries(boolean autogenerate) {
        this.rtfDoc.setAutogenerateTOCEntries(autogenerate);
    }

    public void setDataCacheStyle(int dataCacheStyle) {
        this.rtfDoc.getDocumentSettings().setDataCacheStyle(dataCacheStyle);
    }

    public RtfDocumentSettings getDocumentSettings() {
        return this.rtfDoc.getDocumentSettings();
    }

    public void importRtfDocument(Reader documentSource) throws IOException, DocumentException {
        if (!this.open) {
            throw new DocumentException("The document must be open to import RTF documents.");
        }
        RtfParser rtfImport = new RtfParser();
        rtfImport.importRtfDocument(documentSource, this.rtfDoc);
    }

    public void importRtfFragment(Reader documentSource, RtfImportMappings mappings) throws IOException, DocumentException {
        if (!this.open) {
            throw new DocumentException("The document must be open to import RTF fragments.");
        }
        RtfParser rtfImport = new RtfParser();
        rtfImport.importRtfFragment(documentSource, this.rtfDoc, mappings);
    }
}

