/*
 * Decompiled with CFR 0.152.
 */
package jnacontrib.x11.api;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.platform.unix.X11;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.NativeLongByReference;
import com.sun.jna.ptr.PointerByReference;
import java.awt.Rectangle;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;

public class X {
    public static final int _NET_WM_STATE_REMOVE = 0;
    public static final int _NET_WM_STATE_ADD = 1;
    public static final int _NET_WM_STATE_TOGGLE = 2;
    public static final int MAX_PROPERTY_VALUE_LEN = 4096;
    private static final X11 x11 = X11.INSTANCE;

    private static int bytesToInt(byte[] prop) {
        return (prop[3] & 0xFF) << 24 | (prop[2] & 0xFF) << 16 | (prop[1] & 0xFF) << 8 | prop[0] & 0xFF;
    }

    private static int bytesToInt(byte[] prop, int offset) {
        return (prop[3 + offset] & 0xFF) << 24 | (prop[2 + offset] & 0xFF) << 16 | (prop[1 + offset] & 0xFF) << 8 | prop[offset] & 0xFF;
    }

    public static class X11Exception
    extends Exception {
        private static final long serialVersionUID = 1L;

        public X11Exception() {
        }

        public X11Exception(String message) {
            super(message);
        }

        public X11Exception(String message, Throwable cause) {
            super(message, cause);
        }

        public X11Exception(Throwable cause) {
            super(cause);
        }
    }

    public static class Window {
        private Display display;
        private X11.Window x11Window;

        public X11.Window getX11Window() {
            return this.x11Window;
        }

        public int getID() {
            return this.x11Window.intValue();
        }

        public Window(Display display, X11.Window x11Window) {
            this.display = display;
            this.x11Window = x11Window;
        }

        public String getTitle() throws X11Exception {
            try {
                return this.getUtf8Property(this.display.getAtom("UTF8_STRING"), "_NET_WM_NAME");
            }
            catch (X11Exception e) {
                return this.getUtf8Property(X11.XA_STRING, X11.XA_WM_NAME);
            }
        }

        public String getWindowClass() throws X11Exception {
            return this.getUtf8Property(X11.XA_STRING, X11.XA_WM_CLASS);
        }

        public Integer getPID() throws X11Exception {
            return this.getIntProperty(X11.XA_CARDINAL, "_NET_WM_PID");
        }

        public int getDesktop() throws X11Exception {
            try {
                return this.getIntProperty(X11.XA_CARDINAL, "_NET_WM_DESKTOP");
            }
            catch (X11Exception e) {
                return this.getIntProperty(X11.XA_CARDINAL, "_WIN_WORKSPACE");
            }
        }

        public String getMachine() throws X11Exception {
            return this.getStringProperty(X11.XA_STRING, "WM_CLIENT_MACHINE");
        }

        public X11.XWindowAttributes getXWindowAttributes() {
            X11.XWindowAttributes xwa = new X11.XWindowAttributes();
            x11.XGetWindowAttributes(this.display.x11Display, this.x11Window, xwa);
            return xwa;
        }

        public Geometry getGeometry() {
            X11.WindowByReference junkRoot = new X11.WindowByReference();
            IntByReference junkX = new IntByReference();
            IntByReference junkY = new IntByReference();
            IntByReference x = new IntByReference();
            IntByReference y = new IntByReference();
            IntByReference width = new IntByReference();
            IntByReference height = new IntByReference();
            IntByReference borderWidth = new IntByReference();
            IntByReference depth = new IntByReference();
            x11.XGetGeometry(this.display.x11Display, this.x11Window, junkRoot, junkX, junkY, width, height, borderWidth, depth);
            x11.XTranslateCoordinates(this.display.x11Display, this.x11Window, junkRoot.getValue(), junkX.getValue(), junkY.getValue(), x, y, junkRoot);
            return new Geometry(x.getValue(), y.getValue(), width.getValue(), height.getValue(), borderWidth.getValue(), depth.getValue());
        }

        public Rectangle getBounds() {
            X11.WindowByReference junkRoot = new X11.WindowByReference();
            IntByReference junkX = new IntByReference();
            IntByReference junkY = new IntByReference();
            IntByReference x = new IntByReference();
            IntByReference y = new IntByReference();
            IntByReference width = new IntByReference();
            IntByReference height = new IntByReference();
            IntByReference border_width = new IntByReference();
            IntByReference depth = new IntByReference();
            x11.XGetGeometry(this.display.x11Display, this.x11Window, junkRoot, junkX, junkY, width, height, border_width, depth);
            x11.XTranslateCoordinates(this.display.x11Display, this.x11Window, junkRoot.getValue(), junkX.getValue(), junkY.getValue(), x, y, junkRoot);
            int xVal = x.getValue();
            int yVal = y.getValue();
            return new Rectangle(xVal, yVal, xVal + width.getValue(), yVal + height.getValue());
        }

        public void activate() throws X11Exception {
            this.clientMsg("_NET_ACTIVE_WINDOW", 0, 0, 0, 0, 0);
            x11.XMapRaised(this.display.x11Display, this.x11Window);
        }

        public int moveToDesktop(int desktopNr) throws X11Exception {
            return this.clientMsg("_NET_WM_DESKTOP", desktopNr, 0, 0, 0, 0);
        }

        public void selectInput(int eventMask) {
            x11.XSelectInput(this.display.x11Display, this.x11Window, new NativeLong((long)eventMask));
        }

        public int nextEvent(X11.XEvent event) {
            return x11.XNextEvent(this.display.x11Display, event);
        }

        public void sendEvent(int eventMask, X11.XEvent event) {
            x11.XSendEvent(this.display.x11Display, this.x11Window, 1, new NativeLong((long)eventMask), event);
        }

        public int close() throws X11Exception {
            return this.clientMsg("_NET_CLOSE_WINDOW", 0, 0, 0, 0, 0);
        }

        public Integer getIntProperty(X11.Atom xa_prop_type, X11.Atom xa_prop_name) throws X11Exception {
            byte[] property = this.getProperty(xa_prop_type, xa_prop_name);
            if (property == null) {
                return null;
            }
            return X.bytesToInt(property);
        }

        public Integer getIntProperty(X11.Atom xa_prop_type, String xa_prop_name) throws X11Exception {
            return this.getIntProperty(xa_prop_type, this.display.getAtom(xa_prop_name));
        }

        public Window getWindowProperty(X11.Atom xa_prop_type, X11.Atom xa_prop_name) throws X11Exception {
            Integer windowId = this.getIntProperty(xa_prop_type, xa_prop_name);
            if (windowId == null) {
                return null;
            }
            X11.Window x11Window = new X11.Window((long)windowId.intValue());
            return new Window(this.display, x11Window);
        }

        public Window getWindowProperty(X11.Atom xa_prop_type, String xa_prop_name) throws X11Exception {
            return this.getWindowProperty(xa_prop_type, this.display.getAtom(xa_prop_name));
        }

        public byte[] getNullTerminatedProperty(X11.Atom xa_prop_type, X11.Atom xa_prop_name) throws X11Exception {
            byte[] bytesDest;
            int i;
            byte[] bytesOrig = this.getProperty(xa_prop_type, xa_prop_name);
            if (bytesOrig == null) {
                return null;
            }
            for (i = 0; i < bytesOrig.length && bytesOrig[i] != 0; ++i) {
            }
            if (i < bytesOrig.length - 1) {
                bytesDest = new byte[i + 1];
                System.arraycopy(bytesOrig, 0, bytesDest, 0, i + 1);
            } else {
                bytesDest = bytesOrig;
            }
            return bytesDest;
        }

        public byte[] getNullTerminatedProperty(X11.Atom xa_prop_type, String xa_prop_name) throws X11Exception {
            return this.getNullTerminatedProperty(xa_prop_type, this.display.getAtom(xa_prop_name));
        }

        public byte[] getNullReplacedStringProperty(X11.Atom xa_prop_type, X11.Atom xa_prop_name) throws X11Exception {
            byte[] bytes = this.getProperty(xa_prop_type, xa_prop_name);
            if (bytes == null) {
                return null;
            }
            for (int i = 0; i < bytes.length; ++i) {
                if (bytes[i] != 0) continue;
                bytes[i] = 46;
            }
            return bytes;
        }

        public byte[] getNullReplacedStringProperty(X11.Atom xa_prop_type, String xa_prop_name) throws X11Exception {
            return this.getNullReplacedStringProperty(xa_prop_type, this.display.getAtom(xa_prop_name));
        }

        public String getStringProperty(X11.Atom xa_prop_type, X11.Atom xa_prop_name) throws X11Exception {
            return new String(this.getNullReplacedStringProperty(xa_prop_type, xa_prop_name));
        }

        public String getStringProperty(X11.Atom xa_prop_type, String xa_prop_name) throws X11Exception {
            return new String(this.getNullReplacedStringProperty(xa_prop_type, xa_prop_name));
        }

        public String[] getStringListProperty(X11.Atom xa_prop_type, X11.Atom xa_prop_name) throws X11Exception {
            return new String(this.getProperty(xa_prop_type, xa_prop_name)).split("\u0000");
        }

        public String[] getStringListProperty(X11.Atom xa_prop_type, String xa_prop_name) throws X11Exception {
            byte[] property = this.getProperty(xa_prop_type, xa_prop_name);
            if (property == null) {
                return null;
            }
            return new String(property).split("\u0000");
        }

        public String getUtf8Property(X11.Atom xa_prop_type, X11.Atom xa_prop_name) throws X11Exception {
            try {
                byte[] property = this.getNullReplacedStringProperty(xa_prop_type, xa_prop_name);
                if (property == null) {
                    return null;
                }
                return new String(property, "UTF8");
            }
            catch (UnsupportedEncodingException e) {
                throw new X11Exception(e);
            }
        }

        public String getUtf8Property(X11.Atom xa_prop_type, String xa_prop_name) throws X11Exception {
            return this.getUtf8Property(xa_prop_type, this.display.getAtom(xa_prop_name));
        }

        public String[] getUtf8ListProperty(X11.Atom xa_prop_type, X11.Atom xa_prop_name) throws X11Exception {
            try {
                return new String(this.getProperty(xa_prop_type, xa_prop_name), "UTF8").split("\u0000");
            }
            catch (UnsupportedEncodingException e) {
                throw new X11Exception(e);
            }
        }

        public String[] getUtf8ListProperty(X11.Atom xa_prop_type, String xa_prop_name) throws X11Exception {
            return this.getUtf8ListProperty(xa_prop_type, this.display.getAtom(xa_prop_name));
        }

        public byte[] getProperty(X11.Atom xa_prop_type, X11.Atom xa_prop_name) throws X11Exception {
            int nbytes;
            X11.AtomByReference xa_ret_type_ref = new X11.AtomByReference();
            IntByReference ret_format_ref = new IntByReference();
            NativeLongByReference ret_nitems_ref = new NativeLongByReference();
            NativeLongByReference ret_bytes_after_ref = new NativeLongByReference();
            PointerByReference ret_prop_ref = new PointerByReference();
            NativeLong long_offset = new NativeLong(0L);
            NativeLong long_length = new NativeLong(1024L);
            if (x11.XGetWindowProperty(this.display.x11Display, this.x11Window, xa_prop_name, long_offset, long_length, false, xa_prop_type, xa_ret_type_ref, ret_format_ref, ret_nitems_ref, ret_bytes_after_ref, ret_prop_ref) != 0) {
                String prop_name = x11.XGetAtomName(this.display.x11Display, xa_prop_name);
                throw new X11Exception("Cannot get " + prop_name + " property.");
            }
            X11.Atom xa_ret_type = xa_ret_type_ref.getValue();
            Pointer ret_prop = ret_prop_ref.getValue();
            if (xa_ret_type == null) {
                return null;
            }
            if (xa_ret_type == null) {
                return null;
            }
            if (xa_ret_type == null) {
                return null;
            }
            if (xa_ret_type == null || xa_prop_type == null || !xa_ret_type.toNative().equals(xa_prop_type.toNative())) {
                x11.XFree(ret_prop);
                String prop_name = x11.XGetAtomName(this.display.x11Display, xa_prop_name);
                throw new X11Exception("Invalid type of " + prop_name + " property");
            }
            int ret_format = ret_format_ref.getValue();
            long ret_nitems = ret_nitems_ref.getValue().longValue();
            if (ret_format == 32) {
                nbytes = Native.LONG_SIZE;
            } else if (ret_format == 16) {
                nbytes = Native.LONG_SIZE / 2;
            } else if (ret_format == 8) {
                nbytes = 1;
            } else if (ret_format == 0) {
                nbytes = 0;
            } else {
                throw new X11Exception("Invalid return format");
            }
            int length = Math.min((int)ret_nitems * nbytes, 4096);
            byte[] ret = ret_prop.getByteArray(0L, length);
            x11.XFree(ret_prop);
            return ret;
        }

        public byte[] getProperty(X11.Atom xa_prop_type, String xa_prop_name) throws X11Exception {
            return this.getProperty(xa_prop_type, this.display.getAtom(xa_prop_name));
        }

        public int clientMsg(String msg, int data0, int data1, int data2, int data3, int data4) throws X11Exception {
            return this.clientMsg(msg, new NativeLong((long)data0), new NativeLong((long)data1), new NativeLong((long)data2), new NativeLong((long)data3), new NativeLong((long)data4));
        }

        public int clientMsg(String msg, NativeLong data0, NativeLong data1, NativeLong data2, NativeLong data3, NativeLong data4) throws X11Exception {
            NativeLong mask = new NativeLong(0x180000L);
            X11.XClientMessageEvent event = new X11.XClientMessageEvent();
            event.type = 33;
            event.serial = new NativeLong(0L);
            event.send_event = 1;
            event.message_type = this.display.getAtom(msg);
            event.window = this.x11Window;
            event.format = 32;
            event.data.setType(NativeLong[].class);
            event.data.l[0] = data0;
            event.data.l[1] = data1;
            event.data.l[2] = data2;
            event.data.l[3] = data3;
            event.data.l[4] = data4;
            X11.XEvent e = new X11.XEvent();
            e.setTypedValue(event);
            if (x11.XSendEvent(this.display.x11Display, this.display.getRootWindow().x11Window, 0, mask, e) != 0) {
                return 0;
            }
            throw new X11Exception("Cannot send " + msg + " event.");
        }

        public Window[] getSubwindows() throws X11Exception {
            X11.WindowByReference root = new X11.WindowByReference();
            X11.WindowByReference parent = new X11.WindowByReference();
            PointerByReference children = new PointerByReference();
            IntByReference childCount = new IntByReference();
            if (x11.XQueryTree(this.display.x11Display, this.x11Window, root, parent, children, childCount) == 0) {
                throw new X11Exception("Can't query subwindows");
            }
            if (childCount.getValue() == 0) {
                return null;
            }
            Window[] retVal = new Window[childCount.getValue()];
            if (X11.XID.SIZE == 4) {
                int[] windows = children.getValue().getIntArray(0L, childCount.getValue());
                for (int x = 0; x < retVal.length; ++x) {
                    X11.Window win = new X11.Window((long)windows[x]);
                    retVal[x] = new Window(this.display, win);
                }
            } else {
                long[] windows = children.getValue().getLongArray(0L, childCount.getValue());
                for (int x = 0; x < retVal.length; ++x) {
                    X11.Window win = new X11.Window(windows[x]);
                    retVal[x] = new Window(this.display, win);
                }
            }
            x11.XFree(children.getValue());
            return retVal;
        }

        public String toString() {
            return this.x11Window.toString();
        }

        public static class Geometry {
            public int x;
            public int y;
            public int width;
            public int height;
            public int borderWidth;
            public int depth;

            public Geometry(int x, int y, int width, int height, int border_width, int depth) {
                this.x = x;
                this.y = y;
                this.width = width;
                this.height = height;
                this.borderWidth = border_width;
                this.depth = depth;
            }
        }
    }

    public static class Desktop {
        public Display display;
        public int number;
        public String name;

        public Desktop(Display display, int number, String name) {
            this.display = display;
            this.number = number;
            this.name = name;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ModifierKeymap {
        public ArrayList<Byte> shift = new ArrayList(4);
        public ArrayList<Byte> lock = new ArrayList(4);
        public ArrayList<Byte> control = new ArrayList(4);
        public ArrayList<Byte> mod1 = new ArrayList(4);
        public ArrayList<Byte> mod2 = new ArrayList(4);
        public ArrayList<Byte> mod3 = new ArrayList(4);
        public ArrayList<Byte> mod4 = new ArrayList(4);
        public ArrayList<Byte> mod5 = new ArrayList(4);

        public ModifierKeymap() {
        }

        public ModifierKeymap(X11.XModifierKeymapRef xModifierKeymapRef) {
            this.fromXModifierKeymap(xModifierKeymapRef);
        }

        public void fromXModifierKeymap(X11.XModifierKeymapRef xModifierKeymapRef) {
            int count = xModifierKeymapRef.max_keypermod;
            byte[] keys = xModifierKeymapRef.modifiermap.getByteArray(0L, 8 * count);
            ArrayList<Byte>[] allModifiers = this.getAllModifiers();
            for (int modNr = 0; modNr < 8; ++modNr) {
                ArrayList<Byte> modifier = allModifiers[modNr];
                modifier.clear();
                for (int keyNr = 0; keyNr < count; ++keyNr) {
                    byte key = keys[modNr * count + keyNr];
                    if (key == 0) continue;
                    modifier.add(key);
                }
            }
        }

        public X11.XModifierKeymapRef toXModifierKeyamp() {
            ArrayList<Byte>[] allModifiers = this.getAllModifiers();
            int count = 0;
            for (int i = 0; i < allModifiers.length; ++i) {
                count = Math.max(count, allModifiers[i].size());
            }
            byte[] keys = new byte[8 * count];
            for (int modNr = 0; modNr < 8; ++modNr) {
                ArrayList<Byte> modifier = allModifiers[modNr];
                for (int keyNr = 0; keyNr < modifier.size(); ++keyNr) {
                    keys[modNr * count + keyNr] = modifier.get(keyNr);
                }
            }
            X11.XModifierKeymapRef xModifierKeymapRef = new X11.XModifierKeymapRef();
            xModifierKeymapRef.max_keypermod = count;
            xModifierKeymapRef.modifiermap = new Memory(keys.length);
            xModifierKeymapRef.modifiermap.write(0L, keys, 0, keys.length);
            return xModifierKeymapRef;
        }

        public ArrayList<Byte>[] getAllModifiers() {
            return new ArrayList[]{this.shift, this.lock, this.control, this.mod1, this.mod2, this.mod3, this.mod4, this.mod5};
        }
    }

    public static class Display {
        private X11.Display x11Display;
        private HashMap<String, X11.Atom> atomsHash = new HashMap();

        public Display() {
            this.x11Display = x11.XOpenDisplay(null);
            if (this.x11Display == null) {
                throw new Error("Can't open X Display");
            }
        }

        public Display(X11.Display x11Display) {
            this.x11Display = x11Display;
            if (x11Display == null) {
                throw new Error("X Display is null");
            }
        }

        public void close() {
            x11.XCloseDisplay(this.x11Display);
        }

        public void flush() {
            x11.XFlush(this.x11Display);
        }

        public X11.Display getX11Display() {
            return this.x11Display;
        }

        public X11.Atom getAtom(String name) {
            X11.Atom atom = this.atomsHash.get(name);
            if (atom == null) {
                atom = x11.XInternAtom(this.x11Display, name, false);
                this.atomsHash.put(name, atom);
            }
            return atom;
        }

        public Window getWindowManagerInfo() throws X11Exception {
            Window rootWindow = this.getRootWindow();
            try {
                return rootWindow.getWindowProperty(X11.XA_WINDOW, "_NET_SUPPORTING_WM_CHECK");
            }
            catch (X11Exception e) {
                try {
                    return rootWindow.getWindowProperty(X11.XA_CARDINAL, "_WIN_SUPPORTING_WM_CHECK");
                }
                catch (X11Exception e1) {
                    throw new X11Exception("Cannot get window manager info properties. (_NET_SUPPORTING_WM_CHECK or _WIN_SUPPORTING_WM_CHECK)");
                }
            }
        }

        public Window getRootWindow() {
            return new Window(this, x11.XDefaultRootWindow(this.x11Display));
        }

        public Window getActiveWindow() throws X11Exception {
            return this.getRootWindow().getWindowProperty(X11.XA_WINDOW, "_NET_ACTIVE_WINDOW");
        }

        public Window[] getWindows() throws X11Exception {
            byte[] bytes;
            Window rootWindow = this.getRootWindow();
            try {
                bytes = rootWindow.getProperty(X11.XA_WINDOW, "_NET_CLIENT_LIST");
            }
            catch (X11Exception e) {
                try {
                    bytes = rootWindow.getProperty(X11.XA_CARDINAL, "_WIN_CLIENT_LIST");
                }
                catch (X11Exception e1) {
                    throw new X11Exception("Cannot get client list properties (_NET_CLIENT_LIST or _WIN_CLIENT_LIST)");
                }
            }
            Window[] windowList = new Window[bytes.length / X11.Window.SIZE];
            for (int i = 0; i < windowList.length; ++i) {
                windowList[i] = new Window(this, new X11.Window((long)X.bytesToInt(bytes, X11.XID.SIZE * i)));
            }
            return windowList;
        }

        public int getDesktopCount() throws X11Exception {
            Window root = this.getRootWindow();
            try {
                return root.getIntProperty(X11.XA_CARDINAL, "_NET_NUMBER_OF_DESKTOPS");
            }
            catch (X11Exception e) {
                try {
                    return root.getIntProperty(X11.XA_CARDINAL, "_WIN_WORKSPACE_COUNT");
                }
                catch (X11Exception e1) {
                    throw new X11Exception("Cannot get number of desktops properties (_NET_NUMBER_OF_DESKTOPS or _WIN_WORKSPACE_COUNT)");
                }
            }
        }

        public int getActiveDesktopNumber() throws X11Exception {
            int cur_desktop;
            Window root = this.getRootWindow();
            try {
                cur_desktop = root.getIntProperty(X11.XA_CARDINAL, "_NET_CURRENT_DESKTOP");
            }
            catch (X11Exception e) {
                try {
                    cur_desktop = root.getIntProperty(X11.XA_CARDINAL, "_WIN_WORKSPACE");
                }
                catch (X11Exception e1) {
                    throw new X11Exception("Cannot get current desktop properties (_NET_CURRENT_DESKTOP or _WIN_WORKSPACE property)");
                }
            }
            return cur_desktop;
        }

        public Desktop[] getDesktops() throws X11Exception {
            String[] desktopNames;
            Window root = this.getRootWindow();
            try {
                desktopNames = root.getUtf8ListProperty(this.getAtom("UTF8_STRING"), "_NET_DESKTOP_NAMES");
            }
            catch (X11Exception e) {
                try {
                    desktopNames = root.getStringListProperty(X11.XA_STRING, "_WIN_WORKSPACE_NAMES");
                }
                catch (X11Exception e1) {
                    throw new X11Exception("Cannot get desktop names properties (_NET_DESKTOP_NAMES or _WIN_WORKSPACE_NAMES)");
                }
            }
            Desktop[] desktops = new Desktop[this.getDesktopCount()];
            for (int i = 0; i < desktops.length; ++i) {
                desktops[i] = new Desktop(this, i, desktopNames[i]);
            }
            return desktops;
        }

        public void switchDesktop(int nr) throws X11Exception {
            this.getRootWindow().clientMsg("_NET_CURRENT_DESKTOP", nr, 0, 0, 0, 0);
        }

        public void showingDesktop(boolean state) throws X11Exception {
            this.getRootWindow().clientMsg("_NET_SHOWING_DESKTOP", state ? 1 : 0, 0, 0, 0, 0);
        }

        public void setKeyAutoRepeat(boolean on) {
            if (on) {
                x11.XAutoRepeatOn(this.x11Display);
            } else {
                x11.XAutoRepeatOff(this.x11Display);
            }
        }

        public X11.KeySym getKeySym(String keyName) {
            return x11.XStringToKeysym(keyName);
        }

        public X11.KeySym getKeySym(byte keyCode, int index) {
            return x11.XKeycodeToKeysym(this.x11Display, keyCode, index);
        }

        public byte getKeyCode(X11.KeySym keySym) {
            return x11.XKeysymToKeycode(this.x11Display, keySym);
        }

        public byte getKeyCode(String keyName) {
            return x11.XKeysymToKeycode(this.x11Display, this.getKeySym(keyName));
        }

        public String getKeyName(X11.KeySym keySym) {
            return x11.XKeysymToString(keySym);
        }

        public String getKeyName(byte keyCode, int index) {
            return this.getKeyName(this.getKeySym(keyCode, index));
        }

        public ModifierKeymap getModifierKeymap() {
            X11.XModifierKeymapRef xModifierKeymapRef = x11.XGetModifierMapping(this.x11Display);
            ModifierKeymap modifierKeymap = new ModifierKeymap(xModifierKeymapRef);
            x11.XFreeModifiermap(xModifierKeymapRef);
            return modifierKeymap;
        }

        public void setModifierKeymap(ModifierKeymap modifierKeymap) {
            X11.XModifierKeymapRef xModifierKeymapRef = modifierKeymap.toXModifierKeyamp();
            x11.XSetModifierMapping(this.x11Display, xModifierKeymapRef);
        }
    }
}

