/*
 * Copyright @ 2020 - present 8x8, Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jitsi.srtp;

public enum SrtpErrorStatus
{
    OK ("OK"),
    FAIL("unspecified failure"),
    AUTH_FAIL ("authentication failure"),
    REPLAY_FAIL ("replay check failed (bad index)"),
    REPLAY_OLD("replay check failed (index too old)"),
    INVALID_PACKET("invalid SRTP/SRTCP packet"),
    ;

    public final String desc;

    SrtpErrorStatus(String desc)
    {
        this.desc = desc;
    }
}
