pub fn instruction_str(opcode: u8) -> &'static str {
    match opcode {
        0x00 => "BRK",
        0x01 => "ORA ($xx,X)",
        0x02 => "COP",
        0x03 => "ORA $xx,S",
        0x04 => "TSB $xx",
        0x05 => "ORA $xx",
        0x06 => "ASL $xx",
        0x07 => "ORA [$xx]",
        0x08 => "PHP",
        0x09 => "ORA #<d>",
        0x0A => "ASL A",
        0x0B => "PHD",
        0x0C => "TSB $xxxx",
        0x0D => "ORA $xxxx",
        0x0E => "ASL $xxxx",
        0x0F => "ORA $xxxxxx",
        0x10 => "BPL #<d>",
        0x11 => "ORA ($xx),Y",
        0x12 => "ORA ($xx)",
        0x13 => "ORA ($xx,S),Y",
        0x14 => "TRB $xx",
        0x15 => "ORA $xx,X",
        0x16 => "ASL $xx,X",
        0x17 => "ORA [$xx],Y",
        0x18 => "CLC",
        0x19 => "ORA $xxxx,Y",
        0x1A => "INC A",
        0x1B => "TCS",
        0x1C => "TRB $xxxx",
        0x1D => "ORA $xxxx,X",
        0x1E => "ASL $xxxx,X",
        0x1F => "ORA $xxxxxx,X",
        0x20 => "JSR $xxxx",
        0x21 => "AND ($xx,X)",
        0x22 => "JSL $xxxxxx",
        0x23 => "AND $xx,S",
        0x24 => "BIT $xx",
        0x25 => "AND $xx",
        0x26 => "ROL $xx",
        0x27 => "AND [$xx]",
        0x28 => "PLP",
        0x29 => "AND #<d>",
        0x2A => "ROL A",
        0x2B => "PLD",
        0x2C => "BIT $xxxx",
        0x2D => "AND $xxxx",
        0x2E => "ROL $xxxx",
        0x2F => "AND $xxxxxx",
        0x30 => "BMI #<d>",
        0x31 => "AND ($xx),Y",
        0x32 => "AND ($xx)",
        0x33 => "AND ($xx,S),Y",
        0x34 => "BIT $xx,X",
        0x35 => "AND $xx,X",
        0x36 => "ROL $xx,X",
        0x37 => "AND [$xx],Y",
        0x38 => "SEC",
        0x39 => "AND $xxxx,Y",
        0x3A => "DEC A",
        0x3B => "TSC",
        0x3C => "BIT $xxxx,X",
        0x3D => "AND $xxxx,X",
        0x3E => "ROL $xxxx,X",
        0x3F => "AND $xxxxxx,X",
        0x40 => "RTI",
        0x41 => "EOR ($xx,X)",
        0x42 => "WDM",
        0x43 => "EOR $xx,S",
        0x44 => "MVP",
        0x45 => "EOR $xx",
        0x46 => "LSR $xx",
        0x47 => "EOR [$xx]",
        0x48 => "PHA",
        0x49 => "EOR #<d>",
        0x4A => "LSR A",
        0x4B => "PHK",
        0x4C => "JMP $xxxx",
        0x4D => "EOR $xxxx",
        0x4E => "LSR $xxxx",
        0x4F => "EOR $xxxxxx",
        0x50 => "BVC #<d>",
        0x51 => "EOR ($xx),Y",
        0x52 => "EOR ($xx)",
        0x53 => "EOR ($xx,S),Y",
        0x54 => "MVN",
        0x55 => "EOR $xx,X",
        0x56 => "LSR $xx,X",
        0x57 => "EOR [$xx],Y",
        0x58 => "CLI",
        0x59 => "EOR $xxxx,Y",
        0x5A => "PHY",
        0x5B => "TCD",
        0x5C => "JMP $xxxxxx",
        0x5D => "EOR $xxxx,X",
        0x5E => "LSR $xxxx,X",
        0x5F => "EOR $xxxxxx,X",
        0x60 => "RTS",
        0x61 => "ADC ($xx,X)",
        0x62 => "PER #<d>",
        0x63 => "ADC $xx,S",
        0x64 => "STZ $xx",
        0x65 => "ADC $xx",
        0x66 => "ROR $xx",
        0x67 => "ADC [$xx]",
        0x68 => "PLA",
        0x69 => "ADC #<d>",
        0x6A => "ROR A",
        0x6B => "RTL",
        0x6C => "JMP ($xxxx)",
        0x6D => "ADC $xxxx",
        0x6E => "ROR $xxxx",
        0x6F => "ADC $xxxxxx",
        0x70 => "BVS #<d>",
        0x71 => "ADC ($xx),Y",
        0x72 => "ADC ($xx)",
        0x73 => "ADC ($xx,S),Y",
        0x74 => "STZ $xx,X",
        0x75 => "ADC $xx,X",
        0x76 => "ROR $xx,X",
        0x77 => "ADC [$xx],Y",
        0x78 => "SEI",
        0x79 => "ADC $xxxx,Y",
        0x7A => "PLY",
        0x7B => "TDC",
        0x7C => "JMP ($xxxx,X)",
        0x7D => "ADC $xxxx,X",
        0x7E => "ROR $xxxx,X",
        0x7F => "ADC $xxxxxx,X",
        0x80 => "BRA #<d>",
        0x81 => "STA ($xx,X)",
        0x82 => "BRL #<d>",
        0x83 => "STA $xx,S",
        0x84 => "STY $xx",
        0x85 => "STA $xx",
        0x86 => "STX $xx",
        0x87 => "STA [$xx]",
        0x88 => "DEY",
        0x89 => "BIT #<d>",
        0x8A => "TXA",
        0x8B => "PHB",
        0x8C => "STY $xxxx",
        0x8D => "STA $xxxx",
        0x8E => "STX $xxxx",
        0x8F => "STA $xxxxxx",
        0x90 => "BCC #<d>",
        0x91 => "STA ($xx),Y",
        0x92 => "STA ($xx)",
        0x93 => "STA ($xx,S),Y",
        0x94 => "STY $xx,X",
        0x95 => "STA $xx,X",
        0x96 => "STX $xx,Y",
        0x97 => "STA [$xx],Y",
        0x98 => "TYA",
        0x99 => "STA $xxxx,Y",
        0x9A => "TXS",
        0x9B => "TXY",
        0x9C => "STZ $xxxx",
        0x9D => "STA $xxxx,X",
        0x9E => "STZ $xxxx,X",
        0x9F => "STA $xxxxxx,X",
        0xA0 => "LDY #<d>",
        0xA1 => "LDA ($xx,X)",
        0xA2 => "LDX #<d>",
        0xA3 => "LDA $xx,S",
        0xA4 => "LDY $xx",
        0xA5 => "LDA $xx",
        0xA6 => "LDX $xx",
        0xA7 => "LDA [$xx]",
        0xA8 => "TAY",
        0xA9 => "LDA #<d>",
        0xAA => "TAX",
        0xAB => "PLB",
        0xAC => "LDY $xxxx",
        0xAD => "LDA $xxxx",
        0xAE => "LDX $xxxx",
        0xAF => "LDA $xxxxxx",
        0xB0 => "BCS #<d>",
        0xB1 => "LDA ($xx),Y",
        0xB2 => "LDA ($xx)",
        0xB3 => "LDA ($xx,S),Y",
        0xB4 => "LDY $xx,X",
        0xB5 => "LDA $xx,X",
        0xB6 => "LDX $xx,Y",
        0xB7 => "LDA [$xx],Y",
        0xB8 => "CLV",
        0xB9 => "LDA $xxxx,Y",
        0xBA => "TSX",
        0xBB => "TYX",
        0xBC => "LDY $xxxx,X",
        0xBD => "LDA $xxxx,X",
        0xBE => "LDX $xxxx,Y",
        0xBF => "LDA $xxxxxx,X",
        0xC0 => "CPY #<d>",
        0xC1 => "CMP ($xx,X)",
        0xC2 => "REP #<d>",
        0xC3 => "CMP $xx,S",
        0xC4 => "CPY $xx",
        0xC5 => "CMP $xx",
        0xC6 => "DEC $xx",
        0xC7 => "CMP [$xx]",
        0xC8 => "INY",
        0xC9 => "CMP #<d>",
        0xCA => "DEX",
        0xCB => "WAI",
        0xCC => "CPY $xxxx",
        0xCD => "CMP $xxxx",
        0xCE => "DEC $xxxx",
        0xCF => "CMP $xxxxxx",
        0xD0 => "BNE #<d>",
        0xD1 => "CMP ($xx),Y",
        0xD2 => "CMP ($xx)",
        0xD3 => "CMP ($xx,S),Y",
        0xD4 => "PEI ($xx)",
        0xD5 => "CMP $xx,X",
        0xD6 => "DEC $xx,X",
        0xD7 => "CMP [$xx],Y",
        0xD8 => "CLD",
        0xD9 => "CMP $xxxx,Y",
        0xDA => "PHX",
        0xDB => "STP",
        0xDC => "JMP [$xxxx]",
        0xDD => "CMP $xxxx,X",
        0xDE => "DEC $xxxx,X",
        0xDF => "CMP $xxxxxx,X",
        0xE0 => "CPX #<d>",
        0xE1 => "SBC ($xx,X)",
        0xE2 => "SEP #<d>",
        0xE3 => "SBC $xx,S",
        0xE4 => "CPX $xx",
        0xE5 => "SBC $xx",
        0xE6 => "INC $xx",
        0xE7 => "SBC [$xx]",
        0xE8 => "INX",
        0xE9 => "SBC #<d>",
        0xEA => "NOP",
        0xEB => "XBA",
        0xEC => "CPX $xxxx",
        0xED => "SBC $xxxx",
        0xEE => "INC $xxxx",
        0xEF => "SBC $xxxxxx",
        0xF0 => "BEQ #<d>",
        0xF1 => "SBC ($xx),Y",
        0xF2 => "SBC ($xx)",
        0xF3 => "SBC ($xx,S),Y",
        0xF4 => "PEA $xxxx",
        0xF5 => "SBC $xx,X",
        0xF6 => "INC $xx,X",
        0xF7 => "SBC [$xx],Y",
        0xF8 => "SED",
        0xF9 => "SBC $xxxx,Y",
        0xFA => "PLX",
        0xFB => "XCE",
        0xFC => "JSR ($xxxx,X)",
        0xFD => "SBC $xxxx,X",
        0xFE => "INC $xxxx,X",
        0xFF => "SBC $xxxxxx,X",
    }
}
