//! List of Sega Master System / Game Gear games that have battery-backed SRAM in the cartridge.
//! This is necessary because SMS/GG cartridges don't have a proper header
//!
//! List of games from <https://segaretro.org/Battery_backup>

const SMS_BATTERY_BACKUP_GAMES_CRC32: &[u32] = &[
    0x48651325, // Golfamania (E/B)
    0x0e333b6e, // Miracle Warriors (U/E/B)
    0xb9fdf6d9, // Miracle Warriors (J)
    0x69538469, // Monopoly (U/E)
    0x026d94a4, // Monopoly (E) (Rev A)
    0xf97e9875, // Penguin Land (U/E)
    0x2bcdb8fa, // Penguin Land (J)
    0xe4a65e79, // Phantasy Star (U/E)
    0x00bef1d7, // Phantasy Star (U/E) (Rev A)
    0x6605d36a, // Phantasy Star (J)
    0x07301f83, // Phantasy Star (J) (Virtual Console)
    0xdea82d8e, // Phantasy Star (J) (SMS Power! Retranslation Patch 2.3.1)
    0x75971bef, // Phantasy Star (B)
    0xa1e090b9, // Phantasy Star (World) (Sega Ages)
    0xdf96f194, // Phantasy Star (J) (Sega Ages)
    0xb52d60c8, // Ultima IV (E/B)
    0xb33e2827, // Ys (U/E/B)
    0x32759751, // Ys (J)
];

const GG_BATTERY_BACKUP_GAMES_CRC32: &[u32] = &[
    0x529c864e, // Crystal Warriors (U/E)
    0x35fa3f68, // Crystal Warriors (J)
    0xe2791cc1, // Defenders of Oasis (U/E)
    0x41a367a0, // Defenders of Oasis (U/E) (Virtual Console)
    0x09f9ed60, // Defenders of Oasis (J)
    0x04302bbd, // Eternal Legend (J)
    0x4cf97801, // Godzilla: Kaijuu Daishingeki (J)
    0xa12a28a0, // J.League GG Pro Striker '94 (J)
    0x4af7f2aa, // Kinetic Connection (J)
    0x58459edd, // Lunar: Walking School (J)
    0x7ec95282, // Madou Monogatari A (J)
    0x00c34d94, // Madou Monogatari I (J)
    0x12eb2287, // Madou Monogatari II (J)
    0x0a634d79, // Madou Monogatari III (J)
    0x568f4825, // Madou Monogatari III (J) (Rev A)
    0x8f82a6b9, // Magic Knight Rayearth (J)
    0x1c2c2b04, // Magic Knight Rayearth 2 (J)
    0xcf6d7bc5, // Magical Puzzle Popils (World)
    0x2e4ec17b, // Megami Tensei Gaiden: Last Bible (J)
    0x4ec30806, // Megami Tensei Gaiden: Last Bible Special (J)
    0x4d5d15fb, // Moldorian (J)
    0x73939de4, // Nazo Puyo 2 (J)
    0x3679be80, // Neko Daisuki! (J)
    0x4ed45bda, // Nomo Hideo's World Series Baseball (J)
    0xb42d8430, // Pet Club: Inu Daisuki! (J)
    0xa942514a, // Phantasy Star Gaiden (J)
    0x2da8e943, // Pro Yakyuu GG League (J)
    0xa1a19135, // Pro Yakyuu GG League '94 (J)
    0x445d7cd2, // Royal Stone (J)
    0x4d1f4699, // Shining Force Gaiden (J)
    0xa6ca6fa9, // Shining Force Gaiden II: The Sword of Hajya (U)
    0x1dc56beb, // Shining Force Gaiden II: The Sword of Hajya (U/E) (Virtual Console)
    0x30374681, // Shining Force Gaiden II: The Sword of Hajya (J)
    0x6019fe5e, // Shining Force Gaiden: Final Conflict (J)
    0xeb05c8ec, // Shining Force Gaiden: Final Conflict (J) (Virtual Console)
    0x45ef2062, // Sylvan Tale (J)
    0x7b7717b8, // Taisen-gata Daisenryaku G (J)
];

pub fn has_battery_backup(checksum: u32) -> bool {
    SMS_BATTERY_BACKUP_GAMES_CRC32.contains(&checksum)
        || GG_BATTERY_BACKUP_GAMES_CRC32.contains(&checksum)
}
