/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.start.config;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jetty.start.FS;
import org.eclipse.jetty.start.Props;
import org.eclipse.jetty.start.RawArgs;
import org.eclipse.jetty.start.UsageException;
import org.eclipse.jetty.start.config.CommandLineConfigSource;
import org.eclipse.jetty.start.config.ConfigSource;
import org.eclipse.jetty.start.config.DirConfigSource;

public class ConfigSources
implements Iterable<ConfigSource> {
    private LinkedList<ConfigSource> sources = new LinkedList();
    private Props props = new Props();
    private AtomicInteger sourceWeight = new AtomicInteger(1);

    public void add(ConfigSource source) throws IOException {
        if (this.sources.contains(source)) {
            throw new UsageException(-6, "Duplicate Configuration Source Reference: " + source, new Object[0]);
        }
        this.sources.add(source);
        Collections.sort(this.sources, new WeightedConfigSourceComparator());
        this.updateProps();
        for (RawArgs.Entry arg : source.getArgs()) {
            if (!arg.startsWith("--include-jetty-dir")) continue;
            String ref = this.getValue(arg.getLine());
            String dirName = this.props.expand(ref);
            Path dir = FS.toPath(dirName);
            DirConfigSource dirsource = new DirConfigSource(ref, dir, this.sourceWeight.incrementAndGet(), true);
            this.add(dirsource);
        }
    }

    public CommandLineConfigSource getCommandLineSource() {
        for (ConfigSource source : this.sources) {
            if (!(source instanceof CommandLineConfigSource)) continue;
            return (CommandLineConfigSource)source;
        }
        return null;
    }

    public Props.Prop getProp(String key) {
        return this.props.getProp(key);
    }

    public Props getProps() {
        return this.props;
    }

    private String getValue(String arg) {
        int idx = arg.indexOf(61);
        if (idx == -1) {
            throw new UsageException(-6, "Argument is missing a required value: %s", arg);
        }
        String value = arg.substring(idx + 1).trim();
        if (value.length() <= 0) {
            throw new UsageException(-6, "Argument is missing a required value: %s", arg);
        }
        return value;
    }

    @Override
    public Iterator<ConfigSource> iterator() {
        return this.sources.iterator();
    }

    public ListIterator<ConfigSource> reverseListIterator() {
        return this.sources.listIterator(this.sources.size());
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append(this.getClass().getSimpleName());
        str.append('[');
        boolean delim = false;
        for (ConfigSource source : this.sources) {
            if (delim) {
                str.append(',');
            }
            str.append(source.getId());
            delim = true;
        }
        str.append(']');
        return str.toString();
    }

    private void updateProps() {
        this.props.reset();
        ListIterator<ConfigSource> iter = this.sources.listIterator(this.sources.size());
        while (iter.hasPrevious()) {
            ConfigSource source = iter.previous();
            this.props.addAll(source.getProps());
        }
    }

    private static class WeightedConfigSourceComparator
    implements Comparator<ConfigSource> {
        private WeightedConfigSourceComparator() {
        }

        @Override
        public int compare(ConfigSource o1, ConfigSource o2) {
            return o1.getWeight() - o2.getWeight();
        }
    }
}

