
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
* Make sure that a Str has at least n bytes allocated.  The return value is sp
* if we succeed, or NULL if we fail.  The only reasons for failure is if sp is
* null or we are out of memory.
*/
Str *minStrM(
	Str *sp,
	int  n,
	char*d)		// Description for messages
{	Str *r=0;
	Fenter("minStrM");
	if (!sp) {
		V1 "### minstr(%08X,%d) called ###",sp,n V;
		Fail;
	}
	if (sp->v) {
		if (n < sp->m) Done;
	}
	n = Max(n+1,sp->m+mempad);	// Paranoia
	V5 "Expand %s from %d to %d bytes.",d,sp->m,n V;
	if (sp->v && sp->m) {	// Was it allocated?
		sp->v = (CP)memBlock(sp->v,sp->m,n,d);
	} else {				// Not allocated yet
		sp->v = (CP)memBlock(0,0,n,d);
	}
	unless (sp->v) {
		V1 "### OUT OF MEMORY (minStr can't get %d bytes) ###",n+1 V;
		Fail;
	}
	V6 "Expanded %s from %d to %d bytes ",d,sp->m,n V;
	sp->m = n;		// Use the requested length as the allocated length
done:
	FExit;
	return sp;
fail:
	FExit;
	return 0;
}

