/* -*- Mode: C; c-file-style: "gnu" -*-
   dump.c -- special code for outputting dump-class format for japharh.
   Created: Chris Toshok <toshok@hungry.com>
 */
/*
  This file is part of Japhar, the GNU Virtual Machine for Java Bytecodes.
  Japhar is a project of The Hungry Programmers, GNU, and OryxSoft.

  Copyright (C) 1998 The Hungry Programmers

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "config.h"
#include "ClazzFile.h"
#include "japharh.h"
#include "log.h"
#include "sig.h"
#include "util.h"

#include <assert.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

extern JNIEnv *the_env;
extern jboolean as_html;

void
spew_dump(ClazzFile *cf, char *bar_name)
{
  FILE *fp;
  char *filename;

  dots_to_underscores(bar_name);

  if (as_html)
    {
      filename = (char*)malloc(strlen(bar_name) + strlen(".html") + 1);
      sprintf (filename, "%s.html", bar_name);
    }
  else
    {
      filename = (char*)malloc(strlen(bar_name) + strlen(".out") + 1);
      sprintf (filename, "%s.out", bar_name);
    }
  
  fp = fopen(filename, "w");
  if (fp == NULL)
    {
      printf ("Couldn't open file '%s' for writing.\n", filename);
      free(filename);
      return;
    }
  
  output_header(fp, bar_name);
  spew_clazz(fp, cf);
  output_footer(fp);

  free(filename);
  
  fclose(fp);
}
