/* -*- Mode: C; c-file-style: "gnu" -*-
   inputthread.c -- native methods for sun/awt/motif/InputThread.
   Created: Chris Toshok <toshok@hungry.com>, 9-Mar-1998.
 */
/*
  This file is part of Japhar, the GNU Virtual Machine for Java Bytecodes.
  Japhar is a project of The Hungry Programmers, GNU, and OryxSoft.

  Copyright (C) 1998, 1999 The Hungry Programmers

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "config.h"
#include "jni.h"
#include "log.h"
#include "common.h"

#ifdef FOR_MOZILLA
PLEventQueue *_awt_eventQueue;
#endif

JNIEXPORT void JNICALL
Java_sun_awt_motif_InputThread_run(JNIEnv *env,
				   jobject inputthread)
{
  JAVARLOG0 (AWT_LOG, 2, "In Java_sun_awt_motif_InputThread_run\n");

#ifdef FOR_MOZILLA
  _awt_eventQueue = PL_CreateEventQueue("awt-eventqueue",
					PR_GetCurrentThread());

  PL_EventLoop(_awt_eventQueue);
#else
  
  while (JNI_TRUE)
    {
      XtInputMask pending;

      LOCK_AWT();
      
      pending = XtAppPending(_awt_appContext);

      if (pending)
	XtAppProcessEvent(_awt_appContext, pending);

      UNLOCK_AWT();
    }
#endif
}
