/* -*- Mode: C; c-file-style: "gnu" -*-
   frame.c -- native methods for sun/awt/motif/MFramePeer
   Created: Chris Toshok <toshok@hungry.com>, 3-Mar-1998.
 */
/*
  This file is part of Japhar, the GNU Virtual Machine for Java Bytecodes.
  Japhar is a project of The Hungry Programmers, GNU, and OryxSoft.

  Copyright (C) 1998, 1999 The Hungry Programmers

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "config.h"
#include "jni.h"
#include "ClazzFile.h"
#include "log.h"

#include "common.h"
#include <Xm/XmAll.h>
#include <assert.h>

static void
insets_to_ints(JNIEnv *env,
	       jobject insets,
	       int *x,
	       int *y,
	       int *width,
	       int *height)
{
  jclass insets_class = (*env)->GetObjectClass(env, insets);
  jfieldID top_field = (*env)->GetFieldID(env, insets_class, "top", "I");
  jfieldID left_field = (*env)->GetFieldID(env, insets_class, "left", "I");
  jfieldID right_field = (*env)->GetFieldID(env, insets_class, "right", "I");
  jfieldID bottom_field = (*env)->GetFieldID(env, insets_class, "bottom", "I");
  jint top = (*env)->GetIntField(env, insets, top_field);
  jint left = (*env)->GetIntField(env, insets, left_field);
  jint right = (*env)->GetIntField(env, insets, right_field);
  jint bottom = (*env)->GetIntField(env, insets, bottom_field);

  *x = left;
  *y = left;
  *width = right - left;
  *height = bottom - top;
}

JNIEXPORT void JNICALL
Java_sun_awt_motif_MFramePeer_create(JNIEnv *env,
				     jobject peer,
				     jobject parent_peer,
				     jobject insets)
{
  Widget shell;
  Widget main;
  Widget frame_widget;
  int x, y, width, height;
  Arg av[10];
  int ac;

  JAVARLOG2 (AWT_LOG, 2, "In Java_sun_awt_motif_MFramePeer_create(peer = %p, parent_peer = %p)\n",
	     peer, parent_peer);

  assert(NULL != peer);

  initialize_awt();

  insets_to_ints(env, insets, &x, &y, &width, &height);

  LOCK_AWT();

  ac = 0;
  XtSetArg(av[ac], XtNx, x); ac++;
  XtSetArg(av[ac], XtNy, y); ac++;
  XtSetArg(av[ac], XtNwidth, width); ac++;
  XtSetArg(av[ac], XtNheight, height); ac++;
  XtSetArg(av[ac], XmNallowResize, True); ac++;

  assert(ac < sizeof(av)/sizeof(Arg));
  assert(NULL != _awt_toplevelWidget);
  
  shell = XtCreateWidget("frame-shell",
			 topLevelShellWidgetClass,
			 _awt_toplevelWidget, /* XXX if parent_peer != NULL we should use its widget */
			 av, ac);

  assert(NULL != shell);

  main = XmCreateMainWindow(shell,
			    "main",
			    NULL, 0);

  XtSetArg(av[ac], XmNmarginHeight, 0); ac++;
  XtSetArg(av[ac], XmNmarginWidth, 0); ac++;
  XtSetArg(av[ac], XmNautoUnmanage, False); ac++;

  frame_widget = XmCreateBulletinBoard(main,
				       "main",
				       av, ac);

  add_component_event_handler(shell, peer);

  UNLOCK_AWT();

  assert(NULL != frame_widget);

  set_component_widget(env, peer, frame_widget);
}

JNIEXPORT void JNICALL
Java_sun_awt_motif_MFramePeer_pSetTitle(JNIEnv *env,
					jobject peer,
					jstring title)
{
  Widget frame_widget;
  const jbyte *title_text;

  JAVARLOG0 (AWT_LOG, 2, "In Java_sun_awt_motif_MFramePeer_pSetTitle()\n");

  frame_widget = get_component_widget(env, peer);
  title_text = (*env)->GetStringUTFChars(env, title, NULL);

  JAVARLOG2 (AWT_LOG, 2, "+  peer = %p, title_text = %s\n", peer, title_text);

  LOCK_AWT();

  XtVaSetValues(XtParent(XtParent(frame_widget)),
		XtNtitle, title_text,
		NULL);

  UNLOCK_AWT();

  (*env)->ReleaseStringUTFChars(env, title, title_text);
}

JNIEXPORT void JNICALL
Java_sun_awt_motif_MFramePeer_pShow(JNIEnv *env,
				    jobject peer)
{
  Widget frame_widget;

  JAVARLOG0 (AWT_LOG, 2, "In Java_sun_awt_motif_MFramePeer_pShow()\n");

  frame_widget = get_component_widget(env, peer);

  JAVARLOG2 (AWT_LOG, 2, "+  peer = %p, frame_widget = %p\n", peer, frame_widget);

  LOCK_AWT();

  JAVARLOG0 (AWT_LOG, 2, "managing child widget\n");
  XtManageChild(frame_widget);
  XtManageChild(XtParent(frame_widget));
  XtPopup(XtParent(XtParent(frame_widget)), XtGrabNone);

  UNLOCK_AWT();
  JAVARLOG0 (AWT_LOG, 2, "done\n");
}

JNIEXPORT void JNICALL
Java_sun_awt_motif_MFramePeer_pHide(JNIEnv *env,
				    jobject peer)
{
  Widget frame_widget;

  JAVARLOG1 (AWT_LOG, 2, "In Java_sun_awt_motif_MFramePeer_pHide(peer = %p)\n", peer);

  frame_widget = get_component_widget(env, peer);

  LOCK_AWT();

  XtUnmanageChild(frame_widget);
  
  UNLOCK_AWT();
}

JNIEXPORT void JNICALL
Java_sun_awt_motif_MFramePeer_pReshape(JNIEnv *env,
				       jobject peer,
				       jint x,
				       jint y,
				       jint width,
				       jint height)
{
  Widget frame_widget;
  Arg av[10];
  int ac;

  JAVARLOG4 (AWT_LOG, 2,
	     "In Java_sun_awt_motif_MFramePeer_pReshape(x=%d,y=%d,width=%d,height=%d)\n",
	     x, y, width, height);

  printf("In Java_sun_awt_motif_MFramePeer_pReshape(x=%d,y=%d,width=%d,height=%d)\n",
	 x, y, width, height);
  
  frame_widget = get_component_widget(env, peer);

  LOCK_AWT();

  ac = 0;
  XtSetArg(av[ac], XtNx, x); ac++;
  XtSetArg(av[ac], XtNy, y); ac++;

  if (width && height)
    {
      XtSetArg(av[ac], XtNwidth, width); ac++;
      XtSetArg(av[ac], XtNheight, height); ac++;
    }

  XtSetValues(XtParent(XtParent(frame_widget)), av, ac);

  UNLOCK_AWT();
}

JNIEXPORT void JNICALL
Java_sun_awt_motif_MFramePeer_pDispose(JNIEnv *env,
				       jobject peer)
{
  Widget frame_widget;

  JAVARLOG0 (AWT_LOG, 2, "In Java_sun_awt_motif_MFramePeer_pDispose\n");

  frame_widget = get_component_widget(env, peer);

  LOCK_AWT();

  XtDestroyWidget(XtParent(XtParent(frame_widget)));

  UNLOCK_AWT();
}

JNIEXPORT void JNICALL
Java_sun_awt_motif_MFramePeer_pSetIconImage(JNIEnv *env,
					    jobject obj,
					    jobject image)
{
  JAVARLOG0 (AWT_LOG, 2, "In sun_awt_motif_MFramePeer_pSetIconImage\n");
}

JNIEXPORT void JNICALL
Java_sun_awt_motif_MFramePeer_setResizable(JNIEnv *env,
					   jobject peer,
					   jboolean flag)
{
  Widget frame_widget;

  printf("In Java_sun_awt_motif_MFramePeer_setResizable(peer = %p, flag = %d)\n", peer, flag);

  frame_widget = get_component_widget(env, peer);

  LOCK_AWT();

  XtVaSetValues(XtParent(XtParent(frame_widget)),
		XmNallowShellResize, flag,
		NULL);

  UNLOCK_AWT();
}

/* JDK1.1 */
JNIEXPORT void JNICALL
Java_sun_awt_motif_MFramePeer_addTextComponent(JNIEnv *env,
					       jobject peer)
{
}

/* JDK1.2 */
JNIEXPORT void JNICALL
Java_sun_awt_motif_MFramePeer_addTextComponentNative(JNIEnv *env,
						     jobject peer)
{
}

/* JDK1.2 */
JNIEXPORT jboolean JNICALL
Java_sun_awt_motif_MFramePeer_hasTextComponents(JNIEnv *env,
						jobject peer)
{
  return JNI_FALSE; /* XXX */
}

/* JDK1.2 */
JNIEXPORT void JNICALL
Java_sun_awt_motif_MFramePeer_removeTextComponentNative(JNIEnv *env,
							jobject peer)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_motif_MFramePeer_pSetMenuBar(JNIEnv *env,
					  jobject peer,
					  jobject menubar_peer)
{
  Widget menubar;
  Widget w;

  Dimension width;

  JAVARLOG2 (AWT_LOG, 2, 
	     "In Java_sun_awt_motif_MFramePeer_pSetMenuBar(peer = %p, menubar_peer = %p)\n",
	     peer, menubar_peer);

  if (NULL == menubar_peer)
    {
      JAVARLOG0(AWT_LOG, 1, "menubar_peer is NULL in MFramePeer.pSetMenuBar\n");
      return;
    }

  w = get_component_widget(env, peer);
  menubar = get_menubar_widget(env, menubar_peer);

  if (NULL == menubar)
    {
      JAVARLOG0(AWT_LOG, 1, "menubar is NULL in MFramePeer.pSetMenuBar\n");
      return;
    }

  LOCK_AWT();

  XtVaSetValues(XtParent(w),
		XmNmenuBar, menubar,
		NULL);

  XtManageChild(menubar);

  UNLOCK_AWT();
}

JNIEXPORT void JNICALL
Java_sun_awt_motif_MFramePeer_toBack(JNIEnv *env,
				     jobject peer)
{
  Widget frame_widget;

  JAVARLOG0 (AWT_LOG, 2, "In Java_sun_awt_motif_MFramePeer_toBack\n");

  frame_widget = get_component_widget(env, peer);

  LOCK_AWT();

  XLowerWindow(_awt_Display, XtWindow(XtParent(XtParent(frame_widget))));
  
  UNLOCK_AWT();
}

/* JDK1.2 */
JNIEXPORT void JNICALL
Java_sun_awt_motif_MFramePeer_initIDs(JNIEnv *env,
				      jclass peer_cls)
{
}
