/* -*- Mode: C; c-file-style: "gnu" -*-
   jvmdimsc.c -- JVMDI Miscellaneous Functions
   Created: Hernan Otero <hernan_otero@bigfoot.com>, 18-Jul-1998.
 */
/*
  This file is part of Japhar, the GNU Virtual Machine for Java Bytecodes.
  Japhar is a project of The Hungry Programmers, GNU, and OryxSoft.

  Copyright (C) 1998, 1999 The Hungry Programmers

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "jvmdiint.h"
#include "class-repository.h"
#include "log.h"

#define MYLOG "JVMDI"

JNIEXPORT jvmdiError JNICALL
JVMDI_GetLinkedClasses(JNIEnv *env,
		       jint *classCountPtr, jclass **classesPtr)
{
  if (env == NULL
      || classCountPtr == NULL
      || classesPtr == NULL) {
    return JVMDI_ERROR_NULL_POINTER;
  }

  *classCountPtr = get_num_loaded_classes(env);
  if (JVMDI_Allocate(env, *classCountPtr * sizeof(jclass),
		     (jbyte**) classesPtr) == JVMDI_ERROR_OUT_OF_MEMORY) {
    return JVMDI_ERROR_OUT_OF_MEMORY;
  }

  get_loaded_classes(env, *classesPtr);

  return JVMDI_ERROR_NONE;
}

JNIEXPORT jvmdiError JNICALL
JVMDI_GetVersionNumber(JNIEnv *env,
		       jint *versionPtr)
{
  *versionPtr = JVMDI_VERSION_NUMBER;
  return JVMDI_ERROR_NONE;
}
