/* -*- Mode: C; c-file-style: "gnu" -*-
   signals.c -- wrapper for signal handlers
   Created: Petter Reinholdtsen <pere@td.org.uit.no>, 1998-05-21
 */

/*
  This file is part of Japhar, the GNU Virtual Machine for Java Bytecodes.
  Japhar is a project of The Hungry Programmers, GNU, and OryxSoft.

  Copyright (C) 1997, 1998, 1999 The Hungry Programmers

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include "signals.h"
#include <stdio.h>
#include <signal.h>
#include <assert.h>

static SIGNAL_handler signal_handler = NULL;

/* Sets SIGBUS and SIGSEGV to default and calls the installed handler */
static void
japhar_signal_handler(int signal)
{
#ifdef HAVE_SIGACTION
  struct sigaction sigact;

  sigact.sa_handler = SIG_DFL;
  sigemptyset(&sigact.sa_mask);
  sigact.sa_flags = 0;

# ifdef SIGBUS
  sigaction(SIGBUS, &sigact, NULL);
# endif
# ifdef SIGSEGV
  sigaction(SIGSEGV, &sigact, NULL);
# endif
#endif

  if (NULL != signal_handler)
    signal_handler(signal);
  else
    SIGNAL_crash();
}

/* Should only be called once */
void SIGNAL_install(void (*handler)(int))
{
  if (!signal_handler)
    {
#ifdef HAVE_SIGACTION
      struct sigaction sigact;
#endif
      
      assert(NULL != handler);
      
#ifdef HAVE_SIGACTION
      sigact.sa_handler = japhar_signal_handler;
      sigemptyset(&sigact.sa_mask);
      sigact.sa_flags = 0;
      
# ifdef SIGBUS
      sigaction(SIGBUS, &sigact, NULL);
# endif
# ifdef SIGSEGV
      sigaction(SIGSEGV, &sigact, NULL);
# endif
#else
# ifdef SIGBUS
      signal(SIGBUS, japhar_signal_handler);
# endif
# ifdef SIGSEGV
      signal(SIGSEGV, japhar_signal_handler);
# endif
#endif
    
      signal_handler = handler;
    }
}

void SIGNAL_crash(void)
{
#ifdef SIGBUS
  raise(SIGBUS);
#elif defined(SIGABRT)
  raise(SIGABRT);
#endif
}
