#!/usr/bin/env python
# -*- coding: iso-8859-13 -*-
#
# Autorius: Albertas Agejevas, 2003
# Koregavo: Laimonas Vbra, 2010
#
# Pastaba: veikia su Python v2.3+
#
"""
ispell-lt projekto/odyno rankis.
Suglaudia/sutraukia priedlinius veiksmaodius, pvz.: 
    pa|eina, nu|eina, at|eina, ... -> eina/bef...

o taip ir skirtingas tokio paio odio afikso ymas, pvz.:
    dviratis/D, dviratis/B -> dviratis/DB 

odiai ir j ymos glaudiamos tik suderinam (kalbos dali) 
grupse. Dabar tai: veiksmaodiai, bdvardiai ir lik.  Taip 
padaryta todl, kad veiksmaodiai gali turti aib priedlini 
ym ir kartu su kitos kalbos ymomis gali generuoti daug 
neteising form, arba danos bdvardi /N ymos ne visuomet 
tinka daiktavardiams (ir kt.), pvz.:

    jung/D       (daiktavardis)
    jung/Pef...  (bt. k. l. veiksmaodis)

    jung/DPef... generuot neteisingas formas: 
        {priedliai}{daikt. 'jung' linksniai}

    baltaodis/BDN -> ne[be]baltaodiui (daiktavardis) -- blogai,    
                  -> ne[be]baltaodiam (bdvardis)    -- gerai.

Naudojimas:
    ./sutrauka odynas.txt > sutraukta.txt
    cat odynas.txt | ./sutrauka > sutraukta.txt

"""
import os
import sys
import fileinput

from locale import setlocale, getdefaultlocale, LC_COLLATE, strxfrm

# sets modulis paseno ir nuo v2.6+ sistemoje (built-in) j keiia
# set/frozenset tipai; importuojant pasenus -- spjama (warning).
if sys.version_info < (2, 6):
    from sets import Set


wcount = 0  # constringed words count
bcount = 0  # saved bytes count


def _stats(word, cflags, var=0):
    global wcount, bcount
    
    # Statistika (sutaupyta odi ir vietos)... 
    #
    # Kiek sutaupoma vietos (bcount) suskliaudiant od:
    # odio ilgis + bendr ym kiekis + _papildomi_ (2 arba 1)
    # priklausomai nuo varianto:
    #   - kai odis be afiks -- sutaupoma: '/', '\n' (2)
    #   - kai [var]iantas > 0 -- priedlinis veiksmaodis ir
    #                            sutaupoma:      '\n' (1)
    #                            ('/' keiia priedlio afikso yma)
    #

    wcount += 1

    if not (var and cflags):
        le = 2
    else:
        le = 1

    bcount += len(word) + len(cflags) + le


def _set(arg=''):
    if sys.version_info < (2, 6):
        return Set(arg)  
    else:
        return set(arg)


def sutrauka(lines, outfile=sys.stdout, myspell=True):
    i = 0
    adjes = {}
    verbs = {}
    words = {}


    vflags = _set("TYEP")  # verb flags -- veiksmaodi gr. ymos.
    aflags = _set("AB")    # adjective flags -- bdvardi gr. ymos.

    # Debug
    #f = open('./sutrauka.err', 'w')
    
    # win lokals atpainimo/nustatymo problemos...
    locale = getdefaultlocale()
    if os.name is "nt":
        locale = "Lithuanian"

    try:
        setlocale(LC_COLLATE, locale)
    except:
        sys.stderr.write("Could not set locale\n")


    sys.stderr.write("\n--- " + sys.argv[0] + ' ' + 
                     '-' * (60 - len(sys.argv[0]) - 5) + 
                     "\nReading ")        

    for line in lines:
        # Skaitymo progresas...
        if not lines.lineno() % 5000:
            sys.stderr.write(".")
            sys.stderr.flush()

        # Ignoruojamos tuios ir komentaro eiluts.
        line = line.split("#")[0]
        line = line.strip()
        if not line:
            continue
       
	# Eilut skeliama  od ir jo ym rinkin.
        sp = line.split("/")
        word = sp[0]
        if len(sp) > 1:
            wflags = _set(sp[1])
        else:
            wflags = _set()
       
        # Veiksmaodiai ir bdvardiai  atskirus dict.
        if vflags & wflags:
            d = verbs
        elif aflags & wflags:
            d = adjes
        else:
            d = words

        # odis pridedamas  dict arba jei jau yra -- suliejamos ymos
        if word not in d:
            d[word] = wflags
        else:
            swflags = d[word]  # stored word flags
           
            # Debug
            #f.write("Skliaudiamas odis '%s':\n\t"
            #        "aff: %s\n\t"
            #        "aff: %s\n" % (word, wflags, swflags))

            _stats(word, swflags & wflags)
            swflags.update(wflags)


    sys.stderr.write("\nProcessing ")

    # Suskliaudiami priedliniai veiksmaodiai
    d = verbs
    for word in d.keys():
        # Apdorojimo progresas...
        i += 1
        if not (i % 5000):
            sys.stderr.write(".")
            sys.stderr.flush()
       
        # odis (jau) galjo bti paalintas i words dict...
        if word not in d:
            continue

        # odio afiks ym rinkinys.
        wflags = d[word]
                
        # Kiekvienam odyno odiui derinami/tikrinami visi priedliai.
        for pflag, pref in prefixes:

            if word.startswith(pref):

                # Jei pref sangrinis priedlis, tai odis atmetus paprastj 
                # (nesangrin) priedl, pvz.: i{si}|urbia -> siurbia.
                # Kai toks odis yra odyne, tai situacija netriviali, nes 
                # odyne yra trys odio formos: su priedliu, be priedlio 
                # ir be sangrinio priedlio.  Tampa nebeaiku kok priedl 
                # (sangrin ar ne) ir kokiam odiui pritaikyti; toki 
                # odi savaime suskliausti nemanoma, pvz.:
                #     i{si}|urbia, siurbia, urbia (i|siurbia ar isi|urbia?)
		#     at{si}|joja, sijoja, joja;   (at|sijoja ar atsi|joja?)
                #
                # (word without reflexive prefix part)
                #
                if pref.endswith("si"):
                    wrpword = word[len(pref)-2:]     
                else:
                    wrpword = None
                
    
                # odis be priedlio, pvz.: per|oko -> oko.
                # (word without prefix) 
                wpword = word[len(pref):]                
                
                if wpword in d:
                    wpflags = d[wpword]
   
                    if wrpword not in words:
                        # and wflags.issubset(wpflags))
                        #
                        # Skliaudiant priedlinius veiksmaodius dl /X /N 
                        # priedlini dalelyi (ispell apribojimo jas 
                        # pridedant/jungiant) prarandamos kelios priedlinio 
                        # veiksmaodio formos, pvz:
                        #   pavartyti/X  >  te|pa|vartyti, tebe|pa|vartyti, 
                        #                   be|pa|vartyti, ...
                        # vs
                        #    vartyti/Xf  >  tevartyti, tebevartyti, 
                        #                   bevartyti, ...
                        #
                        # Todl skliaudiant nebtina tikrinti ar sutampa odi
                        # (priedlinio ir akninio) ym aibs; praradimas vyksta, 
                        # net jei jos sutampa, o netikrinant, t.y. susitaikius su
                        # ir taip vykstaniu priedlini darini/form: 
                        #  [tebe, be, te, nebe] {priedlis} odis 
                        #
                        # praradimu, odyn suglaudinamas dar vir 50 kB.
                        #
                        # ARBA atvirkiai -- siekiant, kad nebt praradim, kaip 
                        # tik nereikt toki odi (jei priedlinis odis turi 
                        # /X, /N ymas) glaudinti.
                        
                        # Debug
                        #f.write("\nNeskliaudiamas odis '%s|%s', "
                        #        "nes nesiderina afiksai:\n\t"
                        #        "(su pried.) aff: %s\n\t"
                        #        "(be pried.) aff: %s\n" % \
                        #            (pref, wpword, wflags, wpflags))
                                
                        _stats(word, wflags & wpflags, 1)

                        # Suliejamos afiks ymos ir pridedama priedlio yma.
                        wpflags.update(wflags)
                        wpflags.add(pflag)
                 
                        # odis sukliaustas (prie akninio odio sulietos 
                        # ymos, pridta priedlio afikso yma).  Paaliname 
                        # priedlin od i 'verbs' dict ir baigiame 
                        # priedli cikl, nes priedliai unikals ir odio
                        # pradia nebegali sutapti su jokiu kitu priedliu.
                        del d[word]
                        break

    sys.stderr.write(" done.\n"    
                     "Words constringed: %d, "
                     "bytes saved: %d.\n" % (wcount, bcount) + '-' * 60 + '\n')

    res = []
    for word, flags in words.items() + verbs.items() + adjes.items():
        if flags:
            f = list(flags)
            f.sort()
            end = "/" + "".join(f)
        else:
            end = ""

        res.append((strxfrm(word), word + end))

    res.sort()

    # myspell'o odyno pradioje -- odi kiekis.
    if myspell:
        print >> outfile, len(res)

    for word in res:
        print >> outfile, word[1]

prefixes = (
    ("a", "ap"),
    ("a", "api"),
    ("b", "at"),
    ("b", "ati"),
    ("c", ""),
    ("d", "i"),
    ("e", "nu"),
    ("f", "pa"),
    ("g", "par"),
    ("h", "per"),
    ("i", "pra"),
    ("j", "pri"),
    ("k", "su"),
    ("l", "u"),
    ("m", "apsi"),
    ("n", "atsi"),
    ("o", "si"),
    ("p", "isi"),
    ("q", "nusi"),
    ("r", "pasi"),
    ("s", "parsi"),
    ("t", "persi"),
    ("u", "prasi"),
    ("v", "prisi"),
    ("w", "susi"),
    ("x", "usi"),
    )


if __name__ == "__main__":
    sutrauka(fileinput.input(), myspell=False)
