package isect.io;

import java.lang.Runtime.*;
import java.lang.System.*;
import isect.util.*;

public class IsdIO {
	static {
		System.loadLibrary("isdio");
	}
	public final java.lang.String ISDHOSTNAME = "isectd";
	public final java.lang.String ISDSERVICE = "op";
	public final java.lang.String ISDXSERVICE = "isdexec";
/**
 * Insert the method's description here.
 * Creation date: (06/06/00 %r)
 * @return int
 * @param hostname java.lang.String
 * @param service java.lang.String
 * @param workerID java.lang.String
 * @param priority int
 */
public native int isdAttach(String hostname, String service, String workerID, int priority);
/**
 * Insert the method's description here.
 * Creation date: (06/01/00 %r)
 * @return int
 * @param hostname java.lang.String
 * @param service java.lang.String
 * @param priority int
 */
public native int isdLogin(String hostname, String service, int priority);
/**
 * Insert the method's description here.
 * Creation date: (06/01/00 %r)
 */
public native int isdLogout(int fd);
/**
 * Insert the method's description here.
 * Creation date: (06/05/00 %r)
 * @return int
 * @param fd int
 * @param message isect.util.ByteArray
 * @param len int
 * @param header isect.io.IsdHeader
 */
public native int isdRecvAll(int fd, byte[] buffer, int len);
/**
 * Insert the method's description here.
 * Creation date: (06/05/00 %r)
 * @return int
 * @param fd int
 * @param message isect.util.ByteArray
 * @param len int
 * @param header isect.io.IsdHeader
 */
public native int isdRecvBuffer(int fd, byte[] header, byte[] buffer, int bufferLength);
/**
 * Insert the method's description here.
 * Creation date: (06/05/00 %r)
 * @return int
 * @param fd int
 * @param message isect.util.ByteArray
 * @param len int
 * @param header isect.io.IsdHeader
 */
public native int isdRecvHeader(int fd, byte[] header);
/**
 * Insert the method's description here.
 * Creation date: (06/05/00 %r)
 * @return int
 * @param fd int
 * @param header isect.io.IsdHeader
 * @param byteArray isect.util.ByteArray
 */
public int isdRecv(int fd, IsdHeader header, ByteArray byteArray) {
	return isdRecvBuffer(fd, header.getByteArray(), byteArray.getByteArray(), byteArray.getByteArray().length);
}
/**
 * Insert the method's description here.
 * Creation date: (06/05/00 %r)
 * @return int
 * @param fd int
 * @param message isect.util.ByteArray
 * @param len int
 * @param header isect.io.IsdHeader
 */
public native int isdSend(int fd, byte[] message, int len, byte[] header);
/**
 * Insert the method's description here.
 * Creation date: (06/05/00 %r)
 * @return int
 * @param fd int
 * @param message isect.util.ByteArray
 * @param len int
 * @param header isect.io.IsdHeader
 */
public int isdSend(int fd, ByteArray message , int len, IsdHeader header) {
	return isdSend(fd, message.getByteArray(), len, header.getByteArray());
}
/**
 * Insert the method's description here.
 * Creation date: (06/05/00 %r)
 * @return int
 * @param socket int
 * @param message java.lang.String
 * @param len int
 */
public int isdSend(int socket, String message, int len) {
	IsdHeader header = new IsdHeader();
	ByteArray bytes = new ByteArray(message.getBytes());

	header.reply(1);

	return isdSend(socket, bytes, message.length(), header);
}
/**
 * Insert the method's description here.
 * Creation date: (06/01/00 %r)
 * @param args java.lang.String
 */
public static void main(String[] args) {
	int sock;
	IsdIO libio = new IsdIO();
	IsdHeader header = new IsdHeader();
	ByteArray buffer = new ByteArray(8192);
	
	sock = libio.isdLogin("localhost","echo",2);

	if (sock != -1) {
		libio.isdSend(sock, "hello", -1);
		libio.isdRecv(sock, header, buffer);
	}
	libio.isdLogout(sock);
}
}
