/*
Copyright, 2000, Isect

05/17/2000	used for forwarding requests from one isectd to another.

			configure as:

				CONFIG service oplink
				go
				CONFIG worker oplink localhost /usr/local/bin/isdlink -h localhost:9292:op
				go
*/
#include <stdio.h>
#include <errno.h>
#include "isdio.h"
#include <string.h>

#define max(a, b) (a) > (b) ? (a):(b)

int main(int argc, char **argv)
{
	int mask, status, bytes;
	SOCKET fromSock, toSock = -1;
	isdHeader header;
	char *msgBuffer;
	fd_set readfds;

	char *host = NULL, *port = NULL, *service = NULL;

	char c;
	extern char *optarg;
	extern int optind, opterr, optopt;

	isdLogInit(argc, argv);

	if (argc >= ISDARGMAX) {

		opterr = 0;
		while ((c = getopt(argc - ISDARGMAX, &argv[ISDARGMAX], "h:")) != -1) {
			switch (c) {
				case 'h':
					if (optarg) {
						host = optarg;
						if (port = strchr(host, ':')) {
							if (service = strchr(port + 1, ':')) {
								*service++ = 0;
							}
						}
						toSock = isdLogin(host, service ? service : NULL, 2);
						isdLog("toSock = %d\n", toSock);
					}
					break;
				
				default:
					break;
			}
		}

		if (toSock >= 0) {
			if ((fromSock = isdConnect(argv)) != -1) {

				mask = max(fromSock, toSock);

				FD_ZERO(&readfds);
				for (;;) {
/*
 * Loop around on the select until
 * something shows up.
 */
					FD_SET(fromSock, &readfds);
					FD_SET(toSock, &readfds);
					for (status = -1; status == -1;) {
						status = select(mask + 1, &readfds, (fd_set *) 0, (fd_set *) 0, (struct timeval *) 0);
						if (status == SOCKET_ERROR && errno != EINTR) {
							isdError("select()ing\n");
							exit(1);
						}
					}
/*
 * If it's a request from a client, send it to the worker.
 */
					if (FD_ISSET(fromSock, &readfds)) {
						if (msgBuffer = isdRecv(fromSock, &header)) {
							bytes = isdSend(toSock, msgBuffer, header.len, &header);
							if (bytes < 0)
								isdError("%s: isdSend() request\n", argv[ISDARGWID], strerror(errno));
						}
						else // my isectd has disconnected?
							break;
					}

					if (FD_ISSET(toSock, &readfds)) {
						if (msgBuffer = isdRecv(toSock, &header)) {
							bytes = isdSend(fromSock, msgBuffer, header.len, &header);
							if (bytes < 0)
								isdError("%s: isdSend() reply\n", argv[ISDARGWID], strerror(errno));
						}
						else // the remote isectd has disconnected?
							break;
					}
				}
				isdLog("Worker %s exiting\n", argv[ISDARGWID], strerror(errno));
				isdLogout(fromSock);
				isdLogout(toSock);
			}
			else
				isdError("isdConnect(): %s\n", strerror(errno));
		}
		else
			isdError("isdLogin(): %s\n", strerror(errno));
	}
	else
		fprintf(stderr, "Incorrect number of arguments\n");
	return 0;
}
