#import "IsdIO.h"

@implementation IsdIO
- (int) login: (char *) hostname service: (char *) aString priority: (int) anInteger
{
	return socket = isdLogin(hostname, aString, anInteger);
}

- (void) logout
{
	isdLogout(socket);
}

- (int) send:(char *)aString
{
	return [self send: aString len: -1];
}

- (int) send:(char *) aString len:(int) anInteger
{
	id hdr;
	hdr = [IsdHeader new];
	[hdr reply: 1];
	return [self send: aString len: anInteger header:hdr];
}

- (int) send:(char *) aString len:(int) anInteger header:anIsdHeader
{
	return isdSend(socket, aString, anInteger, [anIsdHeader pointer]);
}

- recvHeader
{
	id hdr;
	int bytes;

	hdr = [IsdHeader new];
	if (isdRecvHeader(socket, [hdr pointer]) == 0) {
		[hdr free];
		hdr = nil;
	}
	return hdr;
}

- (int) recvAll:(char *) buffer len:(int) anInteger
{
	return isdRecvAll(socket, buffer, anInteger);
}
@end
