#include "isectd.h"
#include "tvfuncs.h"
char *
isdStatWorkerQueue(char *cp, Queue * queue)
{
	ISDTIMETYPE now, tp;
	isdWorker *worker;

	cp += ADDBYTES(sprintf(cp, "%16s  %10s  %6s  %16s  %10s  %8s  %10s  %10s  %10s  %10s  %5s\n",
						   "service", "worker id", "avail?", "hostname", "host pid", "xactions", "avg. resp.", "last resp.", "restarts", "client id", "fd"));

	for (worker = (isdWorker *) queue->head; worker != (isdWorker *) QNULL; worker = (isdWorker *) worker->node.next) {
		now = worker->LastTime;
		if (queue == &isdData.BusyWorkers && worker->header.command == 0) {
			GetTime(&tp);
			now = tvMinus(&tp, &worker->LastTime);
		}

		cp += ADDBYTES(sprintf(cp, "%16s  %10d  %6s  %16s  %10d  %8d  %6d.%03.3d  %6d.%03.3d  %10d  %10d  %5d\n",
							   worker->name,
							   worker->id,
							   worker->stopped ? "no" : "yes",
#ifdef inet_ntoa
							   inet_ntoa(worker->sockaddr.sin_addr.s_addr),
#else
							   worker->loghost,
#endif
							   worker->hostpid,
							   worker->Transactions,
		  worker->AverageTime.tv_sec, worker->AverageTime.tv_usec / 1000,
							   now.tv_sec, now.tv_usec / 1000,
							   worker->restarts,
							   worker->client ? worker->client->id : 0,
							   worker->socket));
	}
	return cp;
}
