#include "isectd.h"

void 
isdLazyWorker(isdWorker * worker)
{
	isdHeader header;

	if (worker->client) {
		isdLog("On-strike worker %d working for client %d\n", worker->id, worker->client->id);
		if (worker->client->socket != INVALID_SOCKET && worker->header.reply) {
			header = worker->header;
			header.reply = 0;

   			header.error = ISDERRWORKERDEATH;
 
			isdSend(worker->client->socket, "" /* DELIVERY_FAILURE */ , -1, &header);
		}
		worker->client = NULL;
	}

	isdLogout(worker->socket);
	FD_CLR(worker->socket, &isdData.allfds);
	worker->socket = INVALID_SOCKET;
	InsertTail(&isdData.LazyWorkers, RemoveNode((Node *) worker));
}
