/*
1/3/2001	tgagne@ix.netcom.com	if (client->header.reply)...
6/6/2000	make sure the request to isdCommand is null terminated.
*/

#include <stdlib.h>
#include "isectd.h"

void isdCheckReady(fd_set readfds)
{
	Node *node;
	isdClient *client;
	char *requestNullTerminated, *msgBuffer, *cp;

	for (node = QNULL; (node = QueueSearch(&isdData.PriList, QEQ, offsetof(isdClient, ready), 0, node)) != QNULL;) {
		client = (isdClient *) node;
		if (client->socket == INVALID_SOCKET)
			node = (Node *) isdClientEOF(client);
		else {
			if (FD_ISSET(client->socket, &readfds)) {
				isdLogEvent("request from client %d", client->id);
				msgBuffer = isdRecv(client->socket, &client->header);
				if (msgBuffer) {
					isdLogEvent("  len=%d, seq=%d, more=%d",
								client->header.len,
								client->header.sequence,
								client->header.more);
					client->fromCount++;
					client->msgBuffer = malloc(client->header.len);
					memcpy(client->msgBuffer, msgBuffer, client->header.len);

/*
   We no longer want to require an available echo worker
   for operator commands, so we'd better handle them now
 */
					if (client->service_id == isdData.opid) {
						requestNullTerminated = malloc(client->header.len + 1);
						memcpy(requestNullTerminated, client->msgBuffer, client->header.len);
						requestNullTerminated[client->header.len] = 0;
						cp = isdCommands(requestNullTerminated);
						free(requestNullTerminated);
						client->header.len = -1;
						isdClientSend(client, cp, &client->header);
					}
					else {
						client->ready = 1;
						if (client->worker)
							isdToWorker(client->worker);
						/* if (client->header.reply)
						if (!client->header.more)
							*/
						FD_CLR(client->socket, &isdData.allfds);
					}
				}
				else
					node = (Node *) isdClientEOF(client);
			}
		}
	}
}
