/*
5/17/2000	if *name is an integer value, use that as the port number instead
			of looking one up by name (getservbyname()) or assigning a random
			port.
*/

#include "isdio.h"

SOCKET Xport 
isdSocket(char *name, char *protocol, SOCKET * sock, int *port)
{
	int length, err = -1;
	struct sockaddr_in server;
	struct servent *servent;
	static char *unnamed = "UNNAMED";
	char *endptr;

	*sock = INVALID_SOCKET;
	*port = -1;

	if (!name)
		name = unnamed;

	if ((*sock = socket(AF_INET, SOCK_STREAM, 0)) != INVALID_SOCKET) {
		isdSockOpts(*sock);
		err = 0;
		server.sin_family = AF_INET;
		server.sin_addr.s_addr = INADDR_ANY;
		server.sin_port = 0;
		if (name != unnamed) {
			err = 0;
/*
check to see if name is a number.  If it is then a port
number was specified instead of a name
*/
			server.sin_port = htons(strtol(name, &endptr, 10));
			if (*endptr) {
				if (servent = getservbyname(name, protocol))
					server.sin_port = servent->s_port;
				else {
					err = -1;
					isdError("getservbyname(\"%s\", \"%s\")\n", name, protocol);
					isdLog("Couldn't find \"%s\" in /etc/services.\n", name);
				}
			}
		}

		if (err == 0) {
			err = -1;
			if (bind(*sock, (struct sockaddr *) &server, length = sizeof server) >= 0) {
				if (getsockname(*sock, (struct sockaddr *) &server, &length) == 0) {
					isdLog("%s assigned port #%d\n", name, *port = ntohs(server.sin_port));
					listen(*sock, SOMAXCONN);
					err = 0;
				}
				else
					isdError("getsockname() for %s\n", name);
			}
			else
				isdError("bind()ing %s\n", name);
		}
	}
	else
		isdError("socket()ing %s\n", name);

	return err;
}
