/*
01/03/2001	tgagne@ix.netcom.com	added -r to ignore replies
05/22/2000	tgagne@ix.netcom.com	replaced the way we parse command 
									line options with getopt().

									Added -i argument so XML files w/o 
									a go\n could be sent.
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <malloc.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <sys/time.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include "isdio.h"


#ifdef HAVE_W3C_LIBWWW_WWWLIB_H
#include "w3c-libwww/WWWLib.h"
#ifdef LIBWWW_SHARED
#include "HTextImp.h"
#endif
#endif

#define ISDCLIENT_BUFSIZE 4096

#define max(a, b) (a) > (b) ? (a):(b)

/*
 * I like having a single structure through which
 * global environment stuff is kept.
 */

static struct {
	SOCKET sock;
	int keep;
	long sequence;
	int unescapeURLs;
	int debug;
	int sendOnEOF;
	int reply;
	int runOneCommand;
	FILE *inputFile;
	char *command;
	char *host;
	char *service;
} isdClientData;

static char *sendRequest(char *request)
{
	static int sequence = 0;
	isdHeader header;
	char *msgBuffer;

	memset((char *) &header, 0, sizeof header);
	header.reply = isdClientData.reply;
	header.error = 0;
	header.more = isdClientData.keep;
	header.sequence = ++isdClientData.sequence;

#ifdef HAVE_LIBWWW
	if (unescapeURLs)
		HTUnEscape(request);
#endif
	if (isdClientData.debug)
		fprintf(stderr, "isdSend()ing [%s]\n", request);

	if (isdSend(isdClientData.sock, request, -1, &header) == -1) 
		perror("isdSend()ing");

	return 0;
}

/*
 * get a message from isectd.  Return the value
 * of header.more, meaning:
 * !0 = there's more to get and
 * 0 = there's no more to get.
 */

static void getResponse(isdHeader *header)
{
	char *msgBuffer;

/*
 * initialize some fields inside the header so garbage doesn't get
 * misinterpreted.
 */
	header->len = header->more = header->error = 0;

	if (msgBuffer = isdRecv(isdClientData.sock, header)) {
		if (header->error == ISDERROK)
			fwrite(msgBuffer, strlen(msgBuffer) < header->len ? strlen(msgBuffer) : header->len, 1, stdout);
		else
			fputs("There was an error processing the message.\n", stderr);
	} 
	else {
		perror("isdRecv()");
		fputs("The daemon may have terminated.\n", stderr);
		exit(1);
	}
}

/*
 * getRequest() reads input from isdClientData.inputFile and
 * looks for the "go" at the end, indicating the previous
 * stuff should be sent.  When getRequest() sends its
 * message to isectd, it returns non-zero.
 */

static int getRequest(void)
{
	int size, newsize, sentRequest = 0;
	char *command;
	static char *request = NULL;
	char inputBuffer[ISDCLIENT_BUFSIZE];

	if (request == NULL)
		*(request = malloc(size = ISDCLIENT_BUFSIZE)) = 0;

	command = fgets(inputBuffer, ISDCLIENT_BUFSIZE, isdClientData.inputFile);

	if (command == inputBuffer) {
		isdClientData.sequence++;
/*
 * It would be nice if it didn't have to be newline terminated, but 
 * instead could be null terminated or just a go on a line by 
 * itself, but I suppose I'd have to trim the right-side of the 
 * string of all whitespace characters.  I'm too lazy to do that 
 * today.  I'd rather write comments into my code.
 */
		if (strcmp(inputBuffer, "go\n") == 0) {
			sendRequest(request);
			sentRequest = 1;
			*request = 0;
		}
		else {
			newsize = (((strlen(request) + strlen(inputBuffer)) / 4096) + 1 ) * 4096;
			if (newsize > size)
				request = realloc(request, size = newsize);
			strcat(request, inputBuffer);
		}
		/*
		if (isdClientData.sendOnEOF)
			sendRequest(request);
		*/
	}

	return sentRequest;
}

static int clientInit(int argc, char **argv)
{
	int i, c, usage = 0;
	extern char *optarg;
	extern int optind, opterr, optopt;

#ifndef _Windows
	setbuf(stdin, NULL);
#endif

#ifdef HAVEWWW
	HTLibInit(PACKAGE, VERSION);
#endif

	isdClientData.inputFile = stdin;
	isdClientData.reply = 1;
	isdClientData.service = ISDSERVICE;

	while ((c = getopt(argc, argv, "c:dh:i:kru")) != -1) {
		switch (c) {
		case 'c':
			if (optarg) {
				isdClientData.runOneCommand = 1;
				isdClientData.command = optarg;
			}
			else
				usage = 1;
			break;

		case 'd':
			isdClientData.debug = 1;

			for (i = 0; i < argc; i++)
				fprintf(stderr, "argv[%d] = [%s]\n", i, argv[i]);

			fprintf(stderr, "optind = %d\n", optind);

			break;

		case 'h':
			if (optarg)
				isdClientData.host = optarg;
			else
				usage = 1;

			break;

		case 'i':
			if (optarg) {
				fprintf(stderr, "Reading from '%s'\n", optarg);
				if (!(isdClientData.inputFile = fopen(optarg, "r"))) {
					perror(optarg);
					usage = 1;
				}
				/* else
					isdClientData.sendOnEOF = 1; */
			}
			else
				usage = 1;
			break;

		case 'k':
			isdClientData.keep = 1;
			break;

		case 'r':
			isdClientData.reply = 0;
			break;

		case 'u':
			isdClientData.unescapeURLs = 1;
			break;

		default:
			usage = 1;
			break;
		}
	}

	if (optind < argc)
		isdClientData.service = argv[optind];

	return usage;
}

#define CLIENTFILENO fileno(isdClientData.inputFile)

int main(int argc, char *argv[])
{
	int status, mask, receivedReply;
	char *request;
	fd_set readfds, allfds;

	if (clientInit(argc, argv))
		fprintf(stderr, "%s [-c command] [-d] [-h host[:port]] [-i inputfile] [-k] [-r] [servicename]\n", argv[0]);

	else {
		if ((isdClientData.sock = isdLogin(isdClientData.host, isdClientData.service, 2)) != INVALID_SOCKET) {

			if (isdClientData.runOneCommand) {
				sendRequest(isdClientData.command);
				receivedReply = 0;
			}

			FD_ZERO(&allfds);
			FD_SET(CLIENTFILENO, &allfds);
			FD_SET(isdClientData.sock, &allfds);

			for (;;) {
/*
 * Loop around on the select until
 * something shows up.
 */
/*
 * I know it looks like I should have handled it above,
 * but somehow I think it reads better if I set them
 * together, then unset them if necessary.
 */
				if (feof(isdClientData.inputFile))
					FD_CLR(CLIENTFILENO, &allfds);

				for (status = -1; status == -1;) {
					readfds = allfds;
					mask = max(CLIENTFILENO, isdClientData.sock);
					status = select(mask + 1, &readfds, (fd_set *) 0, (fd_set *) 0, (struct timeval *) 0);
					if (status == SOCKET_ERROR && errno != EINTR) {
						isdError("select()ing\n");
						exit(1);
					}
				}

				if (FD_ISSET(CLIENTFILENO, &readfds)) {
					if (getRequest()) {
						FD_CLR(CLIENTFILENO, &allfds);
						receivedReply = 0;
					}
/*
 * After getting a request from the operator mark that I'm waiting for a reply.
 * It's possible that I didn't get a request but instead got an EOF.  In which
 * case if I'm not waiting, terminate the loop.
 */
					if (receivedReply && feof(isdClientData.inputFile))
						break;
				}
/*
 * handle responses from the worker (or isectd).
 */
				if (FD_ISSET(isdClientData.sock, &readfds)) {
					isdHeader header;

					getResponse(&header);
/*
 * The reasone I'm !ing header.more, is I need to know if I need to keep
 * waiting for another reply.  If there's more, than I need to keep waiting.  If
 * there isn't any more (header.more == 0) then I've received everything
 * I'm supposed to--at least as far as the worker is concerned.
 */
					receivedReply = !header.more;

/*
 * If I've received a reply, then I can start listenint to the client
 * input file again in the select() loop.
 */
					if (receivedReply)
						FD_SET(CLIENTFILENO, &allfds);
/*
 * I want to stop processing if I've gotten my reply and I'm only supposed to
 * run one command (-c) or the input file is EOF, or there was some kind of
 * error processing the command (header.error != ISDERROK)
 */
					if (receivedReply && (
						isdClientData.runOneCommand || 
						feof(isdClientData.inputFile) || 
						header.error != ISDERROK))
						break;
				}
			}
			fflush(stdout);
			isdLogout(isdClientData.sock);
		}
		else
			perror("isdLogin()");
	}

#ifdef HAVEWWW
	HTLibTerminate();
#endif
	return 0;
}
