/*
 icb-nicklist.c : irssi

    Copyright (C) 2010 Jonathan Perkin

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "module.h"
#include "signals.h"

#include "icb-channels.h"
#include "icb-nicklist.h"

/* Add new nick to list*/
NICK_REC *icb_nicklist_insert(ICB_CHANNEL_REC *channel, const char *nick,
	       		      int mod)
{
	NICK_REC *rec;

	g_return_val_if_fail(IS_ICB_CHANNEL(channel), NULL);
	g_return_val_if_fail(nick != NULL, NULL);

	rec = g_new0(NICK_REC, 1);
	rec->nick = g_strdup(nick);

	/* Just use existing 'op' for moderator */
	if (mod) rec->op = TRUE;

	nicklist_insert(CHANNEL(channel), rec);
	return rec;
}
